/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.recipes;

import advsolar.common.AdvancedSolarPanel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gregtech.common.items.MetaGeneratedTool01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeRemovals {
    public static void postInit() {
        if (Mods.AdvancedSolarPanel.isModLoaded()) {
            RecipeUtils.removeRecipeByOutput(ItemUtils.getSimpleStack(AdvancedSolarPanel.blockMolecularTransformer));
        }
    }

    public static void onLoadComplete() {
        RecipeRemovals.removeCrudeTurbineRotors();
    }

    private static void removeCrudeTurbineRotors() {
        int aRemoved = 0;
        int CUT = Configuration.gregtech.turbineCutoffBase;
        Collection<GTRecipe> aAssRecipes = RecipeMaps.assemblerRecipes.getAllRecipes();
        if (!aAssRecipes.isEmpty()) {
            block5: for (GTRecipe aG : aAssRecipes) {
                if (!ArrayUtils.isNotEmpty((Object[])aG.mOutputs)) continue;
                for (ItemStack aI : aG.mOutputs) {
                    String aType;
                    int aCutoff;
                    int aMeta;
                    Item aU;
                    if (aI == null || (aU = aI.func_77973_b()) == null || !(aU instanceof MetaGeneratedTool01) || (aMeta = aI.func_77960_j()) < 170 || aMeta > 176) continue;
                    switch (aMeta) {
                        case 170: {
                            aCutoff = CUT;
                            aType = "Small ";
                            break;
                        }
                        case 172: {
                            aCutoff = 2 * CUT;
                            aType = "";
                            break;
                        }
                        case 174: {
                            aCutoff = 3 * CUT;
                            aType = "Large ";
                            break;
                        }
                        default: {
                            aCutoff = 4 * CUT;
                            aType = "Huge ";
                        }
                    }
                    Materials aMainMaterial = MetaGeneratedTool.getPrimaryMaterial(aI);
                    Materials aSecondaryMaterial = MetaGeneratedTool.getSecondaryMaterial(aI);
                    long rotorDurabilityMax = MetaGeneratedTool.getToolMaxDamage(aI);
                    if (rotorDurabilityMax >= (long)aCutoff) continue block5;
                    Logger.WARNING("[Turbine Cleanup] " + MaterialUtils.getMaterialName(aMainMaterial) + " " + aType + "Turbines have " + rotorDurabilityMax + ", which is below the cutoff durability of " + aCutoff + ", disabling.");
                    aG.mEnabled = false;
                    aG.mHidden = true;
                    aG.mCanBeBuffered = false;
                    ++aRemoved;
                }
            }
        }
        Logger.INFO("Removed " + aRemoved + " useless Turbines.");
    }
}

