/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone.instructions;

import gregtech.shadow.com.github.technus.avrClone.instructions.IInstruction;
import gregtech.shadow.com.github.technus.avrClone.instructions.Instruction;
import gregtech.shadow.com.github.technus.avrClone.memory.program.exceptions.InvalidMnemonic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InstructionRegistry {
    public static final Map<String, InstructionRegistry> REGISTRIES;
    public static final InstructionRegistry INSTRUCTION_REGISTRY_OP;
    public static final InstructionRegistry INSTRUCTION_REGISTRY_IMMERSIVE;
    private HashMap<String, Integer> instructionsMap = new HashMap();
    private IInstruction[] instructions;
    private int instructionDefault;
    private String name;

    public InstructionRegistry(ArrayList<? extends IInstruction> array, IInstruction defaultInstruction, String name) throws InvalidMnemonic {
        this.instructions = new IInstruction[array.size()];
        for (IInstruction iInstruction : array) {
            this.addInstruction(iInstruction);
        }
        this.instructionDefault = this.getID(defaultInstruction.name());
        this.name = name;
        REGISTRIES.put(name, this);
    }

    public InstructionRegistry print() {
        int instructionsLength = this.instructions.length;
        for (int i = 0; i < instructionsLength; ++i) {
            IInstruction instruction = this.instructions[i];
            System.out.println(instruction.name() + " " + i);
        }
        return this;
    }

    public void addInstruction(IInstruction instruction) throws InvalidMnemonic {
        int id = this.instructionsMap.size();
        if (this.instructionsMap.put(instruction.name(), id) != null) {
            throw new InvalidMnemonic("Duplicate instruction " + instruction.name());
        }
        this.instructions[id] = instruction;
    }

    public IInstruction getInstruction(int id) {
        return this.instructions[id];
    }

    public IInstruction getInstructionSlowly(String name) {
        return this.instructions[this.instructionsMap.get(name)];
    }

    public int getID(String name) {
        Integer id = this.instructionsMap.get(name);
        return id == null ? this.instructionDefault : id;
    }

    public Integer getId(String name) {
        Integer id = this.instructionsMap.get(name);
        return id;
    }

    public IInstruction[] getInstructions() {
        return (IInstruction[])this.instructions.clone();
    }

    public String toString() {
        return this.name;
    }

    static {
        InstructionRegistry instructionRegistry;
        REGISTRIES = new HashMap<String, InstructionRegistry>();
        try {
            instructionRegistry = new InstructionRegistry(Instruction.INSTRUCTIONS_OP, Instruction.NULL, "OP");
        }
        catch (InvalidMnemonic e) {
            instructionRegistry = null;
        }
        INSTRUCTION_REGISTRY_OP = instructionRegistry;
        try {
            instructionRegistry = new InstructionRegistry(Instruction.INSTRUCTIONS_IMMERSIVE, Instruction.NULL, "IMMERSIVE");
        }
        catch (InvalidMnemonic e) {
            instructionRegistry = null;
        }
        INSTRUCTION_REGISTRY_IMMERSIVE = instructionRegistry;
    }
}

