/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone;

import gregtech.shadow.com.github.technus.avrClone.instructions.ExecutionEvent;
import gregtech.shadow.com.github.technus.avrClone.instructions.IInstruction;
import gregtech.shadow.com.github.technus.avrClone.instructions.InstructionRegistry;
import gregtech.shadow.com.github.technus.avrClone.memory.EepromMemory;
import gregtech.shadow.com.github.technus.avrClone.memory.IoMemory;
import gregtech.shadow.com.github.technus.avrClone.memory.RemovableMemory;
import gregtech.shadow.com.github.technus.avrClone.memory.SramMemory;
import gregtech.shadow.com.github.technus.avrClone.memory.SystemMemory;
import gregtech.shadow.com.github.technus.avrClone.memory.program.ProgramMemory;
import gregtech.shadow.com.github.technus.avrClone.registerFile.RegisterFilePairs;
import gregtech.shadow.com.github.technus.avrClone.registerFile.RegisterFileSingles;
import gregtech.shadow.com.github.technus.avrClone.registerPackages.CPU_Registers;
import gregtech.shadow.com.github.technus.avrClone.registerPackages.IInterrupt;
import gregtech.shadow.com.github.technus.avrClone.registerPackages.IRegister;
import gregtech.shadow.com.github.technus.avrClone.registerPackages.IRegisterPackage;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AvrCore {
    private volatile boolean valid = false;
    private InstructionRegistry instructionRegistry;
    private boolean immersiveOperands;
    public boolean awoken = true;
    public boolean active = true;
    public int programCounter = 0;
    public final int[] registerFile = new int[32];
    public int[] dataMemory;
    private BitSet accessibleMemory;
    private ProgramMemory programMemory;
    private SystemMemory systemMemory;
    private IoMemory ioMemory;
    private SramMemory sramMemory;
    private EepromMemory eepromMemory;
    private CPU_Registers cpuRegisters;
    private final HashMap<String, IRegisterPackage<?>> packages = new HashMap();
    private final TreeMap<Integer, IInterrupt<?>> interrupts = new TreeMap();

    public boolean checkValid() {
        this.valid = this.instructionRegistry != null && this.programMemory != null && this.ioMemory != null && this.sramMemory != null && this.systemMemory != null && this.dataMemory != null && this.accessibleMemory != null && this.cpuRegisters != null;
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public void invalidateProgramMemory() {
        this.programMemory = null;
        this.programCounter = 0;
        this.invalidate();
    }

    public void invalidateSystemMemory() {
        this.systemMemory = null;
        this.ioMemory = null;
        this.sramMemory = null;
        this.eepromMemory = null;
        this.cpuRegisters = null;
        this.dataMemory = null;
        this.accessibleMemory = null;
        this.programCounter = 0;
        this.removeAllPackages();
        this.clearRegisterFileContent();
        this.invalidate();
    }

    public AvrCore simpleInit() {
        this.setDataMemory(256, 256);
        this.setCpuRegisters(48);
        return this;
    }

    public void reset() {
        this.clearVolatileDataMemoryContent();
        this.clearRegisterFileContent();
        this.programCounter = 0;
    }

    public void clearRegisterFileContent() {
        int len = this.registerFile.length;
        for (int i = 0; i < len; ++i) {
            this.registerFile[i] = 0;
        }
    }

    public void setUsingImmersiveOperands(boolean immersiveOperands) {
        if (this.immersiveOperands != immersiveOperands) {
            this.immersiveOperands = immersiveOperands;
            this.invalidateProgramMemory();
        }
    }

    public boolean isUsingImmersiveOperands() {
        return this.immersiveOperands;
    }

    public void setInstructionRegistry(InstructionRegistry instructionRegistry) {
        if (this.instructionRegistry != instructionRegistry) {
            this.instructionRegistry = instructionRegistry;
            this.invalidateProgramMemory();
        }
    }

    public InstructionRegistry getInstructionRegistry() {
        return this.instructionRegistry;
    }

    public boolean setDataMemory(int ioSize, int ramSize) {
        if (ioSize <= 0 || ramSize <= 0) {
            throw new IllegalArgumentException("Invalid memory size! Must be greater than 0!");
        }
        this.systemMemory = new SystemMemory(ramSize);
        this.dataMemory = new int[this.systemMemory.size];
        this.accessibleMemory = new BitSet(this.dataMemory.length);
        this.ioMemory = new IoMemory(ioSize);
        this.sramMemory = new SramMemory(ramSize);
        this.accessibleMemory.set(this.sramMemory.getOffset(), this.sramMemory.getOffset() + this.sramMemory.getSize());
        this.removeAllPackages();
        this.clearInterruptsConfiguration();
        this.cpuRegisters = null;
        this.eepromMemory = null;
        return this.checkValid();
    }

    public void clearVolatileDataMemoryContent() {
        RemovableMemory<EepromMemory> eepromBackup = this.getEepromMemory();
        this.dataMemory = new int[this.dataMemory.length];
        if (eepromBackup != null) {
            this.setEepromMemory(eepromBackup);
        }
        this.initDataMemoryDefaults();
    }

    public void initDataMemoryDefaults() {
        for (IRegisterPackage<?> pack : this.packages.values()) {
            System.arraycopy(pack.getDataDefault(), 0, this.dataMemory, pack.getOffset(), pack.getSize());
        }
    }

    public boolean isDataAddressValid(int address) {
        return this.accessibleMemory.get(address);
    }

    public boolean isDataRangeValid(int fromInclusive, int toExclusive) {
        return this.accessibleMemory.nextClearBit(fromInclusive) >= toExclusive;
    }

    public boolean isDataBlockValid(int offset, int size) {
        return this.accessibleMemory.nextClearBit(offset) >= offset + size;
    }

    public RemovableMemory<EepromMemory> blockEepromMemory() {
        RemovableMemory<EepromMemory> removableMemory = this.getEepromMemory();
        if (removableMemory != null) {
            this.accessibleMemory.clear(this.eepromMemory.getOffset(), this.eepromMemory.getOffset() + this.eepromMemory.getSize());
        }
        return removableMemory;
    }

    public RemovableMemory<EepromMemory> unblockEepromMemory() {
        RemovableMemory<EepromMemory> removableMemory = this.getEepromMemory();
        if (removableMemory != null) {
            this.accessibleMemory.set(this.eepromMemory.getOffset(), this.eepromMemory.getOffset() + this.eepromMemory.getSize());
        }
        return removableMemory;
    }

    public RemovableMemory<EepromMemory> restoreEepromDefinition(EepromMemory eeprom) {
        if (!this.valid) {
            throw new RuntimeException("Cannot set MCU EEPROM!");
        }
        RemovableMemory<EepromMemory> eepromBackup = this.removeEepromMemory();
        if (eeprom != null) {
            this.eepromMemory = eeprom;
            this.accessibleMemory.set(this.eepromMemory.getOffset(), this.eepromMemory.getOffset() + this.eepromMemory.getSize());
        }
        return eepromBackup;
    }

    public RemovableMemory<EepromMemory> setEepromDefinition(EepromMemory eeprom) {
        if (!this.valid) {
            throw new RuntimeException("Cannot set MCU EEPROM!");
        }
        RemovableMemory<EepromMemory> eepromBackup = this.removeEepromMemory();
        if (eeprom != null) {
            this.eepromMemory = eeprom;
            this.accessibleMemory.set(this.eepromMemory.getOffset(), this.eepromMemory.getOffset() + this.eepromMemory.getSize());
            System.arraycopy(this.eepromMemory.getDataDefault(), 0, this.dataMemory, this.eepromMemory.getOffset(), this.eepromMemory.getSize());
        }
        return eepromBackup;
    }

    public RemovableMemory<EepromMemory> setEepromMemory(RemovableMemory<EepromMemory> eeprom) {
        if (!this.valid) {
            throw new RuntimeException("Cannot set MCU EEPROM!");
        }
        RemovableMemory<EepromMemory> eepromBackup = this.removeEepromMemory();
        if (eeprom != null) {
            this.eepromMemory = eeprom.getDefinition();
            this.accessibleMemory.set(this.eepromMemory.getOffset(), this.eepromMemory.getOffset() + this.eepromMemory.getSize());
            System.arraycopy(this.eepromMemory.getDataDefault(), 0, this.dataMemory, this.eepromMemory.getOffset(), this.eepromMemory.getSize());
        }
        return eepromBackup;
    }

    public RemovableMemory<EepromMemory> setEepromContent(RemovableMemory<EepromMemory> eeprom) {
        if (!this.valid) {
            throw new RuntimeException("Cannot set MCU EEPROM!");
        }
        RemovableMemory<EepromMemory> eepromBackup = this.removeEepromMemory();
        if (eeprom != null) {
            if (this.eepromMemory != null) {
                int[] data = eeprom.getData();
                System.arraycopy(data, 0, this.dataMemory, this.eepromMemory.getOffset(), Math.min(data.length, this.eepromMemory.getSize()));
            } else {
                throw new RuntimeException("No EEPROM to write to!");
            }
        }
        return eepromBackup;
    }

    public RemovableMemory<EepromMemory> setEepromContent(int[] data) {
        if (!this.valid) {
            throw new RuntimeException("Cannot set MCU EEPROM!");
        }
        RemovableMemory<EepromMemory> eepromBackup = this.removeEepromMemory();
        if (data != null) {
            if (this.eepromMemory != null) {
                System.arraycopy(data, 0, this.dataMemory, this.eepromMemory.getOffset(), Math.min(data.length, this.eepromMemory.getSize()));
            } else {
                throw new RuntimeException("No EEPROM to write to!");
            }
        }
        return eepromBackup;
    }

    public RemovableMemory<EepromMemory> clearEepromContent() {
        if (!this.valid) {
            throw new RuntimeException("Cannot set MCU EEPROM!");
        }
        RemovableMemory<EepromMemory> eepromBackup = this.removeEepromMemory();
        if (this.eepromMemory == null) {
            throw new RuntimeException("No EEPROM to clear!");
        }
        System.arraycopy(this.eepromMemory.getDataDefault(), 0, this.dataMemory, this.eepromMemory.getOffset(), this.eepromMemory.getSize());
        return eepromBackup;
    }

    public RemovableMemory<EepromMemory> removeEepromMemory() {
        RemovableMemory<EepromMemory> removableMemory = this.getEepromMemory();
        if (removableMemory != null) {
            this.accessibleMemory.clear(this.eepromMemory.getOffset(), this.eepromMemory.getOffset() + this.eepromMemory.getSize());
            this.eepromMemory = null;
        }
        return removableMemory;
    }

    public RemovableMemory<EepromMemory> getEepromMemory() {
        if (!this.valid || this.eepromMemory == null) {
            return null;
        }
        int[] eeprom = new int[this.eepromMemory.getSize()];
        System.arraycopy(this.dataMemory, this.eepromMemory.getOffset(), eeprom, 0, eeprom.length);
        return RemovableMemory.makeWithoutCloning(this.eepromMemory, eeprom);
    }

    public void setCpuRegisters(int offset) {
        CPU_Registers cpu;
        if (offset < 0 || this.dataMemory == null) {
            throw new RuntimeException("Cannot set MCU CPU Registers!");
        }
        if (this.cpuRegisters != null) {
            this.removeDataBindings(this.cpuRegisters);
        }
        if (!this.putDataBindings(cpu = new CPU_Registers(offset, this.dataMemory.length - 1), "CPU")) {
            throw new RuntimeException("Cannot set MCU CPU Registers, outside of range!");
        }
        this.cpuRegisters = cpu;
        this.checkValid();
    }

    public CPU_Registers getCpuRegisters() {
        return this.cpuRegisters;
    }

    public void setProgramMemory(ProgramMemory programMemory) {
        this.programMemory = programMemory;
        this.checkValid();
    }

    public ProgramMemory getProgramMemory() {
        return this.programMemory;
    }

    public int getProgramSize() {
        return this.programMemory.instructions.length;
    }

    public IInstruction getInstruction() {
        return this.instructionRegistry.getInstruction(this.programMemory.instructions[this.programCounter]);
    }

    public IInstruction getInstruction(int addr) {
        return this.instructionRegistry.getInstruction(this.programMemory.instructions[addr]);
    }

    public int getInstructionID() {
        return this.programMemory.instructions[this.programCounter];
    }

    public int getInstructionID(int addr) {
        return this.programMemory.instructions[addr];
    }

    public int getOperand0() {
        return this.programMemory.param0[this.programCounter];
    }

    public int getOperand0(int addr) {
        return this.programMemory.param0[addr];
    }

    public int getOperand1() {
        return this.programMemory.param1[this.programCounter];
    }

    public int getOperand1(int addr) {
        return this.programMemory.param1[addr];
    }

    public HashMap<String, Integer> getRegisterNames() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.registerFile.length; ++i) {
            map.put("R" + i, i);
            map.put("r" + i, i);
        }
        map.put("X", RegisterFilePairs.X.offset);
        map.put("x", RegisterFilePairs.X.offset);
        map.put("Y", RegisterFilePairs.Y.offset);
        map.put("y", RegisterFilePairs.Y.offset);
        map.put("Z", RegisterFilePairs.Z.offset);
        map.put("z", RegisterFilePairs.Z.offset);
        map.put("W", RegisterFilePairs.W.offset);
        map.put("w", RegisterFilePairs.W.offset);
        map.put("Xl", RegisterFileSingles.Xl.offset);
        map.put("xl", RegisterFileSingles.Xl.offset);
        map.put("Yl", RegisterFileSingles.Yl.offset);
        map.put("yl", RegisterFileSingles.Yl.offset);
        map.put("Zl", RegisterFileSingles.Zl.offset);
        map.put("zl", RegisterFileSingles.Zl.offset);
        map.put("Wl", RegisterFileSingles.Wl.offset);
        map.put("wl", RegisterFileSingles.Wl.offset);
        map.put("Xh", RegisterFileSingles.Xh.offset);
        map.put("xh", RegisterFileSingles.Xh.offset);
        map.put("Yh", RegisterFileSingles.Yh.offset);
        map.put("yh", RegisterFileSingles.Yh.offset);
        map.put("Zh", RegisterFileSingles.Zh.offset);
        map.put("zh", RegisterFileSingles.Zh.offset);
        map.put("Wh", RegisterFileSingles.Wh.offset);
        map.put("wh", RegisterFileSingles.Wh.offset);
        return map;
    }

    public void removeAllPackages() {
        for (Map.Entry<String, IRegisterPackage<?>> entry : this.packages.entrySet()) {
            this.removeDataBindings(entry.getValue(), entry.getKey());
        }
        this.clearInterruptsConfiguration();
    }

    public String getPackageName(int i) {
        if (this.accessibleMemory.get(i)) {
            for (Map.Entry<String, IRegisterPackage<?>> entry : this.packages.entrySet()) {
                IRegisterPackage<?> registerPackage = entry.getValue();
                if (i >= registerPackage.getOffset() + registerPackage.getSize() || i < registerPackage.getOffset()) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public List<? extends IRegister<?>> getDataDefinitions(int i) {
        if (this.accessibleMemory.get(i)) {
            for (IRegisterPackage<?> registerPackage : this.packages.values()) {
                List<IRegister<?>> definitions = registerPackage.addressesMap().get(i);
                if (definitions == null) continue;
                return definitions;
            }
        }
        return null;
    }

    public HashMap<String, Integer> getDataNames() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int i = 0;
        while (i >= 0) {
            List<IRegister<?>> definitions = this.getDataDefinitions(i);
            if (definitions != null) {
                for (IRegister<?> definition : definitions) {
                    map.put(definition.name(), i);
                }
            }
            ++i;
            i = this.accessibleMemory.nextSetBit(i);
        }
        return map;
    }

    public boolean restoreDataBindings(IRegisterPackage<?> registerPackage) {
        return this.restoreDataBindings(registerPackage, registerPackage.getClass().getSimpleName() + registerPackage.hashCode());
    }

    public boolean restoreDataBindings(IRegisterPackage<?> registerPackage, String prefix, String postfix) {
        return this.restoreDataBindings(registerPackage, prefix + registerPackage.getClass().getSimpleName() + postfix);
    }

    public boolean restoreDataBindings(IRegisterPackage<?> registerPackage, String name) {
        if (this.accessibleMemory.get(registerPackage.getOffset(), registerPackage.getOffset() + registerPackage.getSize()).isEmpty()) {
            Map<Integer, IInterrupt<?>> interrupts = registerPackage.interruptsMap();
            if (interrupts != null) {
                for (Integer key : interrupts.keySet()) {
                    if (!this.interrupts.containsKey(key)) continue;
                    throw new IllegalArgumentException("Overlapping interrupt vector");
                }
                this.interrupts.putAll(interrupts);
            }
            this.packages.put(name, registerPackage);
            this.accessibleMemory.set(registerPackage.getOffset(), registerPackage.getOffset() + registerPackage.getSize());
            return true;
        }
        return false;
    }

    public boolean putDataBindings(IRegisterPackage<?> registerPackage) {
        return this.putDataBindings(registerPackage, registerPackage.getClass().getSimpleName() + registerPackage.hashCode());
    }

    public boolean putDataBindings(IRegisterPackage<?> registerPackage, String prefix, String postfix) {
        return this.putDataBindings(registerPackage, prefix + registerPackage.getClass().getSimpleName() + postfix);
    }

    public boolean putDataBindings(IRegisterPackage<?> registerPackage, String name) {
        if (this.accessibleMemory.get(registerPackage.getOffset(), registerPackage.getOffset() + registerPackage.getSize()).isEmpty() && this.ioMemory.canEncapsulate(registerPackage)) {
            Map<Integer, IInterrupt<?>> interrupts = registerPackage.interruptsMap();
            if (interrupts != null) {
                for (Integer key : interrupts.keySet()) {
                    if (!this.interrupts.containsKey(key)) continue;
                    throw new IllegalArgumentException("Overlapping interrupt vector");
                }
                this.interrupts.putAll(interrupts);
            }
            this.packages.put(name, registerPackage);
            this.accessibleMemory.set(registerPackage.getOffset(), registerPackage.getOffset() + registerPackage.getSize());
            System.arraycopy(registerPackage.getDataDefault(), 0, this.dataMemory, registerPackage.getOffset(), registerPackage.getSize());
            return true;
        }
        return false;
    }

    public boolean removeDataBindings(IRegisterPackage<?> registerPackage) {
        return this.removeDataBindings(registerPackage, registerPackage.getClass().getSimpleName() + registerPackage.hashCode());
    }

    public boolean removeDataBindings(IRegisterPackage<?> registerPackage, String prefix, String postfix) {
        String name = prefix + registerPackage.getClass().getSimpleName() + postfix;
        return this.removeDataBindings(registerPackage, name);
    }

    public boolean removeDataBindings(IRegisterPackage<?> registerPackage, String name) {
        if (this.packages.containsKey(name)) {
            Map<Integer, IInterrupt<?>> i = registerPackage.interruptsMap();
            if (i != null) {
                for (Integer key : i.keySet()) {
                    this.interrupts.remove(key);
                }
            }
            this.packages.remove(name);
            this.accessibleMemory.clear(registerPackage.getOffset(), registerPackage.getOffset() + registerPackage.getSize());
            return true;
        }
        return false;
    }

    public void setRegisterBits(int addr, int bitMask, boolean value) {
        this.registerFile[addr] = value ? this.registerFile[addr] | bitMask : this.registerFile[addr] & ~bitMask;
    }

    public void setRegisterBits(int addr, int bitMask) {
        int n = addr;
        this.registerFile[n] = this.registerFile[n] | bitMask;
    }

    public void clearRegisterBits(int addr, int bitMask) {
        int n = addr;
        this.registerFile[n] = this.registerFile[n] & ~bitMask;
    }

    public boolean getRegisterBitsOr(int addr, int bitMask) {
        return (this.registerFile[addr] & bitMask) != 0;
    }

    public boolean getRegisterBitsNotOr(int addr, int bitMask) {
        return (this.registerFile[addr] & bitMask) == 0;
    }

    public boolean getRegisterBitsNotAnd(int addr, int bitMask) {
        return (this.registerFile[addr] & bitMask) != bitMask;
    }

    public boolean getRegisterBitsAnd(int addr, int bitMask) {
        return (this.registerFile[addr] & bitMask) == bitMask;
    }

    public void setDataBits(int addr, int bitMask, boolean value) {
        if (this.accessibleMemory.get(addr)) {
            this.dataMemory[addr] = value ? this.dataMemory[addr] | bitMask : this.dataMemory[addr] & ~bitMask;
        }
    }

    public void setDataBits(int addr, int bitMask) {
        if (this.accessibleMemory.get(addr)) {
            int n = addr;
            this.dataMemory[n] = this.dataMemory[n] | bitMask;
        }
    }

    public void clearDataBits(int addr, int bitMask) {
        if (this.accessibleMemory.get(addr)) {
            int n = addr;
            this.dataMemory[n] = this.dataMemory[n] & ~bitMask;
        }
    }

    public boolean getDataBitsOr(int addr, int bitMask) {
        if (this.accessibleMemory.get(addr)) {
            return (this.dataMemory[addr] & bitMask) != 0;
        }
        return false;
    }

    public boolean getDataBitsNotOr(int addr, int bitMask) {
        if (this.accessibleMemory.get(addr)) {
            return (this.dataMemory[addr] & bitMask) == 0;
        }
        return true;
    }

    public boolean getDataBitsNotAnd(int addr, int bitMask) {
        if (this.accessibleMemory.get(addr)) {
            return (this.dataMemory[addr] & bitMask) != bitMask;
        }
        return true;
    }

    public boolean getDataBitsAnd(int addr, int bitMask) {
        if (this.accessibleMemory.get(addr)) {
            return (this.dataMemory[addr] & bitMask) == bitMask;
        }
        return false;
    }

    public void setRegisterValue(int addr, int value) {
        this.registerFile[addr] = value;
    }

    public int orRegisterValue(int addr, int bits) {
        int n = addr;
        int n2 = this.registerFile[n] | bits;
        this.registerFile[n] = n2;
        return n2;
    }

    public int andRegisterValue(int addr, int bits) {
        int n = addr;
        int n2 = this.registerFile[n] & bits;
        this.registerFile[n] = n2;
        return n2;
    }

    public int xorRegisterValue(int addr, int bits) {
        int n = addr;
        int n2 = this.registerFile[n] ^ bits;
        this.registerFile[n] = n2;
        return n2;
    }

    public int notRegisterValue(int addr) {
        this.registerFile[addr] = ~this.registerFile[addr];
        return this.registerFile[addr];
    }

    public int negRegisterValue(int addr) {
        this.registerFile[addr] = -this.registerFile[addr];
        return this.registerFile[addr];
    }

    public int getRegisterValue(int addr) {
        return this.registerFile[addr];
    }

    public long getRegisterPairValue(int addr) {
        return (long)this.registerFile[addr + 1] << 32 | (long)this.registerFile[addr];
    }

    public void setRegisterPairValue(int addr, long value) {
        this.registerFile[addr + 1] = (int)(value >> 32);
        this.registerFile[addr] = (int)value;
    }

    public void setDataValue(int addr, int value) {
        this.dataMemory[addr] = value;
    }

    public int orDataValue(int addr, int bits) {
        int n = addr;
        int n2 = this.dataMemory[n] | bits;
        this.dataMemory[n] = n2;
        return n2;
    }

    public int andDataValue(int addr, int bits) {
        int n = addr;
        int n2 = this.dataMemory[n] & bits;
        this.dataMemory[n] = n2;
        return n2;
    }

    public int xorDataValue(int addr, int bits) {
        int n = addr;
        int n2 = this.dataMemory[n] ^ bits;
        this.dataMemory[n] = n2;
        return n2;
    }

    public int notDataValue(int addr) {
        this.dataMemory[addr] = ~this.dataMemory[addr];
        return this.dataMemory[addr];
    }

    public int negDataValue(int addr) {
        this.dataMemory[addr] = -this.dataMemory[addr];
        return this.dataMemory[addr];
    }

    public int getDataValue(int addr) {
        return this.dataMemory[addr];
    }

    public void setStatusBits(int bitMask, boolean desiredValue) {
        this.dataMemory[this.cpuRegisters.SREG] = desiredValue ? this.dataMemory[this.cpuRegisters.SREG] | bitMask : this.dataMemory[this.cpuRegisters.SREG] & ~bitMask;
    }

    public void setStatusBits(int bitMask) {
        int n = this.cpuRegisters.SREG;
        this.dataMemory[n] = this.dataMemory[n] | bitMask;
    }

    public void clearStatusBits(int bitMask) {
        int n = this.cpuRegisters.SREG;
        this.dataMemory[n] = this.dataMemory[n] & ~bitMask;
    }

    public boolean getStatusBitsOr(int bitMask) {
        return (this.dataMemory[this.cpuRegisters.SREG] & bitMask) != 0;
    }

    public boolean getStatusBitsNotOr(int bitMask) {
        return (this.dataMemory[this.cpuRegisters.SREG] & bitMask) == 0;
    }

    public boolean getStatusBitsNotAnd(int bitMask) {
        return (this.dataMemory[this.cpuRegisters.SREG] & bitMask) != bitMask;
    }

    public boolean getStatusBitsAnd(int bitMask) {
        return (this.dataMemory[this.cpuRegisters.SREG] & bitMask) == bitMask;
    }

    public int getStatusValue() {
        return this.dataMemory[this.cpuRegisters.SREG];
    }

    public void setStatusValue(int value) {
        this.dataMemory[this.cpuRegisters.SREG] = value;
    }

    public int getStackPointer() {
        return this.dataMemory[this.cpuRegisters.SP];
    }

    public void setStackPointer(int stackPosition) {
        this.dataMemory[this.cpuRegisters.SP] = stackPosition;
    }

    public void incStackPointer() {
        int n = this.cpuRegisters.SP;
        this.dataMemory[n] = this.dataMemory[n] + 1;
    }

    public void decStackPointer() {
        int n = this.cpuRegisters.SP;
        this.dataMemory[n] = this.dataMemory[n] - 1;
    }

    public void pushValue(int value) {
        if (this.accessibleMemory.get(this.dataMemory[this.cpuRegisters.SP])) {
            int n = this.cpuRegisters.SP;
            int n2 = this.dataMemory[n];
            this.dataMemory[n] = n2 - 1;
            this.dataMemory[n2] = value;
        }
    }

    public int popValue() {
        int n = this.cpuRegisters.SP;
        this.dataMemory[n] = this.dataMemory[n] + 1;
        if (this.accessibleMemory.get(this.dataMemory[n])) {
            return this.dataMemory[this.dataMemory[this.cpuRegisters.SP]];
        }
        return 0;
    }

    public int getW() {
        return this.registerFile[RegisterFileSingles.Wl.offset];
    }

    public int getX() {
        return this.registerFile[RegisterFileSingles.Xl.offset];
    }

    public int getY() {
        return this.registerFile[RegisterFileSingles.Yl.offset];
    }

    public int getZ() {
        return this.registerFile[RegisterFileSingles.Zl.offset];
    }

    public int setW(int value) {
        this.registerFile[RegisterFileSingles.Wl.offset] = value;
        return this.registerFile[RegisterFileSingles.Wl.offset];
    }

    public int setX(int value) {
        this.registerFile[RegisterFileSingles.Xl.offset] = value;
        return this.registerFile[RegisterFileSingles.Xl.offset];
    }

    public int setY(int value) {
        this.registerFile[RegisterFileSingles.Yl.offset] = value;
        return this.registerFile[RegisterFileSingles.Yl.offset];
    }

    public int setZ(int value) {
        this.registerFile[RegisterFileSingles.Zl.offset] = value;
        return this.registerFile[RegisterFileSingles.Zl.offset];
    }

    public long getWpair() {
        return (long)this.registerFile[RegisterFileSingles.Wl.offset] & (long)this.registerFile[RegisterFileSingles.Wh.offset] << 32;
    }

    public long getXpair() {
        return (long)this.registerFile[RegisterFileSingles.Xl.offset] & (long)this.registerFile[RegisterFileSingles.Xh.offset] << 32;
    }

    public long getYpair() {
        return (long)this.registerFile[RegisterFileSingles.Yl.offset] & (long)this.registerFile[RegisterFileSingles.Yh.offset] << 32;
    }

    public long getZpair() {
        return (long)this.registerFile[RegisterFileSingles.Zl.offset] & (long)this.registerFile[RegisterFileSingles.Zh.offset] << 32;
    }

    public long setWpair(long value) {
        this.setRegisterPairValue(RegisterFilePairs.W.offset, value);
        return this.getRegisterPairValue(RegisterFilePairs.W.offset);
    }

    public long setXpair(long value) {
        this.setRegisterPairValue(RegisterFilePairs.X.offset, value);
        return this.getRegisterPairValue(RegisterFilePairs.X.offset);
    }

    public long setYpair(long value) {
        this.setRegisterPairValue(RegisterFilePairs.Y.offset, value);
        return this.getRegisterPairValue(RegisterFilePairs.Y.offset);
    }

    public long setZpair(long value) {
        this.setRegisterPairValue(RegisterFilePairs.Z.offset, value);
        return this.getRegisterPairValue(RegisterFilePairs.Z.offset);
    }

    public boolean getInterruptEnable() {
        return (this.dataMemory[this.cpuRegisters.SREG] & CPU_Registers.I) != 0;
    }

    public void interruptsHandle() throws IndexOutOfBoundsException, NullPointerException {
        if (this.getInterruptEnable()) {
            this.interruptsCycleForce();
        }
    }

    private void clearInterruptsConfiguration() {
        this.interrupts.clear();
    }

    public void interruptsCycleForce() throws IndexOutOfBoundsException, NullPointerException {
        for (IRegisterPackage<?> registerPackage : this.packages.values()) {
            for (IInterrupt<?> interrupt : registerPackage.interruptsMap().values()) {
                if (!interrupt.tryInterrupt(this, registerPackage)) continue;
                this.awoken = true;
                this.pushValue(this.programCounter);
                this.programCounter = interrupt.getVector();
                int n = this.cpuRegisters.SREG;
                this.dataMemory[n] = this.dataMemory[n] & CPU_Registers._I;
            }
        }
    }

    public ExecutionEvent cpuCycleForce() throws IndexOutOfBoundsException, NullPointerException {
        return this.instructionRegistry.getInstruction(this.programMemory.instructions[this.programCounter]).execute(this);
    }

    public ExecutionEvent cycle() throws IndexOutOfBoundsException, NullPointerException {
        if (this.active) {
            this.interruptsHandle();
            return this.awoken ? this.cpuCycleForce() : null;
        }
        return null;
    }
}

