/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock;

import com.google.common.primitives.Ints;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.fluid.GTFluidTank;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.multitileentity.enums.GT_MultiTileCasing;
import gregtech.api.multitileentity.multiblock.base.ComplexParallelController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GT_StructureUtilityMuTE;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multiblock.logic.AdvChemicalProcessorProcessingLogic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class AdvChemicalProcessor
extends ComplexParallelController<AdvChemicalProcessor, AdvChemicalProcessorProcessingLogic> {
    private static IStructureDefinition<AdvChemicalProcessor> STRUCTURE_DEFINITION = null;
    protected static final String STRUCTURE_PIECE_T1 = "T1";
    protected static final String STRUCTURE_PIECE_T2 = "T2";
    protected static final String STRUCTURE_PIECE_T3 = "T3";
    protected static final String STRUCTURE_PIECE_T4 = "T4";
    protected static final String STRUCTURE_PIECE_T5_6 = "T5_6";
    protected static final String STRUCTURE_PIECE_T7_8 = "T7_8";
    protected static final Vec3Impl STRUCTURE_OFFSET_T1 = new Vec3Impl(3, 1, 0);
    protected static final Vec3Impl STRUCTURE_OFFSET_T2 = new Vec3Impl(1, 4, -3);
    protected static final Vec3Impl STRUCTURE_OFFSET_T3 = new Vec3Impl(8, 0, 5);
    protected static final Vec3Impl STRUCTURE_OFFSET_T4 = new Vec3Impl(-14, 0, 0);
    protected static final Vec3Impl STRUCTURE_OFFSET_T5 = new Vec3Impl(14, 0, -6);
    protected static final Vec3Impl STRUCTURE_OFFSET_T6 = new Vec3Impl(-16, 0, 0);
    protected static final Vec3Impl STRUCTURE_OFFSET_T7 = new Vec3Impl(16, 0, 15);
    protected static final Vec3Impl STRUCTURE_OFFSET_T8 = new Vec3Impl(-16, 0, 0);
    protected static final int PROCESS_WINDOW_BASE_ID = 100;
    protected static final int ITEM_WHITELIST_SLOTS = 8;
    protected static final int FLUID_WHITELIST_SLOTS = 8;
    protected static final int MAX_PROCESSES = 8;
    protected HeatingCoilLevel coilTier;
    protected final ArrayList<HashSet<String>> processWhitelists = new ArrayList(8);
    protected final ArrayList<ItemStackHandler> processWhitelistInventoryHandlers = new ArrayList(8);
    protected final ArrayList<ArrayList<IFluidTank>> processFluidWhiteLists = new ArrayList(8);
    protected boolean wasWhitelistOpened = false;

    public AdvChemicalProcessor() {
        for (int i = 0; i < 8; ++i) {
            this.processWhitelists.add(null);
            this.processWhitelistInventoryHandlers.add(new ItemStackHandler(8));
            ArrayList<GTFluidTank> processFluidTanks = new ArrayList<GTFluidTank>(8);
            for (int j = 0; j < 8; ++j) {
                processFluidTanks.add(new GTFluidTank());
            }
            this.processFluidWhiteLists.add(processFluidTanks);
        }
        this.setMaxComplexParallels(1, false);
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        this.setMaxComplexParallels(nbt.func_74762_e("processors"), false);
        NBTTagCompound processWhiteLists = nbt.func_74775_l("whiteLists");
        long capacity = 1000L;
        if (nbt.func_74764_b("gt.tankcap")) {
            capacity = Ints.saturatedCast((long)nbt.func_74763_f("gt.tankcap"));
        }
        for (int i = 0; i < 8; ++i) {
            NBTTagList fluidList;
            if (processWhiteLists == null) continue;
            NBTTagCompound itemList = processWhiteLists.func_74775_l("items" + i);
            if (itemList != null) {
                this.processWhitelistInventoryHandlers.get(i).deserializeNBT(itemList);
            }
            if ((fluidList = processWhiteLists.func_150295_c("fluids" + i, 10)) == null) continue;
            for (int j = 0; j < fluidList.func_74745_c(); ++j) {
                NBTTagCompound fluid = fluidList.func_150305_b(j);
                if (fluid == null) continue;
                short index = fluid.func_74765_d("s");
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluid);
                if (fluidStack == null) continue;
                this.processFluidWhiteLists.get(i).get(index).fill(fluidStack, true);
            }
        }
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        nbt.func_74768_a("processors", this.maxComplexParallels);
        NBTTagCompound processWhiteLists = new NBTTagCompound();
        for (int i = 0; i < 8; ++i) {
            processWhiteLists.func_74782_a("items" + i, (NBTBase)this.processWhitelistInventoryHandlers.get(i).serializeNBT());
            NBTTagList fluidList = new NBTTagList();
            for (int j = 0; j < 8; ++j) {
                FluidStack fluidStack = this.processFluidWhiteLists.get(i).get(j).getFluid();
                if (fluidStack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("s", (byte)j);
                fluidStack.writeToNBT(tag);
                fluidList.func_74742_a((NBTBase)tag);
            }
            processWhiteLists.func_74782_a("fluids" + i, (NBTBase)fluidList);
        }
        nbt.func_74782_a("whiteLists", (NBTBase)processWhiteLists);
    }

    @Override
    public short getCasingRegistryID() {
        return GT_MultiTileCasing.Chemical.getRegistryId();
    }

    @Override
    public int getCasingMeta() {
        return GT_MultiTileCasing.Chemical.getId();
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Chemical Reactor").addInfo("Does not lose efficiency when overclocked").addInfo("Accepts fluids instead of fluid cells").addInfo("Can do multiple different recipes at once").addInfo("By using the whitelist filter a recipe can push its output").addInfo("to a different recipes input to chain them").addInfo("Disclaimer: Still WIP - Use at your own risk").beginStructureBlock(5, 3, 3, false).addController("Front center").addCasingInfoExactly("PTFE Pipe Machine Casing", 8, false).addCasingInfoExactly("Heating Coils", 3, true).addCasingInfoExactly("EV+ Glass", 3, true).addCasingInfoExactly("Motor Casing", 3, true).addCasingInfoExactly("Chemical Casing", 27, false).toolTipFinisher(GTValues.Authorminecraft7771);
        return tt;
    }

    @Override
    public Vec3Impl getStartingStructureOffset() {
        return STRUCTURE_OFFSET_T1;
    }

    @Override
    public boolean checkMachine() {
        this.setCoilTier(HeatingCoilLevel.None);
        this.buildState.startBuilding(this.getStartingStructureOffset());
        if (!this.checkPiece(STRUCTURE_PIECE_T1, this.buildState.getCurrentOffset())) {
            return this.buildState.failBuilding();
        }
        if (this.maxComplexParallels > 1) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T2);
            if (!this.checkPiece(STRUCTURE_PIECE_T2, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 2) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T3);
            if (!this.checkPiece(STRUCTURE_PIECE_T3, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 3) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T4);
            if (!this.checkPiece(STRUCTURE_PIECE_T4, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 4) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T5);
            if (!this.checkPiece(STRUCTURE_PIECE_T5_6, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 5) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T6);
            if (!this.checkPiece(STRUCTURE_PIECE_T5_6, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 6) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T7);
            if (!this.checkPiece(STRUCTURE_PIECE_T7_8, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        if (this.maxComplexParallels > 7) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T8);
            if (!this.checkPiece(STRUCTURE_PIECE_T7_8, this.buildState.getCurrentOffset())) {
                return this.buildState.failBuilding();
            }
        }
        this.buildState.stopBuilding();
        return super.checkMachine();
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        this.buildState.startBuilding(this.getStartingStructureOffset());
        this.buildPiece(STRUCTURE_PIECE_T1, trigger, hintsOnly, this.buildState.getCurrentOffset());
        if (this.maxComplexParallels > 1) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T2);
            this.buildPiece(STRUCTURE_PIECE_T2, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 2) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T3);
            this.buildPiece(STRUCTURE_PIECE_T3, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 3) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T4);
            this.buildPiece(STRUCTURE_PIECE_T4, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 4) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T5);
            this.buildPiece(STRUCTURE_PIECE_T5_6, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 5) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T6);
            this.buildPiece(STRUCTURE_PIECE_T5_6, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 6) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T7);
            this.buildPiece(STRUCTURE_PIECE_T7_8, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        if (this.maxComplexParallels > 7) {
            this.buildState.addOffset(STRUCTURE_OFFSET_T8);
            this.buildPiece(STRUCTURE_PIECE_T7_8, trigger, hintsOnly, this.buildState.getCurrentOffset());
        }
        this.buildState.stopBuilding();
    }

    @Override
    public IStructureDefinition<AdvChemicalProcessor> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_T1, StructureUtility.transpose((String[][])new String[][]{{"CPCPC", "CCCCC", "CPCPC"}, {"CGC~C", "GWWWU", "CGCCC"}, {"CPCPC", "CTTTC", "CPCPC"}})).addShape(STRUCTURE_PIECE_T2, (String[][])new String[][]{{"       ", "       ", "       ", "       ", "       ", "  F F  ", "  B B  "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  B B  "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  BBB  "}, {"   C   ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", " BCCCB "}, {"  BBB  ", " C   C ", " C   C ", " C   C ", " C   C ", " C   C ", "BCPPPCB"}, {" CBBBC ", " G W G ", " G W G ", " G W G ", " G W G ", " G W G ", "BCPCPCB"}, {"  BBB  ", " C   C ", " C   C ", " C   C ", " C   C ", " C   C ", "BCPPPCB"}, {"   C   ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", " BCCCB "}, {"       ", "       ", "       ", "       ", "       ", "       ", "  BBB  "}}).addShape(STRUCTURE_PIECE_T3, (String[][])new String[][]{{"         ", "         ", "         ", "         ", "         ", "         ", "  BBB    "}, {"   C     ", "  CGC    ", "  CGC    ", "  CGC    ", "  CGC    ", "  CGC    ", " BCCCB   "}, {"  BBB    ", " C   C   ", " C   C   ", " C   C   ", " C   C   ", " C   CFFF", "BCPPPCBBB"}, {" CBBBC   ", " G W G   ", " G W G   ", " G W G   ", " G W G   ", " G W G   ", "BCPCPCB  "}, {"  BBB    ", " C   C   ", " C   C   ", " C   C   ", " C   C   ", " C   CFFF", "BCPPPCBBB"}, {"   C     ", "  CGC    ", "  CGC    ", "  CGC    ", "  CGC    ", "  CGC    ", " BCCCB   "}, {"         ", "         ", "         ", "         ", "         ", "         ", "  BBB    "}}).addShape(STRUCTURE_PIECE_T4, (String[][])new String[][]{{"         ", "         ", "         ", "         ", "         ", "         ", "    BBB  "}, {"     C   ", "    CGC  ", "    CGC  ", "    CGC  ", "    CGC  ", "    CGC  ", "   BCCCB "}, {"    BBB  ", "   C   C ", "   C   C ", "   C   C ", "   C   C ", "FFFC   C ", "BBBCPPPCB"}, {"   CBBBC ", "   G W G ", "   G W G ", "   G W G ", "   G W G ", "   G W G ", "  BCPCPCB"}, {"    BBB  ", "   C   C ", "   C   C ", "   C   C ", "   C   C ", "FFFC   C ", "BBBCPPPCB"}, {"     C   ", "    CGC  ", "    CGC  ", "    CGC  ", "    CGC  ", "    CGC  ", "   BCCCB "}, {"         ", "         ", "         ", "         ", "         ", "         ", "    BBB  "}}).addShape(STRUCTURE_PIECE_T5_6, (String[][])new String[][]{{"       ", "       ", "       ", "       ", "       ", "  F F  ", "       "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  B B  "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  B B  "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  BBB  "}, {"   C   ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", " BCCCB "}, {"  BBB  ", " C   C ", " C   C ", " C   C ", " C   C ", " C   C ", "BCPPPCB"}, {" CBBBC ", " G W G ", " G W G ", " G W G ", " G W G ", " G W G ", "BCPCPCB"}, {"  BBB  ", " C   C ", " C   C ", " C   C ", " C   C ", " C   C ", "BCPPPCB"}, {"   C   ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", " BCCCB "}, {"       ", "       ", "       ", "       ", "       ", "       ", "  BBB  "}}).addShape(STRUCTURE_PIECE_T7_8, (String[][])new String[][]{{"       ", "       ", "       ", "       ", "       ", "       ", "  BBB  "}, {"   C   ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", " BCCCB "}, {"  BBB  ", " C   C ", " C   C ", " C   C ", " C   C ", " C   C ", "BCPPPCB"}, {" CBBBC ", " G W G ", " G W G ", " G W G ", " G W G ", " G W G ", "BCPCPCB"}, {"  BBB  ", " C   C ", " C   C ", " C   C ", " C   C ", " C   C ", "BCPPPCB"}, {"   C   ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", "  CGC  ", " BCCCB "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  BBB  "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  B B  "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "  B B  "}, {"       ", "       ", "       ", "       ", "       ", "  F F  ", "       "}}).addElement('C', GT_StructureUtilityMuTE.ofMuTECasings(MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT | MultiBlockPart.ENERGY_IN, GT_MultiTileCasing.Chemical.getCasing())).addElement('P', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)1)).addElement('T', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.MOTOR_CASINGS)).addElement('W', GTStructureUtility.ofCoil(AdvChemicalProcessor::setCoilTier, AdvChemicalProcessor::getCoilTier)).addElement('G', Glasses.chainAllGlasses()).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('F', GTStructureUtility.ofFrame(Materials.Steel)).addElement('U', GT_StructureUtilityMuTE.ofMuTECasings(MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT | MultiBlockPart.ENERGY_IN, GT_MultiTileCasing.Chemical.getCasing(), GT_StructureUtilityMuTE.INVENTORY_CASINGS)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected void setMaxComplexParallels(int parallel, boolean stopMachine) {
        super.setMaxComplexParallels(parallel, stopMachine);
        this.onStructureChange();
    }

    protected MultiChildWidget createMainPage(IWidgetBuilder<?> builder) {
        MultiChildWidget child = new MultiChildWidget();
        for (int i = 0; i < 8; ++i) {
            int processIndex = i;
            child.addChild(new ButtonWidget().setPlayClickSound(true).setOnClick((clickData, widget) -> {
                if (!widget.isClient()) {
                    widget.getContext().openSyncedWindow(100 + processIndex);
                }
            }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_WHITELIST}).setSize(18, 18).setEnabled(widget -> processIndex < this.maxComplexParallels).setPos(20 * (i % 4) + 18, 18 + i / 4 * 20));
        }
        child.addChild(new NumericWidget().setGetter(() -> this.maxComplexParallels).setSetter(parallel -> this.setMaxComplexParallels((int)parallel, true)).setBounds(1.0, 8.0).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("Tier").setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).setSize(18, 18).setPos(130, 85));
        return child;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        for (int i = 0; i < 8; ++i) {
            int processIndex = i;
            buildContext.addSyncedWindow(100 + i, player -> this.createProcessConfigWindow(player, processIndex));
        }
        buildContext.addCloseListener(() -> {
            if (this.wasWhitelistOpened) {
                for (int i = 0; i < 8; ++i) {
                    this.processWhitelists.set(i, null);
                }
                this.wasWhitelistOpened = false;
            }
        });
    }

    protected ModularWindow createProcessConfigWindow(EntityPlayer player, int processIndex) {
        this.wasWhitelistOpened = true;
        ModularWindow.Builder builder = ModularWindow.builder((int)86, (int)100);
        builder.widget(new TextWidget("Process " + processIndex).setTextAlignment(Alignment.Center).setPos(13, 7));
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)((IItemHandlerModifiable)this.processWhitelistInventoryHandlers.get(processIndex)), (int)4).startFromSlot(0).endAtSlot(7).phantom(true).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(7, 19));
        builder.widget(SlotGroup.ofFluidTanks((List)this.processFluidWhiteLists.get(processIndex), (int)4).startFromSlot(0).endAtSlot(7).phantom(true).build().setPos(7, 55));
        return builder.build();
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.advchemicalprocessor";
    }

    @Override
    public String getLocalName() {
        return "Advanced Chemical Processor";
    }

    public void setCoilTier(HeatingCoilLevel coilTier) {
        this.coilTier = coilTier;
    }

    public HeatingCoilLevel getCoilTier() {
        return this.coilTier;
    }

    @Override
    protected boolean hasPerfectOverclock() {
        return true;
    }

    protected void generateWhitelist(int processIndex) {
        HashSet<String> whitelist = new HashSet<String>();
        for (ItemStack itemStack : this.processWhitelistInventoryHandlers.get(processIndex).getStacks()) {
            if (itemStack == null) continue;
            whitelist.add(this.getWhitelistString(itemStack));
        }
        for (IFluidTank tank : this.processFluidWhiteLists.get(processIndex)) {
            if (tank.getFluid() == null) continue;
            whitelist.add(this.getWhitelistString(tank.getFluid()));
        }
        this.processWhitelists.set(processIndex, whitelist);
    }

    protected String getWhitelistString(ItemStack itemStack) {
        if (itemStack != null) {
            return itemStack.func_77977_a();
        }
        return null;
    }

    protected String getWhitelistString(FluidStack fluidStack) {
        if (fluidStack != null) {
            return fluidStack.getUnlocalizedName();
        }
        return null;
    }

    @Override
    @Nonnull
    protected AdvChemicalProcessorProcessingLogic createProcessingLogic() {
        return new AdvChemicalProcessorProcessingLogic();
    }
}

