/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.gthandler.multiAirFilter;

import com.dreammaster.gthandler.CustomItemList;
import com.dreammaster.gthandler.casings.GT_Container_CasingsNH;
import com.dreammaster.gthandler.multiAirFilter.ChunkCoordinates;
import com.dreammaster.item.ItemList;
import com.dreammaster.main.MainRegistry;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.items.MetaGeneratedTool01;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_AirFilterBase
extends MTEEnhancedMultiBlockBase<GT_MetaTileEntity_AirFilterBase> {
    protected int baseEff = 0;
    protected int multiTier = 0;
    protected int chunkIndex = 0;
    protected boolean hasPollution = false;
    protected ChunkCoordinates[] chunkList;
    protected int mode = 0;
    protected int size;
    protected boolean isFilterLoaded = false;
    protected int filterUsageRemaining = 0;
    protected int tickCounter = 0;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final ClassValue<IStructureDefinition<GT_MetaTileEntity_AirFilterBase>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_AirFilterBase>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_AirFilterBase> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GT_MetaTileEntity_AirFilterBase.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"xxx", "xxx", "xxx"}, {"vmv", "m-m", "vmv"}, {"vmv", "m-m", "vmv"}, {"c~c", "ccc", "ccc"}})).addElement('c', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)GT_Container_CasingsNH.sBlockCasingsNH, (int)x.getCasingMeta()), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, (int)x.getCasingIndex(), (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, (int)x.getCasingIndex(), (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, (int)x.getCasingIndex(), (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, (int)x.getCasingIndex(), (int)1)}))).addElement('x', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)GT_Container_CasingsNH.sBlockCasingsNH, (int)x.getCasingMeta()))).addElement('v', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)GT_Container_CasingsNH.sBlockCasingsNH, (int)x.getPipeMeta()))).addElement('m', (IStructureElement)StructureUtility.lazy(x -> GTStructureUtility.ofHatchAdderOptional(MTEMultiBlockBase::addMufflerToMachineList, (int)x.getCasingIndex(), (int)2, (Block)GT_Container_CasingsNH.sBlockCasingsNH, (int)x.getCasingMeta()))).build();
        }
    };
    static final GTRecipe tRecipeT1 = new GTRecipe(new ItemStack[]{CustomItemList.AdsorptionFilter.get(1L, new Object())}, new ItemStack[]{CustomItemList.AdsorptionFilterDirty.get(1L, new Object())}, null, null, null, null, 200, 30, 0);
    static final GTRecipe tRecipeT2 = new GTRecipe(new ItemStack[]{CustomItemList.AdsorptionFilter.get(1L, new Object())}, new ItemStack[]{CustomItemList.AdsorptionFilterDirty.get(1L, new Object())}, null, null, null, null, 200, 480, 0);
    static final GTRecipe tRecipeT3 = new GTRecipe(new ItemStack[]{CustomItemList.AdsorptionFilter.get(1L, new Object())}, new ItemStack[]{CustomItemList.AdsorptionFilterDirty.get(1L, new Object())}, null, null, null, null, 200, 7680, 0);

    public final IStructureDefinition<GT_MetaTileEntity_AirFilterBase> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(((Object)((Object)this)).getClass());
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 3, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 3, 0) && !this.mMufflerHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    public GT_MetaTileEntity_AirFilterBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AirFilterBase(String aName) {
        super(aName);
    }

    protected void populateChunkList() {
        this.chunkList = new ChunkCoordinates[this.size * this.size];
        World world = this.getBaseMetaTileEntity().getWorld();
        int xCoordMulti = this.getBaseMetaTileEntity().getXCoord();
        int zCoordMulti = this.getBaseMetaTileEntity().getZCoord();
        for (int i = 0; i < this.size * this.size; ++i) {
            int xCoordChunk = xCoordMulti - 16 * (this.size / 2 - i % this.size) >> 4;
            int zCoordChunk = zCoordMulti + 16 * (this.size / 2 - i / this.size) >> 4;
            this.chunkList[i] = new ChunkCoordinates(xCoordChunk, zCoordChunk, world);
        }
    }

    public abstract GTRecipe getRecipe();

    public String getCasingString() {
        switch (this.getCasingMeta()) {
            case 0: {
                return "Air Filter Turbine Casing";
            }
            case 3: {
                return "Advanced Air Filter Turbine Casing";
            }
            case 5: {
                return "Super Air Filter Turbine Casing";
            }
        }
        return "fill a ticket on github if you read this";
    }

    public String getPipeString() {
        switch (this.getPipeMeta()) {
            case 1: {
                return "Air Filter Vent Casing";
            }
            case 4: {
                return "Advanced Air Filter Vent Casing";
            }
            case 6: {
                return "Super Air Filter Vent Casing";
            }
        }
        return "fill a ticket on github if you read this";
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Air Filter").addInfo("Controller block for the Electric Air Filter T" + this.multiTier).addInfo("Needs a Turbine in the controller").addInfo("Can process " + (2 * this.multiTier + 1) + "x" + (2 * this.multiTier + 1) + " chunks").addInfo("Each muffler hatch reduces pollution in one chunk of the working area by:").addInfo("  " + EnumChatFormatting.WHITE + MainRegistry.CoreConfig.globalMultiplicator + " * multiTierBonus * turbineEff * FLOOR(" + MainRegistry.CoreConfig.scalingFactor + "^mufflerTier)").addInfo("every second").addInfo("- multiTierBonus for this controller is " + this.getBonusByTier()).addInfo("- turbineEff is the efficiency of the Turbine in controller slot").addInfo("- Effective muffler tier is limited by energy input tier").addSeparator().addInfo("Insert " + ItemList.AdsorptionFilter.getIS().func_82833_r() + " in an input bus").addInfo("  to double pollution cleaning amount (30 uses per item)").addInfo("Each maintenance issue reduces cleaning amount by 10%").addSeparator().beginStructureBlock(3, 4, 3, true).addController("Front bottom").addOtherStructurePart(this.getCasingString(), "Top and bottom layers").addOtherStructurePart(this.getPipeString(), "Corners of the middle two layers").addOtherStructurePart("Muffler Hatch", "Sides of the middle two layers").addEnergyHatch("Any bottom layer casing", new int[]{1}).addMaintenanceHatch("Any bottom layer casing", new int[]{1}).addInputBus("Any bottom layer casing", new int[]{1}).addOutputBus("Any bottom layer casing", new int[]{1}).toolTipFinisher("GTNH Coremod");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingIndex()), new GTRenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingIndex())};
    }

    public abstract float getBonusByTier();

    public abstract int getCasingIndex();

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77973_b() instanceof MetaGeneratedTool01 && ((MetaGeneratedTool)aStack.func_77973_b()).getToolStats(aStack).getSpeedMultiplier() > 0.0f && MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed > 0.0f && aStack.func_77960_j() > 169 && aStack.func_77960_j() < 180;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public int getPollutionCleaningRatePerTick(float turbineEff, float multiEff, boolean isRateBoosted) {
        return this.getPollutionCleaningRatePerSecond(turbineEff, multiEff, isRateBoosted) / 20;
    }

    public int getPollutionCleaningRatePerSecond(float turbineEff, float multiEff, boolean isRateBoosted) {
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GTUtility.getTier((long)tVoltage));
        int pollutionPerSecond = 0;
        for (MTEHatchMuffler tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mMufflerHatches)) {
            pollutionPerSecond += (int)Math.pow(MainRegistry.CoreConfig.scalingFactor, Math.min(tTier, tHatch.mTier));
        }
        if (isRateBoosted) {
            pollutionPerSecond = (int)((float)pollutionPerSecond * MainRegistry.CoreConfig.boostPerAbsorptionFilter);
        }
        pollutionPerSecond = (int)((float)pollutionPerSecond * turbineEff * multiEff * this.getBonusByTier() * MainRegistry.CoreConfig.globalMultiplicator);
        return pollutionPerSecond;
    }

    public boolean checkRecipe(ItemStack aStack) {
        this.mEfficiencyIncrease = 10000;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.hasPollution = this.getTotalPollution() >= MainRegistry.CoreConfig.pollutionThresholdAirFilter;
        this.mMaxProgresstime = this.getRecipe().mDuration;
        this.mEUt = -this.getRecipe().mEUt;
        if (!this.hasPollution) {
            return true;
        }
        try {
            if (!this.isCorrectMachinePart(aStack)) {
                return false;
            }
            this.baseEff = GTUtility.safeInt((long)((long)((50.0f + 10.0f * ((MetaGeneratedTool)aStack.func_77973_b()).getToolCombatDamage(aStack)) * 100.0f)));
        }
        catch (Exception e) {
            return false;
        }
        this.tickCounter = 0;
        if (!this.isFilterLoaded && this.isCorrectMachinePart(aStack)) {
            ArrayList tInputList = this.getStoredInputs();
            int tInputList_sS = tInputList.size();
            block2: for (int i = 0; i < tInputList_sS - 1; ++i) {
                for (int j = i + 1; j < tInputList_sS; ++j) {
                    if (!GTUtility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                    if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                        tInputList.remove(j--);
                        tInputList_sS = tInputList.size();
                        continue;
                    }
                    tInputList.remove(i--);
                    tInputList_sS = tInputList.size();
                    continue block2;
                }
            }
            ItemStack[] tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[0]), 0, 2);
            if (!tInputList.isEmpty() && this.getRecipe().isRecipeInputEqual(true, null, tInputs)) {
                this.updateSlots();
                this.filterUsageRemaining = MainRegistry.CoreConfig.usagesPerAbsorptionFilter;
                this.isFilterLoaded = true;
            }
        }
        if (this.isFilterLoaded) {
            --this.filterUsageRemaining;
            if (this.filterUsageRemaining == 0) {
                this.mOutputItems = new ItemStack[]{this.getRecipe().getOutput(0)};
                this.isFilterLoaded = false;
            } else {
                this.mOutputItems = null;
            }
        }
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mode", this.mode);
        aNBT.func_74768_a("chunkIndex", this.chunkIndex);
        aNBT.func_74768_a("size", this.size);
        aNBT.func_74757_a("isFilterLoaded", this.isFilterLoaded);
        aNBT.func_74768_a("filterUsageRemaining", this.filterUsageRemaining);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mode = aNBT.func_74762_e("mode");
        this.chunkIndex = aNBT.func_74762_e("chunkIndex");
        this.size = aNBT.func_74762_e("size");
        this.isFilterLoaded = aNBT.func_74767_n("isFilterLoaded");
        this.filterUsageRemaining = aNBT.func_74762_e("filterUsageRemaining");
    }

    public void cleanPollution() {
        int pollutionCleaningRatePerSecond = this.getPollutionCleaningRatePerSecond((float)this.baseEff / 10000.0f, (float)this.mEfficiency / 10000.0f, this.isFilterLoaded);
        if (pollutionCleaningRatePerSecond > 0) {
            if (this.mode == 0) {
                this.chunkList[this.chunkIndex].removePollution(pollutionCleaningRatePerSecond);
                ++this.chunkIndex;
                if (this.chunkIndex == this.chunkList.length) {
                    this.chunkIndex = 0;
                }
            } else {
                ChunkCoordinates pollutedChunk;
                ArrayList<ChunkCoordinates> pollutedChunkList = new ArrayList<ChunkCoordinates>();
                for (ChunkCoordinates chunk : this.chunkList) {
                    if (chunk.getPollution() <= 0) continue;
                    pollutedChunkList.add(chunk);
                }
                if (pollutedChunkList.size() > 1) {
                    pollutedChunk = (ChunkCoordinates)pollutedChunkList.get(MainRegistry.Rnd.nextInt(pollutedChunkList.size()));
                    pollutedChunk.removePollution(pollutionCleaningRatePerSecond);
                } else if (pollutedChunkList.size() == 1) {
                    pollutedChunk = (ChunkCoordinates)pollutedChunkList.get(0);
                    pollutedChunk.removePollution(pollutionCleaningRatePerSecond);
                }
            }
        }
    }

    public abstract int getPipeMeta();

    public abstract int getCasingMeta();

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.chunkList == null) {
            if (this.size == 0) {
                this.size = 2 * this.multiTier + 1;
            }
            this.populateChunkList();
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public int getTotalPollution() {
        int pollutionAmount = 0;
        for (ChunkCoordinates chunk : this.chunkList) {
            pollutionAmount += chunk.getPollution();
        }
        return pollutionAmount;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 200L == 0L) {
            int Xpos = aBaseMetaTileEntity.getXCoord() + aBaseMetaTileEntity.getBackFacing().offsetX;
            int Ypos = aBaseMetaTileEntity.getYCoord() + 3;
            int Zpos = aBaseMetaTileEntity.getZCoord() + aBaseMetaTileEntity.getBackFacing().offsetZ;
            try {
                aBaseMetaTileEntity.getWorld().func_147458_c(Xpos - 1, Ypos, Zpos - 1, Xpos + 1, Ypos, Zpos + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.tickCounter == 19 && this.hasPollution) {
            this.cleanPollution();
            this.tickCounter = 0;
        } else {
            ++this.tickCounter;
        }
        return super.onRunningTick(aStack);
    }

    public int getDamageToComponent(ItemStack aStack) {
        try {
            if (this.isCorrectMachinePart(aStack) && this.hasPollution) {
                return this.getBaseMetaTileEntity().getRandomNumber(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!aPlayer.func_70093_af()) {
            int n = this.mode = this.mode == 1 ? 0 : 1;
            if (this.mode == 0) {
                this.chunkIndex = 0;
                PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Electric air filter now running in normal mode");
            } else {
                PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Electric air filter now running in random mode");
            }
        } else {
            this.size = this.size == 1 ? 2 * this.multiTier + 1 : (this.size -= 2);
            this.chunkIndex = 0;
            this.populateChunkList();
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)("Electric air filter is now working in a " + this.size + "x" + this.size + " area"));
        }
    }

    public String[] getInfoData() {
        return new String[]{"Progress:", EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", "Stored Energy:", EnumChatFormatting.GREEN + Long.toString(this.getBaseMetaTileEntity().getStoredEU()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + this.getBaseMetaTileEntity().getEUCapacity() + EnumChatFormatting.RESET + " EU", "Probably uses: " + EnumChatFormatting.RED + Math.abs(this.mEUt) + EnumChatFormatting.RESET + " EU/t", "Max Energy Income: " + EnumChatFormatting.YELLOW + this.getMaxInputVoltage() + EnumChatFormatting.RESET + " EU/t(*2A) Tier: " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET, "Problems: " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " Efficiency: " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", "Pollution reduction: " + EnumChatFormatting.GREEN + this.getPollutionCleaningRatePerTick((float)this.baseEff / 10000.0f, (float)this.mEfficiency / 10000.0f, this.isFilterLoaded) + EnumChatFormatting.RESET + " gibbl/t", "Has a filter in it: " + this.isFilterLoaded, "remaining cycles for the filter (if present): " + this.filterUsageRemaining};
    }
}

