/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.proxy;

import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.command.InGameInfoCommand;
import com.github.lunatrius.ingameinfo.handler.ClientConfigurationHandler;
import com.github.lunatrius.ingameinfo.handler.KeyInputHandler;
import com.github.lunatrius.ingameinfo.handler.Ticker;
import com.github.lunatrius.ingameinfo.integration.PluginLoader;
import com.github.lunatrius.ingameinfo.proxy.CommonProxy;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import com.github.lunatrius.ingameinfo.value.registry.ValueRegistry;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private final InGameInfoCore core = InGameInfoCore.INSTANCE;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ClientConfigurationHandler.init(event.getSuggestedConfigurationFile());
        ValueRegistry.INSTANCE.init();
        PluginLoader.getInstance().preInit(event);
        this.core.moveConfig(event.getModConfigurationDirectory(), ClientConfigurationHandler.configName);
        this.core.setConfigDirectory(event.getModConfigurationDirectory().toPath().resolve("InGameInfoXML").toFile());
        this.core.setConfigFileWithLocale(ClientConfigurationHandler.configName);
        this.core.reloadConfig();
        ClientConfigurationHandler.propFileInterval.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        ClientConfigurationHandler.propscale.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        for (KeyBinding keyBinding : KeyInputHandler.KEY_BINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)Ticker.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)Ticker.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)ClientConfigurationHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)KeyInputHandler.INSTANCE);
        ClientCommandHandler.instance.func_71560_a((ICommand)InGameInfoCommand.INSTANCE);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)ClientConfigurationHandler.INSTANCE);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        PluginLoader.getInstance().postInit(event);
        TagRegistry.INSTANCE.init();
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        Tag.setServer(event.getServer());
    }

    @Override
    public void serverStopping(FMLServerStoppingEvent event) {
        Tag.setServer(null);
    }
}

