/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.Position;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.blueprints.Template;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlueprintBase {
    public ArrayList<NBTTagCompound> subBlueprintsNBT = new ArrayList();
    public int anchorX;
    public int anchorY;
    public int anchorZ;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public LibraryId id = new LibraryId();
    public String author;
    public boolean rotate = true;
    public boolean excavate = true;
    public BuildingPermission buildingPermission = BuildingPermission.ALL;
    public boolean isComplete = true;
    protected MappingRegistry mapping = new MappingRegistry();
    protected SchematicBlockBase[] contents;
    private NBTTagCompound nbt;
    private ForgeDirection mainDir = ForgeDirection.EAST;

    public BlueprintBase() {
    }

    public BlueprintBase(int sizeX, int sizeY, int sizeZ) {
        this.contents = new SchematicBlockBase[sizeX * sizeY * sizeZ];
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.anchorX = 0;
        this.anchorY = 0;
        this.anchorZ = 0;
    }

    private int toArrayPos(int x, int y, int z) {
        return (y * this.sizeZ + z) * this.sizeX + x;
    }

    public SchematicBlockBase get(int x, int y, int z) {
        return this.contents[(y * this.sizeZ + z) * this.sizeX + x];
    }

    public void put(int x, int y, int z, SchematicBlockBase s) {
        this.contents[(y * this.sizeZ + z) * this.sizeX + x] = s;
    }

    public void translateToBlueprint(Translation transform) {
        for (SchematicBlockBase content : this.contents) {
            if (content == null) continue;
            content.translateToBlueprint(transform);
        }
    }

    public void translateToWorld(Translation transform) {
        for (SchematicBlockBase content : this.contents) {
            if (content == null) continue;
            content.translateToWorld(transform);
        }
    }

    public void rotateLeft(BptContext context) {
        SchematicBlockBase[] newContents = new SchematicBlockBase[this.sizeZ * this.sizeY * this.sizeX];
        for (int x = 0; x < this.sizeZ; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeX; ++z) {
                    int pos = (y * this.sizeX + z) * this.sizeZ + x;
                    newContents[pos] = this.contents[this.toArrayPos(z, y, this.sizeZ - 1 - x)];
                    if (newContents[pos] == null) continue;
                    try {
                        newContents[pos].rotateLeft(context);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        BCLog.logger.throwing(t);
                    }
                }
            }
        }
        int newAnchorX = this.sizeZ - 1 - this.anchorZ;
        int newAnchorY = this.anchorY;
        int newAnchorZ = this.anchorX;
        for (NBTTagCompound sub : this.subBlueprintsNBT) {
            ForgeDirection dir = ForgeDirection.values()[sub.func_74771_c("dir")];
            dir = dir.getRotation(ForgeDirection.UP);
            Position pos = new Position(sub.func_74762_e("x"), sub.func_74762_e("y"), sub.func_74762_e("z"));
            Position np = context.rotatePositionLeft(pos);
            sub.func_74768_a("x", (int)np.x);
            sub.func_74768_a("z", (int)np.z);
            sub.func_74774_a("dir", (byte)dir.ordinal());
        }
        context.rotateLeft();
        this.anchorX = newAnchorX;
        this.anchorY = newAnchorY;
        this.anchorZ = newAnchorZ;
        this.contents = newContents;
        int tmp = this.sizeX;
        this.sizeX = this.sizeZ;
        this.sizeZ = tmp;
        this.mainDir = this.mainDir.getRotation(ForgeDirection.UP);
    }

    private void writeToNBTInternal(NBTTagCompound nbt) {
        nbt.func_74778_a("version", "7.1.39");
        if (this instanceof Template) {
            nbt.func_74778_a("kind", "template");
        } else {
            nbt.func_74778_a("kind", "blueprint");
        }
        nbt.func_74768_a("sizeX", this.sizeX);
        nbt.func_74768_a("sizeY", this.sizeY);
        nbt.func_74768_a("sizeZ", this.sizeZ);
        nbt.func_74768_a("anchorX", this.anchorX);
        nbt.func_74768_a("anchorY", this.anchorY);
        nbt.func_74768_a("anchorZ", this.anchorZ);
        nbt.func_74757_a("rotate", this.rotate);
        nbt.func_74757_a("excavate", this.excavate);
        if (this.author != null) {
            nbt.func_74778_a("author", this.author);
        }
        this.saveContents(nbt);
        NBTTagList subBptList = new NBTTagList();
        for (NBTTagCompound subBpt : this.subBlueprintsNBT) {
            subBptList.func_74742_a((NBTBase)subBpt);
        }
        nbt.func_74782_a("subBpt", (NBTBase)subBptList);
    }

    public static BlueprintBase loadBluePrint(NBTTagCompound nbt) {
        String kind = nbt.func_74779_i("kind");
        BlueprintBase bpt = "template".equals(kind) ? new Template() : new Blueprint();
        bpt.readFromNBT(nbt);
        return bpt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.sizeX = nbt.func_74762_e("sizeX");
        this.sizeY = nbt.func_74762_e("sizeY");
        this.sizeZ = nbt.func_74762_e("sizeZ");
        this.anchorX = nbt.func_74762_e("anchorX");
        this.anchorY = nbt.func_74762_e("anchorY");
        this.anchorZ = nbt.func_74762_e("anchorZ");
        this.author = nbt.func_74779_i("author");
        this.rotate = nbt.func_74764_b("rotate") ? nbt.func_74767_n("rotate") : true;
        this.excavate = nbt.func_74764_b("excavate") ? nbt.func_74767_n("excavate") : true;
        this.contents = new SchematicBlockBase[this.sizeX * this.sizeY * this.sizeZ];
        try {
            this.loadContents(nbt);
        }
        catch (BptError e) {
            e.printStackTrace();
        }
        if (nbt.func_74764_b("subBpt")) {
            NBTTagList subBptList = nbt.func_150295_c("subBpt", 10);
            for (int i = 0; i < subBptList.func_74745_c(); ++i) {
                this.subBlueprintsNBT.add(subBptList.func_150305_b(i));
            }
        }
    }

    public Box getBoxForPos(int x, int y, int z) {
        int xMin = x - this.anchorX;
        int yMin = y - this.anchorY;
        int zMin = z - this.anchorZ;
        int xMax = x + this.sizeX - this.anchorX - 1;
        int yMax = y + this.sizeY - this.anchorY - 1;
        int zMax = z + this.sizeZ - this.anchorZ - 1;
        Box res = new Box();
        res.initialize(xMin, yMin, zMin, xMax, yMax, zMax);
        res.reorder();
        return res;
    }

    public BptContext getContext(World world, Box box) {
        return new BptContext(world, box, this.mapping);
    }

    public void addSubBlueprint(BlueprintBase subBpt, int x, int y, int z, ForgeDirection dir) {
        NBTTagCompound subNBT = new NBTTagCompound();
        subNBT.func_74768_a("x", x);
        subNBT.func_74768_a("y", y);
        subNBT.func_74768_a("z", z);
        subNBT.func_74774_a("dir", (byte)dir.ordinal());
        subNBT.func_74782_a("bpt", (NBTBase)subBpt.getNBT());
        this.subBlueprintsNBT.add(subNBT);
    }

    public NBTTagCompound getNBT() {
        if (this.nbt == null) {
            this.nbt = new NBTTagCompound();
            this.writeToNBTInternal(this.nbt);
        }
        return this.nbt;
    }

    public BlueprintBase adjustToWorld(World world, int x, int y, int z, ForgeDirection o) {
        if (this.buildingPermission == BuildingPermission.NONE || this.buildingPermission == BuildingPermission.CREATIVE_ONLY && world.func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE) {
            return null;
        }
        BptContext context = this.getContext(world, this.getBoxForPos(x, y, z));
        if (this.rotate && o != ForgeDirection.EAST) {
            if (o == ForgeDirection.SOUTH) {
                this.rotateLeft(context);
            } else if (o == ForgeDirection.WEST) {
                this.rotateLeft(context);
                this.rotateLeft(context);
            } else if (o == ForgeDirection.NORTH) {
                this.rotateLeft(context);
                this.rotateLeft(context);
                this.rotateLeft(context);
            }
        }
        Translation transform = new Translation();
        transform.x = x - this.anchorX;
        transform.y = y - this.anchorY;
        transform.z = z - this.anchorZ;
        this.translateToWorld(transform);
        return this;
    }

    public abstract void loadContents(NBTTagCompound var1) throws BptError;

    public abstract void saveContents(NBTTagCompound var1);

    public abstract void readFromWorld(IBuilderContext var1, TileEntity var2, int var3, int var4, int var5);

    public abstract ItemStack getStack();

    public void readEntitiesFromWorld(IBuilderContext context, TileEntity anchorTile) {
    }
}

