/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.BackwardsCompat;
import serverutils.events.ServerReloadEvent;
import serverutils.events.player.ForgePlayerLoadedEvent;
import serverutils.events.player.ForgePlayerSavedEvent;
import serverutils.events.team.ForgeTeamDeletedEvent;
import serverutils.events.team.ForgeTeamLoadedEvent;
import serverutils.events.team.ForgeTeamSavedEvent;
import serverutils.events.universe.UniverseClearCacheEvent;
import serverutils.events.universe.UniverseClosedEvent;
import serverutils.events.universe.UniverseLoadedEvent;
import serverutils.events.universe.UniverseSavedEvent;
import serverutils.lib.ATHelper;
import serverutils.lib.EnumReloadType;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.data.FakeForgePlayer;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.ServerUtilitiesAPI;
import serverutils.lib.data.TeamType;
import serverutils.lib.io.DataReader;
import serverutils.lib.math.MathUtils;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.task.Task;

public class Universe {
    private static final HashSet<UUID> LOGGED_IN_PLAYERS = new HashSet();
    private static Universe INSTANCE = null;
    public final MinecraftServer server;
    public WorldServer world;
    public final Map<UUID, ForgePlayer> players;
    private final Map<String, ForgeTeam> teams;
    private final HashMap<Short, ForgeTeam> teamMap;
    private final ForgeTeam noneTeam;
    private UUID uuid;
    private boolean needsSaving;
    boolean checkSaving;
    public ForgeTeam fakePlayerTeam;
    public FakeForgePlayer fakePlayer;
    private final List<Task> taskList;
    private final List<Task> taskQueue;
    public Ticks ticks;
    private boolean prevCheats = false;
    public File dataFolder;
    public File latModFolder;

    public static boolean loaded() {
        return INSTANCE != null;
    }

    public static Universe get() {
        if (INSTANCE == null) {
            throw new NullPointerException("ServerUtilities Universe == null!");
        }
        return INSTANCE;
    }

    public static void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        INSTANCE = new Universe(event.getServer());
    }

    public static void onServerStarted(FMLServerStartedEvent event) {
        Universe.INSTANCE.world = Universe.INSTANCE.server.field_71305_c[0];
        Universe.INSTANCE.ticks = Ticks.get(Universe.INSTANCE.world.func_82737_E());
        INSTANCE.load();
    }

    public static void onServerStopping(FMLServerStoppingEvent event) {
        if (Universe.loaded()) {
            for (ForgePlayer player : INSTANCE.getPlayers()) {
                if (!player.isOnline()) continue;
                player.onLoggedOut(player.getPlayer());
            }
            LOGGED_IN_PLAYERS.clear();
            INSTANCE.save();
            new UniverseClosedEvent(INSTANCE).post();
            INSTANCE = null;
        }
    }

    @SubscribeEvent
    public void onWorldSaved(WorldEvent.Save event) {
        if (Universe.loaded()) {
            INSTANCE.save();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP playerMP;
        EntityPlayer entityPlayer;
        if (Universe.loaded() && (entityPlayer = event.player) instanceof EntityPlayerMP && !ServerUtils.isFake(playerMP = (EntityPlayerMP)entityPlayer)) {
            LOGGED_IN_PLAYERS.add(playerMP.func_110124_au());
            INSTANCE.onPlayerLoggedIn(playerMP);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ForgePlayer p;
        EntityPlayerMP playerMP;
        EntityPlayer entityPlayer;
        if (Universe.loaded() && (entityPlayer = event.player) instanceof EntityPlayerMP && LOGGED_IN_PLAYERS.remove((playerMP = (EntityPlayerMP)entityPlayer).func_110124_au()) && (p = INSTANCE.getPlayer(playerMP.func_146103_bH())) != null) {
            p.onLoggedOut(playerMP);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(PlayerEvent.Clone event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            ForgePlayer p = INSTANCE.getPlayer(playerMP.func_146103_bH());
            if (p != null) {
                p.tempPlayer = playerMP;
            }
            INSTANCE.clearCache();
            if (p != null) {
                p.tempPlayer = null;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTickEvent(TickEvent.WorldTickEvent event) {
        if (!Universe.loaded()) {
            return;
        }
        Universe universe = Universe.get();
        if (event.phase == TickEvent.Phase.START) {
            universe.ticks = Ticks.get(event.world.func_82737_E());
        } else if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            boolean cheats;
            universe.taskList.addAll(universe.taskQueue);
            universe.taskQueue.clear();
            Iterator<Task> taskIterator = universe.taskList.iterator();
            while (taskIterator.hasNext()) {
                Task task = taskIterator.next();
                if (!task.isComplete(universe)) continue;
                task.execute(universe);
                if (task.isRepeatable()) {
                    task.setNextTime(System.currentTimeMillis() + task.getInterval());
                    continue;
                }
                taskIterator.remove();
            }
            if (universe.server.func_71264_H() && universe.prevCheats != (cheats = ATHelper.areCommandsAllowedForAll(universe.server.func_71203_ab()))) {
                universe.prevCheats = cheats;
                universe.clearCache();
            }
        }
    }

    public Universe(MinecraftServer s) {
        this.server = s;
        this.ticks = Ticks.NO_TICKS;
        this.players = new HashMap<UUID, ForgePlayer>();
        this.teams = new HashMap<String, ForgeTeam>();
        this.teamMap = new HashMap();
        this.noneTeam = new ForgeTeam(this, 0, "", TeamType.NONE);
        this.uuid = null;
        this.needsSaving = false;
        this.checkSaving = true;
        this.taskList = new ArrayList<Task>();
        this.taskQueue = new ArrayList<Task>();
    }

    public void markDirty() {
        this.needsSaving = true;
        this.checkSaving = true;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public void scheduleTask(Task task) {
        this.scheduleTask(task, true);
    }

    public void scheduleTask(Task task, boolean condition) {
        if (!condition) {
            return;
        }
        if (task.getNextTime() <= -1L) {
            return;
        }
        this.taskQueue.add(task);
    }

    private void load() {
        NBTTagCompound nbt;
        File[] files;
        File worldDataJsonFile;
        JsonElement worldData;
        this.dataFolder = new File(this.getWorldDirectory(), "serverutilities/");
        this.latModFolder = new File(this.getWorldDirectory(), "LatMod");
        NBTTagCompound universeData = NBTUtils.readNBT(new File(this.dataFolder, "universe.dat"));
        if (universeData == null) {
            universeData = new NBTTagCompound();
        }
        if ((worldData = DataReader.get(worldDataJsonFile = new File(this.getWorldDirectory(), "world_data.json")).safeJson()).isJsonObject()) {
            JsonObject jsonWorldData = worldData.getAsJsonObject();
            if (jsonWorldData.has("world_id")) {
                universeData.func_74778_a("UUID", jsonWorldData.get("world_id").getAsString());
            }
            worldDataJsonFile.delete();
        }
        this.uuid = StringUtils.fromString(universeData.func_74779_i("UUID"));
        if (this.uuid != null && this.uuid.getLeastSignificantBits() == 0L && this.uuid.getMostSignificantBits() == 0L) {
            this.uuid = null;
        }
        NBTTagCompound data = universeData.func_74775_l("Data");
        new UniverseLoadedEvent.Pre(this, data).post();
        HashMap<UUID, NBTTagCompound> playerNBT = new HashMap<UUID, NBTTagCompound>();
        HashMap<String, NBTTagCompound> teamNBT = new HashMap<String, NBTTagCompound>();
        try {
            files = new File(this.dataFolder, "players").listFiles();
            if (files != null) {
                for (File file : files) {
                    UUID uuid;
                    if (!file.isFile() || !file.getName().endsWith(".dat") || file.getName().indexOf(46) != file.getName().lastIndexOf(46) || (nbt = NBTUtils.readNBT(file)) == null) continue;
                    String uuidString = nbt.func_74779_i("UUID");
                    if (uuidString.isEmpty()) {
                        uuidString = FileUtils.getBaseName(file);
                        FileUtils.deleteSafe(file);
                    }
                    if ((uuid = StringUtils.fromString(uuidString)) == null) continue;
                    playerNBT.put(uuid, nbt);
                    ForgePlayer player = new ForgePlayer(this, uuid, nbt.func_74779_i("Name"));
                    this.players.put(uuid, player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            files = new File(this.dataFolder, "teams").listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".dat") || file.getName().indexOf(46) != file.getName().lastIndexOf(46) || (nbt = NBTUtils.readNBT(file)) == null) continue;
                    String s = nbt.func_74779_i("ID");
                    if (s.isEmpty()) {
                        s = FileUtils.getBaseName(file);
                    }
                    teamNBT.put(s, nbt);
                    short uid = nbt.func_74765_d("UID");
                    ForgeTeam team = new ForgeTeam(this, this.generateTeamUID(uid), s, TeamType.NAME_MAP.get(nbt.func_74779_i("Type")));
                    this.addTeam(team);
                    if (uid != 0) continue;
                    team.markDirty();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.fakePlayerTeam = new ForgeTeam(this, 1, "fakeplayer", TeamType.SERVER_NO_SAVE){

            @Override
            public void markDirty() {
                Universe.this.markDirty();
            }
        };
        this.fakePlayer = new FakeForgePlayer(this);
        this.fakePlayer.team = this.fakePlayerTeam;
        this.fakePlayerTeam.setColor(EnumTeamColor.GRAY);
        new UniverseLoadedEvent.CreateServerTeams(this).post();
        for (ForgePlayer player : this.players.values()) {
            NBTTagCompound nbt2 = (NBTTagCompound)playerNBT.get(player.getId());
            if (nbt2 != null && !nbt2.func_82582_d()) {
                player.team = this.getTeam(nbt2.func_74779_i("TeamID"));
                player.deserializeNBT(nbt2);
            }
            new ForgePlayerLoadedEvent(player).post();
        }
        for (ForgeTeam team : this.getTeams()) {
            if (!team.type.save) continue;
            NBTTagCompound nbt3 = (NBTTagCompound)teamNBT.get(team.getId());
            if (nbt3 != null && !nbt3.func_82582_d()) {
                team.deserializeNBT(nbt3);
            }
            new ForgeTeamLoadedEvent(team).post();
        }
        if (universeData.func_74764_b("FakePlayer")) {
            this.fakePlayer.deserializeNBT(universeData.func_74775_l("FakePlayer"));
        }
        if (universeData.func_74764_b("FakeTeam")) {
            this.fakePlayerTeam.deserializeNBT(universeData.func_74775_l("FakeTeam"));
        }
        this.fakePlayerTeam.owner = this.fakePlayer;
        new UniverseLoadedEvent.Post(this, data).post();
        if (this.shouldLoadLatmod()) {
            BackwardsCompat.load();
        }
        new UniverseLoadedEvent.Finished(this).post();
        ServerUtilitiesAPI.reloadServer(this, (ICommandSender)this.server, EnumReloadType.CREATED, ServerReloadEvent.ALL);
    }

    private void save() {
        if (!this.checkSaving) {
            return;
        }
        if (this.needsSaving) {
            if (ServerUtilitiesConfig.debugging.print_more_info) {
                ServerUtilities.LOGGER.info("Saving universe data");
            }
            NBTTagCompound universeData = new NBTTagCompound();
            NBTTagCompound data = new NBTTagCompound();
            new UniverseSavedEvent(this, data).post();
            universeData.func_74782_a("Data", (NBTBase)data);
            universeData.func_74778_a("UUID", StringUtils.fromUUID(this.getUUID()));
            universeData.func_74782_a("FakePlayer", (NBTBase)this.fakePlayer.serializeNBT());
            universeData.func_74782_a("FakeTeam", (NBTBase)this.fakePlayerTeam.serializeNBT());
            NBTUtils.writeNBTSafe(new File(this.dataFolder, "universe.dat"), universeData);
            this.needsSaving = false;
        }
        for (ForgePlayer player : this.players.values()) {
            if (!player.needsSaving) continue;
            if (ServerUtilitiesConfig.debugging.print_more_info) {
                ServerUtilities.LOGGER.info("Saved player data for " + player.getName());
            }
            NBTTagCompound nbt = player.serializeNBT();
            nbt.func_74778_a("Name", player.getName());
            nbt.func_74778_a("UUID", StringUtils.fromUUID(player.getId()));
            nbt.func_74778_a("TeamID", player.team.getId());
            NBTUtils.writeNBTSafe(player.getDataFile(), nbt);
            new ForgePlayerSavedEvent(player).post();
            player.needsSaving = false;
        }
        for (ForgeTeam team : this.getTeams()) {
            if (!team.needsSaving) continue;
            if (ServerUtilitiesConfig.debugging.print_more_info) {
                ServerUtilities.LOGGER.info("Saved team data for {}", new Object[]{team.getId()});
            }
            File file = team.getDataFile("");
            if (team.type.save && team.isValid()) {
                NBTTagCompound nbt = team.serializeNBT();
                nbt.func_74778_a("ID", team.getId());
                nbt.func_74777_a("UID", team.getUID());
                nbt.func_74778_a("Type", team.type.getName());
                NBTUtils.writeNBTSafe(file, nbt);
                new ForgeTeamSavedEvent(team).post();
            } else if (file.exists()) {
                file.delete();
            }
            team.needsSaving = false;
        }
        this.checkSaving = false;
    }

    public File getWorldDirectory() {
        return this.server.field_71305_c[0].func_72860_G().func_75765_b();
    }

    private void onPlayerLoggedIn(EntityPlayerMP player) {
        if (!player.field_71133_b.func_71203_ab().func_152607_e(player.func_146103_bH())) {
            return;
        }
        ForgePlayer p = this.getPlayer(player.func_146103_bH());
        if (p == null) {
            p = new ForgePlayer(this, player.func_110124_au(), player.func_70005_c_());
            this.players.put(p.getId(), p);
            p.onLoggedIn(player, this, true);
        } else {
            if (!p.getId().equals(player.func_110124_au()) || !p.getName().equals(player.func_70005_c_())) {
                File old = p.getDataFile();
                this.players.remove(p.getId());
                p.profile = new GameProfile(player.func_110124_au(), player.func_70005_c_());
                this.players.put(p.getId(), p);
                old.renameTo(p.getDataFile());
                p.markDirty();
                p.team.markDirty();
                this.markDirty();
            }
            p.onLoggedIn(player, this, false);
        }
    }

    public Collection<ForgePlayer> getPlayers() {
        return this.players.values();
    }

    @Nullable
    public ForgePlayer getPlayer(@Nullable UUID id) {
        if (id == null) {
            return null;
        }
        if (id.equals(ServerUtils.FAKE_PLAYER_PROFILE.getId())) {
            return this.fakePlayer;
        }
        return this.players.get(id);
    }

    @Nullable
    public ForgePlayer getPlayer(CharSequence nameOrId) {
        String s = nameOrId.toString().toLowerCase();
        if (s.isEmpty()) {
            return null;
        }
        UUID id = StringUtils.fromString(s);
        if (id != null) {
            return this.getPlayer(id);
        }
        if (s.equals(ServerUtils.FAKE_PLAYER_PROFILE.getName().toLowerCase())) {
            return this.fakePlayer;
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.getName().toLowerCase().equals(s)) continue;
            return p;
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.getName().toLowerCase().contains(s)) continue;
            return p;
        }
        return null;
    }

    public ForgePlayer getPlayer(@Nullable ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (ServerUtils.isFake(player)) {
                this.fakePlayer.tempPlayer = player;
                this.fakePlayer.clearCache();
                return this.fakePlayer;
            }
            ForgePlayer p = this.getPlayer(player.func_146103_bH());
            if (p == null) {
                throw new NullPointerException("Player can't be found for " + player.func_70005_c_() + ":" + StringUtils.fromUUID(player.func_110124_au()) + ":" + player.getClass().getName());
            }
            return p;
        }
        throw new IllegalArgumentException("Sender is not a player!");
    }

    public ForgePlayer getPlayer(ForgePlayer player) {
        ForgePlayer p = this.getPlayer(player.getId());
        return p == null ? player : p;
    }

    @Nullable
    public ForgePlayer getPlayer(GameProfile profile) {
        ForgePlayer player = this.getPlayer(profile.getId());
        if (player == null && ServerUtilitiesConfig.general.merge_offline_mode_players.get(!this.server.func_71262_S()) && (player = this.getPlayer(profile.getName())) != null) {
            this.players.put(profile.getId(), player);
            player.markDirty();
        }
        return player;
    }

    public Collection<ForgeTeam> getTeams() {
        return this.teams.values();
    }

    public ForgeTeam getTeam(String id) {
        ForgeTeam team2;
        if (id.isEmpty()) {
            return this.noneTeam;
        }
        if (id.length() == 4) {
            try {
                team2 = this.getTeam(Integer.valueOf(id, 16).shortValue());
                if (team2.isValid()) {
                    return team2;
                }
            }
            catch (Exception team2) {
                // empty catch block
            }
        }
        if (id.equals("fakeplayer")) {
            return this.fakePlayerTeam;
        }
        team2 = this.teams.get(id);
        if (team2 != null) {
            return team2;
        }
        ForgePlayer player = this.getPlayer(id);
        if (player != null) {
            return player.team;
        }
        return this.noneTeam;
    }

    public ForgeTeam getTeam(short uid) {
        if (uid == 0) {
            return this.noneTeam;
        }
        if (uid == 1) {
            return this.fakePlayerTeam;
        }
        ForgeTeam team = this.teamMap.get(uid);
        return team == null ? this.noneTeam : team;
    }

    public Collection<ForgePlayer> getOnlinePlayers() {
        Set<ForgePlayer> set = Collections.emptySet();
        for (ForgePlayer player : this.getPlayers()) {
            if (!player.isOnline()) continue;
            if (set.isEmpty()) {
                set = new HashSet<ForgePlayer>();
            }
            set.add(player);
        }
        return set;
    }

    public void clearCache() {
        new UniverseClearCacheEvent(this).post();
        this.getTeams().forEach(ForgeTeam::clearCache);
        this.getPlayers().forEach(ForgePlayer::clearCache);
        this.fakePlayer.clearCache();
    }

    public void addTeam(ForgeTeam team) {
        this.teamMap.put(team.getUID(), team);
        this.teams.put(team.getId(), team);
    }

    public void removeTeam(ForgeTeam team) {
        File folder = new File(this.dataFolder, "teams/");
        new ForgeTeamDeletedEvent(team, folder).post();
        this.teamMap.remove(team.getUID());
        this.teams.remove(team.getId());
        FileUtils.deleteSafe(new File(folder, team.getId() + ".dat"));
        this.markDirty();
        this.clearCache();
    }

    public short generateTeamUID(short id) {
        while (id == 0 || id == 1 || id == 2 || this.teamMap.containsKey(id)) {
            id = (short)MathUtils.RAND.nextInt();
        }
        return id;
    }

    public boolean shouldLoadLatmod() {
        return this.latModFolder.exists() && !Universe.get().dataFolder.exists();
    }
}

