/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.pipe;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.common.GTClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.TecTech;
import tectech.loader.NetworkDispatcher;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.mechanics.pipe.PipeActivityMessage;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;
import tectech.thing.metaTileEntity.pipe.MTEPipeEnergy;
import tectech.util.CommonValues;

public class MTEPipeEnergyMirror
extends MTEPipeEnergy {
    private static Textures.BlockIcons.CustomIcon EMpipe;
    private ForgeDirection[] connectedSides = new ForgeDirection[]{null, null};
    private ForgeDirection chainedFrontFacing = null;
    private boolean active;

    public MTEPipeEnergyMirror(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPipeEnergyMirror(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEPipeEnergyMirror(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        EMpipe = new Textures.BlockIcons.CustomIcon("iconsets/EM_LASERMIRROR");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int colorIndex, boolean aConnected, boolean aRedstone) {
        return new ITexture[]{new GTRenderedTexture(EMpipe), new GTRenderedTexture(this.getActive() ? EMCandyActive : EMcandy, Dyes.getModulation(colorIndex, Dyes.MACHINE_METAL.getRGBA()))};
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energymirror.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energystream.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energystream.desc.2"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.energymirror.desc.1")};
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if ((aTick & 0x1FL) == 31L) {
                if (TecTech.RANDOM.nextInt(15) == 0) {
                    NetworkDispatcher.INSTANCE.sendToAllAround(new PipeActivityMessage.PipeActivityData(this), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), 256.0);
                }
                if (this.active) {
                    this.active = false;
                }
                this.mConnections = 0;
                this.connectedSides[0] = null;
                this.connectedSides[1] = null;
                this.connectionCount = 0;
                if (aBaseMetaTileEntity.getColorization() < 0) {
                    return;
                }
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    PowerLogic logic;
                    byte tColor;
                    if (this.connectionCount >= 2) continue;
                    ForgeDirection oppositeSide = side.getOpposite();
                    TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(side);
                    if (tTileEntity instanceof IColoredTileEntity && (tColor = ((IColoredTileEntity)tTileEntity).getColorization()) != aBaseMetaTileEntity.getColorization()) continue;
                    if (tTileEntity instanceof PowerLogicHost && (logic = ((PowerLogicHost)tTileEntity).getPowerLogic(oppositeSide)) != null && logic.canUseLaser()) {
                        this.mConnections = (byte)(this.mConnections | 1 << side.ordinal());
                        this.connectedSides[this.connectionCount] = side;
                        this.connectionCount = (byte)(this.connectionCount + 1);
                        continue;
                    }
                    if (tTileEntity instanceof IConnectsToEnergyTunnel && ((IConnectsToEnergyTunnel)tTileEntity).canConnect(oppositeSide)) {
                        this.mConnections = (byte)(this.mConnections | 1 << side.ordinal());
                        this.connectedSides[this.connectionCount] = side;
                        this.connectionCount = (byte)(this.connectionCount + 1);
                        continue;
                    }
                    if (!(tTileEntity instanceof IGregTechTileEntity) || !(((IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof IConnectsToEnergyTunnel) || !((IConnectsToEnergyTunnel)((Object)((IGregTechTileEntity)tTileEntity).getMetaTileEntity())).canConnect(oppositeSide)) continue;
                    this.mConnections = (byte)(this.mConnections | 1 << side.ordinal());
                    this.connectedSides[this.connectionCount] = side;
                    this.connectionCount = (byte)(this.connectionCount + 1);
                }
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GTClient.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    public ForgeDirection getBendDirection(ForgeDirection dir) {
        if (dir == null) {
            return null;
        }
        for (ForgeDirection bendDir : this.connectedSides) {
            if (bendDir == null || bendDir == dir) continue;
            this.chainedFrontFacing = bendDir.getOpposite();
            return bendDir;
        }
        return null;
    }

    public ForgeDirection getChainedFrontFacing() {
        return this.chainedFrontFacing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IGregTechTileEntity bendAround(ForgeDirection inputSide) {
        byte color = this.getBaseMetaTileEntity().getColorization();
        if (color < 0) {
            return null;
        }
        ForgeDirection direction = this.getBendDirection(inputSide);
        if (direction == null) {
            return null;
        }
        ForgeDirection opposite = direction.getOpposite();
        for (int dist = 1; dist < 1000; dist = (int)((short)(dist + 1))) {
            IGregTechTileEntity tGTTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance(direction, dist);
            if (tGTTileEntity == null || tGTTileEntity.getColorization() != color) return null;
            IMetaTileEntity aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
            if (aMetaTileEntity != null) {
                if (aMetaTileEntity instanceof MTEPipeEnergyMirror) {
                    MTEPipeEnergyMirror tMirror = (MTEPipeEnergyMirror)aMetaTileEntity;
                    tGTTileEntity = tMirror.bendAround(opposite);
                    if (tGTTileEntity == null) return null;
                    aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
                    opposite = this.chainedFrontFacing = tMirror.getChainedFrontFacing();
                }
                if (aMetaTileEntity instanceof MTEHatchEnergyTunnel && opposite == tGTTileEntity.getFrontFacing()) {
                    return tGTTileEntity;
                }
                if (!(aMetaTileEntity instanceof MTEPipeEnergy)) return null;
                if (((MTEPipeEnergy)aMetaTileEntity).connectionCount < 2) {
                    return null;
                }
            } else {
                PowerLogic logic;
                if (!(tGTTileEntity instanceof PowerLogicHost) || (logic = ((PowerLogicHost)((Object)tGTTileEntity)).getPowerLogic(opposite)) != null && logic.canUseLaser() && opposite == tGTTileEntity.getFrontFacing()) return null;
                return tGTTileEntity;
            }
            ((MTEPipeEnergy)aMetaTileEntity).markUsed();
        }
        return null;
    }

    @Override
    public float getThickNess() {
        if (GTMod.instance.isClientSide() && GTClient.hideValue == 1) {
            return 0.0625f;
        }
        return 0.6f;
    }
}

