/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.block;

import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import java.nio.FloatBuffer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import tectech.rendering.EOH.EOHTileEntitySR;
import tectech.thing.block.BlockGodforgeGlass;
import tectech.thing.block.TileEntityForgeOfGods;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.multi.ForgeOfGodsRingsStructureString;
import tectech.thing.metaTileEntity.multi.ForgeOfGodsStructureString;
import tectech.util.StructureVBO;
import tectech.util.TextureUpdateRequester;

public class RenderForgeOfGods
extends TileEntitySpecialRenderer {
    private static ShaderProgram starProgram;
    private static IModelCustom starModel;
    private static float modelNormalize;
    private static boolean initialized;
    private static boolean failedInit;
    private static int u_Color;
    private static int u_ModelMatrix;
    private static int u_Gamma;
    private Matrix4fStack starModelMatrix = new Matrix4fStack(3);
    private static ShaderProgram beamProgram;
    private static int a_VertexID;
    private static int u_BeamModelMatrix;
    private static int u_CameraPosition;
    private static int u_SegmentArray;
    private static int u_SegmentQuads;
    private static int u_BeamIntensity;
    private static int u_BeamColor;
    private static int u_BeamTime;
    private static int beam_vboID;
    private static int maxSegments;
    private static final int beamSegmentQuads = 16;
    private static Matrix4fStack beamModelMatrix;
    private VertexBuffer ringOne;
    private VertexBuffer ringTwo;
    private VertexBuffer ringThree;
    private static final Vector3f ringOneNudge;
    private static final Vector3f ringTwoNudge;
    private static final Vector3f ringThreeNudge;
    private static ShaderProgram fadeBypassProgram;
    private static TextureUpdateRequester textureUpdater;

    private void init() {
        try {
            starProgram = new ShaderProgram("tectech", "shaders/star.vert.glsl", "shaders/star.frag.glsl");
            u_Color = starProgram.getUniformLocation("u_Color");
            u_Gamma = starProgram.getUniformLocation("u_Gamma");
            u_ModelMatrix = starProgram.getUniformLocation("u_ModelMatrix");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        starModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tectech", "models/Star.obj"));
        try {
            beamProgram = new ShaderProgram("tectech", "shaders/gorgeBeam.vert.glsl", "shaders/gorgeBeam.frag.glsl");
            u_BeamModelMatrix = beamProgram.getUniformLocation("u_ModelMatrix");
            u_CameraPosition = beamProgram.getUniformLocation("u_CameraPosition");
            u_SegmentQuads = beamProgram.getUniformLocation("u_SegmentQuads");
            u_SegmentArray = beamProgram.getUniformLocation("u_SegmentArray");
            u_BeamColor = beamProgram.getUniformLocation("u_Color");
            u_BeamIntensity = beamProgram.getUniformLocation("u_Intensity");
            u_BeamTime = beamProgram.getUniformLocation("u_Time");
            a_VertexID = beamProgram.getAttribLocation("a_VertexID");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        beamProgram.use();
        GL20.glUniform1f((int)u_SegmentQuads, (float)16.0f);
        maxSegments = 10;
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(maxSegments * 16 * 6 * 3));
        for (int i = 0; i < maxSegments; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int v = 0; v < 6; ++v) {
                    int segID = i * 16 * 6;
                    int quadID = j * 6;
                    int vertID = segID + quadID + v;
                    buffer.put(vertID);
                    buffer.put(0.0f);
                    buffer.put(0.0f);
                }
            }
        }
        buffer.flip();
        beam_vboID = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)beam_vboID);
        GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        GL20.glVertexAttribPointer((int)a_VertexID, (int)1, (int)5126, (boolean)false, (int)12, (long)0L);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)0);
        ShaderProgram.clear();
        initialized = true;
    }

    private void initRings() {
        StructureVBO ringStructure = new StructureVBO().addMapping('H', (Block)BlockGodforgeGlass.INSTANCE, 0).addMapping('B', TTCasingsContainer.GodforgeCasings, 0).addMapping('C', TTCasingsContainer.GodforgeCasings, 1).addMapping('D', TTCasingsContainer.GodforgeCasings, 2).addMapping('E', TTCasingsContainer.GodforgeCasings, 3).addMapping('G', TTCasingsContainer.GodforgeCasings, 5).addMapping('K', TTCasingsContainer.GodforgeCasings, 6).addMapping('I', TTCasingsContainer.GodforgeCasings, 7);
        this.ringOne = ringStructure.assignStructure(ForgeOfGodsStructureString.FIRST_RING).build();
        this.ringTwo = ringStructure.assignStructure(ForgeOfGodsRingsStructureString.SECOND_RING).build();
        this.ringThree = ringStructure.assignStructure(ForgeOfGodsRingsStructureString.THIRD_RING).build();
        fadeBypassProgram = new ShaderProgram("tectech", "shaders/fadebypass.vert.glsl", "shaders/fadebypass.frag.glsl");
        textureUpdater = ringStructure.getTextureUpdateRequestor();
    }

    public void RenderStarLayer(Vector4f color, ResourceLocation texture, float size, Vector3f rotationAxis, float degrees) {
        this.starModelMatrix.pushMatrix();
        this.starModelMatrix.rotate(degrees / 180.0f * (float)Math.PI, rotationAxis.x, rotationAxis.y, rotationAxis.z);
        this.starModelMatrix.scale(size, size, size);
        this.func_147499_a(texture);
        GL11.glPushAttrib((int)1048575);
        if (color.w < 1.0f && color.w > 0.0f) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)false);
        }
        FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
        GL20.glUniformMatrix4((int)u_ModelMatrix, (boolean)false, (FloatBuffer)this.starModelMatrix.get(matrixBuffer));
        GL20.glUniform4f((int)u_Color, (float)color.x, (float)color.y, (float)color.z, (float)color.w);
        starModel.renderAll();
        GL11.glPopAttrib();
        this.starModelMatrix.popMatrix();
    }

    public void RenderEntireStar(TileEntityForgeOfGods tile, double x, double y, double z, float timer) {
        GL11.glPushAttrib((int)1048575);
        GL13.glActiveTexture((int)33984);
        GL11.glDisable((int)2896);
        starProgram.use();
        float cx = (float)x + 0.5f;
        float cy = (float)y + 0.5f;
        float cz = (float)z + 0.5f;
        float size = modelNormalize;
        this.starModelMatrix.clear();
        this.starModelMatrix.translate(cx, cy, cz);
        float r = tile.getColorR();
        float g = tile.getColorG();
        float b = tile.getColorB();
        GL20.glUniform1f((int)u_Gamma, (float)tile.getGamma());
        this.RenderStarLayer(new Vector4f(r, g, b, 1.0f), EOHTileEntitySR.STAR_LAYER_0, size *= tile.getStarRadius(), new Vector3f(0.0f, 1.0f, 1.0f).normalize(), 130.0f + (timer *= tile.getRotationSpeed()) % 360000.0f);
        this.RenderStarLayer(new Vector4f(r, g, b, 0.4f), EOHTileEntitySR.STAR_LAYER_1, size * 1.02f, new Vector3f(1.0f, 1.0f, 0.0f).normalize(), -49.0f + timer % 360000.0f);
        this.RenderStarLayer(new Vector4f(r, g, b, 0.2f), EOHTileEntitySR.STAR_LAYER_2, size * 1.04f, new Vector3f(1.0f, 0.0f, 1.0f).normalize(), 67.0f + timer % 360000.0f);
        ShaderProgram.clear();
        GL11.glPopAttrib();
    }

    public void bufferSoftBeam(TileEntityForgeOfGods tile) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(maxSegments * 3));
        float angle = tile.getStartAngle();
        float radius = tile.getStarRadius() * 1.1f;
        float startx = -radius * (float)Math.cos(angle);
        float starty = radius * (float)Math.sin(angle);
        buffer.put(starty);
        buffer.put(startx);
        buffer.put(0.0f);
        for (int i = tile.getRingCount() - 1; i >= 0; --i) {
            buffer.put(tile.getLenRadius(i));
            buffer.put(tile.getLensDistance(i));
            buffer.put(1.0f);
        }
        buffer.put(13.0f);
        buffer.put(-121.5f);
        buffer.put(-0.05f);
        buffer.rewind();
        GL20.glUniform3((int)u_SegmentArray, (FloatBuffer)buffer);
    }

    public void bufferIntenseBeam(TileEntityForgeOfGods tile) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(maxSegments * 3));
        float angle = tile.getStartAngle();
        float radius = tile.getStarRadius() * 1.05f;
        float startx = -radius * (float)Math.cos(angle);
        float starty = radius * (float)Math.sin(angle);
        int firstLens = tile.getRingCount() - 1;
        float nextx = tile.getLensDistance(firstLens);
        float nexty = tile.getLenRadius(firstLens) * 0.75f;
        float backx = Math.max(-radius, (nextx + radius) / 2.0f);
        float backy = TileEntityForgeOfGods.interpolate(startx, nextx, starty, nexty, backx);
        buffer.put(backy);
        buffer.put(backx);
        buffer.put(0.0f);
        float transparency = 0.2f;
        for (int i = tile.getRingCount() - 1; i >= 0; --i) {
            buffer.put(tile.getLenRadius(i) / 2.0f);
            buffer.put(tile.getLensDistance(i));
            buffer.put(transparency);
            transparency += 0.3f;
        }
        float currx = tile.getLensDistance(0);
        float curry = tile.getLenRadius(0) / 2.0f;
        float lastx = -121.5f;
        float lasty = Math.min(tile.getLenRadius(firstLens), 13.0f);
        float midx = lastx + 8.0f;
        float midy = TileEntityForgeOfGods.interpolate(currx, lastx, curry, lasty, midx);
        buffer.put(midy);
        buffer.put(midx);
        buffer.put(transparency);
        buffer.put(lasty);
        buffer.put(lastx);
        buffer.put(0.0f);
        buffer.rewind();
        GL20.glUniform3((int)u_SegmentArray, (FloatBuffer)buffer);
    }

    public void RenderBeamSegment(TileEntityForgeOfGods tile, double x, double y, double z, float timer) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL13.glActiveTexture((int)33984);
        this.func_147499_a(new ResourceLocation("tectech", "models/spaceLayer.png"));
        float cx = (float)x + 0.5f;
        float cy = (float)y + 0.5f;
        float cz = (float)z + 0.5f;
        beamModelMatrix.clear();
        beamModelMatrix.translate(cx, cy, cz);
        beamModelMatrix.rotate(tile.getRotAngle() / 180.0f * (float)Math.PI, tile.getRotAxisX(), tile.getRotAxisY(), tile.getRotAxisZ());
        beamModelMatrix.rotate(1.5707964f, 0.0f, 1.0f, 0.0f);
        beamProgram.use();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)false);
        this.bufferSoftBeam(tile);
        FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
        GL20.glUniformMatrix4((int)u_BeamModelMatrix, (boolean)false, (FloatBuffer)beamModelMatrix.get(matrixBuffer));
        beamModelMatrix.invert();
        Vector4f cameraPosition = new Vector4f(ActiveRenderInfo.field_74592_a, ActiveRenderInfo.field_74590_b, ActiveRenderInfo.field_74591_c, 1.0f);
        cameraPosition = beamModelMatrix.transform(cameraPosition);
        GL20.glUniform3f((int)u_CameraPosition, (float)cameraPosition.x, (float)cameraPosition.y, (float)cameraPosition.z);
        GL20.glUniform3f((int)u_BeamColor, (float)tile.getColorR(), (float)tile.getColorG(), (float)tile.getColorB());
        GL20.glUniform1f((int)u_BeamIntensity, (float)2.0f);
        GL20.glUniform1f((int)u_BeamTime, (float)timer);
        GL20.glEnableVertexAttribArray((int)a_VertexID);
        GL11.glEnableClientState((int)32884);
        GL11.glDrawArrays((int)4, (int)0, (int)(maxSegments * 16 * 6));
        GL20.glUniform3f((int)u_BeamColor, (float)1.0f, (float)1.0f, (float)1.0f);
        GL20.glUniform1f((int)u_BeamIntensity, (float)4.0f);
        this.bufferIntenseBeam(tile);
        GL11.glDrawArrays((int)4, (int)0, (int)(maxSegments * 16 * 6));
        GL20.glDisableVertexAttribArray((int)a_VertexID);
        GL11.glDisableClientState((int)32884);
        GL11.glPopAttrib();
        ShaderProgram.clear();
    }

    private void RenderRings(TileEntityForgeOfGods tile, double x, double y, double z, float timer) {
        this.func_147499_a(TextureMap.field_110575_b);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        textureUpdater.requestUpdate();
        fadeBypassProgram.use();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotatef((float)tile.getRotAngle(), (float)tile.getRotAxisX(), (float)tile.getRotAxisY(), (float)tile.getRotAxisZ());
        GL11.glRotatef((float)(timer / 6.0f * 7.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)RenderForgeOfGods.ringOneNudge.x, (double)RenderForgeOfGods.ringOneNudge.y, (double)RenderForgeOfGods.ringOneNudge.z);
        this.ringOne.render();
        GL11.glPopMatrix();
        if (tile.getRingCount() > 1) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glRotatef((float)tile.getRotAngle(), (float)tile.getRotAxisX(), (float)tile.getRotAxisY(), (float)tile.getRotAxisZ());
            GL11.glRotatef((float)(-timer / 4.0f * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)RenderForgeOfGods.ringTwoNudge.x, (double)RenderForgeOfGods.ringTwoNudge.y, (double)RenderForgeOfGods.ringTwoNudge.z);
            this.ringTwo.render();
            GL11.glPopMatrix();
            if (tile.getRingCount() > 2) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                GL11.glRotatef((float)tile.getRotAngle(), (float)tile.getRotAxisX(), (float)tile.getRotAxisY(), (float)tile.getRotAxisZ());
                GL11.glRotatef((float)(timer * 3.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)RenderForgeOfGods.ringThreeNudge.x, (double)RenderForgeOfGods.ringThreeNudge.y, (double)RenderForgeOfGods.ringThreeNudge.z);
                this.ringThree.render();
                GL11.glPopMatrix();
            }
        }
        ShaderProgram.clear();
        GL11.glPopAttrib();
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (failedInit) {
            return;
        }
        if (!(tile instanceof TileEntityForgeOfGods)) {
            return;
        }
        TileEntityForgeOfGods forgeTile = (TileEntityForgeOfGods)tile;
        if (forgeTile.getRingCount() < 1) {
            return;
        }
        if (!initialized) {
            this.init();
            if (!initialized) {
                failedInit = true;
                return;
            }
            try {
                this.initRings();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                failedInit = true;
                return;
            }
        }
        long millis = System.currentTimeMillis() % 36000000L;
        float timer = (float)millis / 50.0f;
        this.RenderEntireStar(forgeTile, x, y, z, timer);
        this.RenderRings(forgeTile, x, y, z, timer);
        this.RenderBeamSegment(forgeTile, x, y, z, timer);
    }

    public static void enablePseudoTransparentColorInversion() {
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5389);
    }

    public static void enableOpaqueColorInversion() {
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5388);
    }

    public static void disableOpaqueColorInversion() {
        GL11.glDisable((int)3058);
    }

    static {
        modelNormalize = 0.0134f;
        initialized = false;
        failedInit = false;
        u_Color = -1;
        u_ModelMatrix = -1;
        u_Gamma = -1;
        a_VertexID = -1;
        u_BeamModelMatrix = -1;
        u_CameraPosition = -1;
        u_SegmentArray = -1;
        u_SegmentQuads = -1;
        u_BeamIntensity = -1;
        u_BeamColor = -1;
        u_BeamTime = -1;
        beam_vboID = -1;
        maxSegments = -1;
        beamModelMatrix = new Matrix4fStack(2);
        ringOneNudge = new Vector3f(0.0f, -1.0f, 0.0f);
        ringTwoNudge = new Vector3f(0.0f, -1.0f, 0.0f);
        ringThreeNudge = new Vector3f(0.5f, -1.0f, 0.0f);
    }
}

