/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.enums;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Element;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TCAspects;
import gregtech.api.enums.TextureSet;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.ICondition;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GTConfig;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.xmod.gregtech.api.interfaces.internal.IOreRecipeRegistrator;
import gtPlusPlus.xmod.gregtech.api.objects.GregtechItemData;
import gtPlusPlus.xmod.gregtech.api.objects.GregtechMaterialStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public enum GregtechOrePrefixes {
    ingotHot("Hot Ingots", "Hot ", " Ingot", true, true, false, false, false, false, false, true, false, false, GTValues.B[1], 3628800L, 16, 12),
    ingot("Ingots", "", " Ingot", true, true, false, false, false, false, false, true, false, false, GTValues.B[1], 3628800L, 64, 11),
    dustTiny("Tiny Dusts", "Tiny Pile of ", " Dust", true, true, false, false, false, false, false, true, false, false, GTValues.B[0] | GTValues.B[1] | GTValues.B[2] | GTValues.B[3], 403200L, 64, 0),
    dustSmall("Small Dusts", "Small Pile of ", " Dust", true, true, false, false, false, false, false, true, false, false, GTValues.B[0] | GTValues.B[1] | GTValues.B[2] | GTValues.B[3], 907200L, 64, 1),
    dustImpure("Impure Dusts", "Impure Pile of ", " Dust", true, true, false, false, false, false, false, true, false, true, GTValues.B[3], 3628800L, 64, 3),
    dustRefined("Refined Dusts", "Refined Pile of ", " Dust", true, true, false, false, false, false, false, true, false, true, GTValues.B[3], 3628800L, 64, 2),
    dustPure("Purified Dusts", "Purified Pile of ", " Dust", true, true, false, false, false, false, false, true, false, true, GTValues.B[3], 3628800L, 64, 4),
    dust("Dusts", "", " Dust", true, true, false, false, false, false, false, true, false, false, GTValues.B[0] | GTValues.B[1] | GTValues.B[2] | GTValues.B[3], 3628800L, 64, 2),
    nugget("Nuggets", "", " Nugget", true, true, false, false, false, false, false, true, false, false, GTValues.B[1], 403200L, 64, 9),
    plate("Plates", "", " Plate", true, true, false, false, false, false, true, true, false, false, GTValues.B[1] | GTValues.B[2], 3628800L, 64, 17),
    block("Storage Blocks", "Block of ", "", true, true, false, false, false, true, true, false, false, false, 0, 32659200L, 64, 71),
    gem("Gemstones", "", "", true, true, true, false, false, false, true, true, false, false, GTValues.B[2], 3628800L, 64, 8),
    gemChipped("Chipped Gemstones", "Chipped ", "", true, true, true, false, false, false, true, true, false, false, GTValues.B[2], 907200L, 64, 59),
    gemFlawed("Flawed Gemstones", "Flawed ", "", true, true, true, false, false, false, true, true, false, false, GTValues.B[2], 1814400L, 64, 60),
    gemFlawless("Flawless Gemstones", "Flawless ", "", true, true, true, false, false, false, true, true, false, false, GTValues.B[2], 7257600L, 32, 61),
    gemExquisite("Exquisite Gemstones", "Exquisite ", "", true, true, true, false, false, false, true, true, false, false, GTValues.B[2], 14515200L, 16, 62),
    stick("Sticks/Rods", "", " Rod", true, true, false, false, false, false, true, true, false, false, GTValues.B[1] | GTValues.B[2], 1814400L, 64, 23),
    type2("16x Wires", "16x ", " Wire", true, true, false, false, false, false, true, false, false, false, 0, 29030400L, 64, -1),
    toolAngleGrinder("Angle Grinder", "", "Angle Grinder", true, true, false, false, false, false, true, true, false, false, GTValues.B[6], 21772800L, 16, 37),
    toolElectricSnips("Electric Snips", "", "Electric Snips", true, true, false, false, false, false, true, true, false, false, GTValues.B[6], 21772800L, 16, 37),
    toolElectricLighter("Electric Lighter", "", "Electric Lighter", true, true, false, false, false, false, true, true, false, false, GTValues.B[6], 21772800L, 16, 37),
    toolElectricButcherKnife("Electric Butcher Knife", "", "Electric Butcher Knife", true, true, false, false, false, false, true, true, false, false, GTValues.B[6], 21772800L, 16, 37),
    batterySingleuse("Single Use Batteries", "", "", false, true, false, false, false, false, false, false, false, false, 0, -1L, 64, -1),
    battery("Reusable Batteries", "", "", false, true, false, false, false, false, false, false, false, false, 0, -1L, 64, -1),
    circuit("Circuits", "", "", true, true, false, false, false, false, false, false, false, false, 0, -1L, 64, -1),
    chipset("Chipsets", "", "", true, true, false, false, false, false, false, false, false, false, 0, -1L, 64, -1);

    public static final int VERSION = 508;
    public final ArrayList<ItemStack> mPrefixedItems = new ArrayList();
    public final short mTextureIndex;
    public final String mRegularLocalName;
    public final String mLocalizedMaterialPre;
    public final String mLocalizedMaterialPost;
    public final boolean mIsUsedForOreProcessing;
    public final boolean mIsEnchantable;
    public final boolean mIsUnificatable;
    public final boolean mIsMaterialBased;
    public final boolean mIsSelfReferencing;
    public final boolean mIsContainer;
    public final boolean mDontUnificateActively;
    public final boolean mIsUsedForBlocks;
    public final boolean mAllowNormalRecycling;
    public final boolean mGenerateDefaultItem;
    public final List<TCAspects.TC_AspectStack> mAspects = new ArrayList<TCAspects.TC_AspectStack>();
    public final Collection<GregtechOrePrefixes> mFamiliarPrefixes = new HashSet<GregtechOrePrefixes>();
    public final long mMaterialAmount;
    private final Collection<Materials> mNotGeneratedItems = new HashSet<Materials>();
    private final Collection<Materials> mIgnoredMaterials = new HashSet<Materials>();
    private final Collection<Materials> mGeneratedItems = new HashSet<Materials>();
    private final ArrayList<IOreRecipeRegistrator> mOreProcessing = new ArrayList();
    private final ArrayList<IOreRecipeRegistrator> mOreProcessingFake = new ArrayList();
    public final ItemStack mContainerItem = null;
    public final ICondition<ISubTagContainer> mCondition = null;
    public byte mDefaultStackSize = (byte)64;
    public final GregtechMaterialStack mSecondaryMaterial = null;
    public final GregtechOrePrefixes mPrefixInto = this;
    public float mHeatDamage = 0.0f;
    public int mMaterialGenerationBits = 0;

    private GregtechOrePrefixes(String aRegularLocalName, String aLocalizedMaterialPre, String aLocalizedMaterialPost, boolean aIsUnificatable, boolean aIsMaterialBased, boolean aIsSelfReferencing, boolean aIsContainer, boolean aDontUnificateActively, boolean aIsUsedForBlocks, boolean aAllowNormalRecycling, boolean aGenerateDefaultItem, boolean aIsEnchantable, boolean aIsUsedForOreProcessing, int aMaterialGenerationBits, long aMaterialAmount, int aDefaultStackSize, int aTextureindex) {
        this.mIsUnificatable = aIsUnificatable;
        this.mIsMaterialBased = aIsMaterialBased;
        this.mIsSelfReferencing = aIsSelfReferencing;
        this.mIsContainer = aIsContainer;
        this.mDontUnificateActively = aDontUnificateActively;
        this.mIsUsedForBlocks = aIsUsedForBlocks;
        this.mAllowNormalRecycling = aAllowNormalRecycling;
        this.mGenerateDefaultItem = aGenerateDefaultItem;
        this.mIsEnchantable = aIsEnchantable;
        this.mIsUsedForOreProcessing = aIsUsedForOreProcessing;
        this.mMaterialGenerationBits = aMaterialGenerationBits;
        this.mMaterialAmount = aMaterialAmount;
        this.mRegularLocalName = aRegularLocalName;
        this.mLocalizedMaterialPre = aLocalizedMaterialPre;
        this.mLocalizedMaterialPost = aLocalizedMaterialPost;
        this.mDefaultStackSize = (byte)aDefaultStackSize;
        this.mTextureIndex = (short)aTextureindex;
        if (this.name().startsWith("ore")) {
            Utils.getTcAspectStack(TCAspects.TERRA.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("wire") || this.name().startsWith("cable")) {
            Utils.getTcAspectStack(TCAspects.ELECTRUM.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("dust")) {
            Utils.getTcAspectStack(TCAspects.PERDITIO.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("crushed")) {
            Utils.getTcAspectStack(TCAspects.PERFODIO.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("ingot") || this.name().startsWith("nugget")) {
            Utils.getTcAspectStack(TCAspects.METALLUM.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("armor")) {
            Utils.getTcAspectStack(TCAspects.TUTAMEN.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("stone")) {
            Utils.getTcAspectStack(TCAspects.TERRA.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("pipe")) {
            Utils.getTcAspectStack(TCAspects.ITER.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("gear")) {
            Utils.getTcAspectStack(TCAspects.MOTUS.name(), 1).addToAspectList(this.mAspects);
            Utils.getTcAspectStack(TCAspects.MACHINA.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("frame") || this.name().startsWith("plate")) {
            Utils.getTcAspectStack(TCAspects.FABRICO.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("tool")) {
            Utils.getTcAspectStack(TCAspects.INSTRUMENTUM.name(), 2).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("gem") || this.name().startsWith("crystal") || this.name().startsWith("lens")) {
            Utils.getTcAspectStack(TCAspects.VITREUS.name(), 1).addToAspectList(this.mAspects);
            return;
        }
        if (this.name().startsWith("circuit")) {
            Utils.getTcAspectStack("COGNITIO", 1);
            return;
        }
        if (this.name().startsWith("battery")) {
            Utils.getTcAspectStack(TCAspects.ELECTRUM.name(), 1).addToAspectList(this.mAspects);
        }
    }

    public static GregtechOrePrefixes getOrePrefix(String aOre) {
        for (GregtechOrePrefixes tPrefix : GregtechOrePrefixes.values()) {
            if (!aOre.startsWith(tPrefix.toString())) continue;
            return tPrefix;
        }
        return null;
    }

    public static String stripPrefix(String aOre) {
        for (GregtechOrePrefixes tPrefix : GregtechOrePrefixes.values()) {
            if (!aOre.startsWith(tPrefix.toString())) continue;
            return aOre.replaceFirst(tPrefix.toString(), "");
        }
        return aOre;
    }

    public static String replacePrefix(String aOre, GregtechOrePrefixes aPrefix) {
        for (GregtechOrePrefixes tPrefix : GregtechOrePrefixes.values()) {
            if (!aOre.startsWith(tPrefix.toString())) continue;
            return aOre.replaceFirst(tPrefix.toString(), aPrefix.toString());
        }
        return "";
    }

    public static Materials getMaterial(String aOre) {
        return Materials.get(GregtechOrePrefixes.stripPrefix(aOre));
    }

    public static Materials getMaterial(String aOre, GregtechOrePrefixes aPrefix) {
        return Materials.get(aOre.replaceFirst(aPrefix.toString(), ""));
    }

    public static Materials getRealMaterial(String aOre, GregtechOrePrefixes aPrefix) {
        return Materials.getRealMaterial(aOre.replaceFirst(aPrefix.toString(), ""));
    }

    public static boolean isInstanceOf(String aName, GregtechOrePrefixes aPrefix) {
        return aName != null && aName.startsWith(aPrefix.toString());
    }

    public boolean add(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        if (!this.contains(aStack)) {
            this.mPrefixedItems.add(aStack);
        }
        while (this.mPrefixedItems.contains(null)) {
            this.mPrefixedItems.remove(null);
        }
        return true;
    }

    public boolean contains(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        for (ItemStack tStack : this.mPrefixedItems) {
            if (!GTUtility.areStacksEqual(aStack, tStack, !tStack.func_77942_o())) continue;
            return true;
        }
        return false;
    }

    public boolean doGenerateItem(Materials aMaterial) {
        return !(aMaterial == null || aMaterial == Materials._NULL || (aMaterial.mTypes & this.mMaterialGenerationBits) == 0 && !this.mGeneratedItems.contains(aMaterial) || this.mNotGeneratedItems.contains(aMaterial) || this.mCondition != null && !this.mCondition.isTrue(aMaterial));
    }

    public boolean ignoreMaterials(Materials ... aMaterials) {
        for (Materials tMaterial : aMaterials) {
            if (tMaterial == null) continue;
            this.mIgnoredMaterials.add(tMaterial);
        }
        return true;
    }

    public boolean addFamiliarPrefix(GregtechOrePrefixes aPrefix) {
        if (aPrefix == null || this.mFamiliarPrefixes.contains((Object)aPrefix) || aPrefix == this) {
            return false;
        }
        return this.mFamiliarPrefixes.add(aPrefix);
    }

    public boolean add(IOreRecipeRegistrator aRegistrator) {
        if (aRegistrator == null) {
            return false;
        }
        return this.mOreProcessing.add(aRegistrator);
    }

    public void processOre(GT_Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial != null && (aMaterial != GT_Materials._NULL || this.mIsSelfReferencing || !this.mIsMaterialBased) && GTUtility.isStackValid(aStack)) {
            for (IOreRecipeRegistrator tRegistrator : this.mOreProcessing) {
                if (GTValues.D2) {
                    GTLog.ore.println("Processing '" + aOreDictName + "' with the Prefix '" + this.name() + "' and the Material '" + aMaterial.name() + "' at " + GTUtility.getClassName(tRegistrator));
                }
                tRegistrator.registerOre(this, aMaterial, aOreDictName, aModName, GTUtility.copyAmount(1, aStack));
            }
        }
    }

    public void processOre(Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial != null && (aMaterial != Materials._NULL || this.mIsSelfReferencing || !this.mIsMaterialBased) && GTUtility.isStackValid(aStack)) {
            for (IOreRecipeRegistrator tRegistrator : this.mOreProcessingFake) {
                if (GTValues.D2) {
                    GTLog.ore.println("Processing '" + aOreDictName + "' with the Prefix '" + this.name() + "' and the Material '" + aMaterial.mName + "' at " + GTUtility.getClassName(tRegistrator));
                }
                tRegistrator.registerOre(this, aMaterial, aOreDictName, aModName, GTUtility.copyAmount(1, aStack));
            }
        }
    }

    public Object get(Object aMaterial) {
        if (aMaterial instanceof GT_Materials) {
            return new GregtechItemData(this, (GT_Materials)aMaterial);
        }
        return this.name() + aMaterial;
    }

    public String getDefaultLocalNameForItem(Materials aMaterial) {
        return this.mLocalizedMaterialPre + aMaterial.mDefaultLocalName + this.mLocalizedMaterialPost;
    }

    static {
        GregtechOrePrefixes.ingotHot.mHeatDamage = 3.0f;
    }

    public static enum GT_Materials implements IColorModulationContainer,
    ISubTagContainer
    {
        _NULL(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "NULL", 0, 0, 0, 0, false, false, 1, 1, 1, Dyes._NULL, Element._NULL, Arrays.asList(Utils.getTcAspectStack(TCAspects.VACUOS.name(), 1))),
        Pyrotheum(20, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 255, 128, 0, 0, "Pyrotheum", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeYellow, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L)), Arrays.asList(Utils.getTcAspectStack("PRAECANTATIO", 2), Utils.getTcAspectStack(TCAspects.IGNIS, 1))),
        Cryotheum(21, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 102, 178, 255, 0, "Cryotheum", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Blizz, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Snow, 1L), new MaterialStack(Materials.Niter, 1L)), Arrays.asList(Utils.getTcAspectStack("PRAECANTATIO", 2), Utils.getTcAspectStack(TCAspects.GELUM, 1))),
        Ender(22, TextureSet.SET_FLUID, 1.0f, 0, 2, 1, 255, 255, 255, 0, "Ender", 0, 0, -1, 0, false, false, 3, 1, 1, Dyes.dyeGreen),
        Symbiotic(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "IV Tier", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Arrays.asList(Utils.getTcAspectStack(TCAspects.ELECTRUM, 4), Utils.getTcAspectStack(TCAspects.MACHINA, 4))),
        Neutronic(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "LuV Tier", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Arrays.asList(Utils.getTcAspectStack(TCAspects.ELECTRUM, 6), Utils.getTcAspectStack(TCAspects.MACHINA, 6))),
        Quantum(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "ZPM Tier", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Arrays.asList(Utils.getTcAspectStack(TCAspects.ELECTRUM, 8), Utils.getTcAspectStack(TCAspects.MACHINA, 8))),
        Superconductor(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 190, 240, 190, 0, "Superconductor", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeGreen, Arrays.asList(Utils.getTcAspectStack(TCAspects.ELECTRUM, 8))),
        Staballoy(30, TextureSet.SET_ROUGH, 10.0f, 5120, 4, 243, 68, 75, 66, 0, "Staballoy", 0, 0, 1500, 2800, true, false, 1, 3, 1, Dyes.dyeGreen, 2, Arrays.asList(new MaterialStack(Materials.Titanium, 1L), new MaterialStack(Materials.Uranium, 9L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        Bedrockium(31, TextureSet.SET_FINE, 8.0f, 8196, 3, 243, 39, 39, 39, 0, "Bedrockium", 0, 0, -1, 0, false, false, 1, 5, 1, Dyes.dyeLightGray, 2, Arrays.asList(new MaterialStack(Materials.Carbon, 63L), new MaterialStack(Materials.Carbon, 56L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.VACUOS, 8), Utils.getTcAspectStack(TCAspects.TUTAMEN, 3))),
        BloodSteel(32, TextureSet.SET_METALLIC, 11.0f, 768, 4, 243, 142, 28, 0, 0, "Blood Steel", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeRed, 2, Arrays.asList(new MaterialStack(Materials.Steel, 3L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.VICTUS, 8), Utils.getTcAspectStack(TCAspects.IGNIS, 3))),
        Void(33, TextureSet.SET_METALLIC, 6.0f, 1280, 3, 243, 82, 17, 82, 0, "Void Metal", 0, 0, -1, 0, false, false, 3, 1, 1, Dyes.dyeBlack, Arrays.asList(Utils.getTcAspectStack("PRAECANTATIO", 5), Utils.getTcAspectStack(TCAspects.VACUOS, 7))),
        ConductiveIron(34, TextureSet.SET_METALLIC, 5.0f, 256, 2, 3, 164, 109, 100, 0, "Conductive Iron", 0, 0, -1, 0, false, false, 3, 1, 1, Dyes.dyeRed, 2, Arrays.asList(new MaterialStack(Materials.Iron, 6L), new MaterialStack(Materials.Redstone, 2L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.POTENTIA, 2), Utils.getTcAspectStack(TCAspects.METALLUM, 2))),
        ElectricalSteel(35, TextureSet.SET_METALLIC, 7.0f, 768, 3, 195, 194, 194, 194, 0, "Electrical Steel", 0, 0, 1811, 1000, true, false, 3, 1, 1, Dyes.dyeLightGray, 2, Arrays.asList(new MaterialStack(Materials.Iron, 3L), new MaterialStack(Materials.Coal, 2L), new MaterialStack(Materials.Silicon, 2L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.MAGNETO, 2), Utils.getTcAspectStack(TCAspects.ELECTRUM, 5))),
        EnergeticAlloy(36, TextureSet.SET_SHINY, 5.0f, 512, 3, 195, 252, 152, 45, 0, "Energetic Alloy", 0, 0, -1, 0, false, false, 3, 1, 1, Dyes.dyeOrange, 2, Arrays.asList(new MaterialStack(Materials.Gold, 3L), new MaterialStack(Materials.Glowstone, 2L), new MaterialStack(Materials.Redstone, 2L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.POTENTIA, 4), Utils.getTcAspectStack(TCAspects.LUX, 3))),
        VibrantAlloy(37, TextureSet.SET_SHINY, 7.0f, 1280, 4, 195, 204, 242, 142, 0, "Vibrant Alloy", 0, 0, -1, 0, false, false, 3, 1, 1, Dyes.dyeLime, 2, Arrays.asList(new MaterialStack(Materials.EnergeticAlloy, 1L), new MaterialStack(Materials.EnderPearl, 3L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.MACHINA, 5), Utils.getTcAspectStack(TCAspects.TELUM, 4))),
        PulsatingIron(38, TextureSet.SET_SHINY, 5.0f, 256, 2, 195, 50, 91, 21, 0, "Pulsating Iron", 0, 0, -1, 0, false, false, 3, 1, 1, Dyes.dyeGreen, 2, Arrays.asList(new MaterialStack(Materials.Iron, 2L), new MaterialStack(Materials.EnderPearl, 2L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.ALIENIS, 3), Utils.getTcAspectStack(TCAspects.METALLUM, 3))),
        RedstoneAlloy(39, TextureSet.SET_METALLIC, 1.0f, 256, 2, 115, 178, 34, 34, 0, "Redstone Alloy", 0, 0, -1, 0, false, false, 3, 1, 1, Dyes.dyeRed, 2, Arrays.asList(new MaterialStack(Materials.Iron, 2L), new MaterialStack(Materials.Redstone, 4L))),
        Tantalloy60(40, TextureSet.SET_DULL, 8.0f, 5120, 3, 243, 68, 75, 166, 0, "Tantalloy-60", 0, 0, 3035, 2200, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        Tantalloy61(41, TextureSet.SET_DULL, 7.0f, 5120, 2, 243, 122, 135, 196, 0, "Tantalloy-61", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        Potin(42, TextureSet.SET_METALLIC, 7.0f, 5120, 2, 243, 201, 151, 129, 0, "Potin", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        Inconel792(43, TextureSet.SET_METALLIC, 7.0f, 5120, 2, 243, 108, 240, 118, 0, "Inconel-792", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        Inconel690(44, TextureSet.SET_DULL, 7.0f, 5120, 2, 243, 118, 220, 138, 0, "Inconel-690", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        MaragingSteel300(45, TextureSet.SET_METALLIC, 7.0f, 5120, 2, 243, 150, 150, 150, 0, "Maraging Steel 300", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        MaragingSteel350(46, TextureSet.SET_METALLIC, 7.0f, 5120, 2, 243, 160, 160, 160, 0, "Maraging Steel 350", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        HastelloyX(47, TextureSet.SET_SHINY, 7.0f, 5120, 2, 243, 255, 193, 37, 0, "Hastelloy-X", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        TriniumNaquadahCarbonite(48, TextureSet.SET_SHINY, 7.0f, 5120, 2, 243, 255, 233, 0, 0, "Trinium Naquadah Carbonite", 0, 0, 3015, 2150, true, false, 1, 2, 1, Dyes.dyeLightBlue, 2, Arrays.asList(new MaterialStack(Materials.Tungsten, 1L), new MaterialStack(Materials.Tantalum, 9L), new MaterialStack(Materials.Titanium, 1L)), Arrays.asList(Utils.getTcAspectStack(TCAspects.METALLUM, 8), Utils.getTcAspectStack(TCAspects.STRONTIO, 3))),
        HydrofluoricAcid(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 200, 200, 200, 0, "Hydrofluoric Acid", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeWhite, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        UraniumHexaFluoride(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 73, 220, 83, 0, "Uranium Hexafluoride", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeLime, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        UraniumTetraFluoride(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 73, 220, 83, 0, "Uranium Tetrafluoride", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeLime, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        ThoriumTetraFluoride(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 15, 120, 15, 0, "Thorium Tetrafluoride", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeGreen, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        SulfurousAcid(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 110, 220, 30, 0, "Sulfurous Acid", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeWhite, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        SulfurDioxide(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 150, 200, 50, 0, "Sulfur Dioxide", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeWhite, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        HydrogenChloride(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 150, 240, 90, 0, "Hydrogen Chloride", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeWhite, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        SulfuricApatite(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 0, 105, 105, 0, "Sulfuric Apatite Solution", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeWhite, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        SulfuricLithium(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 0, 105, 105, 0, "Sulfuric Lithium Solution", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeWhite, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L))),
        LithiumHydroxide(-1, TextureSet.SET_FLUID, 1.0f, 0, 1, 50, 0, 105, 105, 0, "Lithium Hydroxide", 0, 0, -1, 0, false, false, 2, 3, 1, Dyes.dyeWhite, 2, Arrays.asList(new MaterialStack(Materials.Coal, 1L), new MaterialStack(Materials.Redstone, 1L), new MaterialStack(Materials.Blaze, 1L), new MaterialStack(Materials.Sulfur, 1L)));

        public static final Collection<GT_Materials> VALUES;
        public final short[] mRGBa = new short[]{255, 255, 255, 0};
        public final short[] mMoltenRGBa = new short[]{255, 255, 255, 0};
        public final TextureSet mIconSet;
        public final int mMetaItemSubID;
        public final boolean mUnificatable;
        public final GT_Materials mMaterialInto;
        public final List<MaterialStack> mMaterialList = new ArrayList<MaterialStack>();
        public final List<GT_Materials> mOreByProducts = new ArrayList<GT_Materials>();
        public final List<GT_Materials> mOreReRegistrations = new ArrayList<GT_Materials>();
        public final List<TCAspects.TC_AspectStack> mAspects = new ArrayList<TCAspects.TC_AspectStack>();
        private final ArrayList<ItemStack> mMaterialItems = new ArrayList();
        private final Collection<SubTag> mSubTags = new HashSet<SubTag>();
        public Enchantment mEnchantmentTools = null;
        public Enchantment mEnchantmentArmors = null;
        public byte mEnchantmentToolsLevel = 0;
        public byte mEnchantmentArmorsLevel = 0;
        public boolean mBlastFurnaceRequired = false;
        public float mToolSpeed = 1.0f;
        public float mHeatDamage = 0.0f;
        public String mChemicalFormula = "?";
        public String mDefaultLocalName = "null";
        public Dyes mColor = Dyes._NULL;
        public short mMeltingPoint = 0;
        public short mBlastFurnaceTemp = 0;
        public int mTypes = 0;
        public int mDurability = 16;
        public int mFuelPower = 0;
        public int mFuelType = 0;
        public int mExtraData = 0;
        public int mOreValue = 0;
        public int mOreMultiplier = 1;
        public int mByProductMultiplier = 1;
        public int mSmeltingMultiplier = 1;
        public long mDensity = 3628800L;
        public Element mElement = null;
        public GT_Materials mDirectSmelting = this;
        public GT_Materials mOreReplacement = this;
        public GT_Materials mMacerateInto = this;
        public GT_Materials mSmeltInto = this;
        public GT_Materials mArcSmeltInto = this;
        public final GT_Materials mHandleMaterial = this;
        public byte mToolQuality = 0;
        public final Fluid mSolid = null;
        public Fluid mFluid = null;
        public Fluid mGas = null;
        public Fluid mPlasma = null;
        public final Fluid mStandardMoltenFluid = null;
        public static final int VERSION = 508;

        private GT_Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aToolDurability, int aToolQuality, boolean aUnificatable) {
            this.mUnificatable = aUnificatable;
            this.mMaterialInto = this;
            this.mMetaItemSubID = aMetaItemSubID;
            this.mToolQuality = (byte)aToolQuality;
            this.mDurability = aToolDurability;
            this.mToolSpeed = aToolSpeed;
            this.mIconSet = aIconSet;
            if (aMetaItemSubID >= 0) {
                if (GTPPCore.sMU_GeneratedMaterials[aMetaItemSubID] == null) {
                    GTPPCore.sMU_GeneratedMaterials[aMetaItemSubID] = this;
                } else {
                    throw new IllegalArgumentException("The Index " + aMetaItemSubID + " is already used!");
                }
            }
        }

        private GT_Materials(GT_Materials aMaterialInto, boolean aReRegisterIntoThis) {
            this.mUnificatable = false;
            this.mDefaultLocalName = aMaterialInto.mDefaultLocalName;
            this.mMaterialInto = aMaterialInto.mMaterialInto;
            if (aReRegisterIntoThis) {
                this.mMaterialInto.mOreReRegistrations.add(this);
            }
            this.mChemicalFormula = aMaterialInto.mChemicalFormula;
            this.mMetaItemSubID = -1;
            this.mIconSet = TextureSet.SET_NONE;
        }

        private GT_Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aToolDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor) {
            this(aMetaItemSubID, aIconSet, aToolSpeed, aToolDurability, aToolQuality, true);
            this.mDefaultLocalName = aLocalName;
            this.mMeltingPoint = (short)aMeltingPoint;
            this.mBlastFurnaceTemp = (short)aBlastFurnaceTemp;
            this.mBlastFurnaceRequired = aBlastFurnaceRequired;
            if (aTransparent) {
                this.add(SubTag.TRANSPARENT);
            }
            this.mFuelPower = aFuelPower;
            this.mFuelType = aFuelType;
            this.mOreValue = aOreValue;
            this.mDensity = 3628800L * (long)aDensityMultiplier / (long)aDensityDivider;
            Dyes dyes = this.mColor = aColor == null ? Dyes._NULL : aColor;
            if (this.mColor != null) {
                this.add(SubTag.HAS_COLOR);
            }
            this.mRGBa[0] = this.mMoltenRGBa[0] = (short)aR;
            this.mRGBa[1] = this.mMoltenRGBa[1] = (short)aG;
            this.mRGBa[2] = this.mMoltenRGBa[2] = (short)aB;
            this.mRGBa[3] = this.mMoltenRGBa[3] = (short)aA;
            this.mTypes = aTypes;
            if ((this.mTypes & 2) != 0) {
                this.add(SubTag.SMELTING_TO_FLUID);
            }
        }

        private GT_Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aToolDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, List<TCAspects.TC_AspectStack> aAspects) {
            this(aMetaItemSubID, aIconSet, aToolSpeed, aToolDurability, aToolQuality, aTypes, aR, aG, aB, aA, aLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor);
            this.mAspects.addAll(aAspects);
        }

        private GT_Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aToolDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, Element aElement, List<TCAspects.TC_AspectStack> aAspects) {
            this(aMetaItemSubID, aIconSet, aToolSpeed, aToolDurability, aToolQuality, aTypes, aR, aG, aB, aA, aLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor);
            this.mElement = aElement;
            if (aElement == Element._NULL) {
                this.mChemicalFormula = "Empty";
            } else {
                this.mChemicalFormula = aElement.toString();
                this.mChemicalFormula = this.mChemicalFormula.replaceAll("_", "-");
            }
            this.mAspects.addAll(aAspects);
        }

        private GT_Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aToolDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, int aExtraData, List<MaterialStack> aMaterialList) {
            this(aMetaItemSubID, aIconSet, aToolSpeed, aToolDurability, aToolQuality, aTypes, aR, aG, aB, aA, aLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor, aExtraData, aMaterialList, null);
        }

        private GT_Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aToolDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, int aExtraData, List<MaterialStack> aMaterialList, List<TCAspects.TC_AspectStack> aAspects) {
            this(aMetaItemSubID, aIconSet, aToolSpeed, aToolDurability, aToolQuality, aTypes, aR, aG, aB, aA, aLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor);
            this.mExtraData = aExtraData;
            this.mMaterialList.addAll(aMaterialList);
            this.mChemicalFormula = "";
            for (MaterialStack tMaterial : this.mMaterialList) {
                this.mChemicalFormula = this.mChemicalFormula + tMaterial.toString();
            }
            this.mChemicalFormula = this.mChemicalFormula.replaceAll("_", "-");
            int tAmountOfComponents = 0;
            int tMeltingPoint = 0;
            for (MaterialStack tMaterial : this.mMaterialList) {
                tAmountOfComponents = (int)((long)tAmountOfComponents + tMaterial.mAmount);
                if (tMaterial.mMaterial.mMeltingPoint > 0) {
                    tMeltingPoint = (int)((long)tMeltingPoint + (long)tMaterial.mMaterial.mMeltingPoint * tMaterial.mAmount);
                }
                if (aAspects != null) continue;
                for (TCAspects.TC_AspectStack tAspect : tMaterial.mMaterial.mAspects) {
                    tAspect.addToAspectList(this.mAspects);
                }
            }
            if (this.mMeltingPoint < 0) {
                this.mMeltingPoint = (short)(tMeltingPoint / tAmountOfComponents);
            }
            tAmountOfComponents *= aDensityMultiplier;
            tAmountOfComponents /= aDensityDivider;
            if (aAspects == null) {
                for (TCAspects.TC_AspectStack tAspect : this.mAspects) {
                    tAspect.mAmount = Math.max(1L, tAspect.mAmount / (long)Math.max(1, tAmountOfComponents));
                }
            } else {
                this.mAspects.addAll(aAspects);
            }
        }

        public static void init(GTConfig aConfiguration) {
            for (GT_Materials tMaterial : VALUES) {
                String tString = tMaterial.toString().toLowerCase();
                tMaterial.mHeatDamage = (float)aConfiguration.get((Object)ConfigCategories.Materials.heatdamage, tString, (double)tMaterial.mHeatDamage);
                if (tMaterial.mBlastFurnaceRequired) {
                    tMaterial.mBlastFurnaceRequired = aConfiguration.get((Object)ConfigCategories.Materials.blastfurnacerequirements, tString, true);
                }
                if (tMaterial.mBlastFurnaceRequired && !aConfiguration.get((Object)ConfigCategories.Materials.blastinductionsmelter, tString, tMaterial.mBlastFurnaceTemp < 1500)) continue;
            }
        }

        public boolean isRadioactive() {
            if (this.mElement != null) {
                return this.mElement.mHalfLifeSeconds >= 0L;
            }
            for (MaterialStack tMaterial : this.mMaterialList) {
                if (!tMaterial.mMaterial.isRadioactive()) continue;
                return true;
            }
            return false;
        }

        public long getProtons() {
            if (this.mElement != null) {
                return this.mElement.getProtons();
            }
            if (this.mMaterialList.size() <= 0) {
                return Element.Tc.getProtons();
            }
            long rAmount = 0L;
            long tAmount = 0L;
            for (MaterialStack tMaterial : this.mMaterialList) {
                tAmount += tMaterial.mAmount;
                rAmount += tMaterial.mAmount * tMaterial.mMaterial.getProtons();
            }
            return this.getDensity() * rAmount / (tAmount * 3628800L);
        }

        public long getNeutrons() {
            if (this.mElement != null) {
                return this.mElement.getNeutrons();
            }
            if (this.mMaterialList.size() <= 0) {
                return Element.Tc.getNeutrons();
            }
            long rAmount = 0L;
            long tAmount = 0L;
            for (MaterialStack tMaterial : this.mMaterialList) {
                tAmount += tMaterial.mAmount;
                rAmount += tMaterial.mAmount * tMaterial.mMaterial.getNeutrons();
            }
            return this.getDensity() * rAmount / (tAmount * 3628800L);
        }

        public long getMass() {
            if (this.mElement != null) {
                return this.mElement.getMass();
            }
            if (this.mMaterialList.size() <= 0) {
                return Element.Tc.getMass();
            }
            long rAmount = 0L;
            long tAmount = 0L;
            for (MaterialStack tMaterial : this.mMaterialList) {
                tAmount += tMaterial.mAmount;
                rAmount += tMaterial.mAmount * tMaterial.mMaterial.getMass();
            }
            return this.getDensity() * rAmount / (tAmount * 3628800L);
        }

        public long getDensity() {
            return this.mDensity;
        }

        public String getToolTip() {
            return this.getToolTip(1L, false);
        }

        public String getToolTip(boolean aShowQuestionMarks) {
            return this.getToolTip(1L, aShowQuestionMarks);
        }

        public String getToolTip(long aMultiplier) {
            return this.getToolTip(aMultiplier, false);
        }

        public String getToolTip(long aMultiplier, boolean aShowQuestionMarks) {
            if (!aShowQuestionMarks && this.mChemicalFormula.equals("?")) {
                return "";
            }
            if (aMultiplier >= 7257600L && !this.mMaterialList.isEmpty()) {
                return (this.mElement != null || this.mMaterialList.size() < 2 && this.mMaterialList.get((int)0).mAmount == 1L ? this.mChemicalFormula : "(" + this.mChemicalFormula + ")") + aMultiplier;
            }
            return this.mChemicalFormula;
        }

        public GT_Materials add(ItemStack aStack) {
            if (aStack != null && !this.contains(aStack)) {
                this.mMaterialItems.add(aStack);
            }
            return this;
        }

        public boolean contains(ItemStack ... aStacks) {
            if (aStacks == null || aStacks.length <= 0) {
                return false;
            }
            for (ItemStack tStack : this.mMaterialItems) {
                for (ItemStack aStack : aStacks) {
                    if (!GTUtility.areStacksEqual(aStack, tStack, !tStack.func_77942_o())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean remove(ItemStack aStack) {
            if (aStack == null) {
                return false;
            }
            boolean temp = false;
            for (int i = 0; i < this.mMaterialItems.size(); ++i) {
                if (!GTUtility.areStacksEqual(aStack, this.mMaterialItems.get(i))) continue;
                this.mMaterialItems.remove(i--);
                temp = true;
            }
            return temp;
        }

        @Override
        public ISubTagContainer add(SubTag ... aTags) {
            if (aTags != null) {
                for (SubTag aTag : aTags) {
                    if (aTag == null || this.contains(aTag)) continue;
                    aTag.addContainerToList(this);
                    this.mSubTags.add(aTag);
                }
            }
            return this;
        }

        @Override
        public boolean contains(SubTag aTag) {
            return this.mSubTags.contains(aTag);
        }

        @Override
        public boolean remove(SubTag aTag) {
            return this.mSubTags.remove(aTag);
        }

        public GT_Materials setHeatDamage(float aHeatDamage) {
            this.mHeatDamage = aHeatDamage;
            return this;
        }

        public GT_Materials addOreByProduct(GT_Materials aMaterial) {
            if (!this.mOreByProducts.contains(aMaterial.mMaterialInto)) {
                this.mOreByProducts.add(aMaterial.mMaterialInto);
            }
            return this;
        }

        public GT_Materials addOreByProducts(GT_Materials ... aMaterials) {
            for (GT_Materials tMaterial : aMaterials) {
                if (tMaterial == null) continue;
                this.addOreByProduct(tMaterial);
            }
            return this;
        }

        public GT_Materials setOreMultiplier(int aOreMultiplier) {
            if (aOreMultiplier > 0) {
                this.mOreMultiplier = aOreMultiplier;
            }
            return this;
        }

        public GT_Materials setByProductMultiplier(int aByProductMultiplier) {
            if (aByProductMultiplier > 0) {
                this.mByProductMultiplier = aByProductMultiplier;
            }
            return this;
        }

        public GT_Materials setSmeltingMultiplier(int aSmeltingMultiplier) {
            if (aSmeltingMultiplier > 0) {
                this.mSmeltingMultiplier = aSmeltingMultiplier;
            }
            return this;
        }

        public GT_Materials setDirectSmelting(GT_Materials aMaterial) {
            if (aMaterial != null) {
                this.mDirectSmelting = aMaterial.mMaterialInto.mDirectSmelting;
            }
            return this;
        }

        public GT_Materials setOreReplacement(GT_Materials aMaterial) {
            if (aMaterial != null) {
                this.mOreReplacement = aMaterial.mMaterialInto.mOreReplacement;
            }
            return this;
        }

        public GT_Materials setSmeltingInto(GT_Materials aMaterial) {
            if (aMaterial != null) {
                this.mSmeltInto = aMaterial.mMaterialInto.mSmeltInto;
            }
            return this;
        }

        public GT_Materials setArcSmeltingInto(GT_Materials aMaterial) {
            if (aMaterial != null) {
                this.mArcSmeltInto = aMaterial.mMaterialInto.mArcSmeltInto;
            }
            return this;
        }

        public GT_Materials setMaceratingInto(GT_Materials aMaterial) {
            if (aMaterial != null) {
                this.mMacerateInto = aMaterial.mMaterialInto.mMacerateInto;
            }
            return this;
        }

        public GT_Materials setEnchantmentForTools(Enchantment aEnchantment, int aEnchantmentLevel) {
            this.mEnchantmentTools = aEnchantment;
            this.mEnchantmentToolsLevel = (byte)aEnchantmentLevel;
            return this;
        }

        public GT_Materials setEnchantmentForArmors(Enchantment aEnchantment, int aEnchantmentLevel) {
            this.mEnchantmentArmors = aEnchantment;
            this.mEnchantmentArmorsLevel = (byte)aEnchantmentLevel;
            return this;
        }

        public FluidStack getSolid(long aAmount) {
            if (this.mSolid == null) {
                return null;
            }
            return new FluidStack(this.mSolid, (int)aAmount);
        }

        public FluidStack getFluid(long aAmount) {
            if (this.mFluid == null) {
                return null;
            }
            return new FluidStack(this.mFluid, (int)aAmount);
        }

        public FluidStack getGas(long aAmount) {
            if (this.mGas == null) {
                return null;
            }
            return new FluidStack(this.mGas, (int)aAmount);
        }

        public FluidStack getPlasma(long aAmount) {
            if (this.mPlasma == null) {
                return null;
            }
            return new FluidStack(this.mPlasma, (int)aAmount);
        }

        public FluidStack getMolten(long aAmount) {
            if (this.mStandardMoltenFluid == null) {
                return null;
            }
            return new FluidStack(this.mStandardMoltenFluid, (int)aAmount);
        }

        @Override
        public short[] getRGBA() {
            return this.mRGBa;
        }

        static {
            VALUES = new HashSet<GT_Materials>(Arrays.asList(GT_Materials.values()));
            Symbiotic.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
            Neutronic.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
            Quantum.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        }
    }
}

