/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.food;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GTOreDictUnificator;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseItemMetaFood
extends ItemFood {
    private static final HashMap<Integer, IIcon> mIconMap = new HashMap();
    private static int mTotalMetaItems = 0;
    private static final HashMap<Integer, Integer> mMaxStackSizeMap = new HashMap();
    private static final HashMap<Integer, String> mTooltipMap = new HashMap();
    private static final HashMap<Integer, EnumRarity> mRarityMap = new HashMap();
    private static final HashMap<Integer, Integer> mHealAmountMap = new HashMap();
    private static final HashMap<Integer, Float> mSaturationAmountMap = new HashMap();
    private static final HashMap<Integer, ArrayList<PotionEffectPackage>> mPotionEffectsMap = new HashMap();
    private static final HashMap<Integer, Boolean> mHasSpecialBehaviourMap = new HashMap();
    private static final HashMap<Integer, SpecialFoodBehaviour> mSpecialBehaviourMap = new HashMap();
    private static final HashMap<Integer, ArrayList<String>> mOreDictNames = new HashMap();

    public static void registerMetaFoods() {
        BaseItemMetaFood.registerNewMetaFood(0, "I wouldn't eat this unless I was starving", 2, 0.0f, 64, BaseItemMetaFood.getPotionEffectPackage(new EffectWeaknessModerate(80), new EffectSlownessModerate(80)), BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatraw"));
        BaseItemMetaFood.registerNewMetaFood(1, "Doesn't look any better cooked", 4, 1.0f, 64, BaseItemMetaFood.getPotionEffectPackage(new EffectWeaknessBasic(50), new EffectSlownessBasic(50)), BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatcooked"));
        BaseItemMetaFood.registerNewMetaFood(2, "", 2, 0.0f, 64, BaseItemMetaFood.getPotionEffectPackage(new EffectWeaknessBasic(30), new EffectSlownessBasic(30)), BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatraw"));
        BaseItemMetaFood.registerNewMetaFood(3, "", 4, 1.0f, 64, BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatcooked"));
        BaseItemMetaFood.registerNewMetaFood(4, "", 2, 0.0f, 64, BaseItemMetaFood.getPotionEffectPackage(new EffectWeaknessBasic(25), new EffectSlownessBasic(30)), BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatraw"));
        BaseItemMetaFood.registerNewMetaFood(5, "", 4, 1.0f, 64, BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatcooked"));
        BaseItemMetaFood.registerNewMetaFood(6, "", 2, 0.0f, 64, BaseItemMetaFood.getPotionEffectPackage(new EffectWeaknessBasic(30), new EffectSlownessBasic(25)), BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatraw"));
        BaseItemMetaFood.registerNewMetaFood(7, "", 4, 1.0f, 64, BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatcooked"));
        BaseItemMetaFood.registerNewMetaFood(8, "Warm to the touch", EnumRarity.uncommon, 4, 1.0f, 64, new ArrayList<PotionEffectPackage>(), new setOnFire(), BaseItemMetaFood.getOreDictNamesAsArrayList("listAllmeatcooked"));
    }

    public static void registerNewMetaFood(int aMetaID, String aTooltip, int aHealAmount, float aSaturationModifier, int aMaxStacksize) {
        BaseItemMetaFood.registerNewMetaFood(aMetaID, aTooltip, EnumRarity.common, aHealAmount, aSaturationModifier, aMaxStacksize, new ArrayList<PotionEffectPackage>(), null, new ArrayList<String>());
    }

    public static void registerNewMetaFood(int aMetaID, String aTooltip, int aHealAmount, float aSaturationModifier, int aMaxStacksize, ArrayList<String> aOreDictNames) {
        BaseItemMetaFood.registerNewMetaFood(aMetaID, aTooltip, EnumRarity.common, aHealAmount, aSaturationModifier, aMaxStacksize, new ArrayList<PotionEffectPackage>(), null, aOreDictNames);
    }

    public static void registerNewMetaFood(int aMetaID, String aTooltip, int aHealAmount, float aSaturationModifier, int aMaxStacksize, ArrayList<PotionEffectPackage> aPotionEffects, ArrayList<String> aOreDictNames) {
        BaseItemMetaFood.registerNewMetaFood(aMetaID, aTooltip, EnumRarity.common, aHealAmount, aSaturationModifier, aMaxStacksize, aPotionEffects, null, aOreDictNames);
    }

    public static void registerNewMetaFood(int aMetaID, String aTooltip, EnumRarity aRarity, int aHealAmount, float aSaturationModifier, int aMaxStacksize, ArrayList<PotionEffectPackage> aPotionEffects, SpecialFoodBehaviour aSpecialBehaviour) {
        BaseItemMetaFood.registerNewMetaFood(aMetaID, aTooltip, EnumRarity.common, aHealAmount, aSaturationModifier, aMaxStacksize, aPotionEffects, null, new ArrayList<String>());
    }

    public static void registerNewMetaFood(int aMetaID, String aTooltip, EnumRarity aRarity, int aHealAmount, float aSaturationModifier, int aMaxStacksize, ArrayList<PotionEffectPackage> aPotionEffects, SpecialFoodBehaviour aSpecialBehaviour, ArrayList<String> aOreDictNames) {
        ++mTotalMetaItems;
        mMaxStackSizeMap.put(aMetaID, aMaxStacksize);
        mTooltipMap.put(aMetaID, aTooltip);
        mRarityMap.put(aMetaID, aRarity);
        mHealAmountMap.put(aMetaID, aHealAmount);
        mSaturationAmountMap.put(aMetaID, Float.valueOf(aSaturationModifier));
        mPotionEffectsMap.put(aMetaID, aPotionEffects);
        mHasSpecialBehaviourMap.put(aMetaID, aSpecialBehaviour != null);
        if (aSpecialBehaviour != null) {
            mSpecialBehaviourMap.put(aMetaID, aSpecialBehaviour);
        }
        mOreDictNames.put(aMetaID, aOreDictNames);
        if (aOreDictNames.contains("listAllmeatraw")) {
            GTOreDictUnificator.addItemData(new ItemStack((Item)ModItems.itemMetaFood, 1, aMetaID), new ItemData(Materials.MeatRaw, 3628800L, new MaterialStack(Materials.Bone, 403200L)));
        } else if (aOreDictNames.contains("listAllmeatcooked")) {
            GTOreDictUnificator.addItemData(new ItemStack((Item)ModItems.itemMetaFood, 1, aMetaID), new ItemData(Materials.MeatCooked, 3628800L, new MaterialStack(Materials.Bone, 403200L)));
        }
    }

    public static void registerFoodsToOreDict() {
        for (int aMetaID = 0; aMetaID < mTotalMetaItems; ++aMetaID) {
            ArrayList<String> aOreDictNames = mOreDictNames.get(aMetaID);
            if (aOreDictNames == null || aOreDictNames.isEmpty()) continue;
            ItemStack aFoodStack = ItemUtils.simpleMetaStack((Item)ModItems.itemMetaFood, aMetaID, 1);
            for (String aOreName : aOreDictNames) {
                ItemUtils.addItemToOreDictionary(aFoodStack, aOreName);
            }
        }
    }

    public BaseItemMetaFood() {
        super(0, 0.0f, false);
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.func_77655_b("BasicMetaFood");
        this.func_77637_a(AddToCreativeTab.tabMisc);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    private static int getMetaKey(ItemStack aStack) {
        return aStack.func_77960_j();
    }

    public int func_150905_g(ItemStack aStack) {
        return mHealAmountMap.get(BaseItemMetaFood.getMetaKey(aStack));
    }

    public float func_150906_h(ItemStack aStack) {
        return mSaturationAmountMap.get(BaseItemMetaFood.getMetaKey(aStack)).floatValue();
    }

    public boolean func_77845_h() {
        return false;
    }

    protected void func_77849_c(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        SpecialFoodBehaviour aBehaviour;
        ArrayList<PotionEffectPackage> aPotionEffects = mPotionEffectsMap.get(BaseItemMetaFood.getMetaKey(aStack));
        if (!aWorld.field_72995_K && aPotionEffects != null && !aPotionEffects.isEmpty()) {
            for (PotionEffectPackage aFoodEffect : aPotionEffects) {
                PotionEffect aEffect;
                if (MathUtils.randInt(0, 100) > aFoodEffect.getChance() && aFoodEffect.getChance() != 100 || (aEffect = aFoodEffect.getEffect()) == null || aEffect.func_76456_a() <= 0) continue;
                aPlayer.func_70690_d(new PotionEffect(aEffect.func_76456_a(), aEffect.func_76459_b() * 20, aEffect.func_76458_c(), aEffect.func_82720_e()));
            }
        }
        boolean aHasEpcialBehaviour = mHasSpecialBehaviourMap.get(BaseItemMetaFood.getMetaKey(aStack));
        if (!aWorld.field_72995_K && aHasEpcialBehaviour && (aBehaviour = mSpecialBehaviourMap.get(BaseItemMetaFood.getMetaKey(aStack))) != null) {
            aBehaviour.doBehaviour(aPlayer);
        }
    }

    public ItemStack func_77654_b(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        return super.func_77654_b(aStack, aWorld, aPlayer);
    }

    public int getItemStackLimit(ItemStack aStack) {
        return mMaxStackSizeMap.get(BaseItemMetaFood.getMetaKey(aStack));
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean func_77629_n_() {
        return super.func_77629_n_();
    }

    public void func_77663_a(ItemStack p_77663_1_, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(p_77663_1_, p_77663_2_, p_77663_3_, p_77663_4_, p_77663_5_);
    }

    public String func_77653_i(ItemStack aStack) {
        return super.func_77653_i(aStack);
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer p_77624_2_, List aList, boolean p_77624_4_) {
        try {
            String aTooltip = mTooltipMap.get(BaseItemMetaFood.getMetaKey(aStack));
            if (aTooltip != null && aTooltip.length() > 0) {
                aList.add(aTooltip);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        super.func_77624_a(aStack, p_77624_2_, aList, p_77624_4_);
    }

    public EnumRarity func_77613_e(ItemStack aStack) {
        return mRarityMap.get(BaseItemMetaFood.getMetaKey(aStack));
    }

    public boolean func_77623_v() {
        return false;
    }

    public void func_150895_a(Item aItem, CreativeTabs p_150895_2_, List aList) {
        for (int i = 0; i < mIconMap.size(); ++i) {
            aList.add(ItemUtils.simpleMetaStack(aItem, i, 1));
        }
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public void func_94581_a(IIconRegister u) {
        for (int i = 0; i < mTotalMetaItems; ++i) {
            String aPath = Mods.GTPlusPlus.ID + ":food/MetaItem1/" + i;
            mIconMap.put(i, u.func_94245_a(aPath));
        }
    }

    public IIcon func_77618_c(int damage, int pass) {
        return mIconMap.get(damage);
    }

    public IIcon func_77617_a(int damage) {
        return mIconMap.get(damage);
    }

    public IIcon getIcon(ItemStack aStack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return mIconMap.get(BaseItemMetaFood.getMetaKey(aStack));
    }

    public IIcon getIcon(ItemStack aStack, int pass) {
        return mIconMap.get(BaseItemMetaFood.getMetaKey(aStack));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    private static ArrayList<PotionEffectPackage> getPotionEffectPackage(PotionEffectPackage ... aEffects) {
        ArrayList<PotionEffectPackage> aPackage = new ArrayList<PotionEffectPackage>();
        if (aEffects != null && aEffects.length > 0) {
            Collections.addAll(aPackage, aEffects);
        }
        return aPackage;
    }

    private static ArrayList<String> getOreDictNamesAsArrayList(String ... aOreDictNames) {
        ArrayList<String> aPackage = new ArrayList<String>();
        if (aOreDictNames != null && aOreDictNames.length > 0) {
            for (String aEffect : aOreDictNames) {
                aPackage.add(aEffect);
            }
        }
        return aPackage;
    }

    private static class PotionEffectPackage {
        private final PotionEffect mEffect;
        private final int mChance;

        private PotionEffectPackage(PotionEffect aEffect, int aChance) {
            this.mEffect = aEffect;
            this.mChance = aChance;
        }

        public PotionEffect getEffect() {
            return this.mEffect;
        }

        public int getChance() {
            return this.mChance;
        }
    }

    private static class EffectWeaknessModerate
    extends PotionEffectPackage {
        protected EffectWeaknessModerate(int aChance) {
            super(new PotionEffect(Potion.field_76437_t.func_76396_c(), 2, 40), aChance);
        }
    }

    private static class EffectSlownessModerate
    extends PotionEffectPackage {
        protected EffectSlownessModerate(int aChance) {
            super(new PotionEffect(Potion.field_76421_d.func_76396_c(), 2, 40), aChance);
        }
    }

    private static class EffectWeaknessBasic
    extends PotionEffectPackage {
        protected EffectWeaknessBasic(int aChance) {
            super(new PotionEffect(Potion.field_76437_t.func_76396_c(), 1, 20), aChance);
        }
    }

    private static class EffectSlownessBasic
    extends PotionEffectPackage {
        protected EffectSlownessBasic(int aChance) {
            super(new PotionEffect(Potion.field_76421_d.func_76396_c(), 1, 20), aChance);
        }
    }

    private static class setOnFire
    extends SpecialFoodBehaviour {
        public setOnFire() {
            super(100);
        }

        @Override
        public void behaviour(EntityPlayer aPlayer) {
            EntityUtils.setEntityOnFire((Entity)aPlayer, 5);
        }
    }

    private static abstract class SpecialFoodBehaviour {
        protected final int mChance;

        public SpecialFoodBehaviour(int aChance) {
            this.mChance = aChance;
        }

        public final void doBehaviour(EntityPlayer aPlayer) {
            if (!(aPlayer == null || aPlayer.field_70170_p.field_72995_K || MathUtils.randInt(0, 100) >= this.mChance && this.mChance != 100)) {
                this.behaviour(aPlayer);
            }
        }

        protected abstract void behaviour(EntityPlayer var1);
    }

    private static class EffectSlownessSevere
    extends PotionEffectPackage {
        protected EffectSlownessSevere(int aChance) {
            super(new PotionEffect(Potion.field_76421_d.func_76396_c(), 3, 60), aChance);
        }
    }

    private static class EffectWeaknessSevere
    extends PotionEffectPackage {
        protected EffectWeaknessSevere(int aChance) {
            super(new PotionEffect(Potion.field_76437_t.func_76396_c(), 3, 60), aChance);
        }
    }
}

