/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="miscutils", configSubDirectory="GTPlusPlus", filename="GTPlusPlus")
@Config.LangKeyPattern(pattern="gtpp.gui.config.%cat.%field", fullyQualified=true)
@Config.Comment(value={"General section"})
@Config.RequiresMcRestart
public class Configuration {
    public static final Debug debug = new Debug();
    public static final Machines machines = new Machines();
    public static final Gregtech gregtech = new Gregtech();
    public static final Pollution pollution = new Pollution();
    public static final Features features = new Features();
    public static final Visual visual = new Visual();
    public static final Worldgen worldgen = new Worldgen();

    @Config.Comment(value={"Debug section"})
    public static class Debug {
        @Config.Comment(value={"Makes many machines display lots of debug logging."})
        @Config.DefaultBoolean(value=false)
        public boolean MachineInfo;
        @Config.Comment(value={"Makes all items hidden from NEI display."})
        @Config.DefaultBoolean(value=false)
        public boolean showHiddenNEIItems;
        @Config.Comment(value={"Dumps all GT++ and Toxic Everglade Data to en_US.lang in the config folder. This config option can be used by foreign players to generate blank .lang files, which they can populate with their language of choice."})
        @Config.DefaultBoolean(value=false)
        public boolean dumpItemAndBlockData;
    }

    @Config.Comment(value={"Machines section"})
    public static class Machines {
        @Config.Comment(value={"Allows the use of TC shards across many recipes by oreDicting them into a common group."})
        @Config.DefaultBoolean(value=false)
        public boolean enableThaumcraftShardUnification;
        @Config.Comment(value={"Alkaluscraft Related - Removes IC2 Cables Except glass fibre. Few other Misc Tweaks."})
        @Config.DefaultBoolean(value=false)
        public boolean disableIC2Recipes;
        @Config.Comment(value={"Sets the steam per second value in LV,MV,HV boilers (respectively 1x,2x,3x this number for the tiers)"})
        @Config.DefaultInt(value=750)
        public int boilerSteamPerSecond;
    }

    @Config.Comment(value={"GregTech section"})
    public static class Gregtech {
        @Config.Comment(value={"Rotors below this durability will be removed, prevents NEI clutter. Minimum Durability is N * x, where N is the new value set and x is the turbine size, where 1 is Tiny and 4 is Huge. Set to 0 to disable."})
        @Config.DefaultInt(value=25500)
        public int turbineCutoffBase;
    }

    @Config.Comment(value={"Pollution section"})
    public static class Pollution {
        @Config.Comment(value={"pollution rate in gibbl/s for the Amazon warehousing depot"})
        @Config.DefaultInt(value=40)
        public int pollutionPerSecondMultiPackager;
        @Config.Comment(value={"pollution rate in gibbl/s for the Alloy blast smelter"})
        @Config.DefaultInt(value=300)
        public int pollutionPerSecondMultiIndustrialAlloySmelter;
        @Config.Comment(value={"pollution rate in gibbl/s for the High current arc furnace"})
        @Config.DefaultInt(value=2400)
        public int pollutionPerSecondMultiIndustrialArcFurnace;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial centrifuge"})
        @Config.DefaultInt(value=300)
        public int pollutionPerSecondMultiIndustrialCentrifuge;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial coke oven"})
        @Config.DefaultInt(value=80)
        public int pollutionPerSecondMultiIndustrialCokeOven;
        @Config.Comment(value={"pollution rate in gibbl/s for the Cutting factory"})
        @Config.DefaultInt(value=160)
        public int pollutionPerSecondMultiIndustrialCuttingMachine;
        @Config.Comment(value={"pollution rate in gibbl/s for the Utupu-Tanuri"})
        @Config.DefaultInt(value=500)
        public int pollutionPerSecondMultiIndustrialDehydrator;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial electrolyzer"})
        @Config.DefaultInt(value=300)
        public int pollutionPerSecondMultiIndustrialElectrolyzer;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial extrusion machine"})
        @Config.DefaultInt(value=1000)
        public int pollutionPerSecondMultiIndustrialExtruder;
        @Config.Comment(value={"pollution rate in gibbl/s for the Maceration stack"})
        @Config.DefaultInt(value=400)
        public int pollutionPerSecondMultiIndustrialMacerator;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial mixing machine"})
        @Config.DefaultInt(value=800)
        public int pollutionPerSecondMultiIndustrialMixer;
        @Config.Comment(value={"pollution rate in gibbl/s for the Large processing factory in metal mode"})
        @Config.DefaultInt(value=400)
        public int pollutionPerSecondMultiIndustrialMultiMachine_ModeMetal;
        @Config.Comment(value={"pollution rate in gibbl/s for the Large processing factory in fluid mode"})
        @Config.DefaultInt(value=400)
        public int pollutionPerSecondMultiIndustrialMultiMachine_ModeFluid;
        @Config.Comment(value={"pollution rate in gibbl/s for the Large processing factory in misc mode"})
        @Config.DefaultInt(value=600)
        public int pollutionPerSecondMultiIndustrialMultiMachine_ModeMisc;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial material press in forming mode"})
        @Config.DefaultInt(value=240)
        public int pollutionPerSecondMultiIndustrialPlatePress_ModeForming;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial material press in bending mode"})
        @Config.DefaultInt(value=480)
        public int pollutionPerSecondMultiIndustrialPlatePress_ModeBending;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial Forge Hammer"})
        @Config.DefaultInt(value=250)
        public int pollutionPerSecondMultiIndustrialForgeHammer;
        @Config.Comment(value={"pollution rate in gibbl/s for the Large Sifter"})
        @Config.DefaultInt(value=40)
        public int pollutionPerSecondMultiIndustrialSifter;
        @Config.Comment(value={"pollution rate in gibbl/s for the Large thermal refinery"})
        @Config.DefaultInt(value=1000)
        public int pollutionPerSecondMultiIndustrialThermalCentrifuge;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial fluid heater"})
        @Config.DefaultInt(value=1000)
        public int pollutionPerSecondMultiIndustrialFluidHeater;
        @Config.Comment(value={"pollution rate in gibbl/s for the Cryogenic freezer"})
        @Config.DefaultInt(value=500)
        public int pollutionPerSecondMultiIndustrialVacuumFreezer;
        @Config.Comment(value={"pollution rate in gibbl/s for the Ore washing plant in chemical bath mode"})
        @Config.DefaultInt(value=400)
        public int pollutionPerSecondMultiIndustrialWashPlant_ModeChemBath;
        @Config.Comment(value={"pollution rate in gibbl/s for the Ore washing plant in ore washer mode"})
        @Config.DefaultInt(value=100)
        public int pollutionPerSecondMultiIndustrialWashPlant_ModeWasher;
        @Config.Comment(value={"pollution rate in gibbl/s for the Wire factory"})
        @Config.DefaultInt(value=100)
        public int pollutionPerSecondMultiIndustrialWireMill;
        @Config.Comment(value={"pollution rate in gibbl/s for the IsaMill grinding machine"})
        @Config.DefaultInt(value=1280)
        public int pollutionPerSecondMultiIsaMill;
        @Config.Comment(value={"pollution rate in gibbl/s for the Dangote distillus in distillery mode"})
        @Config.DefaultInt(value=240)
        public int pollutionPerSecondMultiAdvDistillationTower_ModeDistillery;
        @Config.Comment(value={"pollution rate in gibbl/s for the Dangote distillus in distillation tower mode"})
        @Config.DefaultInt(value=480)
        public int pollutionPerSecondMultiAdvDistillationTower_ModeDT;
        @Config.Comment(value={"pollution rate in gibbl/s for the Volcanus"})
        @Config.DefaultInt(value=500)
        public int pollutionPerSecondMultiAdvEBF;
        @Config.Comment(value={"pollution rate in gibbl/s for the Density^2"})
        @Config.DefaultInt(value=5000)
        public int pollutionPerSecondMultiAdvImplosion;
        @Config.Comment(value={"pollution rate in gibbl/s for the Alloy blast furnace"})
        @Config.DefaultInt(value=200)
        public int pollutionPerSecondMultiABS;
        @Config.Comment(value={"pollution rate in gibbl/s for the Cyclotron"})
        @Config.DefaultInt(value=200)
        public int pollutionPerSecondMultiCyclotron;
        @Config.Comment(value={"pollution rate in gibbl/s for the Zuhai - fishing port"})
        @Config.DefaultInt(value=20)
        public int pollutionPerSecondMultiIndustrialFishingPond;
        @Config.Comment(value={"pollution rate in gibbl/s for the Large semifluid burner"})
        @Config.DefaultInt(value=1280)
        public int pollutionPerSecondMultiLargeSemiFluidGenerator;
        @Config.Comment(value={"pollution rate in gibbl/s for the Matter fabrication CPU"})
        @Config.DefaultInt(value=40)
        public int pollutionPerSecondMultiMassFabricator;
        @Config.Comment(value={"pollution rate in gibbl/s for the Reactor fuel processing plant"})
        @Config.DefaultInt(value=4000)
        public int pollutionPerSecondMultiRefinery;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial Rock Breaker"})
        @Config.DefaultInt(value=100)
        public int pollutionPerSecondMultiIndustrialRockBreaker;
        @Config.Comment(value={"pollution rate in gibbl/s for the Industrial Chisel"})
        @Config.DefaultInt(value=50)
        public int pollutionPerSecondMultiIndustrialChisel;
        @Config.Comment(value={"pollution rate in gibbl/s for the Tree growth simulator"})
        @Config.DefaultInt(value=100)
        public int pollutionPerSecondMultiTreeFarm;
        @Config.Comment(value={"pollution rate in gibbl/s for the Flotation cell regulator"})
        @Config.DefaultInt(value=0)
        public int pollutionPerSecondMultiFrothFlotationCell;
        @Config.Comment(value={"pollution rate in gibbl/s for the Large-Scale auto assembler v1.01"})
        @Config.DefaultInt(value=500)
        public int pollutionPerSecondMultiAutoCrafter;
        @Config.Comment(value={"pollution rate in gibbl/s for the Nuclear salt processing plant"})
        @Config.DefaultInt(value=500)
        public int pollutionPerSecondNuclearSaltProcessingPlant;
        @Config.Comment(value={"pollution rate in gibbl/s for the Multiblock Molecular Transformer"})
        @Config.DefaultInt(value=1000)
        public int pollutionPerSecondMultiMolecularTransformer;
        @Config.Comment(value={"pollution rate in gibbl/s for the Elemental Duplicator"})
        @Config.DefaultInt(value=1000)
        public int pollutionPerSecondElementalDuplicator;
        @Config.Comment(value={"pollution rate in gibbl/s for the Thermal boiler"})
        @Config.DefaultInt(value=700)
        public int pollutionPerSecondMultiThermalBoiler;
        @Config.Comment(value={"pollution rate in gibbl/s for the Algae farm"})
        @Config.DefaultInt(value=0)
        public int pollutionPerSecondMultiAlgaePond;
        @Config.Comment(value={"base pollution rate in gibbl/s for the single block semi fluid generators"})
        @Config.DefaultInt(value=40)
        public int basePollutionPerSecondSemiFluidGenerator;
        @Config.Comment(value={"coefficient applied to the base rate of the single block semi fluid generators based on its tier (first is tier 0 aka ULV)"})
        @Config.DefaultDoubleList(value={0.0, 2.0, 4.0, 8.0, 12.0, 16.0})
        public double[] pollutionReleasedByTierSemiFluidGenerator;
        @Config.Comment(value={"base pollution rate in gibbl/s for the single block boilers"})
        @Config.DefaultInt(value=35)
        public int basePollutionPerSecondBoiler;
        @Config.Comment(value={"coefficient applied to the base rate of the single block boilers based on its tier (first is tier 0 aka ULV)"})
        @Config.DefaultDoubleList(value={0.0, 1.0, 1.43, 1.86})
        public double[] pollutionReleasedByTierBoiler;
        @Config.Comment(value={"minimum base pollution rate in gibbl/s for the single block rocket engines"})
        @Config.DefaultInt(value=250)
        public int baseMinPollutionPerSecondRocketFuelGenerator;
        @Config.Comment(value={"maximum base pollution rate in gibbl/s for the single block rocket engines"})
        @Config.DefaultInt(value=2000)
        public int baseMaxPollutionPerSecondRocketFuelGenerator;
        @Config.Comment(value={"coefficient applied to the base rate of the single block rocket engines based on its tier (first is tier 0 aka ULV)"})
        @Config.DefaultDoubleList(value={0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0})
        public double[] pollutionReleasedByTierRocketFuelGenerator;
        @Config.Comment(value={"base pollution rate in gibbl/s for the geothermal engines"})
        @Config.DefaultInt(value=100)
        public int basePollutionPerSecondGeothermalGenerator;
        @Config.Comment(value={"coefficient applied to the base rate of the single block geothermal engines based on its tier (first is tier 0 aka ULV)"})
        @Config.DefaultDoubleList(value={0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0})
        public double[] pollutionReleasedByTierGeothermalGenerator;
    }

    @Config.Comment(value={"Features section"})
    public static class Features {
        @Config.Comment(value={"Hides every filled IC2 Universal Cell from NEI."})
        @Config.DefaultBoolean(value=true)
        public boolean hideUniversalCells;
    }

    @Config.Comment(value={"Visual section"})
    public static class Visual {
        @Config.Comment(value={"Enables Animated GT++ Textures"})
        @Config.DefaultBoolean(value=true)
        public boolean enableAnimatedTextures;
        @Config.Comment(value={"Use GT textures"})
        @Config.DefaultBoolean(value=true)
        public boolean useGregtechTextures;
    }

    @Config.Comment(value={"Worldgen section"})
    public static class Worldgen {
        @Config.Comment(value={"The ID of the Toxic Everglades."})
        @Config.DefaultInt(value=227)
        public int EVERGLADES_ID;
        @Config.Comment(value={"The biome within the Toxic Everglades."})
        @Config.DefaultInt(value=199)
        public int EVERGLADESBIOME_ID;
    }
}

