/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.common;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.core.entity.mob.EntityEvolvedColdBlaze;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.config.ASMConfiguration;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.entity.InternalEntityRegistry;
import gtPlusPlus.core.handler.BookHandler;
import gtPlusPlus.core.handler.BurnableFuelHandler;
import gtPlusPlus.core.handler.CompatHandler;
import gtPlusPlus.core.handler.CompatIntermodStaging;
import gtPlusPlus.core.handler.GuiHandler;
import gtPlusPlus.core.handler.events.EnderDragonDeathHandler;
import gtPlusPlus.core.handler.events.EntityDeathHandler;
import gtPlusPlus.core.handler.events.MolecularTransformerTooltipNotice;
import gtPlusPlus.core.handler.events.PlayerSleepEventHandler;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.bauble.BaseBauble;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.tileentities.ModTileEntities;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.ic2.CustomInternalName;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class CommonProxy {
    public CommonProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent e) {
        Logger.INFO("Doing some house cleaning.");
        if (ASMConfiguration.debug.debugMode) {
            Logger.INFO("Development mode enabled.");
        } else {
            Logger.WARNING("Development mode not enabled.");
        }
        AddToCreativeTab.initialiseTabs();
        CustomInternalName.init();
        ModItems.init();
        ModBlocks.init();
        CI.preInit();
        CompatIntermodStaging.preInit(e);
        BookHandler.run();
        Logger.INFO("[Proxy] Calling Entity registration.");
        this.registerEntities();
        Logger.INFO("[Proxy] Calling Tile Entity registration.");
        this.registerTileEntities();
        Logger.INFO("[Proxy] Calling Render registration.");
        this.registerRenderThings();
    }

    public void init(FMLInitializationEvent e) {
        CI.init();
        if (Mods.AdvancedSolarPanel.isModLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new MolecularTransformerTooltipNotice());
        }
        PlayerSleepEventHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)ModItems.itemMagicFeather);
        FMLCommonHandler.instance().bus().register((Object)ModItems.itemMagicFeather);
        MinecraftForge.EVENT_BUS.register((Object)new EnderDragonDeathHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntityDeathHandler());
        CompatHandler.registerMyModsOreDictEntries();
        CompatHandler.intermodOreDictionarySupport();
        CompatIntermodStaging.init(e);
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (!GTPPCore.burnables.isEmpty()) {
            BurnableFuelHandler fuelHandler = new BurnableFuelHandler();
            GameRegistry.registerFuelHandler((IFuelHandler)fuelHandler);
            Logger.INFO("[Fuel Handler] Registering " + fuelHandler.getClass().getName());
        }
        Logger.INFO("Removing recipes from other mods.");
        CompatHandler.RemoveRecipesFromOtherMods();
        Logger.INFO("Initialising Handler, Then Adding Recipes");
        CompatHandler.InitialiseHandlerThenAddRecipes();
        Logger.INFO("Loading Intermod staging.");
        CompatIntermodStaging.postInit(e);
        Logger.INFO("Loading queued recipes.");
        CompatHandler.runQueuedRecipes();
        Logger.INFO("Registering custom mob drops.");
        this.registerCustomMobDrops();
        Logger.INFO("Loading Gregtech API recipes.");
        CompatHandler.startLoadingGregAPIBasedRecipes();
    }

    public void serverStarting(FMLServerStartingEvent e) {
        CompatHandler.InitialiseLateHandlerThenAddRecipes();
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        CompatIntermodStaging.onLoadComplete(event);
        CompatHandler.onLoadComplete(event);
    }

    public void registerNetworkStuff() {
        GuiHandler.init();
    }

    public void registerEntities() {
        InternalEntityRegistry.registerEntities();
    }

    public void registerTileEntities() {
        ModTileEntities.init();
    }

    public void registerRenderThings() {
    }

    public int addArmor(String armor) {
        return 0;
    }

    public void registerCustomMobDrops() {
        if (ItemUtils.doesOreDictHaveEntryFor("dustPyrotheum")) {
            EntityUtils.registerDropsForMob(EntityBlaze.class, ItemUtils.getItemStackOfAmountFromOreDict("dustPyrotheum", 1), 1, 10);
            EntityUtils.registerDropsForMob(EntityBlaze.class, ItemUtils.getItemStackOfAmountFromOreDict("dustPyrotheum", 1), 1, 10);
        }
        if (Mods.GalaxySpace.isModLoaded()) {
            ItemStack aSmallBlizz = ItemUtils.getItemStackOfAmountFromOreDict("dustSmallBlizz", 1);
            ItemStack aTinyBlizz = ItemUtils.getItemStackOfAmountFromOreDict("dustTinyBlizz", 1);
            ItemStack aSmallCryo = ItemUtils.getItemStackOfAmountFromOreDict("dustSmallCryotheum", 1);
            ItemStack aTinyCryo = ItemUtils.getItemStackOfAmountFromOreDict("dustTinyCryotheum", 1);
            EntityUtils.registerDropsForMob(EntityEvolvedColdBlaze.class, ItemUtils.getItemStackOfAmountFromOreDict("stickBlizz", 1), 2, 500);
            if (aSmallBlizz != null) {
                EntityUtils.registerDropsForMob(EntityEvolvedColdBlaze.class, aSmallBlizz, 2, 750);
            }
            if (aTinyBlizz != null) {
                EntityUtils.registerDropsForMob(EntityEvolvedColdBlaze.class, aTinyBlizz, 4, 1500);
            }
            if (aSmallCryo != null) {
                EntityUtils.registerDropsForMob(EntityEvolvedColdBlaze.class, aSmallCryo, 1, 50);
            }
            if (aTinyCryo != null) {
                EntityUtils.registerDropsForMob(EntityEvolvedColdBlaze.class, aTinyCryo, 2, 100);
            }
        }
    }

    public World getClientWorld() {
        return null;
    }

    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    @Optional.Method(modid="Baubles")
    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        BaseBauble gtBauble;
        Item item;
        BaseBauble gtBauble2;
        Item item2;
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLivingBase;
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        if (baubles == null) {
            return;
        }
        ItemStack bauble1 = baubles.func_70301_a(1);
        if (bauble1 != null && (item2 = bauble1.func_77973_b()) instanceof BaseBauble && (gtBauble2 = (BaseBauble)item2).getDamageNegations().contains(event.source.field_76373_n)) {
            event.setCanceled(true);
            return;
        }
        ItemStack bauble2 = baubles.func_70301_a(2);
        if (bauble2 != null && (item = bauble2.func_77973_b()) instanceof BaseBauble && (gtBauble = (BaseBauble)item).getDamageNegations().contains(event.source.field_76373_n)) {
            event.setCanceled(true);
        }
    }
}

