/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.data;

import gregtech.api.objects.XSTR;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class WeightedCollection<E>
implements Map<Integer, E> {
    private NavigableMap<Integer, E> map = new TreeMap<Integer, E>();
    private Random random;
    private int total = 0;

    public WeightedCollection() {
        this(new XSTR());
    }

    public WeightedCollection(Random random) {
        this.random = random;
    }

    public E add(int weight, E object) {
        if (weight <= 0) {
            return null;
        }
        this.total += weight;
        return this.map.put(this.total, object);
    }

    private E next() {
        int value = this.random.nextInt(this.total) + 1;
        return this.map.ceilingEntry(value).getValue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public E get() {
        return this.next();
    }

    @Override
    public E get(Object key) {
        return this.next();
    }

    @Override
    public void putAll(Map m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.total = 0;
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection values() {
        return this.map.values();
    }

    @Override
    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public E put(Integer key, E value) {
        return this.add(key, value);
    }

    @Override
    public E remove(Object key) {
        return (E)this.map.remove(key);
    }
}

