/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone.compiler;

import gregtech.shadow.com.github.technus.avrClone.compiler.IIncludeProcessor;
import gregtech.shadow.com.github.technus.avrClone.compiler.Line;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.CompilerException;
import gregtech.shadow.com.github.technus.avrClone.compiler.exceptions.InvalidInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SourceCollection {
    public static final char INCLUDE_SEPARATOR_CHAR = '\u001c';
    public static final char MACRO_SEPARATOR_CHAR = '\u001d';
    public static final char LINE_NUMBER_SEPARATOR_CHAR = '\u001e';
    private HashSet<String> systemDirectories = new HashSet();
    private HashSet<String> userDirectories = new HashSet();
    private HashMap<String, String> paths = new HashMap();
    private IIncludeProcessor currentIncludeProcessor;
    private HashMap<String, ArrayList<String>> includedFiles = new HashMap(8);

    public void clear() {
        this.includedFiles = new HashMap(8);
    }

    public void setCurrentIncludeProcessor(IIncludeProcessor include) {
        this.currentIncludeProcessor = include;
    }

    public IIncludeProcessor getCurrentIncludeProcessor() {
        return this.currentIncludeProcessor;
    }

    public ArrayList<Line> projectRootInclude(String absoluteIncludeName, boolean shouldList) throws CompilerException {
        this.paths.clear();
        return this.getInclude("", "", absoluteIncludeName, 1, shouldList);
    }

    public ArrayList<Line> getInclude(String includePath, String parentIncludeName, String includeName, int currentLine, boolean shouldList) throws CompilerException {
        if (includePath == null || includeName == null) {
            throw new InvalidInclude("Invalid include parameters! " + includePath + " " + includeName);
        }
        String includePathNew = includePath + includeName + '\u001c';
        ArrayList<String> contents = this.includedFiles.get(includePathNew);
        if (contents == null) {
            if (this.currentIncludeProcessor == null) {
                throw new InvalidInclude("No include processor set!");
            }
            contents = this.currentIncludeProcessor.include(includePath, includeName, includePathNew, this.systemDirectories, this.userDirectories, this.paths);
            if (contents == null) {
                throw new InvalidInclude("Unable to include file! " + includeName);
            }
            this.includedFiles.put(includePathNew, contents);
        }
        ArrayList<Line> inc = new ArrayList<Line>(contents.size());
        String lineName = parentIncludeName + includeName + '\u001e' + currentLine + '\u001c';
        for (int i = 0; i < contents.size(); ++i) {
            inc.add(new Line(includePathNew, lineName, i + 1, contents.get(i), shouldList));
        }
        return inc;
    }

    public HashSet<String> getSystemDirectories() {
        return this.systemDirectories;
    }

    public void setSystemDirectories(HashSet<String> systemDirectories) throws InvalidInclude {
        if (systemDirectories == null) {
            throw new InvalidInclude("System directories cannot be null!");
        }
        this.systemDirectories = systemDirectories;
    }

    public HashSet<String> getUserDirectories() {
        return this.userDirectories;
    }

    public void setUserDirectories(HashSet<String> userDirectories) throws InvalidInclude {
        if (userDirectories == null) {
            throw new InvalidInclude("System directories cannot be null!");
        }
        this.userDirectories = userDirectories;
    }
}

