/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class ProcessingCell
implements IOreRecipeRegistrator {
    public ProcessingCell() {
        OrePrefixes.cell.add(this);
        OrePrefixes.cellPlasma.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aPrefix) {
            case cell: {
                ItemStack[] outputsArray;
                if (aMaterial == Materials.Empty) {
                    GTModHandler.removeRecipeByOutputDelayed(aStack);
                    if (!aModName.equalsIgnoreCase("AtomicScience")) break;
                    GTValues.RA.stdBuilder().itemInputs(ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(aStack).duration(300).eut(2).addTo(RecipeMaps.extractorRecipes);
                    break;
                }
                if (aMaterial.mFuelPower > 0) {
                    GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                    recipeBuilder.itemInputs(GTUtility.copyAmount(1, aStack));
                    if (GTUtility.getFluidForFilledItem(aStack, true) == null && GTUtility.getContainerItem(aStack, true) != null) {
                        recipeBuilder.itemOutputs(GTUtility.getContainerItem(aStack, true));
                    }
                    recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (aMaterial.mMaterialList.size() <= 0 || (aMaterial.mExtraData & 3) == 0) break;
                int tAllAmount = 0;
                for (MaterialStack tMat2 : aMaterial.mMaterialList) {
                    tAllAmount = (int)((long)tAllAmount + tMat2.mAmount);
                }
                long tItemAmount = 0L;
                long tCapsuleCount = (long)GTModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(aStack) * (long)(-tAllAmount);
                long tDensityMultiplier = aMaterial.getDensity() > 3628800L ? aMaterial.getDensity() / 3628800L : 1L;
                ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
                for (MaterialStack tMat : aMaterial.mMaterialList) {
                    ItemStack tStack;
                    if (tMat.mAmount <= 0L) continue;
                    if (tMat.mMaterial == Materials.Air) {
                        tStack = ItemList.Cell_Air.get(tMat.mAmount * tDensityMultiplier / 2L, new Object[0]);
                    } else {
                        tStack = GTOreDictUnificator.get(OrePrefixes.dust, tMat.mMaterial, tMat.mAmount);
                        if (tStack == null) {
                            tStack = GTOreDictUnificator.get(OrePrefixes.cell, tMat.mMaterial, tMat.mAmount);
                        }
                    }
                    if (tItemAmount + tMat.mAmount * 3628800L > (long)aStack.func_77976_d() * aMaterial.getDensity()) continue;
                    tItemAmount += tMat.mAmount * 3628800L;
                    if (tStack == null) continue;
                    tStack.field_77994_a = (int)((long)tStack.field_77994_a * tDensityMultiplier);
                    while (tStack.field_77994_a > 64 && (tCapsuleCount + (long)GTModHandler.getCapsuleCellContainerCount(tStack) * 64L < 0L ? tList.size() < 5 : tList.size() < 6) && tCapsuleCount + (long)GTModHandler.getCapsuleCellContainerCount(tStack) * 64L <= 64L) {
                        tCapsuleCount += (long)GTModHandler.getCapsuleCellContainerCount(tStack) * 64L;
                        tList.add(GTUtility.copyAmount(64, tStack));
                        tStack.field_77994_a -= 64;
                    }
                    int tThisCapsuleCount = GTModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(tStack);
                    if (tStack.field_77994_a <= 0 || tCapsuleCount + (long)tThisCapsuleCount > 64L || !(tCapsuleCount + (long)tThisCapsuleCount < 0L ? tList.size() < 5 : tList.size() < 6)) continue;
                    tCapsuleCount += (long)tThisCapsuleCount;
                    tList.add(tStack);
                }
                tItemAmount = GTUtility.ceilDiv(tItemAmount * tDensityMultiplier, aMaterial.getDensity());
                if (tList.size() <= 0) break;
                if ((aMaterial.mExtraData & 1) != 0) {
                    if (GTUtility.getFluidForFilledItem(aStack, true) == null) {
                        GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                        if (tCapsuleCount > 0L) {
                            recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                        } else {
                            recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack));
                        }
                        if (tCapsuleCount < 0L) {
                            tList.add(ItemList.Cell_Empty.get(-tCapsuleCount, new Object[0]));
                        }
                        outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                        recipeBuilder.itemOutputs(outputsArray).duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 2L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(RecipeMaps.electrolyzerRecipes);
                    } else {
                        long tCellBalance = tCapsuleCount + tItemAmount - 1L;
                        GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                        if (tCellBalance > 0L) {
                            recipeBuilder.itemInputs(aStack, ItemList.Cell_Empty.get(tCellBalance, new Object[0]));
                        } else {
                            recipeBuilder.itemInputs(aStack);
                        }
                        if (tCellBalance < 0L) {
                            tList.add(ItemList.Cell_Empty.get(-tCellBalance, new Object[0]));
                        }
                        ItemStack[] outputsArray2 = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                        recipeBuilder.itemOutputs(outputsArray2).duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 8L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(RecipeMaps.electrolyzerRecipes);
                    }
                }
                if ((aMaterial.mExtraData & 2) == 0) break;
                GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                if (tCapsuleCount > 0L) {
                    recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                } else {
                    recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack));
                }
                if (tCapsuleCount < 0L) {
                    tList.add(ItemList.Cell_Empty.get(-tCapsuleCount, new Object[0]));
                }
                outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                recipeBuilder.itemOutputs(outputsArray).duration(Math.max(1L, Math.abs(aMaterial.getMass() * 2L * tItemAmount))).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                break;
            }
            case cellPlasma: {
                if (aMaterial == Materials.Empty) {
                    GTModHandler.removeRecipeByOutputDelayed(aStack);
                    break;
                }
                GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                recipeBuilder.itemInputs(GTUtility.copyAmount(1, aStack));
                if (GTUtility.getFluidForFilledItem(aStack, true) == null && GTUtility.getContainerItem(aStack, true) != null) {
                    recipeBuilder.itemOutputs(GTUtility.getContainerItem(aStack, true));
                }
                switch (aMaterial.mName) {
                    case "Aluminium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 159744).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Americium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 501760).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Antimony": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 309760).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Argon": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 188416).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Arsenic": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 230400).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Barium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 342302).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Beryllium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 110592).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Bismuth": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 425984).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Boron": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 112640).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Cadmium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 293601).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Caesium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 332513).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Calcium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 188416).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Cerium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 346931).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Chlorine": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 172032).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Chrome": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 202342).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Cobalt": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 217497).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Copper": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 219340).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Deuterium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 40960).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Erbium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 376217).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Europium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 355635).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Fluorine": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 147456).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Force": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 180000).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Gadolinium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 366551).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Gallium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 229376).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Gold": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 401408).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Helium_3": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 61440).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Helium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 81920).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Holmium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 376176).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Hydrogen": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 20480).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Indium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 296509).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Iridium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 397148).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Iron": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 206438).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Lanthanum": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 344801).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Lead": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 423936).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Lithium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 100352).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Lutetium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 381296).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Magnesium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 152371).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Manganese": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 202752).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Mercury": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 409600).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Molybdenum": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 272384).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Neodymium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 347996).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Nickel": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 213811).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Niobium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 269516).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Nitrogen": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 129024).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Osmium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 393659).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Oxygen": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 131072).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Palladium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 282214).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Phosphor": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 165888).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Platinum": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 399360).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Plutonium241": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 497664).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Plutonium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 503808).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Potassium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 183705).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Praseodymium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 346931).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Promethium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 347996).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Radon": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 450560).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Rubidium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 243712).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Samarium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 353280).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Scandium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 193536).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Silicon": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 160563).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Silver": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 282685).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Sodium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 148684).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Strontium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 249446).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Sulfur": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 170393).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Tantalum": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 384000).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Terbium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 368885).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Thorium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 471040).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Thulium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 378470).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Tin": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 150000).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Titanium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 196608).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Tritium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 61440).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Tungsten": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 384778).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Uranium235": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 481280).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Uranium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 487424).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Vanadium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 198451).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Ytterbium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 379695).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Yttrium": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 255180).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "Zinc": {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, 226304).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    default: {
                        recipeBuilder.metadata(GTRecipeConstants.FUEL_VALUE, (int)Math.max(1024L, 1024L * aMaterial.getMass())).metadata(GTRecipeConstants.FUEL_TYPE, 4).addTo(GTRecipeConstants.Fuel);
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L)).duration((int)Math.max(aMaterial.getMass() * 2L, 1L) * 1).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.vacuumFreezerRecipes);
                break;
            }
        }
    }
}

