/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.casings.upgrade;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.enums.InventoryType;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.casing.UpgradeCasing;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class Inventory
extends UpgradeCasing {
    public UUID inventoryID;
    private String inventoryName = "inventory";
    private int inventorySize;
    private InventoryType type = InventoryType.Both;

    public String getCustomInventoryName() {
        return this.inventoryName;
    }

    public String getInventoryID() {
        return this.inventoryID != null ? this.inventoryID.toString() : "";
    }

    public void setInventoryName(String aInventoryName) {
        this.inventoryName = aInventoryName;
    }

    public InventoryType getType() {
        return this.type;
    }

    @Override
    protected void customWork(IMultiBlockController target) {
        int invSize = this.inventorySize;
        if (this.type == InventoryType.Both) {
            invSize /= 2;
        }
        target.registerItemInventory(invSize, this.tier, this.type, true);
        if (this.isServerSide()) {
            this.issueClientUpdate();
        }
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.inventory";
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        this.inventoryName = nbt.func_74764_b("gt.invname.upg") ? nbt.func_74779_i("gt.invname.upg") : "inventory";
        this.inventorySize = nbt.func_74762_e("gt.invsize.upg");
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        if (this.inventoryID != null) {
            nbt.func_74778_a("gt.invuuid.upg", this.inventoryID.toString());
        }
        if (this.inventoryName != null) {
            nbt.func_74778_a("gt.invname.upg", this.inventoryName);
        }
    }

    @Override
    public boolean onBlockBroken() {
        IMultiBlockController controller = this.getTarget(false);
        if (controller != null && this.inventoryID != null) {
            controller.unregisterItemInventory(this.inventoryID, this.type);
        }
        return super.onBlockBroken();
    }

    @Override
    public boolean hasGui(ForgeDirection side) {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new TextFieldWidget().setGetter(() -> this.inventoryName).setSetter(val -> {
            this.inventoryName = val;
            IMultiBlockController controller = this.getTarget(false);
            if (controller != null && this.inventoryID != null) {
                controller.changeItemInventoryDisplayName(this.inventoryID, this.inventoryName, this.type);
            }
        }).setSize(100, 25).setPos(50, 30));
    }

    @Override
    protected boolean canOpenControllerGui() {
        return false;
    }

    @Override
    public void addToolTips(List<String> list, ItemStack stack, boolean f3_h) {
        super.addToolTips(list, stack, f3_h);
        list.add("Adds another item inventory");
        list.add("Inventory size: " + this.inventorySize);
        list.add("Inventory Type: " + (Object)((Object)this.type));
    }

    public void setInventoryId(String inventoryID) {
        this.inventoryID = UUID.fromString(inventoryID);
    }
}

