/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverDoesWork
extends CoverBehavior {
    private static int FLAG_INVERTED = 1;
    private static int FLAG_PROGRESS = 2;
    private static int FLAG_ENABLED = 4;

    public CoverDoesWork(ITexture coverTexture) {
        super(coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IMachineProgress) {
            int tScale;
            IMachineProgress mProgress = (IMachineProgress)((Object)aTileEntity);
            boolean inverted = CoverDoesWork.isFlagSet(aCoverVariable, FLAG_INVERTED);
            int signal = 0;
            signal = CoverDoesWork.isFlagSet(aCoverVariable, FLAG_ENABLED) ? (inverted == mProgress.isAllowedToWork() ? 0 : 15) : (CoverDoesWork.isFlagSet(aCoverVariable, FLAG_PROGRESS) ? (inverted == (mProgress.getMaxProgress() == 0) ? 0 : 15) : ((tScale = mProgress.getMaxProgress() / 15) > 0 && mProgress.hasThingsToDo() ? (inverted ? 15 - mProgress.getProgress() / tScale : mProgress.getProgress() / tScale) : (inverted ? 15 : 0)));
            aTileEntity.setOutputRedstoneSignal(side, (byte)signal);
        } else {
            aTileEntity.setOutputRedstoneSignal(side, (byte)0);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 6) < 0) {
            aCoverVariable = 5;
        }
        switch (aCoverVariable) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("018", "Normal"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("019", "Inverted"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("020", "Ready to work"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("021", "Not ready to work"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("028", "Machine Enabled"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("029", "Machine Disabled"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new DoesWorkUIFactory(buildContext).createWindow();
    }

    private static boolean isFlagSet(int coverVariable, int flag) {
        return (coverVariable & flag) == flag;
    }

    private class DoesWorkUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public DoesWorkUIFactory(CoverUIBuildContext buildContext) {
            super(CoverDoesWork.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, CoverDoesWork.this, (id, coverData) -> this.isEnabled((int)id, CoverDoesWork.convert(coverData)), (id, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)id, CoverDoesWork.convert(coverData)))).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_PROGRESS).setPos(0, 0)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CHECKMARK).setPos(18, 0)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON).setPos(36, 0)).addToggleButton(3, CoverDataFollowerToggleButtonWidget.ofRedstone(), widget -> widget.setPos(0, 18)).setPos(10, 25))).widget(TextWidget.dynamicString(() -> {
                int coverVariable = CoverDoesWork.convert((ISerializableObject.LegacyCoverData)this.getCoverData());
                if (CoverDoesWork.isFlagSet(coverVariable, FLAG_ENABLED)) {
                    return GTUtility.trans("271", "Machine enabled");
                }
                if (CoverDoesWork.isFlagSet(coverVariable, FLAG_PROGRESS)) {
                    return GTUtility.trans("242", "Machine idle");
                }
                return GTUtility.trans("241", "Recipe progress");
            }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 29))).widget(TextWidget.dynamicString(() -> CoverDoesWork.isFlagSet(CoverDoesWork.convert((ISerializableObject.LegacyCoverData)this.getCoverData()), FLAG_INVERTED) ? GTUtility.trans("INVERTED", "Inverted") : GTUtility.trans("NORMAL", "Normal")).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 47));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            switch (id) {
                case 0: {
                    return coverVariable & ~FLAG_ENABLED & ~FLAG_PROGRESS;
                }
                case 1: {
                    return coverVariable & ~FLAG_ENABLED | FLAG_PROGRESS;
                }
                case 2: {
                    return coverVariable & ~FLAG_PROGRESS | FLAG_ENABLED;
                }
                case 3: {
                    if (CoverDoesWork.isFlagSet(coverVariable, FLAG_INVERTED)) {
                        return coverVariable & ~FLAG_INVERTED;
                    }
                    return coverVariable | FLAG_INVERTED;
                }
            }
            return coverVariable;
        }

        private boolean isEnabled(int id, int coverVariable) {
            boolean bl;
            switch (id) {
                case 0: {
                    if (!CoverDoesWork.isFlagSet(coverVariable, FLAG_PROGRESS) && !CoverDoesWork.isFlagSet(coverVariable, FLAG_ENABLED)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    bl = CoverDoesWork.isFlagSet(coverVariable, FLAG_PROGRESS);
                    break;
                }
                case 2: {
                    bl = CoverDoesWork.isFlagSet(coverVariable, FLAG_ENABLED);
                    break;
                }
                case 3: {
                    bl = CoverDoesWork.isFlagSet(coverVariable, FLAG_INVERTED);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

