/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs.paths;

import gregtech.api.graphs.paths.NodePath;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.MTECable;
import gregtech.api.util.AveragePerTickCounter;
import net.minecraft.server.MinecraftServer;

public class PowerNodePath
extends NodePath {
    long mMaxAmps;
    long mAmps = 0L;
    long mLoss;
    long mVoltage = 0L;
    long mMaxVoltage;
    int mTick = 0;
    boolean mCountUp = true;
    private AveragePerTickCounter avgAmperageCounter = new AveragePerTickCounter(20);
    private AveragePerTickCounter avgVoltageCounter = new AveragePerTickCounter(20);

    public PowerNodePath(MetaPipeEntity[] aCables) {
        super(aCables);
    }

    public long getLoss() {
        return this.mLoss;
    }

    public void applyVoltage(long aVoltage, boolean aCountUp) {
        this.avgVoltageCounter.addValue(Math.max(aVoltage - this.mLoss, 0L));
        int tNewTime = MinecraftServer.func_71276_C().func_71259_af();
        if (this.mTick != tNewTime) {
            this.reset(tNewTime - this.mTick);
            this.mTick = tNewTime;
            this.mVoltage = aVoltage;
            this.mCountUp = aCountUp;
        } else if (this.mCountUp != aCountUp && aVoltage - this.mLoss > this.mVoltage || aVoltage > this.mVoltage) {
            this.mCountUp = aCountUp;
            this.mVoltage = aVoltage;
        }
        if (aVoltage > this.mMaxVoltage) {
            this.lock.addTileEntity(null);
            for (MetaPipeEntity tCable : this.mPipes) {
                BaseMetaPipeEntity tBaseCable;
                if (((MTECable)tCable).mVoltage >= this.mVoltage || (tBaseCable = (BaseMetaPipeEntity)tCable.getBaseMetaTileEntity()) == null) continue;
                tBaseCable.setToFire();
            }
        }
    }

    private void reset(int aTimePassed) {
        if (aTimePassed < 0 || aTimePassed > 100) {
            this.mAmps = 0L;
            return;
        }
        this.mAmps = Math.max(0L, this.mAmps - this.mMaxAmps * (long)aTimePassed);
    }

    public void addAmps(long aAmps) {
        this.avgAmperageCounter.addValue(aAmps);
        this.mAmps += aAmps;
        if (this.mAmps > this.mMaxAmps * 40L) {
            this.lock.addTileEntity(null);
            for (MetaPipeEntity tCable : this.mPipes) {
                BaseMetaPipeEntity tBaseCable;
                if (((MTECable)tCable).mAmperage * 40L >= this.mAmps || (tBaseCable = (BaseMetaPipeEntity)tCable.getBaseMetaTileEntity()) == null) continue;
                tBaseCable.setToFire();
            }
        }
    }

    public long getAmperage() {
        return this.avgAmperageCounter.getLast();
    }

    public double getAvgAmperage() {
        return this.avgAmperageCounter.getAverage();
    }

    public long getVoltage() {
        return this.avgVoltageCounter.getLast();
    }

    public double getAvgVoltage() {
        return this.avgVoltageCounter.getAverage();
    }

    @Override
    protected void processPipes() {
        super.processPipes();
        this.mMaxAmps = Integer.MAX_VALUE;
        this.mMaxVoltage = Integer.MAX_VALUE;
        for (MetaPipeEntity tCable : this.mPipes) {
            if (!(tCable instanceof MTECable)) continue;
            this.mMaxAmps = Math.min(((MTECable)tCable).mAmperage, this.mMaxAmps);
            this.mLoss += ((MTECable)tCable).mCableLossPerMeter;
            this.mMaxVoltage = Math.min(((MTECable)tCable).mVoltage, this.mMaxVoltage);
        }
    }
}

