/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.oregen;

import bartworks.system.oregen.BWOreLayer;
import cpw.mods.fml.common.IWorldGenerator;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTLog;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class BWWordGenerator
implements IWorldGenerator {
    public synchronized void generate(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        new WorldGenContainer(aX * 16, aZ * 16, aWorld.field_73011_w, aWorld, aChunkGenerator, aChunkProvider).run();
    }

    public static class WorldGenContainer
    implements Runnable {
        public static HashSet<ChunkCoordIntPair> mGenerated = new HashSet(2000);
        public final WorldProvider mWorldProvider;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public int mX;
        public int mZ;

        public WorldGenContainer(int aX, int aZ, WorldProvider aWorldProvider, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
            this.mX = aX;
            this.mZ = aZ;
            this.mWorldProvider = aWorldProvider;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
        }

        public int getVeinCenterCoordinate(int c) {
            return (c += c < 0 ? 1 : 3) - c % 3 - 2;
        }

        public boolean surroundingChunksLoaded(int xCenter, int zCenter) {
            return this.mWorld.func_72904_c(xCenter - 16, 0, zCenter - 16, xCenter + 16, 0, zCenter + 16);
        }

        public XSTR getRandom(int xChunk, int zChunk) {
            long worldSeed = this.mWorld.func_72905_C();
            XSTR fmlRandom = new XSTR(worldSeed);
            long xSeed = fmlRandom.nextLong() >> 3;
            long zSeed = fmlRandom.nextLong() >> 3;
            long chunkSeed = xSeed * (long)xChunk + zSeed * (long)zChunk ^ worldSeed;
            fmlRandom.setSeed(chunkSeed);
            return new XSTR(fmlRandom.nextInt());
        }

        @Override
        public void run() {
            Chunk tChunk;
            int xCenter = this.getVeinCenterCoordinate(this.mX >> 4);
            int zCenter = this.getVeinCenterCoordinate(this.mZ >> 4);
            XSTR random = this.getRandom(xCenter, zCenter);
            ChunkCoordIntPair centerChunk = new ChunkCoordIntPair(xCenter <<= 4, zCenter <<= 4);
            if (!mGenerated.contains(centerChunk) && this.surroundingChunksLoaded(xCenter, zCenter)) {
                mGenerated.add(centerChunk);
                if (BWOreLayer.sWeight > 0 && BWOreLayer.sList.size() > 0) {
                    boolean temp = true;
                    block2: for (int i = 0; i < 256 && temp; ++i) {
                        int tRandomWeight = ((Random)random).nextInt(BWOreLayer.sWeight);
                        for (BWOreLayer tWorldGen : BWOreLayer.sList) {
                            if (!tWorldGen.isGenerationAllowed(this.mWorld, this.mWorldProvider.getClass()) || (tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                boolean placed;
                                int attempts = 0;
                                while (!(placed = tWorldGen.executeWorldgen(this.mWorld, random, "", this.mWorldProvider.field_76574_g, xCenter, zCenter, this.mChunkGenerator, this.mChunkProvider)) && ++attempts < 25) {
                                }
                                temp = false;
                                continue block2;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GTLog.err);
                            }
                        }
                    }
                }
            }
            if ((tChunk = this.mWorld.func_72938_d(this.mX, this.mZ)) != null) {
                tChunk.field_76643_l = true;
            }
        }
    }
}

