/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.List;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.SimpleGraphics;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class ItemStackRenderer {
    private final TextureManager texManager;
    private FontRenderer fontRenderer;
    private final boolean renderEffects;
    private final boolean ignoreDepth;
    private final boolean renderInColor;
    private ItemIdentifierStack itemIdentifierStack;
    private int posX;
    private int posY;
    private float zLevel;
    private float scaleX;
    private float scaleY;
    private float scaleZ;
    private DisplayAmount displayAmount;

    public ItemStackRenderer(int posX, int posY, float zLevel, boolean renderEffects, boolean ignoreDepth, boolean renderInColor) {
        this.texManager = Minecraft.func_71410_x().field_71446_o;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.posX = posX;
        this.posY = posY;
        this.zLevel = zLevel;
        this.renderEffects = renderEffects;
        this.ignoreDepth = ignoreDepth;
        this.renderInColor = renderInColor;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount) {
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, zLevel, displayAmount, true, true, false);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount, boolean renderInColor, boolean renderEffect, boolean ignoreDepth) {
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer(0, 0, zLevel, renderEffect, ignoreDepth, renderInColor);
        itemStackRenderer.setDisplayAmount(displayAmount);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, itemStackRenderer);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, ItemStackRenderer itemStackRenderer) {
        int ppi = 0;
        int column = 0;
        int row = 0;
        for (ItemIdentifierStack itemIdentifierStack : _allItems) {
            if (itemIdentifierStack == null) {
                if (++column >= columns) {
                    ++row;
                    column = 0;
                }
                ++ppi;
                continue;
            }
            ItemIdentifier item = itemIdentifierStack.getItem();
            if (IItemSearch2 != null && !IItemSearch2.itemSearched(item) || ++ppi <= items * page || ppi > items * (page + 1)) continue;
            int x = left + xSize * column;
            int y = top + ySize * row + 1;
            itemStackRenderer.setItemIdentifierStack(itemIdentifierStack).setPosX(x).setPosY(y);
            itemStackRenderer.renderInGui();
            if (++column < columns) continue;
            ++row;
            column = 0;
        }
    }

    public void renderInGui() {
        assert (this.itemIdentifierStack != null);
        assert (this.displayAmount != null);
        assert (this.texManager != null);
        assert (this.fontRenderer != null);
        assert (this.scaleX != 0.0f);
        assert (this.scaleY != 0.0f);
        assert (this.scaleZ != 0.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2977);
        GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
        if (this.ignoreDepth) {
            GL11.glDisable((int)2929);
        } else {
            GL11.glEnable((int)2929);
        }
        RenderBlocks renderBlocks = RenderBlocks.getInstance();
        ItemStack itemStack = this.itemIdentifierStack.makeNormalStack();
        if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)this.texManager, (ItemStack)itemStack, (boolean)this.renderInColor, (float)this.zLevel, (float)this.posX, (float)this.posY)) {
            RenderItem renderItem = RenderItem.getInstance();
            renderItem.field_77023_b += this.zLevel;
            renderItem.renderItemIntoGUI(this.fontRenderer, this.texManager, itemStack, this.posX, this.posY, this.renderEffects);
            renderItem.field_77023_b -= this.zLevel;
        }
        RenderHelper.func_74518_a();
        if (this.ignoreDepth) {
            GL11.glDisable((int)2929);
        } else {
            GL11.glEnable((int)2929);
        }
        GuiGraphics.drawDurabilityBar(itemStack, this.posX, this.posY, this.zLevel + 20.0f);
        if (this.displayAmount != DisplayAmount.NEVER) {
            if (this.ignoreDepth) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            FontRenderer specialFontRenderer = this.itemIdentifierStack.getItem().item.getFontRenderer(itemStack);
            if (specialFontRenderer != null) {
                this.fontRenderer = specialFontRenderer;
            }
            GL11.glDisable((int)2896);
            String amountString = StringUtils.getFormatedStackSize(this.itemIdentifierStack.getStackSize(), this.displayAmount == DisplayAmount.ALWAYS);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.zLevel + 40.0f));
            SimpleGraphics.drawStringWithTranslatedShadow(this.fontRenderer, amountString, this.posX + 17 - this.fontRenderer.func_78256_a(amountString), this.posY + 9, Color.getValue(Color.WHITE));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-(this.zLevel + 40.0f)));
        }
        GL11.glPopAttrib();
    }

    public TextureManager getTexManager() {
        return this.texManager;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public boolean isRenderEffects() {
        return this.renderEffects;
    }

    public boolean isIgnoreDepth() {
        return this.ignoreDepth;
    }

    public boolean isRenderInColor() {
        return this.renderInColor;
    }

    public ItemIdentifierStack getItemIdentifierStack() {
        return this.itemIdentifierStack;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public float getZLevel() {
        return this.zLevel;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public DisplayAmount getDisplayAmount() {
        return this.displayAmount;
    }

    public ItemStackRenderer setFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        return this;
    }

    public ItemStackRenderer setItemIdentifierStack(ItemIdentifierStack itemIdentifierStack) {
        this.itemIdentifierStack = itemIdentifierStack;
        return this;
    }

    public ItemStackRenderer setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public ItemStackRenderer setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public ItemStackRenderer setZLevel(float zLevel) {
        this.zLevel = zLevel;
        return this;
    }

    public ItemStackRenderer setScaleX(float scaleX) {
        this.scaleX = scaleX;
        return this;
    }

    public ItemStackRenderer setScaleY(float scaleY) {
        this.scaleY = scaleY;
        return this;
    }

    public ItemStackRenderer setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
        return this;
    }

    public ItemStackRenderer setDisplayAmount(DisplayAmount displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStackRenderer)) {
            return false;
        }
        ItemStackRenderer other = (ItemStackRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRenderEffects() != other.isRenderEffects()) {
            return false;
        }
        if (this.isIgnoreDepth() != other.isIgnoreDepth()) {
            return false;
        }
        if (this.isRenderInColor() != other.isRenderInColor()) {
            return false;
        }
        if (this.getPosX() != other.getPosX()) {
            return false;
        }
        if (this.getPosY() != other.getPosY()) {
            return false;
        }
        if (Float.compare(this.getZLevel(), other.getZLevel()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleX(), other.getScaleX()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleY(), other.getScaleY()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleZ(), other.getScaleZ()) != 0) {
            return false;
        }
        TextureManager this$texManager = this.getTexManager();
        TextureManager other$texManager = other.getTexManager();
        if (this$texManager == null ? other$texManager != null : !this$texManager.equals(other$texManager)) {
            return false;
        }
        FontRenderer this$fontRenderer = this.getFontRenderer();
        FontRenderer other$fontRenderer = other.getFontRenderer();
        if (this$fontRenderer == null ? other$fontRenderer != null : !this$fontRenderer.equals(other$fontRenderer)) {
            return false;
        }
        ItemIdentifierStack this$itemIdentifierStack = this.getItemIdentifierStack();
        ItemIdentifierStack other$itemIdentifierStack = other.getItemIdentifierStack();
        if (this$itemIdentifierStack == null ? other$itemIdentifierStack != null : !((Object)this$itemIdentifierStack).equals(other$itemIdentifierStack)) {
            return false;
        }
        DisplayAmount this$displayAmount = this.getDisplayAmount();
        DisplayAmount other$displayAmount = other.getDisplayAmount();
        return !(this$displayAmount == null ? other$displayAmount != null : !((Object)((Object)this$displayAmount)).equals((Object)other$displayAmount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStackRenderer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRenderEffects() ? 79 : 97);
        result = result * 59 + (this.isIgnoreDepth() ? 79 : 97);
        result = result * 59 + (this.isRenderInColor() ? 79 : 97);
        result = result * 59 + this.getPosX();
        result = result * 59 + this.getPosY();
        result = result * 59 + Float.floatToIntBits(this.getZLevel());
        result = result * 59 + Float.floatToIntBits(this.getScaleX());
        result = result * 59 + Float.floatToIntBits(this.getScaleY());
        result = result * 59 + Float.floatToIntBits(this.getScaleZ());
        TextureManager $texManager = this.getTexManager();
        result = result * 59 + ($texManager == null ? 43 : $texManager.hashCode());
        FontRenderer $fontRenderer = this.getFontRenderer();
        result = result * 59 + ($fontRenderer == null ? 43 : $fontRenderer.hashCode());
        ItemIdentifierStack $itemIdentifierStack = this.getItemIdentifierStack();
        result = result * 59 + ($itemIdentifierStack == null ? 43 : ((Object)$itemIdentifierStack).hashCode());
        DisplayAmount $displayAmount = this.getDisplayAmount();
        result = result * 59 + ($displayAmount == null ? 43 : ((Object)((Object)$displayAmount)).hashCode());
        return result;
    }

    public String toString() {
        return "ItemStackRenderer(texManager=" + this.getTexManager() + ", fontRenderer=" + this.getFontRenderer() + ", renderEffects=" + this.isRenderEffects() + ", ignoreDepth=" + this.isIgnoreDepth() + ", renderInColor=" + this.isRenderInColor() + ", itemIdentifierStack=" + this.getItemIdentifierStack() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", zLevel=" + this.getZLevel() + ", scaleX=" + this.getScaleX() + ", scaleY=" + this.getScaleY() + ", scaleZ=" + this.getScaleZ() + ", displayAmount=" + (Object)((Object)this.getDisplayAmount()) + ")";
    }

    public static enum DisplayAmount {
        HIDE_ONE,
        ALWAYS,
        NEVER;

    }
}

