/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.integration.nei.NEIDragAndDropHandler;
import com.cleanroommc.modularui.integration.nei.NEIIngredientProvider;
import com.cleanroommc.modularui.mixins.early.minecraft.GuiAccessor;
import com.cleanroommc.modularui.mixins.early.minecraft.GuiContainerAccessor;
import com.cleanroommc.modularui.mixins.early.minecraft.GuiScreenAccessor;
import com.cleanroommc.modularui.screen.ClientScreenHandler;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.utils.item.IItemHandlerLong;
import com.cleanroommc.modularui.utils.item.IItemStackLong;
import com.cleanroommc.modularui.utils.item.ItemStackLong;
import com.cleanroommc.modularui.value.sync.ItemSlotLongSH;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.slot.ModularSlotLong;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class ItemSlotLong
extends Widget<ItemSlotLong>
implements IVanillaSlot,
Interactable,
NEIDragAndDropHandler,
NEIIngredientProvider {
    public static final int SIZE = 18;
    private static final TextRenderer textRenderer = new TextRenderer();
    private ItemSlotLongSH syncHandler;

    public ItemSlotLong() {
        this.tooltip().setAutoUpdate(true);
        this.tooltipBuilder(tooltip -> {
            if (!this.isSynced()) {
                return;
            }
            ItemStack stack = this.getSlot().func_75211_c();
            if (stack == null) {
                return;
            }
            tooltip.addFromItem(stack);
        });
    }

    @Override
    public void onInit() {
        if (this.getScreen().isOverlay()) {
            throw new IllegalStateException("Overlays can't have slots!");
        }
        this.size(18);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        this.syncHandler = this.castIfTypeElseNull(syncHandler, ItemSlotLongSH.class);
        return this.syncHandler != null;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        boolean shouldBeEnabled = this.areAncestorsEnabled();
        if (shouldBeEnabled != this.getSlot().func_111238_b()) {
            this.syncHandler.setEnabled(shouldBeEnabled, true);
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        if (this.syncHandler == null) {
            return;
        }
        RenderHelper.func_74520_c();
        this.drawSlot(this.getSlot());
        RenderHelper.func_74518_a();
        if (this.isHovering()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect(1.0f, 1.0f, 16.0f, 16.0f, this.getSlotHoverColor());
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.getShowUpTimer())) {
            tooltip.draw(this.getContext(), this.getSlot().func_75211_c());
        }
    }

    @Override
    public WidgetSlotTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getItemSlotTheme();
    }

    public int getSlotHoverColor() {
        WidgetTheme theme = this.getWidgetTheme(this.getContext().getTheme());
        if (theme instanceof WidgetSlotTheme) {
            WidgetSlotTheme slotTheme = (WidgetSlotTheme)theme;
            return slotTheme.getSlotHoverColor();
        }
        return ITheme.getDefault().getItemSlotTheme().getSlotHoverColor();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        if (this.syncHandler.isPhantom()) {
            MouseData mouseData = MouseData.create(mouseButton);
            this.syncHandler.syncToServer(2, mouseData::writeToPacket);
        } else {
            ClientScreenHandler.clickSlot();
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        if (!this.syncHandler.isPhantom()) {
            ClientScreenHandler.releaseSlot();
        }
        return true;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.syncHandler.isPhantom()) {
            MouseData mouseData = MouseData.create(scrollDirection.modifier);
            this.syncHandler.syncToServer(3, mouseData::writeToPacket);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        ClientScreenHandler.dragSlot(timeSinceClick);
    }

    public ModularSlotLong getSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    public Slot getVanillaSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    @NotNull
    public ItemSlotLongSH getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised!");
        }
        return this.syncHandler;
    }

    public ItemSlotLong slot(ModularSlotLong slot) {
        this.syncHandler = new ItemSlotLongSH(slot);
        this.setSyncHandler(this.syncHandler);
        return this;
    }

    public ItemSlotLong slot(IItemHandlerLong itemHandler, int index) {
        return this.slot(new ModularSlotLong(itemHandler, index));
    }

    @SideOnly(value=Side.CLIENT)
    private void drawSlot(ModularSlotLong slotIn) {
        GuiScreen guiScreen = this.getScreen().getScreenWrapper().getGuiScreen();
        if (!(guiScreen instanceof GuiContainer)) {
            throw new IllegalStateException("The gui must be an instance of GuiContainer if it contains slots!");
        }
        GuiContainerAccessor acc = (GuiContainerAccessor)guiScreen;
        RenderItem renderItem = ((GuiScreenAccessor)guiScreen).getItemRender();
        IItemStackLong itemstack = slotIn.getStackLong();
        boolean flag = false;
        boolean flag1 = slotIn == acc.getClickedSlot() && acc.getDraggedStack() != null && !acc.getIsRightMouseClick();
        ItemStack itemstack2 = guiScreen.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        ItemStackLong itemstack1 = itemstack2 == null ? null : new ItemStackLong(itemstack2);
        long amount = -1L;
        String format = null;
        if (slotIn == acc.getClickedSlot() && acc.getDraggedStack() != null && acc.getIsRightMouseClick() && itemstack != null) {
            itemstack = itemstack.copy();
            itemstack.setStackSize(itemstack.getStackSize() / 2L);
        } else if (acc.getDragSplitting() && acc.getDragSplittingSlots().contains((Object)slotIn) && itemstack1 != null) {
            if (acc.getDragSplittingSlots().size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack2, (boolean)true) && this.getScreen().getContainer().func_94531_b(slotIn)) {
                itemstack = itemstack1.copy();
                flag = true;
                Container.func_94525_a(acc.getDragSplittingSlots(), (int)acc.getDragSplittingLimit(), (ItemStack)itemstack.getAsItemStack(), (int)(slotIn.func_75211_c() == null ? 0 : slotIn.func_75211_c().field_77994_a));
                long k = Math.min(itemstack.getMaxStackSize(), (long)slotIn.func_75219_a());
                if (itemstack.getStackSize() > k) {
                    amount = k;
                    format = EnumChatFormatting.YELLOW.toString();
                    itemstack.setStackSize(k);
                }
            } else {
                acc.getDragSplittingSlots().remove((Object)slotIn);
                acc.invokeUpdateDragSplitting();
            }
        }
        ((GuiAccessor)guiScreen).setZLevel(100.0f);
        renderItem.field_77023_b = 100.0f;
        if (!flag1) {
            if (flag) {
                GuiDraw.drawRect(1.0f, 1.0f, 16.0f, 16.0f, -2130706433);
            }
            if (itemstack != null) {
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                GL11.glEnable((int)2929);
                renderItem.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemstack.getAsItemStack(), 1, 1);
                GuiDraw.afterRenderItemAndEffectIntoGUI(itemstack.getAsItemStack());
                GL11.glDisable((int)32826);
                if (amount < 0L) {
                    amount = itemstack.getStackSize();
                }
                if (amount > 1L || format != null) {
                    String amountText = NumberFormat.formatWithMaxDigits(amount);
                    if (format != null) {
                        amountText = format + amountText;
                    }
                    float scale = 1.0f;
                    if (amountText.length() == 3) {
                        scale = 0.8f;
                    } else if (amountText.length() == 4) {
                        scale = 0.6f;
                    } else if (amountText.length() > 4) {
                        scale = 0.5f;
                    }
                    textRenderer.setShadow(true);
                    textRenderer.setScale(scale);
                    textRenderer.setColor(Color.WHITE.main);
                    textRenderer.setAlignment(Alignment.BottomRight, this.getArea().width - 1, this.getArea().height - 1);
                    textRenderer.setPos(1, 1);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3042);
                    textRenderer.draw(amountText);
                    GL11.glEnable((int)2896);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3042);
                }
                long cachedCount = itemstack.getStackSize();
                itemstack.setStackSize(1L);
                renderItem.func_94148_a(((GuiScreenAccessor)guiScreen).getFontRenderer(), Minecraft.func_71410_x().func_110434_K(), itemstack.getAsItemStack(), 1, 1, null);
                itemstack.setStackSize(cachedCount);
                GL11.glDisable((int)2929);
            }
        }
        ((GuiAccessor)guiScreen).setZLevel(0.0f);
        renderItem.field_77023_b = 0.0f;
    }

    @Override
    public boolean handleDragAndDrop(@NotNull ItemStack draggedStack, int button) {
        if (!this.syncHandler.isPhantom()) {
            return false;
        }
        this.syncHandler.updateFromClient(draggedStack, button);
        draggedStack.field_77994_a = 0;
        return true;
    }

    @Override
    @Nullable
    public ItemStack getStackForNEI() {
        return this.syncHandler.getSlot().func_75211_c();
    }
}

