/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureColorBlockBase
extends TextureAtlasSprite {
    private String name;
    private final String directory;
    public float scale;

    public TextureColorBlockBase(String par1Str) {
        this(par1Str, "blocks");
    }

    public TextureColorBlockBase(String par1Str, String directory) {
        super("extrautils:bw_(" + par1Str + ")");
        this.name = par1Str;
        this.directory = directory;
        this.scale = 1.6666666f;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        String s1 = "minecraft";
        String s2 = this.name;
        int ind = this.name.indexOf(58);
        if (ind >= 0) {
            s2 = this.name.substring(ind + 1, this.name.length());
            if (ind > 1) {
                s1 = this.name.substring(0, ind);
            }
        }
        int mp = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        s1 = s1.toLowerCase();
        s2 = "textures/" + this.directory + "/" + s2 + ".png";
        try {
            IResource iresource = manager.func_110536_a(new ResourceLocation(s1, s2));
            BufferedImage[] abufferedimage = new BufferedImage[1 + mp];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            this.func_147964_a(abufferedimage, animationmetadatasection, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J > 1.0f);
        }
        catch (IOException e) {
            return true;
        }
        for (int j = 0; j < this.field_110976_a.size(); ++j) {
            int[] image = new int[((int[][])this.field_110976_a.get(j))[0].length];
            float min_m = 1.0f;
            float max_m = 0.0f;
            for (int i = 0; i < image.length; ++i) {
                int l = ((int[][])this.field_110976_a.get(j))[0][i];
                if (l >= 0) continue;
                float r = (float)(-l >> 16 & 0xFF) / 255.0f;
                float g = (float)(-l >> 8 & 0xFF) / 255.0f;
                float b = (float)(-l & 0xFF) / 255.0f;
                float m = (r = 1.0f - r) * 0.2126f + (g = 1.0f - g) * 0.7152f + (b = 1.0f - b) * 0.0722f;
                if (m > max_m) {
                    max_m = m;
                }
                if (!(m < min_m)) continue;
                min_m = m;
            }
            if (min_m == 1.0f && max_m == 0.0f) {
                return false;
            }
            if (max_m == min_m) {
                max_m = min_m + 0.001f;
            }
            float new_max_m = Math.min(max_m * this.scale, 1.0f);
            float new_min_m = min_m / max_m * new_max_m;
            for (int i = 0; i < image.length; ++i) {
                int l = ((int[][])this.field_110976_a.get(j))[0][i];
                if (l >= 0) continue;
                float r = (float)(-l >> 16 & 0xFF) / 255.0f;
                float g = (float)(-l >> 8 & 0xFF) / 255.0f;
                float b = (float)(-l & 0xFF) / 255.0f;
                r = 1.0f - r;
                g = 1.0f - g;
                b = 1.0f - b;
                float m = r * 0.2126f + g * 0.7152f + b * 0.0722f;
                float dm = (m - min_m) / (max_m - min_m);
                m = new_min_m + dm * (new_max_m - new_min_m);
                g = b = Math.max(Math.min(0.975f, m), 0.025f);
                r = b;
                r = 1.0f - r;
                g = 1.0f - g;
                b = 1.0f - b;
                image[i] = -((int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f));
            }
            int[][] aint = new int[1 + mp][];
            aint[0] = image;
            this.field_110976_a.set(j, aint);
        }
        return false;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }
}

