/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import makamys.coretweaks.CoreTweaks;
import net.minecraft.block.Block;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.SaveFormatComparator;

public class MCUtil {
    public static boolean tryToLoadWorld(String worldName) {
        Minecraft mc = Minecraft.func_71410_x();
        ISaveFormat saveLoader = mc.func_71359_d();
        try {
            Optional<Object> saveOpt;
            List saveList = saveLoader.func_75799_b();
            if (worldName != null && !worldName.isEmpty()) {
                saveOpt = saveList.stream().filter(s -> s.func_75786_a().equals(worldName)).findFirst();
            } else if (saveList != null && !saveList.isEmpty()) {
                Collections.sort(saveList);
                saveOpt = Optional.of(saveList.get(0));
            } else {
                saveOpt = Optional.empty();
            }
            if (saveOpt.isPresent()) {
                SaveFormatComparator save = (SaveFormatComparator)saveOpt.get();
                if (mc.field_71461_s == null) {
                    mc.field_71461_s = new LoadingScreenRenderer(mc);
                }
                FMLClientHandler.instance().tryLoadExistingWorld(null, save.func_75786_a(), save.func_75788_b());
                return true;
            }
            CoreTweaks.LOGGER.error("Couldn't find a suitable world to load");
        }
        catch (Exception e) {
            CoreTweaks.LOGGER.error("Failed to load world " + worldName);
            e.printStackTrace();
        }
        return false;
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase entity, double reach, boolean stopOnLiquid) {
        Vec3 vec3 = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        Vec3 vec31 = entity.func_70676_i(1.0f);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * reach, vec31.field_72448_b * reach, vec31.field_72449_c * reach);
        return MCUtil.rayTrace(entity.field_70170_p, vec3, vec32, stopOnLiquid, false, true);
    }

    public static MovingObjectPosition rayTrace(World dis, Vec3 start, Vec3 end, boolean stopOnLiquid, boolean mysteryFlag1, boolean mysteryFlag2) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                MovingObjectPosition movingobjectposition;
                int endX = MathHelper.func_76128_c((double)end.field_72450_a);
                int endY = MathHelper.func_76128_c((double)end.field_72448_b);
                int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
                int startX = MathHelper.func_76128_c((double)start.field_72450_a);
                int startY = MathHelper.func_76128_c((double)start.field_72448_b);
                int startZ = MathHelper.func_76128_c((double)start.field_72449_c);
                Block startBlock = dis.func_147439_a(startX, startY, startZ);
                int startMeta = dis.func_72805_g(startX, startY, startZ);
                if ((!mysteryFlag1 || startBlock.func_149668_a(dis, startX, startY, startZ) != null) && startBlock.func_149678_a(startMeta, stopOnLiquid) && (movingobjectposition = startBlock.func_149731_a(dis, startX, startY, startZ, start, end)) != null) {
                    return movingobjectposition;
                }
                MovingObjectPosition result2 = null;
                int stepsLeft = (int)(Math.abs(end.field_72450_a) + Math.abs(end.field_72448_b) + Math.abs(end.field_72449_c)) * 2;
                while (stepsLeft-- >= 0) {
                    int dir;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (startX == endX && startY == endY && startZ == endZ) {
                        return mysteryFlag2 ? result2 : null;
                    }
                    boolean moveX = true;
                    boolean moveY = true;
                    boolean moveZ = true;
                    double newX = 999.0;
                    double newY = 999.0;
                    double newZ = 999.0;
                    if (endX > startX) {
                        newX = (double)startX + 1.0;
                    } else if (endX < startX) {
                        newX = (double)startX + 0.0;
                    } else {
                        moveX = false;
                    }
                    if (endY > startY) {
                        newY = (double)startY + 1.0;
                    } else if (endY < startY) {
                        newY = (double)startY + 0.0;
                    } else {
                        moveY = false;
                    }
                    if (endZ > startZ) {
                        newZ = (double)startZ + 1.0;
                    } else if (endZ < startZ) {
                        newZ = (double)startZ + 0.0;
                    } else {
                        moveZ = false;
                    }
                    double rx = 999.0;
                    double ry = 999.0;
                    double rz = 999.0;
                    double dx = end.field_72450_a - start.field_72450_a;
                    double dy = end.field_72448_b - start.field_72448_b;
                    double dz = end.field_72449_c - start.field_72449_c;
                    if (moveX) {
                        rx = (newX - start.field_72450_a) / dx;
                    }
                    if (moveY) {
                        ry = (newY - start.field_72448_b) / dy;
                    }
                    if (moveZ) {
                        rz = (newZ - start.field_72449_c) / dz;
                    }
                    boolean unusedFlag = false;
                    if (rx < ry && rx < rz) {
                        dir = endX > startX ? 4 : 5;
                        start.field_72450_a = newX;
                        start.field_72448_b += dy * rx;
                        start.field_72449_c += dz * rx;
                    } else if (ry < rz) {
                        dir = endY > startY ? 0 : 1;
                        start.field_72450_a += dx * ry;
                        start.field_72448_b = newY;
                        start.field_72449_c += dz * ry;
                    } else {
                        dir = endZ > startZ ? 2 : 3;
                        start.field_72450_a += dx * rz;
                        start.field_72448_b += dy * rz;
                        start.field_72449_c = newZ;
                    }
                    Vec3 vec32 = Vec3.func_72443_a((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
                    vec32.field_72450_a = MathHelper.func_76128_c((double)start.field_72450_a);
                    startX = (int)vec32.field_72450_a;
                    if (dir == 5) {
                        --startX;
                        vec32.field_72450_a += 1.0;
                    }
                    vec32.field_72448_b = MathHelper.func_76128_c((double)start.field_72448_b);
                    startY = (int)vec32.field_72448_b;
                    if (dir == 1) {
                        --startY;
                        vec32.field_72448_b += 1.0;
                    }
                    vec32.field_72449_c = MathHelper.func_76128_c((double)start.field_72449_c);
                    startZ = (int)vec32.field_72449_c;
                    if (dir == 3) {
                        --startZ;
                        vec32.field_72449_c += 1.0;
                    }
                    if (!dis.func_72899_e(startX, startY, startZ)) break;
                    Block newStartBlock = dis.func_147439_a(startX, startY, startZ);
                    int newStartMeta = dis.func_72805_g(startX, startY, startZ);
                    if (mysteryFlag1 && newStartBlock.func_149668_a(dis, startX, startY, startZ) == null) continue;
                    if (newStartBlock.func_149678_a(newStartMeta, stopOnLiquid)) {
                        MovingObjectPosition result1 = newStartBlock.func_149731_a(dis, startX, startY, startZ, start, end);
                        if (result1 == null) continue;
                        return result1;
                    }
                    result2 = new MovingObjectPosition(startX, startY, startZ, dir, start, false);
                }
                return mysteryFlag2 ? result2 : null;
            }
            return null;
        }
        return null;
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase entity, double reach) {
        return MCUtil.rayTrace(entity, reach, true);
    }
}

