/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.base.FCContainerMonitor;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.network.CPacketFluidUpdate;
import com.glodblock.github.network.SPacketFluidUpdate;
import com.glodblock.github.network.SPacketMEUpdateBuffer;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ContainerFluidMonitor
extends FCContainerMonitor<IAEFluidStack> {
    protected final IItemList<IAEFluidStack> fluids = AEApi.instance().storage().createFluidList();
    protected static final int REM_IDX = 0;
    protected static final int ACT_IDX = 1;
    protected static final int PARTIAL_IDX = 2;

    public ContainerFluidMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected ContainerFluidMonitor(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable, bindInventory);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            if (monitorable instanceof IGridHost) {
                IGridNode node = ((IGridHost)monitorable).getGridNode(ForgeDirection.UNKNOWN);
                if (node != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                        IStorageGrid storageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
                        this.monitor = storageGrid.getFluidInventory();
                        if (this.monitor == null) {
                            this.setValidContainer(false);
                        } else {
                            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                        }
                    }
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.monitor = monitorable.getFluidInventory();
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setPowerSource((IEnergySource)monitorable);
            }
        } else {
            this.monitor = null;
        }
        this.canAccessViewCells = false;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, ((IViewCellStorage)monitorable).getViewCellStorage(), y, 206, y * 18 + 8, this.getInventoryPlayer());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.func_75146_a((Slot)this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        Slot clickSlot;
        if (Platform.isClient() && !this.isEssentiaMode() && ((clickSlot = (Slot)this.field_75151_b.get(idx)) instanceof SlotPlayerInv || clickSlot instanceof SlotPlayerHotBar) && clickSlot.func_75216_d() && Util.FluidUtil.isFluidContainer(clickSlot.func_75211_c())) {
            int index = Util.findItemInPlayerInvSlot(p, clickSlot.func_75211_c());
            FluidCraft.proxy.netHandler.sendToServer(new CPacketFluidUpdate(index));
        }
        return super.func_82846_b(p, idx);
    }

    @Override
    protected void processItemList() {
        if (!this.fluids.isEmpty()) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEFluidStack> toSend = new ArrayList<IAEFluidStack>();
            for (IAEFluidStack is : this.fluids) {
                IAEFluidStack send = (IAEFluidStack)monitorCache.findPrecise((IAEStack)is);
                if (send != null) {
                    toSend.add(send);
                    continue;
                }
                is.setStackSize(0L);
                toSend.add(is);
            }
            for (Object c : this.field_75149_d) {
                if (!(c instanceof EntityPlayerMP)) continue;
                SPacketMEUpdateBuffer.scheduleFluidUpdate((EntityPlayerMP)c, toSend);
            }
            this.fluids.resetStatus();
        }
    }

    @Override
    protected void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayerMP && this.monitor != null) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEFluidStack> toSend = new ArrayList<IAEFluidStack>();
            for (IAEFluidStack is : monitorCache) {
                toSend.add(is);
            }
            SPacketMEUpdateBuffer.scheduleFluidUpdate((EntityPlayerMP)c, toSend);
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add((IAEStack)is);
        }
    }

    protected void dropItem(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return;
        }
        ItemStack itemStack = is.func_77946_l();
        int i = itemStack.func_77976_d();
        while (itemStack.field_77994_a > 0) {
            if (i > itemStack.field_77994_a) {
                if (this.getPlayerInv().func_70441_a(itemStack.func_77946_l())) break;
                this.getPlayerInv().field_70458_d.func_70099_a(itemStack.func_77946_l(), 0.0f);
                break;
            }
            itemStack.field_77994_a -= i;
            ItemStack item = itemStack.func_77946_l();
            item.field_77994_a = i;
            if (this.getPlayerInv().func_70441_a(item)) continue;
            this.getPlayerInv().field_70458_d.func_70099_a(item, 0.0f);
        }
    }

    protected void dropItem(ItemStack itemStack, int stackSize) {
        if (itemStack == null || itemStack.field_77994_a <= 0) {
            return;
        }
        ItemStack is = itemStack.func_77946_l();
        is.field_77994_a = stackSize;
        this.dropItem(is);
    }

    public void postChange(IAEFluidStack fluid, EntityPlayer player, int slotIndex, boolean shift) {
        ItemStack targetStack = slotIndex == -1 ? player.field_71071_by.func_70445_o() : player.field_71071_by.func_70301_a(slotIndex);
        if (Util.FluidUtil.isEmpty(targetStack) && fluid != null) {
            this.extractFluid(fluid, player, slotIndex, shift);
        } else if (!Util.FluidUtil.isEmpty(targetStack)) {
            this.insertFluid(player, slotIndex, shift);
        }
        this.func_75142_b();
    }

    private void insertFluid(EntityPlayer player, int slotIndex, boolean shift) {
        ItemStack partialTanksStack;
        ItemStack emptiedTanksStack;
        int partialDrain;
        int emptiedTanks;
        long totalInserted;
        long insertableFluid;
        boolean partialInsertSupported;
        int fluidPerContainer;
        FluidStack fluidStackPerContainer;
        ItemStack targetStack = slotIndex == -1 ? player.field_71071_by.func_70445_o() : player.field_71071_by.func_70301_a(slotIndex);
        int containersRequestedToInsert = shift ? targetStack.field_77994_a : 1;
        Item item = targetStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem fcItem = (IFluidContainerItem)item;
            ItemStack test = targetStack.func_77946_l();
            test.field_77994_a = 1;
            fluidStackPerContainer = fcItem.drain(test, Integer.MAX_VALUE, false);
            if (fluidStackPerContainer == null || fluidStackPerContainer.amount == 0) {
                return;
            }
            fluidPerContainer = fluidStackPerContainer.amount;
            partialInsertSupported = true;
        } else if (FluidContainerRegistry.isContainer((ItemStack)targetStack)) {
            ItemStack emptyTank = FluidContainerRegistry.drainFluidContainer((ItemStack)targetStack);
            if (emptyTank == null) {
                return;
            }
            fluidStackPerContainer = FluidContainerRegistry.getFluidForFilledItem((ItemStack)targetStack);
            fluidPerContainer = fluidStackPerContainer.amount;
            partialInsertSupported = false;
        } else {
            return;
        }
        AEFluidStack totalFluid = AEFluidStack.create((Object)fluidStackPerContainer);
        totalFluid.setStackSize((long)fluidPerContainer * (long)containersRequestedToInsert);
        IAEFluidStack notInsertable = (IAEFluidStack)this.host.getFluidInventory().injectItems((IAEStack)totalFluid, Actionable.SIMULATE, this.getActionSource());
        if (notInsertable == null || notInsertable.getStackSize() == 0L) {
            insertableFluid = totalFluid.getStackSize();
        } else {
            long insertable = totalFluid.getStackSize() - notInsertable.getStackSize();
            insertableFluid = partialInsertSupported ? insertable : insertable - insertable % (long)fluidPerContainer;
        }
        totalFluid.setStackSize(insertableFluid);
        IAEFluidStack notInserted = (IAEFluidStack)this.host.getFluidInventory().injectItems((IAEStack)totalFluid, Actionable.MODULATE, this.getActionSource());
        if (notInserted != null && notInserted.getStackSize() > 0L) {
            long total = totalFluid.getStackSize() - notInserted.getStackSize();
            if (partialInsertSupported) {
                totalInserted = total;
            } else {
                long overflowAmount = (long)fluidPerContainer - total % (long)fluidPerContainer;
                AEFluidStack overflow = AEFluidStack.create((Object)fluidStackPerContainer);
                overflow.setStackSize(overflowAmount);
                this.dropItem(ItemFluidPacket.newStack((IAEFluidStack)overflow));
                totalInserted = total + overflowAmount;
            }
        } else {
            totalInserted = totalFluid.getStackSize();
        }
        if (fluidPerContainer > 0) {
            emptiedTanks = (int)(totalInserted / (long)fluidPerContainer);
            partialDrain = (int)(totalInserted % (long)fluidPerContainer);
        } else {
            emptiedTanks = containersRequestedToInsert;
            partialDrain = 0;
        }
        int partialTanks = partialDrain > 0 && partialInsertSupported ? 1 : 0;
        int usedTanks = emptiedTanks + partialTanks;
        int untouchedTanks = targetStack.field_77994_a - usedTanks;
        Item item2 = targetStack.func_77973_b();
        if (item2 instanceof IFluidContainerItem) {
            IFluidContainerItem fcItem = (IFluidContainerItem)item2;
            if (emptiedTanks > 0) {
                emptiedTanksStack = targetStack.func_77946_l();
                emptiedTanksStack.field_77994_a = 1;
                fcItem.drain(emptiedTanksStack, fluidPerContainer, true);
                emptiedTanksStack.field_77994_a = emptiedTanks;
            } else {
                emptiedTanksStack = null;
            }
            if (partialTanks > 0) {
                partialTanksStack = targetStack.func_77946_l();
                partialTanksStack.field_77994_a = 1;
                fcItem.drain(partialTanksStack, partialDrain, true);
            } else {
                partialTanksStack = null;
            }
        } else {
            if (emptiedTanks > 0) {
                emptiedTanksStack = FluidContainerRegistry.drainFluidContainer((ItemStack)targetStack);
                emptiedTanksStack.field_77994_a = emptiedTanks;
            } else {
                emptiedTanksStack = null;
            }
            partialTanksStack = null;
        }
        boolean shouldSendStack = true;
        if (slotIndex == -1) {
            if (untouchedTanks > 0) {
                targetStack.field_77994_a = untouchedTanks;
                this.adjustStack(targetStack);
                this.dropItem(emptiedTanksStack);
                this.dropItem(partialTanksStack);
            } else if (emptiedTanksStack != null) {
                this.adjustStack(emptiedTanksStack);
                player.field_71071_by.func_70437_b(emptiedTanksStack);
                this.dropItem(partialTanksStack);
            } else if (partialTanksStack != null) {
                player.field_71071_by.func_70437_b(partialTanksStack);
            } else {
                player.field_71071_by.func_70437_b(null);
                shouldSendStack = false;
            }
        } else if (untouchedTanks > 0) {
            targetStack.field_77994_a = untouchedTanks;
            this.adjustStack(targetStack);
            this.dropItem(emptiedTanksStack);
            this.dropItem(partialTanksStack);
        } else if (emptiedTanksStack != null) {
            this.adjustStack(emptiedTanksStack);
            player.field_71071_by.func_70299_a(slotIndex, emptiedTanksStack);
            this.dropItem(partialTanksStack);
        } else if (partialTanksStack != null) {
            player.field_71071_by.func_70299_a(slotIndex, partialTanksStack);
        } else {
            player.field_71071_by.func_70437_b(null);
            shouldSendStack = false;
        }
        if (shouldSendStack) {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>(), player.field_71071_by.func_70445_o()), (EntityPlayerMP)player);
        } else {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>()), (EntityPlayerMP)player);
        }
    }

    private void extractFluid(IAEFluidStack clientRequestedFluid, EntityPlayer player, int slotIndex, boolean shift) {
        ItemStack partialTanksStack;
        FluidStack toInsert;
        ItemStack filledTanksStack;
        IAEFluidStack extracted;
        boolean partialInsertSupported;
        int fluidPerContainer;
        if (slotIndex != -1) {
            return;
        }
        ItemStack targetStack = player.field_71071_by.func_70445_o();
        int containersRequestedToExtract = shift ? targetStack.field_77994_a : 1;
        FluidStack clientRequestedFluidStack = clientRequestedFluid.getFluidStack();
        clientRequestedFluidStack.amount = Integer.MAX_VALUE;
        Item item = targetStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem fcItem = (IFluidContainerItem)item;
            ItemStack testStack = targetStack.func_77946_l();
            testStack.field_77994_a = 1;
            fluidPerContainer = fcItem.fill(testStack, clientRequestedFluidStack, false);
            if (fluidPerContainer == 0) {
                return;
            }
            partialInsertSupported = true;
        } else if (FluidContainerRegistry.isContainer((ItemStack)targetStack)) {
            fluidPerContainer = FluidContainerRegistry.getContainerCapacity((FluidStack)clientRequestedFluidStack, (ItemStack)targetStack);
            partialInsertSupported = false;
        } else {
            return;
        }
        IAEFluidStack totalRequestedFluid = clientRequestedFluid.copy();
        totalRequestedFluid.setStackSize((long)fluidPerContainer * (long)containersRequestedToExtract);
        IAEFluidStack availableFluid = (IAEFluidStack)this.host.getFluidInventory().extractItems((IAEStack)totalRequestedFluid, Actionable.SIMULATE, this.getActionSource());
        if (availableFluid == null || availableFluid.getStackSize() == 0L) {
            return;
        }
        if (availableFluid.getStackSize() != totalRequestedFluid.getStackSize() && !partialInsertSupported) {
            availableFluid.decStackSize(availableFluid.getStackSize() % (long)fluidPerContainer);
        }
        long totalExtracted = (extracted = (IAEFluidStack)this.host.getFluidInventory().extractItems((IAEStack)availableFluid, Actionable.MODULATE, this.getActionSource())) != null ? extracted.getStackSize() : 0L;
        int filledTanks = (int)(totalExtracted / (long)fluidPerContainer);
        int partialFill = (int)(totalExtracted % (long)fluidPerContainer);
        int partialTanks = partialFill > 0 && partialInsertSupported ? 1 : 0;
        int usedTanks = filledTanks + partialTanks;
        int untouchedTanks = targetStack.field_77994_a - usedTanks;
        Item item2 = targetStack.func_77973_b();
        if (item2 instanceof IFluidContainerItem) {
            IFluidContainerItem fcItem = (IFluidContainerItem)item2;
            if (filledTanks > 0) {
                filledTanksStack = targetStack.func_77946_l();
                filledTanksStack.field_77994_a = 1;
                toInsert = extracted.getFluidStack().copy();
                toInsert.amount = fluidPerContainer;
                fcItem.fill(filledTanksStack, toInsert, true);
                filledTanksStack.field_77994_a = filledTanks;
            } else {
                filledTanksStack = null;
            }
            if (partialTanks > 0) {
                partialTanksStack = targetStack.func_77946_l();
                partialTanksStack.field_77994_a = 1;
                toInsert = extracted.getFluidStack().copy();
                toInsert.amount = partialFill;
                fcItem.fill(partialTanksStack, toInsert, true);
            } else {
                partialTanksStack = null;
            }
        } else {
            if (filledTanks > 0) {
                toInsert = extracted.getFluidStack().copy();
                toInsert.amount = fluidPerContainer;
                filledTanksStack = FluidContainerRegistry.fillFluidContainer((FluidStack)toInsert, (ItemStack)targetStack);
                filledTanksStack.field_77994_a = filledTanks;
            } else {
                filledTanksStack = null;
            }
            if (partialFill > 0) {
                IAEFluidStack overflow = extracted.copy();
                overflow.setStackSize((long)partialFill);
                this.dropItem(ItemFluidPacket.newStack(overflow));
            }
            partialTanksStack = null;
        }
        boolean shouldSendStack = true;
        if (untouchedTanks > 0) {
            ItemStack emptyStack = player.field_71071_by.func_70445_o();
            emptyStack.field_77994_a = untouchedTanks;
            this.adjustStack(emptyStack);
            this.dropItem(filledTanksStack);
            this.dropItem(partialTanksStack);
        } else if (filledTanksStack != null) {
            this.adjustStack(filledTanksStack);
            player.field_71071_by.func_70437_b(filledTanksStack);
            this.dropItem(partialTanksStack);
        } else if (partialTanksStack != null) {
            player.field_71071_by.func_70437_b(partialTanksStack);
        } else {
            player.field_71071_by.func_70437_b(null);
            shouldSendStack = false;
        }
        if (shouldSendStack) {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>(), player.field_71071_by.func_70445_o()), (EntityPlayerMP)player);
        } else {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>()), (EntityPlayerMP)player);
        }
    }

    void adjustStack(ItemStack stack) {
        if (stack != null && stack.field_77994_a > stack.func_77976_d()) {
            this.dropItem(stack, stack.field_77994_a - stack.func_77976_d());
            stack.field_77994_a = stack.func_77976_d();
        }
    }

    protected boolean isEssentiaMode() {
        return false;
    }

    @Override
    protected boolean isWirelessTerminal() {
        return false;
    }
}

