/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.TileEntityCopperChest;
import cpw.mods.ironchest.TileEntityCrystalChest;
import cpw.mods.ironchest.TileEntityDarkSteelChest;
import cpw.mods.ironchest.TileEntityDiamondChest;
import cpw.mods.ironchest.TileEntityDirtChest;
import cpw.mods.ironchest.TileEntityGoldChest;
import cpw.mods.ironchest.TileEntityIronChest;
import cpw.mods.ironchest.TileEntityNetheriteChest;
import cpw.mods.ironchest.TileEntityObsidianChest;
import cpw.mods.ironchest.TileEntitySilverChest;
import cpw.mods.ironchest.TileEntitySteelChest;
import cpw.mods.ironchest.ValidatingSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum IronChestType {
    IRON(54, 9, 2, "Iron Chest", "ironchest.png", 0, Arrays.asList("ingotIron", "ingotRefinedIron"), TileEntityIronChest.class, null, "mGmGPGmGm", "mmmmPmmmm", 0),
    GOLD(81, 9, 4, "Gold Chest", "goldchest.png", 1, Arrays.asList("ingotGold"), TileEntityGoldChest.class, null, "mGmGPGmGm", "mmmmPmmmm", 0),
    DIAMOND(108, 12, 5, "Diamond Chest", "diamondchest.png", 2, Arrays.asList("gemDiamond"), TileEntityDiamondChest.class, null, "GGGmPmGGG", "GGGGPGmmm", 0),
    COPPER(45, 9, 1, "Copper Chest", "copperchest.png", 3, Arrays.asList("ingotCopper"), TileEntityCopperChest.class, null, "mmmmPmmmm", "mGmGPGmGm", 0),
    STEEL(72, 9, 3, "Steel Chest", "silverchest.png", 4, Arrays.asList("ingotSteel"), TileEntitySteelChest.class, null, "mGmGPGmGm", "mmmmPmmmm", 0),
    CRYSTAL(108, 12, 5, "Crystal Chest", "crystalchest.png", 5, Arrays.asList("blockGlass"), TileEntityCrystalChest.class, "mmmmPmmmm", null, null, 0),
    OBSIDIAN(108, 12, 5, "Obsidian Chest", "obsidianchest.png", 6, Arrays.asList("obsidian"), TileEntityObsidianChest.class, "mmmmPmmmm", null, null, 1),
    DIRTCHEST9000(1, 1, -1, "Dirt Chest 9000", "dirtchest.png", 7, Arrays.asList("dirt"), TileEntityDirtChest.class, Item.func_150898_a((Block)Blocks.field_150346_d), "mmmmCmmmm", null, null, 0),
    NETHERITE(135, 15, 6, "Netherite Chest", "netheritechest.png", 2, Arrays.asList("ingotNetherite"), TileEntityNetheriteChest.class, null, "OOOmPmOOO", "OOOOPOmmm", 1),
    DARKSTEEL(135, 15, 6, "Dark Steel Chest", "darksteelchest.png", 2, Arrays.asList("ingotDarkSteel"), TileEntityDarkSteelChest.class, null, "OOOmPmOOO", "OOOOPOmmm", 0),
    SILVER(72, 9, 3, "Silver Chest", "silverchest.png", 4, Arrays.asList("ingotSilver"), TileEntitySilverChest.class, null, "mGmGPGmGm", "mmmmPmmmm", 0),
    WOOD(0, 0, -1, "", "", -1, Arrays.asList("plankWood"), null, null, null, null, 0);

    final int size;
    private final int rowLength;
    public final String friendlyName;
    private final Integer tier;
    private final String modelTexture;
    private final int textureRow;
    public final Class<? extends TileEntityIronChest> clazz;
    private final String recipeDirect;
    private final String recipeUpgradeOneTier;
    private final String recipeUpgradeTwoTiers;
    private final ArrayList<String> matList;
    private final Item itemFilter;
    private final int resistance;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private static final HashMap<IronChestType, ItemStack> registredChests;
    private static final String[] sideNames;
    private static final int[] sideMapping;

    private IronChestType(int size, int rowLength, int tier, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityIronChest> clazz, String recipeDirect, String recipeUpgradeOneTier, String recipeUpgradeTwoTiers, int resistance) {
        this(size, rowLength, tier, friendlyName, modelTexture, textureRow, mats, clazz, null, recipeDirect, recipeUpgradeOneTier, recipeUpgradeTwoTiers, resistance);
    }

    private IronChestType(int size, int rowLength, int tier, String friendlyName, String modelTexture, int textureRow, List<String> mats, Class<? extends TileEntityIronChest> clazz, Item itemFilter, String recipeDirect, String recipeUpgradeOneTier, String recipeUpgradeTwoTiers, int resistance) {
        this.size = size;
        this.rowLength = rowLength;
        this.tier = tier;
        this.friendlyName = friendlyName;
        this.modelTexture = modelTexture;
        this.textureRow = textureRow;
        this.clazz = clazz;
        this.itemFilter = itemFilter;
        this.recipeDirect = recipeDirect;
        this.recipeUpgradeOneTier = recipeUpgradeOneTier;
        this.recipeUpgradeTwoTiers = recipeUpgradeTwoTiers;
        this.matList = new ArrayList();
        this.resistance = resistance;
        this.matList.addAll(mats);
    }

    public String getModelTexture() {
        return this.modelTexture;
    }

    public int getTextureRow() {
        return this.textureRow;
    }

    public boolean isEnabled() {
        if (this == STEEL) {
            return IronChest.ENABLE_STEEL_CHESTS;
        }
        if (this == SILVER) {
            return IronChest.ENABLE_SILVER_CHESTS;
        }
        if (this == DARKSTEEL) {
            return IronChest.ENABLE_DARK_STEEL_CHESTS;
        }
        if (this == NETHERITE) {
            return IronChest.ENABLE_NETHERITE_CHESTS;
        }
        return true;
    }

    public boolean allowUpgradeFrom(IronChestType typ) {
        String name = typ.name() + ":" + this.name();
        for (String blocked : IronChest.blocklistUpgrades) {
            if (!blocked.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static TileEntityIronChest makeEntity(int metadata) {
        int chesttype = IronChestType.validateMeta(metadata);
        if (chesttype == metadata) {
            try {
                return IronChestType.values()[chesttype].clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IronChestType[] getAll() {
        return IronChestType.values();
    }

    public static IronChestType[] getAllSortedByTier() {
        IronChestType[] vals = IronChestType.getAll();
        Arrays.sort(vals, new Comparator<IronChestType>(){

            @Override
            public int compare(IronChestType a, IronChestType b) {
                return a.tier.compareTo(b.tier);
            }
        });
        return vals;
    }

    public static IronChestType[] getAllByTier(int i) {
        HashSet<IronChestType> vals = new HashSet<IronChestType>();
        for (IronChestType typ : IronChestType.values()) {
            if (typ.tier != i) continue;
            vals.add(typ);
        }
        return vals.toArray(new IronChestType[vals.size()]);
    }

    public static void registerBlocksAndRecipes(BlockIronChest blockResult) {
        IronChestType[] vals;
        for (IronChestType typ : vals = IronChestType.getAllSortedByTier()) {
            if (!typ.isEnabled()) continue;
            ItemStack chest = new ItemStack((Block)blockResult, 1, typ.ordinal());
            IronChestType.registerChest(typ, chest);
            if (!typ.isValidForCreativeMode()) continue;
            GameRegistry.registerCustomItemStack((String)typ.friendlyName, (ItemStack)chest);
        }
        if (!IronChest.isGTNHLoaded) {
            for (IronChestType typ : vals) {
                if (!typ.isEnabled()) continue;
                IronChestType.generateRecipesForType(typ);
            }
        }
    }

    public static void generateRecipesForType(IronChestType typ) {
        ItemStack chest = IronChestType.getRegistredChest(typ);
        for (String mat : typ.matList) {
            Object[] prevPrevTiers;
            Object mainMaterial = IronChestType.translateOreName(mat);
            if (typ.recipeDirect != null) {
                Object[] curTiers = IronChestType.getRegistredChestsByTier(typ, typ.tier, typ.resistance - 1);
                if (curTiers.length > 1) {
                    for (Object curTier : curTiers) {
                        if (curTier == chest) continue;
                        IronChestType.addRecipe(chest, IronChestType.getRecipeSplitted(typ.recipeDirect), Character.valueOf('m'), mainMaterial, Character.valueOf('P'), curTier, Character.valueOf('G'), "blockGlass", Character.valueOf('C'), "chestWood", Character.valueOf('O'), Blocks.field_150343_Z);
                    }
                } else {
                    IronChestType.addRecipe(chest, IronChestType.getRecipeSplitted(typ.recipeDirect), Character.valueOf('m'), mainMaterial, Character.valueOf('G'), "blockGlass", Character.valueOf('C'), "chestWood", Character.valueOf('O'), Blocks.field_150343_Z);
                }
            }
            if (typ.recipeUpgradeOneTier != null) {
                Object[] prevTiers;
                for (Object prevTier : prevTiers = IronChestType.getRegistredChestsByTier(typ, typ.tier - 1, typ.resistance)) {
                    IronChestType.addRecipe(chest, IronChestType.getRecipeSplitted(typ.recipeUpgradeOneTier), Character.valueOf('m'), mainMaterial, Character.valueOf('P'), prevTier, Character.valueOf('G'), "blockGlass", Character.valueOf('C'), "chestWood", Character.valueOf('O'), Blocks.field_150343_Z);
                }
            }
            if (typ.recipeUpgradeTwoTiers == null) continue;
            for (Object prevTier : prevPrevTiers = IronChestType.getRegistredChestsByTier(typ, typ.tier - 2, typ.resistance)) {
                IronChestType.addRecipe(chest, IronChestType.getRecipeSplitted(typ.recipeUpgradeTwoTiers), Character.valueOf('m'), mainMaterial, Character.valueOf('P'), prevTier, Character.valueOf('G'), "blockGlass", Character.valueOf('C'), "chestWood", Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static String[] getRecipeSplitted(String recipe) {
        return new String[]{recipe.substring(0, 3), recipe.substring(3, 6), recipe.substring(6, 9)};
    }

    public static Object translateOreName(String mat) {
        if (mat.equals("obsidian")) {
            return Blocks.field_150343_Z;
        }
        if (mat.equals("dirt")) {
            return Blocks.field_150346_d;
        }
        return mat;
    }

    public static void addRecipe(ItemStack is, Object ... parts) {
        ShapedOreRecipe oreRecipe = new ShapedOreRecipe(is, parts);
        GameRegistry.addRecipe((IRecipe)oreRecipe);
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    public List<String> getMatList() {
        return this.matList;
    }

    public static int validateMeta(int i) {
        if (i < IronChestType.values().length && IronChestType.values()[i].size > 0) {
            return i;
        }
        return 0;
    }

    public boolean isValidForCreativeMode() {
        return IronChestType.validateMeta(this.ordinal()) == this.ordinal();
    }

    public boolean isExplosionResistant() {
        return this.resistance >= 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void makeIcons(IIconRegister par1IconRegister) {
        if (this.isValidForCreativeMode()) {
            this.icons = new IIcon[3];
            int i = 0;
            for (String s : sideNames) {
                if (this.name().equalsIgnoreCase("steel")) {
                    this.icons[i++] = par1IconRegister.func_94245_a(String.format("ironchest:silver_%s", s));
                    continue;
                }
                this.icons[i++] = par1IconRegister.func_94245_a(String.format("ironchest:%s_%s", this.name().toLowerCase(), s));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        return this.icons[sideMapping[side]];
    }

    public Slot makeSlot(IInventory chestInventory, int index, int x, int y) {
        return new ValidatingSlot(chestInventory, index, x, y, this);
    }

    public boolean acceptsStack(ItemStack itemstack) {
        return this.itemFilter == null || itemstack == null || itemstack.func_77973_b() == this.itemFilter;
    }

    public void adornItemDrop(ItemStack item) {
        if (this == DIRTCHEST9000) {
            item.func_77983_a("dirtchest", (NBTBase)new NBTTagByte(1));
        }
    }

    private static void registerChest(IronChestType typ, ItemStack stack) {
        registredChests.put(typ, stack);
    }

    public static ItemStack getRegistredChest(IronChestType typ) {
        return registredChests.getOrDefault((Object)typ, null);
    }

    public static Object[] getRegistredChestsByTier(IronChestType parentMaterial, int tier, int resistance) {
        if (tier < 0) {
            return new Object[0];
        }
        if (tier == 0) {
            return new Object[]{"chestWood"};
        }
        IronChestType[] allTyps = IronChestType.getAllByTier(tier);
        HashSet<ItemStack> result = new HashSet<ItemStack>();
        for (IronChestType typ : allTyps) {
            ItemStack itemStack;
            if (typ.tier != tier || typ.resistance < resistance || !parentMaterial.allowUpgradeFrom(typ) || (itemStack = IronChestType.getRegistredChest(typ)) == null) continue;
            result.add(itemStack);
        }
        return result.toArray(new Object[result.size()]);
    }

    static {
        registredChests = new HashMap();
        sideNames = new String[]{"top", "front", "side"};
        sideMapping = new int[]{0, 0, 2, 1, 2, 2, 2};
    }
}

