/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.common.config;

import java.util.EnumSet;
import net.minecraftforge.common.config.Configuration;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.timecore.api.common.config.Config;
import ru.timeconqueror.timecore.api.common.config.ConfigSection;

public class ConfigGOL
extends Config {
    public int weight;
    public int startDigitAmount;
    public int attemptCount;
    public int expandFieldAtStage;
    public boolean explodeOnFail;
    public boolean zombiesOnFail;
    public boolean lavaOnFail;
    public int timeout;
    public StageConfig stage1 = new StageConfig(this.getKey(), "stage_1", "Regulates characteristics of stage 1.", new DefaultData(5, false, 24));
    public StageConfig stage2 = new StageConfig(this.getKey(), "stage_2", "Regulates characteristics of stage 2.", new DefaultData(5, false, 16));
    public StageConfig stage3 = new StageConfig(this.getKey(), "stage_3", "Regulates characteristics of stage 3.", new DefaultData(5, false, 12));
    public StageConfig stage4 = new StageConfig(this.getKey(), "stage_4", "Regulates characteristics of stage 4.", new DefaultData(5, true, 12));

    public ConfigGOL() {
        super("game_of_light");
    }

    @Override
    public void init() {
        this.weight = this.config.getInt("weight", this.getKey(), 1, 0, Integer.MAX_VALUE, "How likely this game is chosen compared to other games. The higher this value is, the more likely this game is chosen. Set to 0 to turn this off.");
        this.startDigitAmount = this.config.getInt("start_digit_amount", this.getKey(), 2, 1, Integer.MAX_VALUE, "Regulates how many digits should be randomly chosen and shown at game-start.");
        this.attemptCount = this.config.getInt("attempt_count", this.getKey(), 3, 1, Integer.MAX_VALUE, "It represents the number of attempts the player has to beat the game successfully.");
        this.expandFieldAtStage = this.config.getInt("expand_field_at_stage", this.getKey(), 2, 0, 4, "At which stage should the playfield become a full 3x3 pattern?\nSet 0 to disable and keep the 4-block size; set 1 to always start with 3x3.");
        this.explodeOnFail = this.config.getBoolean("explode_on_fail", this.getKey(), true, "Enables or disables structure exploding on max failed attempts.");
        this.zombiesOnFail = this.config.getBoolean("zombies_on_fail", this.getKey(), true, "Enables or disables structure filling with zombies on max failed attempts.");
        this.lavaOnFail = this.config.getBoolean("lava_on_fail", this.getKey(), true, "Enables or disables structure filling with lava on max failed attempts.");
        this.timeout = this.config.getInt("timeout", this.getKey(), 30, 10, Integer.MAX_VALUE, "How long does it take to timeout a game? Value is in seconds.\nIf player has been inactive for given time, the game will go to sleep. The next player can start the game from the beginning.");
        this.stage1.init(this.config);
        this.stage2.init(this.config);
        this.stage3.init(this.config);
        this.stage4.init(this.config);
        this.config.setCategoryComment(this.getKey(), "Regulates \"Game of Light\" minigame.");
    }

    @Override
    public String getRelativePath() {
        return LGConfigs.resolve("games/" + this.getKey());
    }

    public EnumSet<Fail> getAllowedFails() {
        EnumSet<Fail> fails = EnumSet.noneOf(Fail.class);
        if (this.zombiesOnFail) {
            fails.add(Fail.ZOMBIES);
        }
        if (this.explodeOnFail) {
            fails.add(Fail.EXPLOSION);
        }
        if (this.lavaOnFail) {
            fails.add(Fail.LAVA);
        }
        return fails;
    }

    public StageConfig getStageByIndex(int index) {
        if (index == 0) {
            return this.stage1;
        }
        if (index == 1) {
            return this.stage2;
        }
        if (index == 2) {
            return this.stage3;
        }
        return this.stage4;
    }

    public static enum Fail {
        ZOMBIES,
        EXPLOSION,
        LAVA;

    }

    private static class DefaultData {
        private final int rounds;
        private final boolean randomizeSequence;
        private final int displayTime;

        public DefaultData(int rounds, boolean randomizeSequence, int displayTime) {
            this.rounds = rounds;
            this.randomizeSequence = randomizeSequence;
            this.displayTime = displayTime;
        }
    }

    public static class StageConfig
    extends ConfigSection {
        public int rounds;
        public boolean randomizeSequence;
        public int displayTime;
        private final DefaultData defData;

        public StageConfig(String parentKey, String key, String comment, DefaultData defData) {
            super(parentKey, key, comment);
            this.defData = defData;
        }

        @Override
        protected void init(Configuration config) {
            this.rounds = config.getInt("round_count", this.getCategoryName(), this.defData.rounds, 1, 256, "Round count required to complete this stage and unlock leveled reward.");
            this.randomizeSequence = config.getBoolean("randomize_sequence", this.getCategoryName(), this.defData.randomizeSequence, "If true, the pattern will randomize on each round in this stage.");
            this.displayTime = config.getInt("display_time", this.getCategoryName(), this.defData.displayTime, 2, 40, "Amount of time (in ticks; 20 ticks = 1s) for which the symbol will be displayed.");
            config.setCategoryComment(this.getCategoryName(), this.getComment());
        }
    }

    public static class Names {
        public static final String CATEGORY_GAME_OF_LIGHT = "game_of_light";
        public static final String ATTEMPT_COUNT = "attempt_count";
        public static final String START_DIGIT_AMOUNT = "start_digit_amount";
        public static final String EXPAND_FIELD_AT_STAGE = "expand_field_at_stage";
        public static final String EXPLODE_ON_FAIL = "explode_on_fail";
        public static final String ZOMBIES_ON_FAIL = "zombies_on_fail";
        public static final String LAVA_ON_FAIL = "lava_on_fail";
        public static final String TIMEOUT = "timeout";
        public static final String ROUNDS = "round_count";
        public static final String RANDOMIZE_SEQUENCE = "randomize_sequence";
        public static final String DISPLAY_TIME = "display_time";
    }
}

