/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.commands;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.ICokeOvenRecipe;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StringHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class RailcraftLogger
implements ICommandFunction {
    private static final List<String> validArguments = new LinkedList<String>();

    public void execute(String[] arguments, IPlayer player) {
        List<String> args = StringHelper.toLowerCase(Arrays.asList(arguments));
        if (!validArguments.containsAll(args)) {
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("Invalid arguments for command. Valid arguments: " + StringHelper.join(validArguments, ", ")));
            }
        } else {
            if (args.isEmpty() || args.contains("BlastFurnace")) {
                for (IBlastFurnaceRecipe iBlastFurnaceRecipe : RailcraftHelper.furnace) {
                    MineTweakerAPI.logCommand((String)String.format("mods.railcraft.BlastFurnace.addRecipe(%s, %s, %s, %d, %s);", LogHelper.getStackDescription(iBlastFurnaceRecipe.getInput()), ReflectionHelper.getObject(iBlastFurnaceRecipe, "matchDamage"), ReflectionHelper.getObject(iBlastFurnaceRecipe, "matchNBT"), iBlastFurnaceRecipe.getCookTime(), LogHelper.getStackDescription(iBlastFurnaceRecipe.getOutput())));
                }
            }
            if (args.isEmpty() || args.contains("CokeOven")) {
                for (ICokeOvenRecipe iCokeOvenRecipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.railcraft.CokeOven.addRecipe(%s, %s, %s, %s, %s, %d);", LogHelper.getStackDescription(iCokeOvenRecipe.getInput()), ReflectionHelper.getObject(iCokeOvenRecipe, "matchDamage"), ReflectionHelper.getObject(iCokeOvenRecipe, "matchNBT"), LogHelper.getStackDescription(iCokeOvenRecipe.getOutput()), LogHelper.getStackDescription(iCokeOvenRecipe.getFluidOutput()), iCokeOvenRecipe.getCookTime()));
                }
            }
            if (args.isEmpty() || args.contains("RockCrusher")) {
                for (IRockCrusherRecipe iRockCrusherRecipe : RailcraftHelper.crusher) {
                    MineTweakerAPI.logCommand((String)String.format("mods.railcraft.RockCrusher.addRecipe(%s, %s, %s, %s);", LogHelper.getStackDescription(iRockCrusherRecipe.getInput()), ReflectionHelper.getObject(iRockCrusherRecipe, "matchDamage"), ReflectionHelper.getObject(iRockCrusherRecipe, "matchNBT"), this.getRockCrusherOutputDescription(iRockCrusherRecipe.getOutputs())));
                }
            }
            if (args.isEmpty() || args.contains("RollingMachine")) {
                for (IRecipe iRecipe : RailcraftHelper.rolling) {
                    MineTweakerAPI.logCommand((String)String.format("mods.railcraft.RollingMachine.addRecipe(%s, %s);", LogHelper.getStackDescription(iRecipe.func_77571_b()), LogHelper.getCraftingDescription(iRecipe)));
                }
            }
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
            }
        }
    }

    private Object getRockCrusherOutputDescription(List<Map.Entry<ItemStack, Float>> outputs) {
        if (outputs.isEmpty()) {
            return "[], []";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Map.Entry<ItemStack, Float> entry : outputs) {
            sb.append(LogHelper.getStackDescription(entry.getKey())).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("], [");
        for (Map.Entry<ItemStack, Float> entry : outputs) {
            sb.append(entry.getValue()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        return sb.toString();
    }

    static {
        validArguments.add("BlastFurnace");
        validArguments.add("CokeOven");
        validArguments.add("RockCrusher");
        validArguments.add("RollingMachine");
    }
}

