/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fluid;

import com.cleanroommc.modularui.utils.fluid.IFluidTankLong;
import com.cleanroommc.modularui.utils.fluid.IFluidTanksHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ListFluidHandler
implements IFluidTanksHandler {
    protected final List<? extends IFluidTanksHandler> fluidHandlers;

    public ListFluidHandler(List<? extends IFluidTanksHandler> fluidHandlers) {
        this.fluidHandlers = fluidHandlers;
    }

    @Override
    public int getTanks() {
        int tanks = 0;
        for (IFluidTanksHandler iFluidTanksHandler : this.fluidHandlers) {
            tanks += iFluidTanksHandler.getTanks();
        }
        return tanks;
    }

    @Override
    @Nonnull
    public IFluidTankLong getTank(int tankSlot) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tankSlot);
        return ((IFluidTanksHandler)result.getLeft()).getTank((Integer)result.getRight());
    }

    @Override
    public void setFluidInTank(int tankSlot, @Nullable Fluid fluid, long amount) {
        Pair<? extends IFluidTanksHandler, Integer> result = this.findFluidHandler(tankSlot);
        ((IFluidTanksHandler)result.getLeft()).setFluidInTank((Integer)result.getRight(), fluid, amount);
    }

    protected Pair<? extends IFluidTanksHandler, Integer> findFluidHandler(int tankSlot) {
        int searching = 0;
        for (IFluidTanksHandler iFluidTanksHandler : this.fluidHandlers) {
            if (tankSlot >= searching && tankSlot < searching + iFluidTanksHandler.getTanks()) {
                return new ImmutablePair((Object)iFluidTanksHandler, (Object)(tankSlot - searching));
            }
            searching += iFluidTanksHandler.getTanks();
        }
        throw new RuntimeException("Tank slot " + tankSlot + " not in valid range - [0," + this.getTanks() + ")");
    }
}

