/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.navigator;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalInteractableRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.Waypoint;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.integration.navigator.ClaimsButtonManager;
import serverutils.integration.navigator.ClaimsLocation;
import serverutils.integration.navigator.ClaimsRenderStep;
import serverutils.integration.navigator.NavigatorIntegration;
import serverutils.net.MessageNavigatorRequest;
import serverutils.net.MessageNavigatorValidateKnown;

public class ClaimsLayerManager
extends InteractableLayerManager {
    public static final ClaimsLayerManager INSTANCE = new ClaimsLayerManager();
    private long lastRequest;
    private long lastValidateRequest;

    public ClaimsLayerManager() {
        super((ButtonManager)ClaimsButtonManager.INSTANCE);
    }

    @Nullable
    protected LayerRenderer addLayerRenderer(InteractableLayerManager manager, SupportedMods mod) {
        return new UniversalInteractableRenderer(manager).withClickAction(NavigatorIntegration::claimChunk).withRenderStep(location -> new ClaimsRenderStep((ClaimsLocation)location));
    }

    public void setActiveWaypoint(Waypoint waypoint) {
    }

    public void onLayerToggled(boolean toEnabled) {
        super.onLayerToggled(toEnabled);
        if (!toEnabled) {
            NavigatorIntegration.CLAIMS.clear();
            this.lastRequest = 0L;
        }
    }

    @Nullable
    protected ILocationProvider generateLocation(int chunkX, int chunkZ, int dim) {
        ClientClaimedChunks.ChunkData data = (ClientClaimedChunks.ChunkData)NavigatorIntegration.CLAIMS.get((Object)NavigatorIntegration.mutablePos.set(chunkX, chunkZ, dim));
        if (data == null) {
            return null;
        }
        return new ClaimsLocation(chunkX, chunkZ, dim, data);
    }

    public void onUpdatePre(int minX, int maxX, int minZ, int maxZ) {
        long now = System.currentTimeMillis();
        if (now - this.lastRequest >= TimeUnit.SECONDS.toMillis(2L)) {
            this.lastRequest = now;
            new MessageNavigatorRequest(minX, maxX, minZ, maxZ).sendToServer();
        }
    }

    public void onUpdatePost(int minX, int maxX, int minZ, int maxZ) {
        long now = System.currentTimeMillis();
        if (now - this.lastValidateRequest >= TimeUnit.SECONDS.toMillis(10L)) {
            this.lastValidateRequest = now;
            Collection visibleLocations = this.getVisibleLocations();
            if (visibleLocations.isEmpty()) {
                return;
            }
            LongOpenHashSet positions = new LongOpenHashSet();
            visibleLocations.forEach(arg_0 -> ClaimsLayerManager.lambda$onUpdatePost$1((LongSet)positions, arg_0));
            new MessageNavigatorValidateKnown((LongSet)positions).sendToServer();
        }
    }

    private static /* synthetic */ void lambda$onUpdatePost$1(LongSet positions, IWaypointAndLocationProvider location) {
        positions.add(location.toLong());
    }
}

