/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import serverutils.ServerUtilitiesCommon;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.util.SidedUtils;

@Mod(modid="serverutilities", name="Server Utilities", version="2.0.78", dependencies="required-after:gtnhlib;after:navigator;", guiFactory="serverutils.client.gui.GuiFactory")
public class ServerUtilities {
    public static final String MOD_ID = "serverutilities";
    public static final String MOD_NAME = "Server Utilities";
    public static final String VERSION = "2.0.78";
    public static final Logger LOGGER = LogManager.getLogger((String)"Server Utilities");
    public static final String SERVER_FOLDER = "serverutilities/server/";
    @Mod.Instance(value="serverutilities")
    public static ServerUtilities INST;
    @SidedProxy(serverSide="serverutils.ServerUtilitiesCommon", clientSide="serverutils.client.ServerUtilitiesClient")
    public static ServerUtilitiesCommon PROXY;

    public static IChatComponent lang(@Nullable ICommandSender sender, String key, Object ... args) {
        return SidedUtils.lang(sender, MOD_ID, key, args);
    }

    public static CommandException error(@Nullable ICommandSender sender, String key, Object ... args) {
        return CommandUtils.error(ServerUtilities.lang(sender, key, args));
    }

    public static CommandException errorFeatureDisabledServer(@Nullable ICommandSender sender) {
        return ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Locale.setDefault(Locale.US);
        PROXY.preInit(event);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        PROXY.init(event);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        PROXY.onServerAboutToStart(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        PROXY.onServerStarting(event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        PROXY.onServerStarted(event);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        PROXY.onServerStopping(event);
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> map, Side side) {
        return side != Side.CLIENT || map.containsKey(MOD_ID) && map.get(MOD_ID).equals(VERSION);
    }
}

