/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock.eigbuckets;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.util.GTUtility;
import gregtech.common.GTDummyWorld;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import kubatech.api.eig.EIGBucket;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.eig.IEIGBucketFactory;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeIndustrialGreenhouse;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class EIGSeedBucket
extends EIGBucket {
    public static final IEIGBucketFactory factory = new Factory();
    private static final String NBT_IDENTIFIER = "SEED";
    private static final int REVISION_NUMBER = 0;
    private static final int NUMBER_OF_DROPS_TO_SIMULATE = 1000;
    private static final int FORTUNE_LEVEL = 0;
    private static final GreenHouseWorld fakeWorld = new GreenHouseWorld(5, 5, 5);
    private boolean isValid = false;
    private EIGDropTable drops = new EIGDropTable();

    private EIGSeedBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack seed) {
        super(seed, 1, null);
        this.recalculateDrops(greenhouse);
    }

    private EIGSeedBucket(NBTTagCompound nbt) {
        super(nbt);
        this.drops = new EIGDropTable(nbt, "drops");
        this.isValid = nbt.func_74762_e("version") == 0 && !this.drops.isEmpty();
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = super.save();
        nbt.func_74782_a("drops", (NBTBase)this.drops.save());
        nbt.func_74768_a("version", 0);
        return nbt;
    }

    @Override
    protected String getNBTIdentifier() {
        return NBT_IDENTIFIER;
    }

    @Override
    public void addProgress(double multiplier, EIGDropTable tracker) {
        if (!this.isValid()) {
            return;
        }
        this.drops.addTo(tracker, multiplier * (double)this.seedCount);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isValid;
    }

    @Override
    public boolean revalidate(MTEExtremeIndustrialGreenhouse greenhouse) {
        this.recalculateDrops(greenhouse);
        return this.isValid();
    }

    public void recalculateDrops(MTEExtremeIndustrialGreenhouse greenhouse) {
        Block block;
        this.isValid = false;
        int optimalGrowthMetadata = 7;
        Item item = this.seed.func_77973_b();
        if (!(item instanceof IPlantable)) {
            return;
        }
        if (item instanceof ItemSeeds) {
            block = ((ItemSeeds)item).getPlant((IBlockAccess)fakeWorld, 0, 0, 0);
        } else if (item instanceof ItemSeedFood) {
            block = ((ItemSeedFood)item).getPlant((IBlockAccess)fakeWorld, 0, 0, 0);
        } else {
            return;
        }
        GameRegistry.UniqueIdentifier u = GameRegistry.findUniqueIdentifierFor((Item)item);
        if (u != null && Objects.equals(u.modId, "Natura")) {
            optimalGrowthMetadata = 8;
        }
        EIGDropTable drops = new EIGDropTable();
        World world = greenhouse.getBaseMetaTileEntity().getWorld();
        for (int i = 0; i < 1000; ++i) {
            ArrayList blockDrops = block.getDrops(world, 0, 0, 0, optimalGrowthMetadata, 0);
            for (ItemStack drop : blockDrops) {
                drops.addDrop(drop, drop.field_77994_a);
            }
        }
        if (!this.removeSeedFromDrops(world, drops, this.seed, 1000)) {
            return;
        }
        drops.entrySet().forEach(x -> x.setValue((Double)x.getValue() / 1000.0));
        if (drops.isEmpty()) {
            return;
        }
        this.drops = drops;
        this.isValid = true;
    }

    private boolean removeSeedFromDrops(World world, EIGDropTable drops, ItemStack seed, int seedsToConsume) {
        ItemStack seedSafe = seed.func_77946_l();
        seedSafe.field_77994_a = 1;
        int inputSeedDropCountAfterRemoval = (int)Math.round(drops.getItemAmount(seedSafe)) - seedsToConsume;
        if (inputSeedDropCountAfterRemoval > 0) {
            drops.setItemAmount(seedSafe, inputSeedDropCountAfterRemoval);
        } else {
            drops.removeItem(seedSafe);
        }
        if (inputSeedDropCountAfterRemoval >= 0) {
            return true;
        }
        int seedsToCraft = -inputSeedDropCountAfterRemoval;
        IRecipe[] validRecipes = (IRecipe[])CraftingManager.func_77594_a().func_77592_b().parallelStream().filter(recipe -> GTUtility.areStacksEqual(recipe.func_77571_b(), seed)).toArray(IRecipe[]::new);
        if (validRecipes.length == 0) {
            return false;
        }
        Iterator<Map.Entry<ItemStack, Double>> dropIterator = drops.entrySet().iterator();
        while (dropIterator.hasNext()) {
            Map.Entry<ItemStack, Double> entry = dropIterator.next();
            int inputCount = (int)Math.round(entry.getValue());
            ItemStack input = entry.getKey().func_77946_l();
            input.field_77994_a = 1;
            EIGCraftingSeedFinder seedFinder = new EIGCraftingSeedFinder(input);
            for (IRecipe recipe2 : validRecipes) {
                if (!recipe2.func_77569_a((InventoryCrafting)seedFinder, world)) continue;
                int outputsPerCraft = recipe2.func_77572_b((InventoryCrafting)seedFinder).field_77994_a;
                int craftableSeeds = outputsPerCraft * inputCount;
                if (seedsToCraft >= craftableSeeds) {
                    dropIterator.remove();
                    if ((seedsToCraft -= craftableSeeds) > 0) continue;
                    return true;
                }
                entry.setValue(entry.getValue() - (double)seedsToCraft / (double)outputsPerCraft);
                return true;
            }
        }
        return false;
    }

    private static class GreenHouseWorld
    extends GTDummyWorld {
        public int x;
        public int y;
        public int z;
        public int meta = 0;
        public Block block;

        GreenHouseWorld(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.field_73012_v = new GreenHouseRandom();
        }

        @Override
        public int func_72805_g(int aX, int aY, int aZ) {
            if (aX == this.x && aY == this.y && aZ == this.z) {
                return 7;
            }
            return 0;
        }

        @Override
        public Block func_147439_a(int aX, int aY, int aZ) {
            if (aY == this.y - 1) {
                return Blocks.field_150458_ak;
            }
            return Blocks.field_150350_a;
        }

        public int func_72957_l(int p_72957_1_, int p_72957_2_, int p_72957_3_) {
            return 10;
        }

        @Override
        public boolean func_147465_d(int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
            if (aBlock == Blocks.field_150350_a) {
                return false;
            }
            if (aX == this.x && aY == this.y && aZ == this.z) {
                return false;
            }
            this.block = aBlock;
            this.meta = aMeta;
            return true;
        }
    }

    class EIGCraftingSeedFinder
    extends InventoryCrafting {
        public ItemStack recipeInput;

        public EIGCraftingSeedFinder(ItemStack recipeInput) {
            super(null, 3, 3);
            this.recipeInput = recipeInput;
        }

        public ItemStack func_70301_a(int p_70301_1_) {
            if (p_70301_1_ == 0) {
                return this.recipeInput.func_77946_l();
            }
            return null;
        }

        public ItemStack func_70304_b(int par1) {
            return null;
        }

        public ItemStack func_70298_a(int par1, int par2) {
            return null;
        }

        public void func_70299_a(int par1, ItemStack par2ItemStack) {
        }
    }

    public static class Factory
    implements IEIGBucketFactory {
        @Override
        public String getNBTIdentifier() {
            return EIGSeedBucket.NBT_IDENTIFIER;
        }

        @Override
        public EIGBucket tryCreateBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack input) {
            return new EIGSeedBucket(greenhouse, input);
        }

        @Override
        public EIGBucket restore(NBTTagCompound nbt) {
            return new EIGSeedBucket(nbt);
        }
    }

    private static class GreenHouseRandom
    extends Random {
        private static final long serialVersionUID = -387271808935248890L;

        private GreenHouseRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }
}

