/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.SimpleShutDownReason;
import gtnhlanth.common.beamline.BeamInformation;
import gtnhlanth.common.beamline.BeamLinePacket;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.hatch.MTEHatchOutputBeamline;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.tileentity.recipe.beamline.BeamlineRecipeAdder2;
import gtnhlanth.common.tileentity.recipe.beamline.RecipeSC;
import gtnhlanth.util.DescTextLocalization;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTESourceChamber
extends MTEEnhancedMultiBlockBase<MTESourceChamber>
implements ISurvivalConstructable {
    private static final IStructureDefinition<MTESourceChamber> STRUCTURE_DEFINITION;
    private ArrayList<MTEHatchOutputBeamline> mOutputBeamline = new ArrayList();
    private static final int CASING_INDEX;
    private float outputEnergy;
    private int outputRate;
    private int outputParticle;
    private float outputFocus;

    public MTESourceChamber(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public MTESourceChamber(String name) {
        super(name);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece("sc", stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity te) {
        return new MTESourceChamber(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Particle Source").addInfo("Controller block for the Source Chamber").addInfo("Output energy scales with EU/t up to the point shown in the recipe").addInfo(DescTextLocalization.BLUEPRINT_INFO).addInfo(DescTextLocalization.BEAMLINE_SCANNER_INFO).addSeparator().beginStructureBlock(5, 5, 6, true).addController("Front bottom").addCasingInfoExactly(LanthItemList.SHIELDED_ACCELERATOR_CASING.func_149732_F(), 56, false).addCasingInfoExactly(LanthItemList.SHIELDED_ACCELERATOR_GLASS.func_149732_F(), 52, false).addCasingInfoExactly(LanthItemList.ELECTRODE_CASING.func_149732_F(), 16, false).addOtherStructurePart("Beamline Output Hatch", DescTextLocalization.addDotText(4)).addEnergyHatch(DescTextLocalization.addDotText(3)).addMaintenanceHatch(DescTextLocalization.addDotText(3)).addInputBus(DescTextLocalization.addDotText(1)).addOutputBus(DescTextLocalization.addDotText(2)).toolTipFinisher("GTNH: Lanthanides");
        return tt;
    }

    private boolean addBeamLineOutputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchOutputBeamline) {
            return this.mOutputBeamline.add((MTEHatchOutputBeamline)mte);
        }
        return false;
    }

    @Override
    public boolean checkRecipe(ItemStack itemStack) {
        this.outputFocus = 0.0f;
        this.outputEnergy = 0.0f;
        this.outputParticle = 0;
        this.outputRate = 0;
        ItemStack[] tItems = this.getStoredInputs().toArray(new ItemStack[0]);
        long tVoltageMaxTier = this.getMaxInputVoltage();
        long tVoltageActual = GTValues.VP[(int)this.getInputVoltageTier()];
        RecipeSC tRecipe = (RecipeSC)BeamlineRecipeAdder2.instance.SourceChamberRecipes.findRecipeQuery().items(tItems).voltage(tVoltageActual).find();
        if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, new FluidStack[0], tItems)) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = tRecipe.mDuration;
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        this.mEUt = (int)(-tVoltageActual);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.outputParticle = tRecipe.particleId;
        float maxParticleEnergy = Particle.getParticleFromId(this.outputParticle).maxSourceEnergy();
        float maxMaterialEnergy = tRecipe.maxEnergy;
        this.outputEnergy = (float)Math.min((double)(-maxMaterialEnergy) * Math.pow(1.001, -tRecipe.energyRatio * (float)(tVoltageMaxTier - (long)tRecipe.mEUt)) + (double)maxMaterialEnergy, (double)maxParticleEnergy);
        if (this.outputEnergy <= 0.0f) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.scerror"));
            return false;
        }
        this.outputFocus = tRecipe.focus;
        this.outputRate = tRecipe.rate;
        this.mOutputItems = tRecipe.mOutputs;
        this.updateSlots();
        this.outputAfterRecipe();
        return true;
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("SourceChamber.hint", 7);
    }

    private void outputAfterRecipe() {
        if (!this.mOutputBeamline.isEmpty()) {
            BeamLinePacket packet = new BeamLinePacket(new BeamInformation(this.outputEnergy, this.outputRate, this.outputParticle, this.outputFocus));
            for (MTEHatchOutputBeamline o : this.mOutputBeamline) {
                o.q = packet;
            }
        }
    }

    @Override
    public void stopMachine() {
        this.outputFocus = 0.0f;
        this.outputEnergy = 0.0f;
        this.outputParticle = 0;
        this.outputRate = 0;
        super.stopMachine();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BeamlineRecipeAdder2.instance.SourceChamberRecipes;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : this.mEnergyHatches) {
            if (!tHatch.isValid()) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.out_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(this.outputParticle).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + this.outputEnergy + EnumChatFormatting.RESET + " keV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + this.outputFocus + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + this.outputRate};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("sc", stackSize, hintsOnly, 2, 4, 0);
    }

    @Override
    public IStructureDefinition<MTESourceChamber> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputBeamline.clear();
        return this.checkPiece("sc", 2, 4, 0) && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() == 1 && this.mOutputBusses.size() == 1 && this.mOutputBeamline.size() == 1 && this.mEnergyHatches.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][14], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][14], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][14]};
    }

    static {
        CASING_INDEX = GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings5, 14);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("sc", (String[][])new String[][]{{"ccccc", "ckkkc", "ckikc", "ckkkc", "dd~dd"}, {"ckkkc", "keeek", "ke-ek", "keeek", "ccocc"}, {"ckkkc", "k---k", "k---k", "k---k", "ccccc"}, {"ckkkc", "k---k", "k---k", "k---k", "ccccc"}, {"ckkkc", "keeek", "ke-ek", "keeek", "ccccc"}, {"ccccc", "ckkkc", "ckbkc", "ckkkc", "ccccc"}}).addElement('c', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0)).addElement('k', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_GLASS, (int)0)).addElement('e', StructureUtility.ofBlock((Block)LanthItemList.ELECTRODE_CASING, (int)0)).addElement('b', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).hatchClass(MTEHatchOutputBeamline.class).casingIndex(CASING_INDEX).dot(4).adder(MTESourceChamber::addBeamLineOutputHatch).build()).addElement('i', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).atLeast(HatchElement.InputBus).casingIndex(CASING_INDEX).dot(1).build()).addElement('o', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).atLeast(HatchElement.OutputBus).casingIndex(CASING_INDEX).dot(2).build()).addElement('d', GTStructureUtility.buildHatchAdder(MTESourceChamber.class).atLeast(HatchElement.Maintenance, HatchElement.Energy).casingIndex(CASING_INDEX).dot(3).buildAndChain(StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0))).build();
    }
}

