/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;

public class ProcessingTransforming
implements IOreRecipeRegistrator {
    public ProcessingTransforming() {
        for (OrePrefixes tPrefix : OrePrefixes.values()) {
            if ((tPrefix.mMaterialAmount <= 0L || tPrefix.mIsContainer || tPrefix.mIsEnchantable) && tPrefix != OrePrefixes.plank) continue;
            tPrefix.add(this);
        }
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aPrefix == OrePrefixes.plank) {
            aPrefix = OrePrefixes.plate;
        }
        switch (aMaterial.mName) {
            case "Wood": {
                if (GTOreDictUnificator.get(aPrefix, Materials.WoodSealed, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.Wood, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.WoodSealed, 1L)).fluidInputs(Materials.SeedOil.getFluid(GTUtility.translateMaterialToAmount(aPrefix.mMaterialAmount, 120L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                break;
            }
            case "Iron": {
                if (GTOreDictUnificator.get(aPrefix, Materials.FierySteel, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.Iron, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.FierySteel, 1L)).fluidInputs(Materials.FierySteel.getFluid(GTUtility.translateMaterialToAmount(aPrefix.mMaterialAmount, 250L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                }
                if (GTOreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.Iron, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.LV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "WroughtIron": {
                if (GTOreDictUnificator.get(aPrefix, Materials.FierySteel, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.WroughtIron, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.FierySteel, 1L)).fluidInputs(Materials.FierySteel.getFluid(GTUtility.translateMaterialToAmount(aPrefix.mMaterialAmount, 225L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                }
                if (GTOreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.WroughtIron, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.LV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "Steel": {
                if (GTOreDictUnificator.get(aPrefix, Materials.FierySteel, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.Steel, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.FierySteel, 1L)).fluidInputs(Materials.FierySteel.getFluid(GTUtility.translateMaterialToAmount(aPrefix.mMaterialAmount, 200L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                }
                if (GTOreDictUnificator.get(aPrefix, Materials.SteelMagnetic, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.Steel, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.SteelMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.LV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "Neodymium": {
                if (GTOreDictUnificator.get(aPrefix, Materials.NeodymiumMagnetic, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.Neodymium, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.NeodymiumMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.HV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "Samarium": {
                if (GTOreDictUnificator.get(aPrefix, Materials.SamariumMagnetic, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.Samarium, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.SamariumMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.IV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "TengamPurified": {
                if (GTOreDictUnificator.get(aPrefix, Materials.TengamAttuned, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(aPrefix, Materials.TengamPurified, 1L)).itemOutputs(GTOreDictUnificator.get(aPrefix, Materials.TengamAttuned, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.RECIPE_UHV).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
        }
    }
}

