/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings10;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputInventory;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSolidifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEMultiSolidifier
extends MTEExtendedPowerMultiBlockBase<MTEMultiSolidifier>
implements ISurvivalConstructable {
    protected final String MS_LEFT_MID;
    protected final String MS_RIGHT_MID;
    protected final String MS_END;
    private final int PARALLELS_PER_WIDTH = 3;
    private byte glassTier;
    private static final double decay_rate = 0.025;
    private final String STRUCTURE_PIECE_MAIN = "main";
    private final IStructureDefinition<MTEMultiSolidifier> STRUCTURE_DEFINITION;
    protected int mWidth;
    protected int nWidth;
    protected int mCasing;
    private int mCasingAmount;
    private float speedup;
    private int tickcount;
    private int tickcounts;

    public MTEMultiSolidifier(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.MS_LEFT_MID = this.mName + "leftmid";
        this.MS_RIGHT_MID = this.mName + "rightmid";
        this.MS_END = this.mName + "end";
        this.PARALLELS_PER_WIDTH = 3;
        this.glassTier = 0;
        this.STRUCTURE_PIECE_MAIN = "main";
        this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.MS_LEFT_MID, StructureUtility.transpose((String[][])new String[][]{{"  ", "BB", "BB", "BB"}, {"  ", "AA", "D ", "AA"}, {"  ", "AA", "  ", "AA"}, {"  ", "CC", "FC", "CC"}, {"  ", "BB", "BB", "BB"}})).addShape(this.MS_RIGHT_MID, StructureUtility.transpose((String[][])new String[][]{{"  ", "BB", "BB", "BB"}, {"  ", "AA", " D", "AA"}, {"  ", "AA", "  ", "AA"}, {"  ", "CC", "CF", "CC"}, {"  ", "BB", "BB", "BB"}})).addShape(this.MS_END, StructureUtility.transpose((String[][])new String[][]{{"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}})).addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       ", "BBBBBBB", "BBBBBBB", "BBBBBBB", "       "}, {"BBBBBBB", "       ", "D D D D", "       ", "AAAAAAA"}, {"AAAAAAA", "       ", "       ", "       ", "AAAAAAA"}, {"CCCBCCC", "       ", "F F F F", "       ", "CCCCCCC"}, {"BBB~BBB", "BBBBBBB", "BBBBBBB", "BBBBBBB", "BBBBBBB"}})).addElement('A', BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
            te.glassTier = t;
        }, te -> te.glassTier)).addElement('B', GTStructureUtility.buildHatchAdder(MTEMultiSolidifier.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(13)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEMultiSolidifier::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)13)))).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)14)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).build();
        this.speedup = 1.0f;
        this.tickcount = 0;
        this.tickcounts = 0;
    }

    public MTEMultiSolidifier(String aName) {
        super(aName);
        this.MS_LEFT_MID = this.mName + "leftmid";
        this.MS_RIGHT_MID = this.mName + "rightmid";
        this.MS_END = this.mName + "end";
        this.PARALLELS_PER_WIDTH = 3;
        this.glassTier = 0;
        this.STRUCTURE_PIECE_MAIN = "main";
        this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.MS_LEFT_MID, StructureUtility.transpose((String[][])new String[][]{{"  ", "BB", "BB", "BB"}, {"  ", "AA", "D ", "AA"}, {"  ", "AA", "  ", "AA"}, {"  ", "CC", "FC", "CC"}, {"  ", "BB", "BB", "BB"}})).addShape(this.MS_RIGHT_MID, StructureUtility.transpose((String[][])new String[][]{{"  ", "BB", "BB", "BB"}, {"  ", "AA", " D", "AA"}, {"  ", "AA", "  ", "AA"}, {"  ", "CC", "CF", "CC"}, {"  ", "BB", "BB", "BB"}})).addShape(this.MS_END, StructureUtility.transpose((String[][])new String[][]{{"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}, {"B", "B", "B", "B", "B"}})).addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       ", "BBBBBBB", "BBBBBBB", "BBBBBBB", "       "}, {"BBBBBBB", "       ", "D D D D", "       ", "AAAAAAA"}, {"AAAAAAA", "       ", "       ", "       ", "AAAAAAA"}, {"CCCBCCC", "       ", "F F F F", "       ", "CCCCCCC"}, {"BBB~BBB", "BBBBBBB", "BBBBBBB", "BBBBBBB", "BBBBBBB"}})).addElement('A', BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
            te.glassTier = t;
        }, te -> te.glassTier)).addElement('B', GTStructureUtility.buildHatchAdder(MTEMultiSolidifier.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(13)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEMultiSolidifier::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)13)))).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)14)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).build();
        this.speedup = 1.0f;
        this.tickcount = 0;
        this.tickcounts = 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMultiSolidifier(this.mName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 13)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 13)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_CANNER_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 13))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fluid Solidifier").addInfo("Controller Block for the Fluid Shaper").addInfo("Speeds up to a maximum of 300% faster than singleblock machines while running").addInfo("Decays at double the Rate that it Speeds up at").addInfo("Only uses 80% of the EU/t normally required").addInfo("Starts with 4 Parallels").addInfo("Gain 3 Parallels per Width Expansion and Multiplied by Voltage Tier").addInfo("Energy Hatch Based on Glass Tier, UMV Glass Unlocks all").addInfo(EnumChatFormatting.BLUE + "Pretty \u2c14\u2c41\u2c3e\u2c3b\u2c34, isn't it").addInfo(GTValues.AuthorOmdaCZ).addInfo("With the Help Of " + EnumChatFormatting.LIGHT_PURPLE + "Four" + EnumChatFormatting.RESET + ", " + EnumChatFormatting.AQUA + "GDCloud" + EnumChatFormatting.RESET + ", " + EnumChatFormatting.GOLD + "Ba" + EnumChatFormatting.LIGHT_PURPLE + "ps" + EnumChatFormatting.RESET + " & " + EnumChatFormatting.DARK_AQUA + "TheEpicGamer274").addSeparator().beginVariableStructureBlock(17, 33, 5, 5, 5, 5, true).addController("Front Center bottom").addCasingInfoMin("Solidifier Casing", 146, false).addCasingInfoMin("Radiator Casing", 18, false).addCasingInfoMin("Heat Proof Casing", 4, false).addCasingInfoMin("Solid Steel Casing", 4, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).toolTipFinisher("GregTech");
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 3, 4, 0);
        int tTotalWidth = Math.min(stackSize.field_77994_a + 1, 6);
        for (int i = 1; i < tTotalWidth - 1; ++i) {
            this.buildPiece(this.MS_LEFT_MID, stackSize, hintsOnly, 3 + 2 * i, 4, 0);
            this.buildPiece(this.MS_RIGHT_MID, stackSize, hintsOnly, -2 - 2 * i, 4, 0);
        }
        this.buildPiece(this.MS_END, stackSize, hintsOnly, (tTotalWidth + 2) * 2 - 4, 4, 0);
        this.buildPiece(this.MS_END, stackSize, hintsOnly, (-tTotalWidth - 2) * 2 + 4, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        this.mWidth = 0;
        this.nWidth = 0;
        int built = this.survivialBuildPiece("main", stackSize, 3, 4, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int tTotalWidth = Math.min(stackSize.field_77994_a + 1, 6);
        for (int i = 1; i < tTotalWidth; ++i) {
            this.mWidth = i;
            this.nWidth = i;
            built = this.survivialBuildPiece(this.MS_LEFT_MID, stackSize, 3 + 2 * i, 4, 0, elementBudget, env, false, true);
            if (built >= 0) {
                return built;
            }
            built = this.survivialBuildPiece(this.MS_RIGHT_MID, stackSize, -2 - 2 * i, 4, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        if (this.mWidth == tTotalWidth - 1) {
            built += this.survivialBuildPiece(this.MS_END, stackSize, (3 + tTotalWidth) * 2 - 4, 4, 0, elementBudget, env, false, true);
            built += this.survivialBuildPiece(this.MS_END, stackSize, (-3 - tTotalWidth) * 2 + 4, 4, 0, elementBudget, env, false, true);
        }
        return built;
    }

    @Override
    public IStructureDefinition<MTEMultiSolidifier> getStructureDefinition() {
        return this.STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mWidth = 0;
        this.mCasingAmount = 0;
        if (this.checkPiece("main", 3, 4, 0)) {
            while (this.mWidth < 6 && this.checkPiece(this.MS_RIGHT_MID, -2 * (this.mWidth + 1) - 2, 4, 0) && this.checkPiece(this.MS_LEFT_MID, 2 * (this.mWidth + 1) + 3, 4, 0)) {
                ++this.mWidth;
            }
        } else {
            return false;
        }
        if (!this.checkPiece(this.MS_END, -2 * this.mWidth - 4, 4, 0) || !this.checkPiece(this.MS_END, this.mWidth * 2 + 4, 4, 0)) {
            return false;
        }
        if (this.glassTier >= 12) {
            return true;
        }
        for (int i = 0; i < this.mEnergyHatches.size(); ++i) {
            if (((MTEHatchEnergy)this.mEnergyHatches.get((int)i)).mTier <= this.glassTier) continue;
            return false;
        }
        return this.mCasingAmount >= 100 + this.mWidth * 23;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                this.setSpeedBonus(1.0f / MTEMultiSolidifier.this.speedup);
                return super.validateRecipe(recipe);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes)).setEuModifier(0.8f);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        ++this.tickcount;
        if (this.tickcount % 10 == 0 && this.speedup < 3.0f) {
            this.tickcount = 0;
            this.speedup += 0.025f;
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mMaxProgresstime == 0 && this.speedup > 1.0f) {
            ++this.tickcounts;
            if (this.tickcounts % 5 == 0) {
                this.tickcounts = 0;
                this.speedup = (float)Math.max(1.0, (double)this.speedup - 0.025);
            }
        }
    }

    public int getMaxParallelRecipes() {
        return 4 + this.mWidth * 3 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fluidSolidifierRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("speedup")) {
            this.speedup = aNBT.func_74760_g("speedup");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74776_a("speedup", this.speedup);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74776_a("speedup", this.speedup);
        tag.func_74768_a("parallels", this.getMaxParallelRecipes());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.speed") + ": " + EnumChatFormatting.WHITE + String.format("%.1f%%", Float.valueOf(100.0f * tag.func_74760_g("speedup"))));
        currentTip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.WHITE + tag.func_74762_e("parallels"));
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    @NotNull
    protected CheckRecipeResult doCheckRecipe() {
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_RECIPE;
        if (this.supportsCraftingMEBuffer()) {
            for (IDualInputHatch dualInputHatch : this.mDualInputHatches) {
                Iterator<? extends IDualInputInventory> it = dualInputHatch.inventories();
                while (it.hasNext()) {
                    IDualInputInventory slot = it.next();
                    this.processingLogic.setInputItems(slot.getItemInputs());
                    this.processingLogic.setInputFluids(slot.getFluidInputs());
                    CheckRecipeResult foundResult = this.processingLogic.process();
                    if (foundResult.wasSuccessful()) {
                        return foundResult;
                    }
                    if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
                    result = foundResult;
                }
            }
        }
        for (MTEHatchInput solidifierHatch : this.mInputHatches) {
            if (!(solidifierHatch instanceof MTEHatchSolidifier)) continue;
            MTEHatchSolidifier hatch = (MTEHatchSolidifier)solidifierHatch;
            ItemStack mold = hatch.getMold();
            FluidStack fluid = solidifierHatch.getFluid();
            if (mold == null || fluid == null) continue;
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            inputItems.add(mold);
            this.processingLogic.setInputItems(inputItems.toArray(new ItemStack[0]));
            this.processingLogic.setInputFluids(fluid);
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            result = foundResult;
        }
        this.processingLogic.clear();
        this.processingLogic.setInputFluids(this.getStoredFluids());
        for (MTEHatchInputBus bus : this.mInputBusses) {
            if (bus instanceof MTEHatchCraftingInputME) continue;
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            for (int i = bus.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack stored = bus.func_70301_a(i);
                if (stored == null) continue;
                inputItems.add(stored);
            }
            if (this.canUseControllerSlotForRecipe() && this.getControllerSlot() != null) {
                inputItems.add(this.getControllerSlot());
            }
            this.processingLogic.setInputItems(inputItems.toArray(new ItemStack[0]));
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            result = foundResult;
        }
        return result;
    }

    @Override
    public boolean isInputSeparationEnabled() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }
}

