/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.AssemblyLineUtils;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.VoidProtectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEAssemblyLine
extends MTEExtendedPowerMultiBlockBase<MTEAssemblyLine>
implements ISurvivalConstructable {
    public ArrayList<MTEHatchDataAccess> mDataAccessHatches = new ArrayList();
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final String STRUCTURE_PIECE_LAST = "last";
    private static final IStructureDefinition<MTEAssemblyLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"~", "l", "G"}, {"g", "m", "g"}, {"b", "i", "b"}})).addShape("later", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"b", "I", "b"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"o", "i", "b"}})).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('l', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)9)).addElement('m', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5)).addElement('g', Glasses.chainAllGlasses()).addElement('e', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{HatchElement.Energy.newAny(16, 1, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)})).addElement('d', GTStructureUtility.buildHatchAdder(MTEAssemblyLine.class).atLeast(DataHatchElement.DataAccess).dot(2).casingIndex(42).allowOnly(ForgeDirection.NORTH).buildAndChain(GregTechAPI.sBlockCasings3, 10)).addElement('b', GTStructureUtility.buildHatchAdder(MTEAssemblyLine.class).atLeast(HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.Maintenance).casingIndex(16).dot(3).allowOnly(ForgeDirection.DOWN).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 16, 4)})).addElement('I', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{HatchElement.InputBus.newAny(16, 5, ForgeDirection.DOWN), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 16, 4)})).addElement('i', HatchElement.InputBus.newAny(16, 5, ForgeDirection.DOWN)).addElement('o', HatchElement.OutputBus.newAny(16, 4, ForgeDirection.DOWN)).build();

    public MTEAssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAssemblyLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAssemblyLine(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Assembling Line").addInfo("Controller block for the Assembling Line").addInfo("Used to make complex machine parts (LuV+)").addInfo("Does not make Assembler items").addInfo("Recipe tier is at most Energy Hatch tier + 1.").addSeparator().beginVariableStructureBlock(5, 16, 4, 4, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input Bus (last can be Output Bus), Solid Steel Machine Casing").addStructureInfo("Layer 2 - Borosilicate Glass(any)/Warded Glass/Reinforced Glass, Assembling Line Casing, Reinforced Glass").addStructureInfo("Layer 3 - Grate Machine Casing, Assembler Machine Casing, Grate Machine Casing").addStructureInfo("Layer 4 - Empty, Solid Steel Machine Casing, Empty").addStructureInfo("Up to 16 repeating slices, each one allows for 1 more item in recipes").addController("Either Grate on layer 3 of the first slice").addEnergyHatch("Any layer 4 casing", 1).addMaintenanceHatch("Any layer 1 casing", 3).addInputBus("As specified on layer 1", 4, 5).addInputHatch("Any layer 1 casing", 3).addOutputBus("Replaces Input Bus on final slice or on any solid steel casing on layer 1", 4).addOtherStructurePart("Data Access Hatch", "Optional, next to controller", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.assemblylineVisualRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Start ALine recipe check");
        }
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_DATA_STICKS;
        ArrayList<ItemStack> tDataStickList = this.getDataItems(2);
        if (tDataStickList.isEmpty()) {
            return result;
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Stick accepted, " + tDataStickList.size() + " Data Sticks found");
        }
        int[] tStacks = new int[]{};
        FluidStack[] tFluids = new FluidStack[]{};
        long averageVoltage = this.getAverageInputVoltage();
        int maxParallel = 1;
        long maxAmp = this.getMaxInputAmps();
        Map<GTUtility.ItemId, ItemStack> inputsFromME = this.getStoredInputsFromME();
        Map<Fluid, FluidStack> fluidsFromME = this.getStoredFluidsFromME();
        for (ItemStack tDataStick : tDataStickList) {
            int originalMaxParallel;
            AssemblyLineUtils.LookupResult tLookupResult = AssemblyLineUtils.findAssemblyLineRecipeFromDataStick(tDataStick, false);
            if (tLookupResult.getType() == AssemblyLineUtils.LookupResultType.INVALID_STICK) {
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            GTRecipe.RecipeAssemblyLine tRecipe = tLookupResult.getRecipe();
            if (tLookupResult.getType() != AssemblyLineUtils.LookupResultType.VALID_STACK_AND_VALID_HASH && (tRecipe = AssemblyLineUtils.processDataStick(tDataStick)) == null) {
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            if ((long)tRecipe.mEUt > averageVoltage * 4L) {
                result = CheckRecipeResultRegistry.insufficientPower(tRecipe.mEUt);
                continue;
            }
            if ((long)tRecipe.mEUt > maxAmp * averageVoltage) {
                result = CheckRecipeResultRegistry.insufficientPower(tRecipe.mEUt);
                continue;
            }
            if (this.mInputBusses.size() < tRecipe.mInputs.length || this.mInputHatches.size() < tRecipe.mFluidInputs.length) {
                if (GTValues.D1) {
                    GTMod.GT_FML_LOGGER.info("Not enough sources: Need ({}, {}), has ({}, {})", new Object[]{this.mInputBusses.size(), tRecipe.mInputs.length, this.mInputHatches.size(), tRecipe.mFluidInputs.length});
                }
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            maxParallel = originalMaxParallel = 1;
            OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt(tRecipe.mEUt).setEUt(averageVoltage).setAmperage(maxAmp).setAmperageOC(this.mEnergyHatches.size() != 1).setDuration(tRecipe.mDuration).setParallel(originalMaxParallel);
            double tickTimeAfterOC = calculator.calculateDurationUnderOneTick();
            if (tickTimeAfterOC < 1.0) {
                maxParallel = GTUtility.safeInt((long)((double)maxParallel / tickTimeAfterOC), 0);
            }
            int maxParallelBeforeBatchMode = maxParallel;
            if (this.isBatchModeEnabled()) {
                maxParallel = GTUtility.safeInt((long)maxParallel * (long)this.getMaxBatchSize(), 0);
            }
            if (this.protectsExcessItem()) {
                VoidProtectionHelper voidProtectionHelper = new VoidProtectionHelper();
                voidProtectionHelper.setMachine(this).setItemOutputs(new ItemStack[]{tRecipe.mOutput}).setMaxParallel(maxParallel).build();
                maxParallel = Math.min(voidProtectionHelper.getMaxParallel(), maxParallel);
                if (voidProtectionHelper.isItemFull()) {
                    result = CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
                    continue;
                }
            }
            int currentParallel = maxParallel;
            int[] itemConsumptions = GTRecipe.RecipeAssemblyLine.getItemConsumptionAmountArray(this.mInputBusses, tRecipe);
            if (itemConsumptions == null || itemConsumptions.length == 0) {
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            if ((currentParallel = (int)GTRecipe.RecipeAssemblyLine.maxParallelCalculatedByInputItems(this.mInputBusses, currentParallel, itemConsumptions, inputsFromME)) <= 0) {
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            tStacks = itemConsumptions;
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("All Items accepted");
            }
            if (tRecipe.mFluidInputs.length > 0) {
                if ((currentParallel = (int)GTRecipe.RecipeAssemblyLine.maxParallelCalculatedByInputFluids(this.mInputHatches, currentParallel, tRecipe.mFluidInputs, fluidsFromME)) <= 0) {
                    result = CheckRecipeResultRegistry.NO_RECIPE;
                    continue;
                }
                tFluids = tRecipe.mFluidInputs;
            }
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("All fluids accepted");
            }
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("Check overclock");
            }
            int currentParallelBeforeBatchMode = Math.min(currentParallel, maxParallelBeforeBatchMode);
            calculator.setCurrentParallel(currentParallelBeforeBatchMode).calculate();
            double batchMultiplierMax = 1.0;
            if (currentParallel > maxParallelBeforeBatchMode && calculator.getDuration() < this.getMaxBatchSize()) {
                batchMultiplierMax = (double)this.getMaxBatchSize() / (double)calculator.getDuration();
                batchMultiplierMax = Math.min(batchMultiplierMax, (double)currentParallel / (double)maxParallelBeforeBatchMode);
            }
            int finalParallel = (int)(batchMultiplierMax * (double)maxParallelBeforeBatchMode);
            this.lEUt = calculator.getConsumption();
            this.mMaxProgresstime = (int)((double)calculator.getDuration() * batchMultiplierMax);
            maxParallel = finalParallel;
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("Find available recipe");
            }
            result = CheckRecipeResultRegistry.SUCCESSFUL;
            this.mOutputItems = new ItemStack[]{tRecipe.mOutput.func_77946_l()};
            this.mOutputItems[0].field_77994_a = (int)((double)this.mOutputItems[0].field_77994_a * ((double)maxParallelBeforeBatchMode * batchMultiplierMax));
            break;
        }
        if (!result.wasSuccessful()) {
            return result;
        }
        if (tStacks.length == 0 || maxParallel <= 0) {
            return CheckRecipeResultRegistry.INTERNAL_ERROR;
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("All checked start consuming inputs");
        }
        GTRecipe.RecipeAssemblyLine.consumeInputItems(this.mInputBusses, maxParallel, tStacks, inputsFromME);
        GTRecipe.RecipeAssemblyLine.consumeInputFluids(this.mInputHatches, maxParallel, tFluids, fluidsFromME);
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Recipe successful");
        }
        return result;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        for (MTEHatchDataAccess hatch_dataAccess : this.mDataAccessHatches) {
            hatch_dataAccess.setActive(true);
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public IStructureDefinition<MTEAssemblyLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mDataAccessHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 1, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 16; ++i) {
            if (!this.checkPiece(STRUCTURE_PIECE_LATER, leftToRight ? -i : i, 1, 0)) {
                return false;
            }
            if (this.mOutputBusses.isEmpty()) continue;
            return !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1 && this.mDataAccessHatches.size() <= 1;
        }
        return false;
    }

    private static boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GTUtility.isStackValid(this.mInventory[1]) && MTEAssemblyLine.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (MTEHatchDataAccess tHatch : GTUtility.validMTEList(this.mDataAccessHatches)) {
            rList.addAll(tHatch.getInventoryItems(stack -> MTEAssemblyLine.isCorrectDataItem(stack, state)));
        }
        return rList;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchDataAccess) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((MTEHatchDataAccess)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 1, 0);
        int tLength = Math.min(stackSize.field_77994_a + 1, 16);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LATER, stackSize, hintsOnly, -i, 1, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivialBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 0, 1, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        int tLength = Math.min(stackSize.field_77994_a + 1, 16);
        for (int i = 1; i < tLength - 1; ++i) {
            build = this.survivialBuildPiece(STRUCTURE_PIECE_LATER, stackSize, -i, 1, 0, elementBudget, env, false, true);
            if (build < 0) continue;
            return build;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_LAST, stackSize, 1 - tLength, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public Set<VoidingMode> getAllowedVoidingModes() {
        return VoidingMode.ITEM_ONLY_MODES;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    private static enum DataHatchElement implements IHatchElement<MTEAssemblyLine>
    {
        DataAccess;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchDataAccess.class);
        }

        @Override
        public IGTHatchAdder<MTEAssemblyLine> adder() {
            return MTEAssemblyLine::addDataAccessToMachineList;
        }

        @Override
        public long count(MTEAssemblyLine t) {
            return t.mDataAccessHatches.size();
        }
    }
}

