/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.GTMod;
import gregtech.api.interfaces.ITexture;
import gregtech.api.logic.ModelRenderLogic;
import gregtech.api.logic.interfaces.ModelRenderLogicHost;
import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.common.render.MultiTileBasicRender;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MultiTileRenderer
implements ISimpleBlockRenderingHandler {
    private final int renderID = RenderingRegistry.getNextAvailableRenderId();
    public static MultiTileRenderer INSTANCE;

    public MultiTileRenderer() {
        INSTANCE = this;
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof MultiTileEntityBlock)) {
            return;
        }
        MultiTileEntityBlock muteBlock = (MultiTileEntityBlock)block;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        MultiTileEntityRegistry registry = muteBlock.getRegistry();
        if (registry == null) {
            return;
        }
        MultiTileEntityClassContainer classContainer = registry.getClassContainer(metadata);
        if (classContainer == null) {
            return;
        }
        renderer.func_147775_a((Block)muteBlock);
        block8: for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            ITexture texture = classContainer.getReferenceTileEntity().getTexture(side);
            if (texture == null) continue;
            switch (side) {
                case DOWN: {
                    MultiTileRenderer.renderYNegative(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case UP: {
                    MultiTileRenderer.renderYPositive(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case WEST: {
                    MultiTileRenderer.renderXNegative(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case EAST: {
                    MultiTileRenderer.renderXPositive(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case NORTH: {
                    MultiTileRenderer.renderZNegative(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
                case SOUTH: {
                    MultiTileRenderer.renderZPositive(null, renderer, 0, 0, 0, block, texture, side);
                    continue block8;
                }
            }
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IMultiBlockController controller;
        ModelRenderLogicHost modelEntity;
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity == null) {
            return false;
        }
        renderer.field_147863_w = Minecraft.func_71379_u() && GTMod.gregtechproxy.mRenderTileAmbientOcclusion;
        renderer.field_147844_c = false;
        if (entity instanceof ModelRenderLogicHost && (modelEntity = (ModelRenderLogicHost)entity).shouldRenderModel()) {
            ModelRenderLogic renderLogic = modelEntity.getRenderLogic();
            return true;
        }
        if (!(entity instanceof MultiTileBasicRender)) {
            return false;
        }
        MultiTileBasicRender renderedEntity = (MultiTileBasicRender)entity;
        if (entity instanceof MultiBlockPart && (controller = ((MultiBlockPart)entity).getTarget(false)) instanceof ModelRenderLogicHost && ((ModelRenderLogicHost)((Object)controller)).shouldRenderModel()) {
            return false;
        }
        block8: for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            ITexture texture = renderedEntity.getTexture(side);
            if (texture == null) continue;
            switch (side) {
                case DOWN: {
                    MultiTileRenderer.renderYNegative(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case UP: {
                    MultiTileRenderer.renderYPositive(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case WEST: {
                    MultiTileRenderer.renderXNegative(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case EAST: {
                    MultiTileRenderer.renderXPositive(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case NORTH: {
                    MultiTileRenderer.renderZNegative(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
                case SOUTH: {
                    MultiTileRenderer.renderZPositive(world, renderer, x, y, z, block, texture, side);
                    continue block8;
                }
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }

    private static void renderYNegative(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y - 1, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y - 1, z));
        }
        texture.renderYNeg(renderer, block, x, y, z);
    }

    private static void renderZNegative(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y, z - 1, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z - 1));
        }
        texture.renderZNeg(renderer, block, x, y, z);
    }

    private static void renderXNegative(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x - 1, y, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x - 1, y, z));
        }
        texture.renderXNeg(renderer, block, x, y, z);
    }

    private static void renderYPositive(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y + 1, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y + 1, z));
        }
        texture.renderYPos(renderer, block, x, y, z);
    }

    private static void renderXPositive(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x + 1, y, z, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x + 1, y, z));
        }
        texture.renderXPos(renderer, block, x, y, z);
    }

    private static void renderZPositive(IBlockAccess world, RenderBlocks renderer, int x, int y, int z, Block block, ITexture texture, ForgeDirection side) {
        if (world != null) {
            if (!block.func_149646_a(world, x, y, z + 1, side.ordinal())) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z + 1));
        }
        texture.renderZPos(renderer, block, x, y, z);
    }
}

