/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTRecipe;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class OverclockCalculator {
    private long recipeEUt = 0L;
    private long machineVoltage = 0L;
    private long machineAmperage = 1L;
    private int duration = 0;
    private Supplier<Double> durationUnderOneTickSupplier;
    private int parallel = 1;
    private double eutDiscount = 1.0;
    private double speedBoost = 1.0;
    private double eutIncreasePerOC = 4.0;
    private Function<Integer, Double> eutIncreasePerOCSupplier = this.getDefaultEutIncreasePerOCSupplier();
    private double durationDecreasePerOC = 2.0;
    private Function<Integer, Double> durationDecreasePerOCSupplier = this.getDefaultDurationDecreasePerOCSupplier();
    private boolean hasAtLeastOneSupplierBeenSet;
    private boolean oneTickDiscount;
    private boolean amperageOC;
    private boolean limitOverclocks;
    private int maxOverclocks;
    private int overclockCount;
    private boolean noOverclock;
    private int currentParallel;
    private int recipeHeat = 0;
    private int machineHeat = 0;
    private double durationDecreasePerHeatOC = 4.0;
    private boolean heatOC;
    private boolean heatDiscount;
    private double heatDiscountExponent = 0.95;
    private boolean calculated;
    private int calculatedDuration;
    private long calculatedConsumption;
    private static final int HEAT_DISCOUNT_THRESHOLD = 900;
    private static final int HEAT_PERFECT_OVERCLOCK_THRESHOLD = 1800;
    private static final double LOG2 = Math.log(2.0);

    public static OverclockCalculator ofNoOverclock(@Nonnull GTRecipe recipe) {
        return OverclockCalculator.ofNoOverclock(recipe.mEUt, recipe.mDuration);
    }

    public static OverclockCalculator ofNoOverclock(long eut, int duration) {
        return new OverclockCalculator().setRecipeEUt(eut).setDuration(duration).setEUt(eut).setNoOverclock(true);
    }

    @Nonnull
    public OverclockCalculator setRecipeEUt(long recipeEUt) {
        this.recipeEUt = recipeEUt;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUt(long machineVoltage) {
        this.machineVoltage = machineVoltage;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public OverclockCalculator setAmperage(long machineAmperage) {
        this.machineAmperage = machineAmperage;
        return this;
    }

    @Nonnull
    public OverclockCalculator enablePerfectOC() {
        this.durationDecreasePerOC = 4.0;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatOC(boolean heatOC) {
        this.heatOC = heatOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatDiscount(boolean heatDiscount) {
        this.heatDiscount = heatDiscount;
        return this;
    }

    @Nonnull
    public OverclockCalculator setRecipeHeat(int recipeHeat) {
        this.recipeHeat = recipeHeat;
        return this;
    }

    @Nonnull
    public OverclockCalculator setMachineHeat(int machineHeat) {
        this.machineHeat = machineHeat;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUtDiscount(double aEUtDiscount) {
        this.eutDiscount = aEUtDiscount;
        return this;
    }

    @Nonnull
    public OverclockCalculator setSpeedBoost(double aSpeedBoost) {
        this.speedBoost = aSpeedBoost;
        return this;
    }

    @Nonnull
    public OverclockCalculator setParallel(int aParallel) {
        this.parallel = aParallel;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatDiscountMultiplier(double heatDiscountExponent) {
        this.heatDiscountExponent = heatDiscountExponent;
        return this;
    }

    @Nonnull
    public OverclockCalculator setHeatPerfectOC(double heatPerfectOC) {
        if (heatPerfectOC <= 0.0) {
            throw new IllegalArgumentException("Heat OC can't be a negative number or zero");
        }
        this.durationDecreasePerHeatOC = heatPerfectOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setEUtIncreasePerOC(double eutIncreasePerOC) {
        if (eutIncreasePerOC <= 0.0) {
            throw new IllegalArgumentException("EUt increase can't be a negative number or zero");
        }
        this.eutIncreasePerOC = eutIncreasePerOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationDecreasePerOC(double durationDecreasePerOC) {
        if (durationDecreasePerOC <= 0.0) {
            throw new IllegalArgumentException("Duration decrease can't be a negative number or zero");
        }
        this.durationDecreasePerOC = durationDecreasePerOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setOneTickDiscount(boolean oneTickDiscount) {
        this.oneTickDiscount = oneTickDiscount;
        return this;
    }

    @Nonnull
    public OverclockCalculator limitOverclockCount(int maxOverclocks) {
        this.limitOverclocks = true;
        this.maxOverclocks = maxOverclocks;
        return this;
    }

    @Nonnull
    public OverclockCalculator setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this;
    }

    @Nonnull
    public OverclockCalculator setDurationUnderOneTickSupplier(Supplier<Double> supplier) {
        this.durationUnderOneTickSupplier = supplier;
        return this;
    }

    @Nonnull
    public OverclockCalculator setNoOverclock(boolean noOverclock) {
        this.noOverclock = noOverclock;
        return this;
    }

    public OverclockCalculator setEutIncreasePerOCSupplier(Function<Integer, Double> eutIncreasePerOCSupplier) {
        this.eutIncreasePerOCSupplier = eutIncreasePerOCSupplier;
        this.hasAtLeastOneSupplierBeenSet = true;
        return this;
    }

    public OverclockCalculator setDurationDecreasePerOCSupplier(Function<Integer, Double> durationDecreasePerOCSupplier) {
        this.durationDecreasePerOCSupplier = durationDecreasePerOCSupplier;
        this.hasAtLeastOneSupplierBeenSet = true;
        return this;
    }

    public OverclockCalculator setCurrentParallel(int currentParallel) {
        this.currentParallel = currentParallel;
        this.parallel = Math.min(this.parallel, currentParallel);
        return this;
    }

    @Nonnull
    public OverclockCalculator calculate() {
        if (this.calculated) {
            throw new IllegalStateException("Tried to calculate overclocks twice");
        }
        this.calculateOverclock();
        this.calculated = true;
        return this;
    }

    private void calculateOverclock() {
        double durationInDouble = this.durationUnderOneTickSupplier != null ? this.durationUnderOneTickSupplier.get() : (double)this.duration * this.speedBoost;
        this.calculatedConsumption = this.recipeEUt;
        double heatDiscountMultiplier = this.calculateHeatDiscountMultiplier();
        this.currentParallel = Math.max(this.currentParallel, this.parallel);
        if (this.noOverclock) {
            this.calculatedConsumption = this.calculateFinalRecipeEUt(heatDiscountMultiplier);
            this.calculatedDuration = (int)Math.ceil(durationInDouble);
            return;
        }
        double requiredUnderOneTickMultiplier = durationInDouble * (double)this.currentParallel / (double)this.parallel;
        if (this.hasAtLeastOneSupplierBeenSet) {
            double currentEutIncrease = this.eutIncreasePerOCSupplier.apply(this.overclockCount + 1);
            double currentDurationDecrease = this.durationDecreasePerOCSupplier.apply(this.overclockCount + 1);
            double machinePower = this.calculateMachinePower();
            double currentConsumption = this.calculateRecipePower(heatDiscountMultiplier);
            double currentUnderOneTickMultiplier = 1.0;
            while (machinePower > currentConsumption * currentEutIncrease && requiredUnderOneTickMultiplier > currentUnderOneTickMultiplier && (!this.limitOverclocks || this.overclockCount < this.maxOverclocks)) {
                currentUnderOneTickMultiplier *= currentDurationDecrease;
                currentConsumption *= currentEutIncrease;
                durationInDouble /= currentDurationDecrease;
                ++this.overclockCount;
                currentEutIncrease = this.eutIncreasePerOCSupplier.apply(this.overclockCount + 1);
                currentDurationDecrease = this.durationDecreasePerOCSupplier.apply(this.overclockCount + 1);
            }
            this.calculatedConsumption = (long)Math.max(currentConsumption, 1.0);
            this.calculatedDuration = (int)Math.max(durationInDouble, 1.0);
        } else {
            double recipePowerTier = this.calculateRecipePowerTier(heatDiscountMultiplier);
            double machinePowerTier = this.calculateMachinePowerTier();
            int maxOverclockCount = this.calculateAmountOfOverclocks(machinePowerTier, recipePowerTier);
            if (this.limitOverclocks) {
                maxOverclockCount = Math.min(this.maxOverclocks, maxOverclockCount);
            }
            if (!this.amperageOC) {
                maxOverclockCount = Math.min(maxOverclockCount, this.calculateRecipeToMachineVoltageDifference());
            }
            this.overclockCount = this.calculateAmountOfNeededOverclocks(maxOverclockCount, requiredUnderOneTickMultiplier);
            this.overclockCount = Math.max(this.overclockCount, 0);
            int heatOverclockCount = Math.min(this.calculateMaxAmountOfHeatOverclocks(), this.overclockCount);
            this.calculatedConsumption = (long)Math.floor((double)this.recipeEUt * Math.pow(this.eutIncreasePerOC, this.overclockCount));
            durationInDouble /= Math.pow(this.durationDecreasePerHeatOC, heatOverclockCount) * Math.pow(this.durationDecreasePerOC, this.overclockCount - heatOverclockCount);
            if (this.oneTickDiscount) {
                this.calculatedConsumption = (long)Math.floor((double)this.calculatedConsumption / Math.pow(this.durationDecreasePerOC, maxOverclockCount - this.overclockCount));
                this.calculatedConsumption = Math.max(this.calculatedConsumption, 1L);
            }
            this.calculatedConsumption = this.calculateFinalRecipeEUt(heatDiscountMultiplier);
            this.calculatedDuration = (int)Math.max(durationInDouble, 1.0);
        }
    }

    private double calculateRecipePower(double heatDiscountMultiplier) {
        return (double)(this.recipeEUt * (long)this.parallel) * this.eutDiscount * heatDiscountMultiplier;
    }

    private double calculateRecipePowerTier(double heatDiscountMultiplier) {
        return this.calculatePowerTier(this.calculateRecipePower(heatDiscountMultiplier));
    }

    private double calculateMachinePower() {
        return this.machineVoltage * (this.amperageOC ? this.machineAmperage : Math.min(this.machineAmperage, (long)this.parallel));
    }

    private double calculateMachinePowerTier() {
        return this.calculatePowerTier(this.calculateMachinePower());
    }

    private int calculateRecipeToMachineVoltageDifference() {
        return (int)(Math.ceil(this.calculatePowerTier(this.machineVoltage)) - Math.ceil(this.calculatePowerTier(this.recipeEUt)));
    }

    private double calculatePowerTier(double voltage) {
        return 1.0 + Math.max(0.0, Math.log(voltage) / LOG2 - 5.0) / 2.0;
    }

    private long calculateFinalRecipeEUt(double heatDiscountMultiplier) {
        return (long)Math.ceil((double)this.calculatedConsumption * this.eutDiscount * heatDiscountMultiplier * (double)this.parallel);
    }

    private int calculateMaxAmountOfHeatOverclocks() {
        return this.heatOC ? (this.machineHeat - this.recipeHeat) / 1800 : 0;
    }

    private int calculateAmountOfOverclocks(double machinePowerTier, double recipePowerTier) {
        return (int)(machinePowerTier - recipePowerTier);
    }

    private int calculateAmountOfNeededOverclocks(int maxOverclockCount, double requiredUnderOneTickMultiplier) {
        int neededHeatOC = (int)Math.min((double)this.calculateMaxAmountOfHeatOverclocks(), Math.ceil(Math.log(requiredUnderOneTickMultiplier) / Math.log(this.durationDecreasePerHeatOC)));
        neededHeatOC = Math.max(neededHeatOC, 0);
        int neededNormalOC = (int)Math.ceil((Math.log(requiredUnderOneTickMultiplier) - Math.log(this.durationDecreasePerHeatOC) * (double)neededHeatOC) / Math.log(this.durationDecreasePerOC));
        neededNormalOC = Math.max(neededNormalOC, 0);
        return Math.min(maxOverclockCount, neededHeatOC + neededNormalOC);
    }

    private double calculateHeatDiscountMultiplier() {
        int heatDiscounts = this.heatDiscount ? (this.machineHeat - this.recipeHeat) / 900 : 0;
        return Math.pow(this.heatDiscountExponent, heatDiscounts);
    }

    public long getConsumption() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get consumption before calculating");
        }
        return this.calculatedConsumption;
    }

    public int getDuration() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get duration before calculating");
        }
        return this.calculatedDuration;
    }

    public int getPerformedOverclocks() {
        if (!this.calculated) {
            throw new IllegalStateException("Tried to get performed overclocks before calculating");
        }
        return this.overclockCount;
    }

    public boolean getCalculationStatus() {
        return this.calculated;
    }

    public double calculateDurationUnderOneTick() {
        double durationInDouble;
        double d = durationInDouble = this.durationUnderOneTickSupplier != null ? this.durationUnderOneTickSupplier.get() : (double)this.duration * this.speedBoost;
        if (this.noOverclock) {
            return durationInDouble;
        }
        double heatDiscountMultiplier = this.calculateHeatDiscountMultiplier();
        if (this.hasAtLeastOneSupplierBeenSet) {
            int overclockCount = 0;
            double currentEutIncrease = this.eutIncreasePerOCSupplier.apply(overclockCount + 1);
            double currentDurationDecrease = this.durationDecreasePerOCSupplier.apply(overclockCount + 1);
            double machinePower = this.calculateMachinePower();
            double recipePower = this.calculateRecipePower(heatDiscountMultiplier);
            while (machinePower > recipePower * currentEutIncrease && (!this.limitOverclocks || overclockCount < this.maxOverclocks)) {
                recipePower *= currentEutIncrease;
                durationInDouble /= currentDurationDecrease;
                currentEutIncrease = this.eutIncreasePerOCSupplier.apply(++overclockCount + 1);
                currentDurationDecrease = this.durationDecreasePerOCSupplier.apply(overclockCount + 1);
            }
        } else {
            int maxOverclockCount = this.calculateAmountOfOverclocks(this.calculateMachinePowerTier(), this.calculateRecipePowerTier(heatDiscountMultiplier));
            if (this.limitOverclocks) {
                maxOverclockCount = Math.min(this.maxOverclocks, maxOverclockCount);
            }
            int heatOverclocks = Math.min(this.calculateMaxAmountOfHeatOverclocks(), maxOverclockCount);
            durationInDouble /= Math.pow(this.durationDecreasePerOC, maxOverclockCount - heatOverclocks) * Math.pow(this.durationDecreasePerHeatOC, heatOverclocks);
        }
        return durationInDouble;
    }

    private Function<Integer, Double> getDefaultEutIncreasePerOCSupplier() {
        return overclockCount -> this.eutIncreasePerOC;
    }

    private Function<Integer, Double> getDefaultDurationDecreasePerOCSupplier() {
        return overclockCount -> overclockCount <= this.calculateMaxAmountOfHeatOverclocks() ? this.durationDecreasePerHeatOC : this.durationDecreasePerOC;
    }
}

