/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class MultiblockTooltipBuilder {
    private static final String TAB = "   ";
    private static final String COLON = ": ";
    private static final String SEPARATOR = ", ";
    private final List<String> iLines = new LinkedList<String>();
    private final List<String> sLines = new LinkedList<String>();
    private final List<String> hLines = new LinkedList<String>();
    private final SetMultimap<Integer, String> hBlocks = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
    private String[] iArray;
    private String[] sArray;
    private String[] hArray;
    private static final String TT_machineType = StatCollector.func_74838_a((String)"GT5U.MBTT.MachineType");
    private static final String TT_dimensions = StatCollector.func_74838_a((String)"GT5U.MBTT.Dimensions");
    private static final String TT_hollow = StatCollector.func_74838_a((String)"GT5U.MBTT.Hollow");
    private static final String TT_structure = StatCollector.func_74838_a((String)"GT5U.MBTT.Structure");
    private static final String TT_controller = StatCollector.func_74838_a((String)"GT5U.MBTT.Controller");
    private static final String TT_minimum = StatCollector.func_74838_a((String)"GT5U.MBTT.Minimum");
    private static final String TT_tiered = StatCollector.func_74838_a((String)"GT5U.MBTT.Tiered");
    private static final String TT_maintenancehatch = StatCollector.func_74838_a((String)"GT5U.MBTT.MaintenanceHatch");
    private static final String TT_energyhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.EnergyHatch");
    private static final String TT_dynamohatch = StatCollector.func_74838_a((String)"GT5U.MBTT.DynamoHatch");
    private static final String TT_mufflerhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.MufflerHatch");
    private static final String TT_inputbus = StatCollector.func_74838_a((String)"GT5U.MBTT.InputBus");
    private static final String TT_inputhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.InputHatch");
    private static final String TT_outputbus = StatCollector.func_74838_a((String)"GT5U.MBTT.OutputBus");
    private static final String TT_outputhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.OutputHatch");
    private static final String TT_causes = StatCollector.func_74838_a((String)"GT5U.MBTT.Causes");
    private static final String TT_pps = StatCollector.func_74838_a((String)"GT5U.MBTT.PPS");
    private static final String TT_hold = StatCollector.func_74838_a((String)"GT5U.MBTT.Hold");
    private static final String TT_todisplay = StatCollector.func_74838_a((String)"GT5U.MBTT.Display");
    private static final String TT_structurehint = StatCollector.func_74838_a((String)"GT5U.MBTT.StructureHint");
    private static final String TT_mod = StatCollector.func_74838_a((String)"GT5U.MBTT.Mod");
    private static final String TT_air = StatCollector.func_74838_a((String)"GT5U.MBTT.Air");
    private static final String[] TT_dots = (String[])IntStream.range(0, 16).mapToObj(i -> StatCollector.func_74838_a((String)("structurelib.blockhint." + i + ".name"))).toArray(String[]::new);

    public MultiblockTooltipBuilder() {
        this.hBlocks.put((Object)13, (Object)TT_air);
    }

    public MultiblockTooltipBuilder addMachineType(String machine) {
        this.iLines.add(TT_machineType + COLON + EnumChatFormatting.YELLOW + machine + EnumChatFormatting.RESET);
        return this;
    }

    public MultiblockTooltipBuilder addInfo(String info) {
        this.iLines.add(info);
        return this;
    }

    public MultiblockTooltipBuilder addInfoAll(String ... infoStrings) {
        for (String str : infoStrings) {
            this.iLines.add(str);
        }
        return this;
    }

    public MultiblockTooltipBuilder addSeparator() {
        this.iLines.add("-----------------------------------------");
        return this;
    }

    public MultiblockTooltipBuilder addPollutionAmount(int pollution) {
        this.iLines.add(TT_causes + COLON + EnumChatFormatting.DARK_PURPLE + pollution + " " + EnumChatFormatting.GRAY + TT_pps);
        return this;
    }

    public MultiblockTooltipBuilder beginStructureBlock(int w, int h, int l, boolean hollow) {
        this.sLines.add(EnumChatFormatting.WHITE + TT_dimensions + COLON + EnumChatFormatting.GOLD + w + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + h + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + l + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.GOLD + "W" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "H" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "L" + EnumChatFormatting.GRAY + ") " + EnumChatFormatting.RED + (hollow ? EnumChatFormatting.RED + TT_hollow : ""));
        this.sLines.add(EnumChatFormatting.WHITE + TT_structure + COLON);
        return this;
    }

    public MultiblockTooltipBuilder beginVariableStructureBlock(int wmin, int wmax, int hmin, int hmax, int lmin, int lmax, boolean hollow) {
        this.sLines.add(EnumChatFormatting.WHITE + TT_dimensions + COLON + EnumChatFormatting.GOLD + wmin + (wmin != wmax ? "-" + wmax : "") + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + hmin + (hmin != hmax ? "-" + hmax : "") + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + lmin + (lmin != lmax ? "-" + lmax : "") + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.GOLD + "W" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "H" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "L" + EnumChatFormatting.GRAY + ") " + (hollow ? EnumChatFormatting.RED + TT_hollow : ""));
        this.sLines.add(EnumChatFormatting.WHITE + TT_structure + COLON);
        return this;
    }

    public MultiblockTooltipBuilder addController(String info) {
        this.sLines.add(TAB + EnumChatFormatting.WHITE + TT_controller + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    @Deprecated
    public MultiblockTooltipBuilder addCasingInfo(String casingName, int minCount) {
        return this.addCasingInfoMin(casingName, minCount, false);
    }

    public MultiblockTooltipBuilder addCasingInfoExactly(String casingName, int count, boolean isTiered) {
        return this.addCasingInfoExactlyColored(casingName, EnumChatFormatting.GRAY, count, EnumChatFormatting.GOLD, isTiered);
    }

    public MultiblockTooltipBuilder addCasingInfoExactlyColored(String casingName, EnumChatFormatting textColor, int count, EnumChatFormatting countColor, boolean isTiered) {
        this.sLines.add(countColor + TAB + count + "x " + EnumChatFormatting.RESET + textColor + casingName + (isTiered ? " " + TT_tiered : ""));
        return this;
    }

    public MultiblockTooltipBuilder addCasingInfoMin(String casingName, int minCount, boolean isTiered) {
        return this.addCasingInfoMinColored(casingName, EnumChatFormatting.GRAY, minCount, EnumChatFormatting.GOLD, isTiered);
    }

    public MultiblockTooltipBuilder addCasingInfoMinColored(String casingName, EnumChatFormatting textColor, int minCount, EnumChatFormatting countColor, boolean isTiered) {
        this.sLines.add(countColor + TAB + minCount + "x " + EnumChatFormatting.RESET + textColor + casingName + " " + TT_minimum + (isTiered ? " " + TT_tiered : ""));
        return this;
    }

    public MultiblockTooltipBuilder addCasingInfoRange(String casingName, int minCount, int maxCount, boolean isTiered) {
        return this.addCasingInfoRangeColored(casingName, EnumChatFormatting.GRAY, minCount, maxCount, EnumChatFormatting.GOLD, isTiered);
    }

    public MultiblockTooltipBuilder addCasingInfoRangeColored(String casingName, EnumChatFormatting textColor, int minCount, int maxCount, EnumChatFormatting countColor, boolean isTiered) {
        this.sLines.add(countColor + TAB + minCount + "x" + EnumChatFormatting.GRAY + " - " + countColor + maxCount + "x " + EnumChatFormatting.RESET + textColor + casingName + (isTiered ? " " + TT_tiered : ""));
        return this;
    }

    public MultiblockTooltipBuilder addOtherStructurePart(String name, String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + name + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addMaintenanceHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_maintenancehatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addMufflerHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_mufflerhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addEnergyHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_energyhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addDynamoHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_dynamohatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addInputBus(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputbus + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addInputHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addOutputBus(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputbus + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addOutputHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addOtherStructurePart(String name, String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + name + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)name);
        }
        return this;
    }

    public MultiblockTooltipBuilder addMaintenanceHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_maintenancehatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_maintenancehatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addMufflerHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_mufflerhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_mufflerhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addEnergyHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_energyhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_energyhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addDynamoHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_dynamohatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_dynamohatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addInputBus(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputbus + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_inputbus);
        }
        return this;
    }

    public MultiblockTooltipBuilder addInputHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_inputhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addOutputBus(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputbus + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_outputbus);
        }
        return this;
    }

    public MultiblockTooltipBuilder addOutputHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_outputhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addStructureInfo(String info) {
        this.sLines.add(TAB + info);
        return this;
    }

    public MultiblockTooltipBuilder addSubChannelUsage(String channel, String purpose) {
        this.sLines.add(TAB + StatCollector.func_74837_a((String)"GT5U.MBTT.subchannel", (Object[])new Object[]{channel, purpose}));
        return this;
    }

    public MultiblockTooltipBuilder addStructureHint(String info) {
        this.hLines.add(StatCollector.func_74838_a((String)info));
        return this;
    }

    public MultiblockTooltipBuilder addStructureHint(String name, int ... dots) {
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)StatCollector.func_74838_a((String)name));
        }
        return this;
    }

    public MultiblockTooltipBuilder toolTipFinisher(String mod) {
        this.iLines.add(TT_hold + " " + EnumChatFormatting.BOLD + "[LSHIFT]" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " " + TT_todisplay);
        this.iLines.add(TT_mod + COLON + EnumChatFormatting.GREEN + mod + EnumChatFormatting.GRAY);
        this.hLines.add(TT_structurehint);
        this.iArray = this.iLines.toArray(new String[0]);
        this.sArray = this.sLines.toArray(new String[0]);
        this.hArray = (String[])Stream.concat(this.hLines.stream(), this.hBlocks.asMap().entrySet().stream().map(e -> TT_dots[(Integer)e.getKey() - 1] + COLON + String.join((CharSequence)SEPARATOR, (Iterable)e.getValue()))).toArray(String[]::new);
        return this;
    }

    public String[] getInformation() {
        return this.iArray;
    }

    public String[] getStructureInformation() {
        return this.sArray;
    }

    public String[] getStructureHint() {
        return this.hArray;
    }
}

