/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.client.renderer.EICPistonVisualizer;
import bartworks.common.configs.Configuration;
import bartworks.common.loaders.ItemRegistry;
import bartworks.common.net.PacketEIC;
import bartworks.util.BWTooltipReference;
import bartworks.util.Coords;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.blocks.LudicrousBlocks;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTEElectricImplosionCompressor
extends MTEExtendedPowerMultiBlockBase<MTEElectricImplosionCompressor>
implements ISurvivalConstructable {
    private static final boolean pistonEnabled = !Configuration.multiblocks.disablePistonInEIC;
    private Boolean piston = true;
    private static final SoundResource sound = SoundResource.RANDOM_EXPLODE;
    private final ArrayList<ChunkCoordinates> chunkCoordinates = new ArrayList(5);
    private int mBlockTier = 0;
    private int mCasing;
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEElectricImplosionCompressor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cec", "ccc"}, {"ttt", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"nnn", "nnn", "nnn"}, {"nNn", "NNN", "nNn"}, {"nnn", "nnn", "nnn"}, {"t~t", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"CCC", "CeC", "CCC"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)4)})).addElement('t', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)1)).addElement('f', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)0)).addElement('n', StructureUtility.ofBlocksTiered(MTEElectricImplosionCompressor.tieredBlockConverter(), MTEElectricImplosionCompressor.getAllBlockTiers(), (Object)0, MTEElectricImplosionCompressor::setBlockTier, MTEElectricImplosionCompressor::getBlockTier)).addElement('C', GTStructureUtility.buildHatchAdder(MTEElectricImplosionCompressor.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(16).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)4)))).addElement('e', GTStructureUtility.buildHatchAdder(MTEElectricImplosionCompressor.class).atLeast(HatchElement.Energy.or(HatchElement.ExoticEnergy)).casingIndex(16).dot(2).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)4)))).addElement('N', (IStructureElement)new IStructureElement<MTEElectricImplosionCompressor>(){
        private final List<Pair<Block, Integer>> tiers = MTEElectricImplosionCompressor.getAllBlockTiers();

        public boolean check(MTEElectricImplosionCompressor te, World world, int x, int y, int z) {
            if (!te.piston.booleanValue() && !world.func_147437_c(x, y, z)) {
                return false;
            }
            if (te.piston.booleanValue()) {
                int candidateMeta;
                Block candidate = world.func_147439_a(x, y, z);
                return MTEElectricImplosionCompressor.getTierOfBlock(candidate, candidateMeta = world.func_72805_g(x, y, z)) != -1;
            }
            return true;
        }

        private Pair<Block, Integer> getTier(ItemStack trigger) {
            return this.tiers.get(Math.min(Math.max(trigger.field_77994_a, 1), this.tiers.size()) - 1);
        }

        public boolean spawnHint(MTEElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
            Pair<Block, Integer> tier = this.getTier(itemStack);
            if (te.piston.booleanValue()) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)((Block)tier.getKey()), (int)((Integer)tier.getValue()));
            }
            return true;
        }

        public boolean placeBlock(MTEElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
            Pair<Block, Integer> tier = this.getTier(itemStack);
            if (te.piston.booleanValue()) {
                world.func_147465_d(x, y, z, (Block)tier.getKey(), ((Integer)tier.getValue()).intValue(), 3);
            } else {
                world.func_147468_f(x, y, z);
            }
            return true;
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(MTEElectricImplosionCompressor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.createEmpty();
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(MTEElectricImplosionCompressor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return StructureUtility.isAir().survivalPlaceBlock((Object)t, world, x, y, z, trigger, env);
        }
    }).build();

    public MTEElectricImplosionCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEElectricImplosionCompressor(String aName) {
        super(aName);
    }

    public static List<Pair<Block, Integer>> getAllBlockTiers() {
        return new ArrayList<Pair<Block, Integer>>(){
            private static final long serialVersionUID = 8171991663102417651L;
            {
                this.add(Pair.of((Object)GregTechAPI.sBlockMetal5, (Object)2));
                if (Mods.Avaritia.isModLoaded()) {
                    this.add(Pair.of((Object)LudicrousBlocks.resource_block, (Object)1));
                }
                this.add(Pair.of((Object)GregTechAPI.sBlockMetal9, (Object)4));
                this.add(Pair.of((Object)GregTechAPI.sBlockMetal9, (Object)3));
                this.add(Pair.of((Object)GregTechAPI.sBlockMetal9, (Object)8));
            }
        };
    }

    public static ITierConverter<Integer> tieredBlockConverter() {
        return MTEElectricImplosionCompressor::getTierOfBlock;
    }

    private static int getTierOfBlock(Block block, int meta) {
        if (block == null) {
            return -1;
        }
        if (block == GregTechAPI.sBlockMetal5 && meta == 2) {
            return 1;
        }
        if (block == LudicrousBlocks.resource_block && meta == 1) {
            return 2;
        }
        if (block == GregTechAPI.sBlockMetal9) {
            int n;
            switch (meta) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 8: {
                    n = 5;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            return n;
        }
        return -1;
    }

    private void setBlockTier(int tier) {
        this.mBlockTier = tier;
    }

    private int getBlockTier() {
        return this.mBlockTier;
    }

    @Override
    public IStructureDefinition<MTEElectricImplosionCompressor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Implosion Compressor").addInfo("Explosions are fun").addInfo("Controller block for the Electric Implosion Compressor").addInfo("Uses electricity instead of Explosives").addInfo("Can parallel up to 4^(Tier - 1)").addInfo("Tier is determined by containment block").addInfo("Valid blocks: Neutronium, Infinity, Transcendent Metal, Spacetime, Universium").addInfo("Minimum allowed energy hatch tier is one below recipe tier").addInfo("Supports " + BWTooltipReference.TT + " energy hatches").addSeparator().beginStructureBlock(3, 9, 3, false).addController("Front 3rd layer center").addCasingInfoMin("Solid Steel Machine Casing", 8, false).addStructureInfo("Casings can be replaced with Explosion Warning Signs").addOtherStructurePart("Transformer-Winding Blocks", "Outer layer 2,3,7,8").addOtherStructurePart("Nickel-Zinc-Ferrite Blocks", "Inner layer 2,3,7,8").addOtherStructurePart("Containment Blocks", "Layer 4,5,6").addMaintenanceHatch("Any bottom casing", 1).addInputBus("Any bottom casing", 1).addInputHatch("Any bottom casing", 1).addOutputBus("Any bottom casing", 1).addEnergyHatch("Bottom middle and/or top middle", 2).toolTipFinisher(BWTooltipReference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.electricImplosionCompressorRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                long voltage = MTEElectricImplosionCompressor.this.getAverageInputVoltage();
                if ((long)recipe.mEUt > voltage * 4L) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTEElectricImplosionCompressor.this.getMaxInputEu()).setAmperage(1L);
            }
        }.setMaxParallelSupplier(() -> (int)Math.pow(4.0, Math.max(this.mBlockTier - 1, 0)));
    }

    private void updateChunkCoordinates() {
        this.chunkCoordinates.clear();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                int[] abc = new int[]{x, -2, z + 1};
                int[] xyz = new int[]{0, 0, 0};
                this.getExtendedFacing().getWorldOffset(abc, xyz);
                xyz[0] = xyz[0] + this.getBaseMetaTileEntity().getXCoord();
                xyz[1] = xyz[1] + this.getBaseMetaTileEntity().getYCoord();
                xyz[2] = xyz[2] + this.getBaseMetaTileEntity().getZCoord();
                this.chunkCoordinates.add(new ChunkCoordinates(xyz[0], xyz[1], xyz[2]));
            }
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.updateChunkCoordinates();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (pistonEnabled && aBaseMetaTileEntity.isActive() && aTick % 20L == 0L) {
            if (aBaseMetaTileEntity.isClientSide()) {
                this.animatePiston(aBaseMetaTileEntity);
            } else if (aBaseMetaTileEntity.hasMufflerUpgrade()) {
                GTValues.NW.sendPacketToAllPlayersInRange(aBaseMetaTileEntity.getWorld(), new PacketEIC(new Coords(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()), true), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
            }
        }
    }

    @Override
    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        super.setExtendedFacing(newExtendedFacing);
        this.updateChunkCoordinates();
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public void stopMachine() {
        this.resetPiston(this.mBlockTier);
        super.stopMachine();
    }

    private void resetPiston(int tier) {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (!this.piston.booleanValue()) {
            List<Pair<Block, Integer>> tiers = MTEElectricImplosionCompressor.getAllBlockTiers();
            Pair<Block, Integer> tieredBlock = tiers.get(Math.min(tier, tiers.size()) - 1);
            this.chunkCoordinates.forEach(c -> {
                if (aBaseMetaTileEntity.getWorld().func_147437_c(c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(c.field_71574_a, c.field_71572_b, c.field_71573_c, (Block)tieredBlock.getKey(), ((Integer)tieredBlock.getValue()).intValue(), 3);
                }
            });
            this.piston = this.piston == false;
        }
    }

    private void activatePiston() {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (this.piston.booleanValue()) {
            this.chunkCoordinates.forEach(c -> aBaseMetaTileEntity.getWorld().func_147468_f(c.field_71574_a, c.field_71572_b, c.field_71573_c));
            this.piston = this.piston == false;
        }
    }

    private void animatePiston(IGregTechTileEntity aBaseMetaTileEntity) {
        if (!aBaseMetaTileEntity.getWorld().field_72995_K) {
            return;
        }
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            GTUtility.doSoundAtClient(sound, 10, 1.0f, 1.0f, (double)this.chunkCoordinates.get((int)0).field_71574_a, (double)this.chunkCoordinates.get((int)0).field_71572_b, (double)this.chunkCoordinates.get((int)0).field_71573_c);
        }
        this.spawnVisualPistonBlocks(aBaseMetaTileEntity.getWorld(), this.chunkCoordinates.get((int)2).field_71574_a, this.chunkCoordinates.get((int)2).field_71572_b, this.chunkCoordinates.get((int)2).field_71573_c, 10);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVisualPistonBlocks(World world, int x, int y, int z, int age) {
        EICPistonVisualizer pistonVisualizer = new EICPistonVisualizer(world, x, y, z, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)pistonVisualizer);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("piston", this.piston.booleanValue());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("piston")) {
            this.piston = aNBT.func_74767_n("piston");
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int pistonTier = this.mBlockTier;
        this.mCasing = 0;
        int mMaxHatchTier = 0;
        this.setBlockTier(0);
        boolean isOK = this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0);
        List<MTEHatch> energyHatches = this.getExoticAndNormalEnergyHatchList();
        for (MTEHatch hatch : energyHatches) {
            mMaxHatchTier = Math.max(mMaxHatchTier, hatch.mTier);
        }
        boolean bl = isOK = isOK && this.mMaintenanceHatches.size() == 1 && energyHatches.size() >= 1;
        if (isOK) {
            this.activatePiston();
            return true;
        }
        this.resetPiston(pistonTier);
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEElectricImplosionCompressor(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 6, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }
}

