/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.PixelProvider;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public class ImageProducerChannel
implements Channel,
PixelProvider {
    @NotNull
    private final ImageProducer producer;
    private WritableRaster raster;

    public ImageProducerChannel(@NotNull ImageProducer producer) {
        this.producer = producer;
    }

    @Override
    @NotNull
    public ImageProducer producer() {
        return this.producer;
    }

    @Override
    @NotNull
    public Channel applyFilter(@NotNull ImageFilter filter) {
        return new ImageProducerChannel(new FilteredImageSource(this.producer, filter));
    }

    @Override
    @NotNull
    public PixelProvider pixels(@NotNull RenderContext context) {
        if (this.raster == null) {
            BufferedImage bufferedImage = this.toBufferedImageNonAliased(context);
            this.raster = bufferedImage.getRaster();
        }
        return this;
    }

    @Override
    public int pixelAt(double x, double y) {
        int[] rgb = this.raster.getPixel((int)x, (int)y, (int[])null);
        return rgb[3] << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }
}

