/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StableTopologicalSort {
    @NotNull
    public static <T> List<T> sort(@NotNull List<T> data, @NotNull @NotNull List<@NotNull List<@NotNull Integer>> edges) throws CycleException {
        Objects.requireNonNull(data, "data");
        Objects.requireNonNull(edges, "edges");
        if (edges.size() != data.size()) {
            throw new IllegalStateException("edges size != data size");
        }
        if (data.isEmpty()) {
            return new ArrayList(0);
        }
        int vertexCount = data.size();
        int[] inDegree = new int[vertexCount];
        for (int vtxA = 0; vtxA < vertexCount; ++vtxA) {
            Iterator<Integer> iterator = edges.get(vtxA).iterator();
            while (iterator.hasNext()) {
                int vtxB;
                int n = vtxB = iterator.next().intValue();
                inDegree[n] = inDegree[n] + 1;
            }
        }
        PriorityQueue<Integer> queue = new PriorityQueue<Integer>(vertexCount);
        for (int i = 0; i < vertexCount; ++i) {
            if (inDegree[i] != 0) continue;
            queue.add(i);
        }
        ArrayList<T> output = new ArrayList<T>(data.size());
        while (!queue.isEmpty()) {
            int next = (Integer)queue.poll();
            output.add(data.get(next));
            Iterator<Object> iterator = edges.get(next).iterator();
            while (iterator.hasNext()) {
                int adjacent;
                int n = adjacent = ((Integer)iterator.next()).intValue();
                inDegree[n] = inDegree[n] - 1;
                if (inDegree[n] != 0) continue;
                queue.add(adjacent);
            }
        }
        if (output.size() != vertexCount) {
            Set remaining = Collections.newSetFromMap(new IdentityHashMap());
            remaining.addAll(data);
            for (Object sorted : output) {
                remaining.remove(sorted);
            }
            throw new CycleException(remaining);
        }
        return output;
    }

    public static class CycleException
    extends Exception {
        @NotNull
        private final Set<?> cyclicElements;

        CycleException(@NotNull Set<?> cyclicElements) {
            super("Cycle found");
            this.cyclicElements = cyclicElements;
        }

        @NotNull
        public <T> Set<T> cyclicElements(@NotNull Class<T> elementType) {
            if (this.cyclicElements.isEmpty()) {
                return Collections.emptySet();
            }
            if (!elementType.isAssignableFrom(this.cyclicElements.iterator().next().getClass())) {
                throw new IllegalArgumentException("Wrong element type " + elementType + " for a set of " + this.cyclicElements.iterator().next().getClass());
            }
            return Collections.unmodifiableSet(this.cyclicElements);
        }
    }
}

