/*
 * Decompiled with CFR 0.152.
 */
package emt.tile;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import emt.EMT;
import emt.network.PacketNodeInfo;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ResearchNoteData;
import thaumcraft.common.tiles.TileNode;

public class GT_MetaTileEntity_ResearchCompleter
extends MTEEnhancedMultiBlockBase<GT_MetaTileEntity_ResearchCompleter> {
    private static final int CASING_INDEX = 184;
    private static final int MAX_LENGTH = 13;
    private static final int RECIPE_LENGTH = 1200;
    private static final int RECIPE_EUT = 120;
    private static final float NODE_COST_MULTIPLIER = 1.0f;
    private int recipeAspectCost;
    private int aspectsAbsorbed;
    protected int mLength;
    protected int mCasing;
    protected boolean endFound;
    private int lastNodeDistance;
    private int lastNodeColor;
    private int syncTimer;
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final String STRUCTURE_PIECE_LAST = "last";
    private static final String STRUCTURE_PIECE_LATER_HINT = "laterHint";
    private static final IStructureDefinition<GT_MetaTileEntity_ResearchCompleter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{"ccc"}, {"g~g"}, {"ccc"}})).addShape("later", StructureUtility.transpose((String[][])new String[][]{{"c c"}, {"gxg"}, {"c c"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{"c"}, {"g"}, {"c"}})).addShape("laterHint", StructureUtility.transpose((String[][])new String[][]{{"c c"}, {"g g"}, {"c c"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, (int)184, (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, (int)184, (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, (int)184, (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, (int)184, (int)1), StructureUtility.onElementPass(GT_MetaTileEntity_ResearchCompleter::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)8))})).addElement('x', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(GT_MetaTileEntity_ResearchCompleter::onEndFound, (IStructureElement)StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticOpaque, (int)2)), StructureUtility.isAir(), StructureUtility.notAir()})).addElement('g', StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticOpaque, (int)2)).build();

    public GT_MetaTileEntity_ResearchCompleter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ResearchCompleter(String aName) {
        super(aName);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("recipeAspectCost", this.recipeAspectCost);
        aNBT.func_74768_a("aspectsAbsorbed", this.aspectsAbsorbed);
        aNBT.func_74768_a("mLength", this.mLength);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.recipeAspectCost = aNBT.func_74762_e("recipeAspectCost");
        this.aspectsAbsorbed = aNBT.func_74762_e("aspectsAbsorbed");
        this.mLength = aNBT.func_74762_e("mLength");
        super.loadNBTData(aNBT);
    }

    public void setNodeValues(int nodeDistance, int nodeColor) {
        this.lastNodeDistance = nodeDistance;
        this.lastNodeColor = nodeColor;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isClientSide()) {
            if (aBaseMetaTileEntity.isActive()) {
                int xDir = aBaseMetaTileEntity.getBackFacing().offsetX;
                int yDir = aBaseMetaTileEntity.getBackFacing().offsetY;
                int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ;
                double xCoord = (double)aBaseMetaTileEntity.getXCoord() + 0.5;
                double yCoord = (double)aBaseMetaTileEntity.getYCoord() + 0.5;
                double zCoord = (double)aBaseMetaTileEntity.getZCoord() + 0.5;
                Thaumcraft.proxy.beam(aBaseMetaTileEntity.getWorld(), xCoord + 0.5 * (double)xDir, yCoord + 0.5 * (double)yDir, zCoord + 0.5 * (double)zDir, xCoord + (double)(xDir * this.lastNodeDistance), yCoord + (double)(yDir * this.lastNodeDistance), zCoord + (double)(zDir * this.lastNodeDistance), 3, this.lastNodeColor, true, 2.0f, 1);
            } else {
                this.lastNodeDistance = 0;
                this.lastNodeColor = 0;
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        float progressAmount = (float)this.mProgresstime / (float)this.mMaxProgresstime;
        int requiredVis = (int)Math.ceil(progressAmount * (float)this.recipeAspectCost - (float)this.aspectsAbsorbed);
        --this.syncTimer;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX;
        int yDir = aBaseMetaTileEntity.getBackFacing().offsetY;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ;
        for (int i = 1; i < this.mLength - 1 && requiredVis > 0; ++i) {
            int nodeX = aBaseMetaTileEntity.getXCoord() + xDir * i;
            int nodeY = aBaseMetaTileEntity.getYCoord() + yDir * i;
            int nodeZ = aBaseMetaTileEntity.getZCoord() + zDir * i;
            TileEntity tileEntity = aBaseMetaTileEntity.getWorld().func_147438_o(nodeX, nodeY, nodeZ);
            if (!(tileEntity instanceof TileNode)) continue;
            TileNode aNode = (TileNode)tileEntity;
            AspectList aspectsBase = aNode.getAspectsBase();
            for (Aspect aspect : aspectsBase.getAspects()) {
                int aspectAmount = aspectsBase.getAmount(aspect);
                int drainAmount = Math.min(requiredVis, aspectAmount);
                aNode.setNodeVisBase(aspect, (short)(aspectAmount - drainAmount));
                aNode.takeFromContainer(aspect, drainAmount);
                this.aspectsAbsorbed += drainAmount;
                if ((requiredVis -= drainAmount) > 0) continue;
                if (i == this.lastNodeDistance && aspect.getColor() == this.lastNodeColor) break;
                this.sendClientAnimationUpdate(aBaseMetaTileEntity, i, aspect.getColor());
                break;
            }
            if (aspectsBase.visSize() <= 0) {
                aBaseMetaTileEntity.getWorld().func_147468_f(nodeX, nodeY, nodeZ);
                continue;
            }
            aNode.func_70296_d();
            aBaseMetaTileEntity.getWorld().func_147471_g(nodeX, nodeY, nodeZ);
        }
        if (this.syncTimer <= 0) {
            this.sendClientAnimationUpdate(aBaseMetaTileEntity, this.lastNodeDistance, this.lastNodeColor);
        }
        if (requiredVis > 0) {
            this.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
        }
        return super.onRunningTick(aStack);
    }

    private void sendClientAnimationUpdate(IGregTechTileEntity aBaseMetaTileEntity, int nodeDistance, int nodeColor) {
        int xCoord = aBaseMetaTileEntity.getXCoord();
        short yCoord = aBaseMetaTileEntity.getYCoord();
        int zCoord = aBaseMetaTileEntity.getZCoord();
        int dim = aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
        PacketNodeInfo packet = new PacketNodeInfo(xCoord, yCoord, zCoord, dim, nodeDistance, nodeColor);
        EMT.INSTANCE.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(dim, (double)xCoord, (double)yCoord, (double)zCoord, 128.0));
        this.lastNodeDistance = nodeDistance;
        this.lastNodeColor = nodeColor;
        this.syncTimer = 100;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        ArrayList tInputList = this.getStoredInputs();
        for (ItemStack stack : tInputList) {
            ResearchItem researchItem;
            ResearchNoteData noteData;
            if (!GTUtility.isStackValid((ItemStack)stack) || stack.field_77994_a <= 0 || stack.func_77973_b() != ConfigItems.itemResearchNotes || stack.field_77990_d.func_74767_n("complete") || (noteData = ResearchManager.getData((ItemStack)stack)) == null || (researchItem = ResearchCategories.getResearch((String)noteData.key)) == null) continue;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMultiInternal(120L, 1200, 1, this.getMaxInputVoltage(), false);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mOutputItems = new ItemStack[]{GTUtility.copyAmount((int)1, (ItemStack)stack)};
            this.mOutputItems[0].field_77990_d.func_74757_a("complete", true);
            this.mOutputItems[0].func_77964_b(64);
            --stack.field_77994_a;
            this.aspectsAbsorbed = 0;
            this.recipeAspectCost = (int)Math.ceil((float)researchItem.tags.visSize() * 1.0f);
            this.lastNodeDistance = 0;
            this.lastNodeColor = 0;
            this.sendLoopStart((byte)20);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mLength = 1;
        this.mCasing = 0;
        this.endFound = false;
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 1, 1, 0)) {
            return false;
        }
        while (!this.endFound && this.mLength++ < 13) {
            if (this.checkPiece(STRUCTURE_PIECE_LATER, 1, 1, -(this.mLength - 1))) continue;
            return false;
        }
        return this.endFound && this.mLength >= 3 && this.checkPiece(STRUCTURE_PIECE_LAST, 0, 1, -(this.mLength - 1)) && this.mCasing >= this.mLength * 3;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_ResearchCompleter(this.mName);
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    protected void onEndFound() {
        this.endFound = true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int ColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)184), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_RESEARCH_COMPLETER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_RESEARCH_COMPLETER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)184), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_RESEARCH_COMPLETER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_RESEARCH_COMPLETER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)184)};
    }

    public IStructureDefinition<GT_MetaTileEntity_ResearchCompleter> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Research Completer").addInfo("Controller block for the Research Completer").addInfo("Completes Thaumcraft research notes using EU and Thaumcraft nodes").addInfo("Place nodes in the center row").addSeparator().beginVariableStructureBlock(3, 3, 3, 3, 3, 13, true).addController("Front center").addOtherStructurePart("Magical machine casing", "Top and bottom layers outside. 3 x L minimum").addOtherStructurePart("Warded glass", "Middle layer outside").addEnergyHatch("Any casing").addMaintenanceHatch("Any casing").addInputBus("Any casing").addOutputBus("Any casing").toolTipFinisher("Electro-Magic Tools");
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 1, 1, 0);
        int tTotalLength = Math.min(13, stackSize.field_77994_a + 2);
        for (int i = 1; i < tTotalLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LATER_HINT, stackSize, hintsOnly, 1, 1, -i);
        }
        this.buildPiece(STRUCTURE_PIECE_LAST, stackSize, hintsOnly, 0, 1, -(tTotalLength - 1));
    }
}

