/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class Sliding4WaysMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (tileEntity.isOpened() && type == BoundingBoxType.COLLISION && !topBlock) {
            return null;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
        if (!tileEntity.isOpened() && type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                aabb.field_72337_e += 1.0;
            } else {
                aabb.field_72338_b -= 1.0;
            }
        }
        float x = 0.0f;
        float y = 0.0f;
        if (topBlock == tileEntity.isReversed()) {
            x = topBlock ? -0.8125f : 0.8125f;
        } else {
            float f = y = topBlock ? 0.8125f : -0.8125f;
        }
        if (tileEntity.isOpened()) {
            aabb.func_72317_d((double)x, (double)y, 0.0);
        }
        return aabb;
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float dir = 0.8125f;
        float toX = 0.0f;
        float toY = 0.0f;
        if (tileEntity.isReversed()) {
            dir = -dir;
        }
        if (topBlock != tileEntity.isReversed()) {
            toY = dir;
        } else {
            toX = dir;
        }
        Translation translation = new Translation(toX, toY, 0.0f);
        translation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        translation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return translation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation(model.getShape("top"), this.getTransformation(tileEntity, true)), new Animation(model.getShape("bottom"), this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

