/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiRenderer
extends MalisisRenderer {
    public static RenderItem itemRenderer = new RenderItem();
    public UIComponent currentComponent;
    private int scaleFactor;
    private boolean ignoreScale = false;
    public int mouseX;
    public int mouseY;
    private GuiTexture defaultGuiTexture = new GuiTexture(new ResourceLocation("malisiscore", "textures/gui/gui.png"), 300, 100);
    private GuiTexture currentTexture;
    private static GuiShape rectangle = new SimpleGuiShape();

    public GuiTexture getDefaultTexture() {
        return this.defaultGuiTexture;
    }

    public void setDefaultTexture(GuiTexture texture) {
        this.defaultGuiTexture = texture;
    }

    public void setScaleFactor(int factor) {
        this.scaleFactor = factor;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setIgnoreScale(boolean ignore) {
        this.ignoreScale = ignore;
    }

    public boolean isIgnoreScale() {
        return this.ignoreScale;
    }

    public void set(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTick = partialTicks;
    }

    @Override
    public void prepare(RenderType renderType, double ... data) {
        this._initialize();
        this.renderType = renderType;
        this.currentTexture = null;
        this.bindDefaultTexture();
        if (this.ignoreScale) {
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / (float)this.scaleFactor), (float)(1.0f / (float)this.scaleFactor), (float)1.0f);
        }
        this.enableBlending();
        this.startDrawing();
    }

    @Override
    public void clean() {
        this.draw();
        if (this.ignoreScale) {
            GL11.glPopMatrix();
        }
        this.reset();
    }

    @Override
    public void next() {
        super.next();
        this.bindDefaultTexture();
    }

    public void bindTexture(GuiTexture texture) {
        if (texture == null || texture == this.currentTexture) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getResourceLocation());
        this.currentTexture = texture;
    }

    public void bindDefaultTexture() {
        this.bindTexture(this.defaultGuiTexture);
    }

    @Override
    public void applyTexture(Shape shape, RenderParameters parameters) {
        if (parameters.icon.get() == null) {
            return;
        }
        Face[] faces = shape.getFaces();
        IIcon icon = parameters.icon.get();
        boolean isGuiIcon = icon instanceof GuiIcon;
        for (int i = 0; i < faces.length; ++i) {
            faces[i].setTexture((IIcon)(isGuiIcon ? ((GuiIcon)icon).getIcon(i) : icon), false, false, false);
        }
    }

    public void drawScreen(UIContainer container, int mouseX, int mouseY, float partialTick) {
        if (container == null) {
            return;
        }
        this.set(mouseX, mouseY, partialTick);
        this.prepare(RenderType.GUI, new double[0]);
        container.draw(this, mouseX, mouseY, partialTick);
        this.clean();
    }

    public void drawShape(GuiShape s, RenderParameters params) {
        if (s == null) {
            return;
        }
        this.shape = s;
        this.rp = params != null ? params : new RenderParameters();
        this.shape.translate(this.currentComponent.screenX(), this.currentComponent.screenY(), this.currentComponent.getZIndex());
        this.shape.applyMatrix();
        this.applyTexture(this.shape, this.rp);
        for (Face face : s.getFaces()) {
            this.drawFace(face, face.getParameters());
        }
    }

    public void drawRectangle(int x, int y, int z, int width, int height, int color, int alpha) {
        this.drawRectangle(x, y, z, width, height, color, alpha, true);
    }

    public void drawRectangle(float x, float y, float z, float width, float height, int color, int alpha, boolean relative) {
        if (relative && this.currentComponent != null) {
            x += (float)this.currentComponent.screenX();
            y += (float)this.currentComponent.screenY();
            z += (float)this.currentComponent.getZIndex();
        }
        rectangle.resetState();
        rectangle.setSize(width, height);
        rectangle.setPosition(x, y);
        GuiRenderer.rectangle.getFaces()[0].getParameters().colorMultiplier.set(color);
        GuiRenderer.rectangle.getFaces()[0].getParameters().alpha.set(alpha);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)z);
        this.disableTextures();
        this.enableBlending();
        this.drawShape(rectangle);
        this.next();
        this.enableTextures();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public void drawTooltip(UITooltip tooltip) {
        if (tooltip != null) {
            this.tessellator.func_78382_b();
            tooltip.draw(this, this.mouseX, this.mouseY, this.partialTick);
            this.tessellator.func_78381_a();
        }
    }

    public void drawText(String text) {
        this.drawText(null, text, 0.0f, 0.0f, 0.0f, null, true);
    }

    public void drawText(String text, float x, float y, float z) {
        this.drawText(null, text, x, y, z, null, true);
    }

    public void drawText(MalisisFont font, String text, FontRenderOptions fro) {
        this.drawText(font, text, 0.0f, 0.0f, 0.0f, fro, true);
    }

    @Override
    public void drawText(MalisisFont font, String text, float x, float y, float z, FontRenderOptions fro) {
        this.drawText(font, text, x, y, z, fro, true);
    }

    public void drawText(MalisisFont font, String text, float x, float y, float z, FontRenderOptions fro, boolean relative) {
        if (relative && this.currentComponent != null) {
            x += (float)this.currentComponent.screenX();
            y += (float)this.currentComponent.screenY();
            z += (float)this.currentComponent.getZIndex();
        }
        super.drawText(font, text, x, y, z, fro);
    }

    public void drawItemStack(ItemStack itemStack) {
        this.drawItemStack(itemStack, 0, 0, null, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y) {
        this.drawItemStack(itemStack, x, y, null, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, EnumChatFormatting format) {
        this.drawItemStack(itemStack, x, y, null, format, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, String label) {
        this.drawItemStack(itemStack, x, y, label, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, String label, EnumChatFormatting format, boolean relative) {
        FontRenderer fontRenderer;
        if (itemStack == null) {
            return;
        }
        if (relative && this.currentComponent != null) {
            x += this.currentComponent.screenX();
            y += this.currentComponent.screenY();
        }
        if ((fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack)) == null) {
            fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        if (label == null && (itemStack.field_77994_a > 1 || format != null)) {
            label = Integer.toString(itemStack.field_77994_a);
        }
        if (label == null) {
            label = "";
        }
        if (format != null) {
            label = format + label;
        }
        this.tessellator.func_78381_a();
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        itemRenderer.func_82406_b(fontRenderer, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y);
        itemRenderer.func_94148_a(fontRenderer, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y, label);
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.currentTexture = null;
        this.bindDefaultTexture();
        this.tessellator.func_78382_b();
    }

    public void renderPickedItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.tessellator = Tessellator.field_78398_a;
        GuiRenderer.itemRenderer.field_77023_b = 100.0f;
        this.tessellator.func_78382_b();
        this.drawItemStack(itemStack, this.mouseX - 8, this.mouseY - 8, null, (EnumChatFormatting)(itemStack.field_77994_a == 0 ? EnumChatFormatting.YELLOW : null), false);
        this.tessellator.func_78381_a();
        GuiRenderer.itemRenderer.field_77023_b = 0.0f;
    }

    public void startClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glPushAttrib((int)524288);
        GL11.glEnable((int)3089);
        int f = this.ignoreScale ? 1 : this.scaleFactor;
        int x = area.x * f;
        int y = Minecraft.func_71410_x().field_71440_d - (area.y + area.height()) * f;
        int w = area.width() * f;
        int h = area.height() * f;
        GL11.glScissor((int)x, (int)y, (int)w, (int)h);
    }

    public void endClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glDisable((int)3089);
        GL11.glPopAttrib();
    }
}

