/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.model.layers;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayer;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.layers.UniversalLayerRenderer;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.RenderStep;
import com.gtnewhorizons.navigator.api.model.steps.UniversalInteractableStep;
import com.gtnewhorizons.navigator.api.util.ClickPos;
import com.gtnewhorizons.navigator.api.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;

public class UniversalInteractableRenderer
extends UniversalLayerRenderer
implements InteractableLayer {
    private final ClickPos clickPos = new ClickPos();
    protected InteractableLayerManager manager;
    protected UniversalInteractableStep<?> hoveredRenderStep = null;
    private Predicate<ClickPos> clickAction;
    private IntPredicate keyPressAction;

    public UniversalInteractableRenderer(@Nonnull InteractableLayerManager manager) {
        super(manager);
        this.manager = manager;
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.hoveredRenderStep = null;
        for (RenderStep renderStep : this.getRenderStepsForInteraction()) {
            UniversalInteractableStep step;
            if (!(renderStep instanceof UniversalInteractableStep) || !(step = (UniversalInteractableStep)renderStep).mouseOver(mouseX, mouseY)) continue;
            this.hoveredRenderStep = step;
            return;
        }
    }

    @Override
    public final boolean onMapClick(boolean isDoubleClick, int mouseX, int mouseY, int blockX, int blockZ) {
        if (this.clickAction != null && this.clickAction.test(this.clickPos.set(this.hoveredRenderStep, isDoubleClick, mouseX, mouseY, blockX, blockZ))) {
            return true;
        }
        if (this.hoveredRenderStep != null) {
            return this.onClick(isDoubleClick, mouseX, mouseY, blockX, blockZ);
        }
        return this.onClickOutsideRenderStep(isDoubleClick, mouseX, mouseY, blockX, blockZ);
    }

    public boolean onClick(boolean isDoubleClick, int mouseX, int mouseY, int blockX, int blockZ) {
        if (isDoubleClick) {
            if (((IWaypointAndLocationProvider)this.hoveredRenderStep.getLocation()).isActiveAsWaypoint()) {
                this.manager.clearActiveWaypoint();
            } else {
                this.manager.setActiveWaypoint(((IWaypointAndLocationProvider)this.hoveredRenderStep.getLocation()).toWaypoint());
            }
            return true;
        }
        return false;
    }

    public boolean onClickOutsideRenderStep(boolean isDoubleClick, int mouseX, int mouseY, int blockX, int blockZ) {
        return false;
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.hoveredRenderStep != null) {
            this.hoveredRenderStep.getTooltip(tooltip);
        }
        return tooltip;
    }

    @Override
    public void drawCustomTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int displayWidth, int displayHeight) {
        if (this.hoveredRenderStep != null) {
            this.hoveredRenderStep.drawCustomTooltip(fontRenderer, mouseX, mouseY, displayWidth, displayHeight);
        }
    }

    @Override
    public boolean onKeyPressed(int keyCode) {
        if (this.keyPressAction != null && this.keyPressAction.test(keyCode)) {
            return true;
        }
        if (Util.isKeyPressed(NavigatorApi.ACTION_KEY) && this.hoveredRenderStep != null) {
            this.hoveredRenderStep.onActionKeyPressed();
            this.manager.forceRefresh();
            return true;
        }
        return false;
    }

    public UniversalInteractableRenderer withClickAction(@Nonnull Predicate<ClickPos> action) {
        this.clickAction = action;
        return this;
    }

    public UniversalInteractableRenderer withKeyPressAction(@Nonnull IntPredicate keyPressAction) {
        this.keyPressAction = keyPressAction;
        return this;
    }
}

