/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.journeymap.render;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.journeymap.drawsteps.JMInteractableStep;
import com.gtnewhorizons.navigator.api.journeymap.drawsteps.JMRenderStep;
import com.gtnewhorizons.navigator.api.journeymap.render.JMLayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayer;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.steps.RenderStep;
import com.gtnewhorizons.navigator.api.util.Util;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;

public abstract class JMInteractableLayerRenderer
extends JMLayerRenderer
implements InteractableLayer {
    protected InteractableLayerManager manager;
    protected JMInteractableStep hoveredDrawStep = null;

    public JMInteractableLayerRenderer(@Nonnull InteractableLayerManager manager) {
        super(manager);
        this.manager = manager;
    }

    @Override
    public List<JMRenderStep> getRenderSteps() {
        return this.getReversedRenderSteps();
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.hoveredDrawStep = null;
        for (RenderStep renderStep : this.getRenderStepsForInteraction()) {
            JMInteractableStep clickableDrawStep;
            if (!(renderStep instanceof JMInteractableStep) || !(clickableDrawStep = (JMInteractableStep)renderStep).isMouseOver(mouseX, mouseY)) continue;
            this.hoveredDrawStep = clickableDrawStep;
            return;
        }
    }

    @Override
    public final boolean onMapClick(boolean isDoubleClick, int mouseX, int mouseY, int blockX, int blockZ) {
        if (!this.manager.getOpenModGui().equals((Object)this.getLayerMod())) {
            return false;
        }
        if (this.hoveredDrawStep != null) {
            return this.onClick(isDoubleClick, mouseX, mouseY, blockX, blockZ);
        }
        return this.onClickOutsideRenderStep(isDoubleClick, mouseX, mouseY, blockX, blockZ);
    }

    public boolean onClick(boolean isDoubleClick, int mouseX, int mouseY, int blockX, int blockZ) {
        if (isDoubleClick) {
            if (this.hoveredDrawStep.getLocation().isActiveAsWaypoint()) {
                this.manager.clearActiveWaypoint();
            } else {
                this.manager.setActiveWaypoint(this.hoveredDrawStep.getLocation().toWaypoint());
            }
            return true;
        }
        return false;
    }

    public boolean onClickOutsideRenderStep(boolean isDoubleClick, int mouseX, int mouseY, int blockX, int blockZ) {
        return false;
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.hoveredDrawStep != null) {
            this.hoveredDrawStep.getTooltip(tooltip);
        }
        return tooltip;
    }

    @Override
    public void drawCustomTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int displayWidth, int displayHeight) {
        if (this.hoveredDrawStep != null) {
            this.hoveredDrawStep.drawCustomTooltip(fontRenderer, mouseX, mouseY, displayWidth, displayHeight);
        }
    }

    @Override
    public boolean onKeyPressed(int keyCode) {
        if (Util.isKeyPressed(NavigatorApi.ACTION_KEY) && this.hoveredDrawStep != null) {
            this.hoveredDrawStep.onActionKeyPressed();
            this.manager.forceRefresh();
            return true;
        }
        return false;
    }
}

