/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.gui;

import com.rwtema.extrautils.gui.ContainerFilingCabinet;
import com.rwtema.extrautils.gui.SlotFilingCabinet;
import com.rwtema.extrautils.tileentity.TileEntityFilingCabinet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiFilingCabinet
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("extrautils", "textures/guiFilingCabinet.png");
    ItemSorter sorter = new ItemSorter();
    private int numItems = 0;
    private int currentScroll = 0;
    private boolean isScrolling = false;
    private int prevn = -1;
    private TileEntityFilingCabinet cabinet;

    public GuiFilingCabinet(IInventory player, TileEntityFilingCabinet cabinet) {
        super((Container)new ContainerFilingCabinet(player, cabinet, true));
        this.field_146999_f = 176;
        this.field_147000_g = 240;
        this.prevn = cabinet.getMaxSlots();
        this.cabinet = cabinet;
    }

    public void sortItems() {
        ArrayList<Slot> items = new ArrayList<Slot>();
        items.clear();
        this.numItems = 0;
        for (int i = 0; i < this.cabinet.getMaxSlots(); ++i) {
            if (((Slot)this.field_147002_h.field_75151_b.get(i)).func_75216_d()) {
                ++this.numItems;
            } else if (i > this.prevn) break;
            items.add((Slot)this.field_147002_h.field_75151_b.get(i));
        }
        this.prevn = this.numItems + 1;
        Collections.sort(items, this.sorter);
        int start = this.getStartSlot();
        if (start > this.numItems - 54) {
            start = this.numItems - 54;
        }
        if (start < 0) {
            start = 0;
        }
        for (int i = 0; i < items.size(); ++i) {
            if (i < start || i >= start + 54) {
                ((Slot)items.get((int)i)).field_75223_e = Integer.MIN_VALUE;
                ((Slot)items.get((int)i)).field_75221_f = Integer.MIN_VALUE;
                continue;
            }
            int x = (i - start) % 9;
            int y = (i - start - x) / 9;
            ((Slot)items.get((int)i)).field_75223_e = 8 + x * 18;
            ((Slot)items.get((int)i)).field_75221_f = 18 + y * 18;
        }
        ContainerFilingCabinet.updated = false;
    }

    public int getStartSlot() {
        float t = this.currentScroll;
        return (int)Math.floor((double)(t /= 144.0f) * Math.ceil((float)(this.numItems - 54 + 1) / 1.0f));
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.numItems <= 54) {
            this.func_73729_b(k + this.ScrollX(), l + 128, 176, 9, 17, 8);
        } else {
            this.func_73729_b(k + this.ScrollX(), l + 128, 176, 0, 17, 8);
        }
    }

    public void setScroll(int mX) {
        int prevScroll = this.getStartSlot();
        this.currentScroll = this.numItems <= 54 ? 0 : mX;
        if (prevScroll != this.getStartSlot()) {
            this.sortItems();
        }
    }

    public int ScrollX() {
        if (this.numItems <= 54) {
            return 8;
        }
        if (this.currentScroll < 0) {
            return 8;
        }
        if (this.currentScroll > 143) {
            return 151;
        }
        return 8 + this.currentScroll;
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        if (par3 >= 0) {
            this.isScrolling = false;
        }
        super.func_146286_b(par1, par2, par3);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        if (!this.isScrolling && par3 == 0 && this.func_146978_c(8, 128, 162, 8, par1, par2)) {
            this.isScrolling = true;
            this.setScroll(par1 - this.field_147003_i - 8 - 9);
        }
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_146273_a(int par1, int par2, int par3, long par4) {
        if (this.isScrolling) {
            this.setScroll(par1 - this.field_147003_i - 8 - 9);
        }
        super.func_146273_a(par1, par2, par3, par4);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.numItems > 54) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll -= i * 9;
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
            if (this.currentScroll > 153) {
                this.currentScroll = 153;
            }
            this.setScroll(this.currentScroll);
            this.sortItems();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        if (ContainerFilingCabinet.updated) {
            this.sortItems();
        }
        SlotFilingCabinet.drawing = true;
        super.func_73863_a(par1, par2, par3);
        SlotFilingCabinet.drawing = false;
    }

    public static class ItemSorter
    implements Comparator<Slot> {
        @Override
        public int compare(Slot arg0, Slot arg1) {
            if (!arg0.func_75216_d()) {
                if (!arg1.func_75216_d()) {
                    return 0;
                }
                return 1;
            }
            if (!arg1.func_75216_d()) {
                return -1;
            }
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            boolean sneak = player.field_71158_b.field_78899_d;
            player.field_71158_b.field_78899_d = false;
            String i1 = this.concat(arg0.func_75211_c().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true));
            String i2 = this.concat(arg1.func_75211_c().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true));
            player.field_71158_b.field_78899_d = sneak;
            int a = i1.compareTo(i2);
            if (a == 0) {
                int b = arg0.func_75211_c().func_77973_b().func_77658_a().compareTo(arg0.func_75211_c().func_77973_b().func_77658_a());
                if (b != 0) {
                    return b;
                }
                int c = this.intCompare(arg0.func_75211_c().func_77960_j(), arg0.func_75211_c().func_77960_j());
                if (c != 0) {
                    return c;
                }
                return 0;
            }
            return a;
        }

        public int intCompare(int a, int b) {
            if (a == b) {
                return 0;
            }
            if (a > b) {
                return 1;
            }
            return -1;
        }

        public String concat(List list) {
            String s = "";
            for (Object aList : list) {
                s = s + aList + "\n";
            }
            return s;
        }
    }
}

