/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.config;

import com.gtnewhorizon.gtnhlib.config.Config;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import cpw.mods.fml.common.Loader;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigFieldParser {
    private static final Map<Class<?>, Parser> PARSERS = new HashMap();
    private static final Object2BooleanMap<String> detectedMods = new Object2BooleanOpenHashMap<String>();

    public static void loadField(Object instance, Field field, Configuration config, String category, String key) throws ConfigException {
        try {
            Parser parser = ConfigFieldParser.getParser(field);
            String comment = Optional.ofNullable(field.getAnnotation(Config.Comment.class)).map(Config.Comment::value).map(lines -> String.join((CharSequence)"\n", lines)).orElse("");
            String name = ConfigFieldParser.getFieldName(field);
            String defValueString = ConfigFieldParser.getModDefault(field);
            parser.load(instance, defValueString, field, config, category, name, comment, key);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to load field " + field.getName() + " of type " + field.getType().getSimpleName() + " in class " + field.getDeclaringClass().getName() + ". Caused by: " + e);
        }
    }

    public static void saveField(Object instance, Field field, Configuration config, String category) throws ConfigException {
        try {
            String name = ConfigFieldParser.getFieldName(field);
            Parser parser = ConfigFieldParser.getParser(field);
            parser.save(instance, field, config, category, name);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to save field " + field.getName() + " of type " + field.getType().getSimpleName() + " in class " + field.getDeclaringClass().getName() + ". Caused by: " + e);
        }
    }

    private static Parser getParser(Field field) throws ConfigException {
        Class<?> fieldClass = field.getType();
        Parser parser = PARSERS.get(fieldClass);
        if (Enum.class.isAssignableFrom(fieldClass)) {
            parser = PARSERS.get(Enum.class);
        }
        if (parser == null) {
            throw new ConfigException("No parser found for field");
        }
        return parser;
    }

    public static boolean canParse(Field field) {
        Class<?> fieldClass = field.getType();
        return PARSERS.containsKey(fieldClass) || Enum.class.isAssignableFrom(fieldClass);
    }

    public static String getFieldName(Field field) {
        if (field.isAnnotationPresent(Config.Name.class)) {
            return field.getAnnotation(Config.Name.class).value();
        }
        return field.getName();
    }

    @Nullable
    private static String getModDefault(Field field) {
        Config.ModDetectedDefaultList modDefaultList = field.getAnnotation(Config.ModDetectedDefaultList.class);
        if (modDefaultList != null) {
            return Arrays.stream(modDefaultList.values()).filter(ConfigFieldParser::isModDetected).findFirst().map(modDefault -> modDefault.values().length != 0 ? String.join((CharSequence)",", modDefault.values()) : modDefault.value().trim()).orElse(null);
        }
        Config.ModDetectedDefault modDefault2 = field.getAnnotation(Config.ModDetectedDefault.class);
        if (ConfigFieldParser.isModDetected(modDefault2)) {
            return modDefault2.values().length != 0 ? String.join((CharSequence)",", modDefault2.values()) : modDefault2.value().trim();
        }
        return null;
    }

    private static boolean isModDetected(Config.ModDetectedDefault modDefault) {
        if (modDefault == null) {
            return false;
        }
        String modID = modDefault.modID();
        String coremod = modDefault.coremod();
        if (modID.isEmpty() && coremod.isEmpty()) {
            return false;
        }
        return detectedMods.computeIfAbsent(modID.isEmpty() ? coremod : modID, id -> {
            if (!coremod.isEmpty()) {
                try {
                    Class.forName(coremod);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return !modID.isEmpty() && Loader.isModLoaded((String)modID);
        });
    }

    private static Field extractField(Class<?> clazz, String field) {
        return clazz.getDeclaredField(field);
    }

    private static Object extractValue(Field field) {
        return field.get(null);
    }

    static {
        PARSERS.put(Boolean.TYPE, new BooleanParser());
        PARSERS.put(Boolean.class, new BooleanParser());
        PARSERS.put(Integer.TYPE, new IntParser());
        PARSERS.put(Integer.class, new IntParser());
        PARSERS.put(Float.TYPE, new FloatParser());
        PARSERS.put(Float.class, new FloatParser());
        PARSERS.put(Double.TYPE, new DoubleParser());
        PARSERS.put(Double.class, new DoubleParser());
        PARSERS.put(String.class, new StringParser());
        PARSERS.put(String[].class, new StringArrayParser());
        PARSERS.put(double[].class, new DoubleArrayParser());
        PARSERS.put(int[].class, new IntArrayParser());
        PARSERS.put(Enum.class, new EnumParser());
    }

    public static interface Parser {
        public void load(@Nullable Object var1, @Nullable String var2, Field var3, Configuration var4, String var5, String var6, String var7, String var8);

        public void save(@Nullable Object var1, Field var2, Configuration var3, String var4, String var5);
    }

    private static class BooleanParser
    implements Parser {
        private BooleanParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            boolean defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            field.setBoolean(instance, config.getBoolean(name, category, defaultValue, comment, langKey));
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            boolean boxed = field.getType().equals(Boolean.class);
            Property prop = config.getCategory(category).get(name);
            prop.set(boxed ? ((Boolean)field.get(instance)).booleanValue() : field.getBoolean(instance));
        }

        private boolean fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            boolean boxed = field.getType().equals(Boolean.class);
            if (defValueString == null) {
                return Optional.ofNullable(field.getAnnotation(Config.DefaultBoolean.class)).map(Config.DefaultBoolean::value).orElse(boxed ? ((Boolean)field.get(instance)).booleanValue() : field.getBoolean(instance));
            }
            if (!"true".equalsIgnoreCase(defValueString) && !"false".equalsIgnoreCase(defValueString)) {
                throw new ConfigException("Invalid boolean value: " + defValueString);
            }
            return Boolean.parseBoolean(defValueString);
        }
    }

    private static class IntParser
    implements Parser {
        private IntParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            Optional<Config.RangeInt> range = Optional.ofNullable(field.getAnnotation(Config.RangeInt.class));
            Integer min = range.map(Config.RangeInt::min).orElse(Integer.MIN_VALUE);
            Integer max = range.map(Config.RangeInt::max).orElse(Integer.MAX_VALUE);
            int defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            field.setInt(instance, config.getInt(name, category, defaultValue, min.intValue(), max.intValue(), comment, langKey));
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            boolean boxed = field.getType().equals(Integer.class);
            Property prop = config.getCategory(category).get(name);
            prop.set(boxed ? ((Integer)field.get(instance)).intValue() : field.getInt(instance));
        }

        private int fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            boolean boxed = field.getType().equals(Integer.class);
            if (defValueString == null) {
                return Optional.ofNullable(field.getAnnotation(Config.DefaultInt.class)).map(Config.DefaultInt::value).orElse(boxed ? ((Integer)field.get(instance)).intValue() : field.getInt(instance));
            }
            return Integer.parseInt(defValueString);
        }
    }

    private static class FloatParser
    implements Parser {
        private FloatParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            Optional<Config.RangeFloat> range = Optional.ofNullable(field.getAnnotation(Config.RangeFloat.class));
            Float min = range.map(Config.RangeFloat::min).orElse(Float.valueOf(Float.MIN_VALUE));
            Float max = range.map(Config.RangeFloat::max).orElse(Float.valueOf(Float.MAX_VALUE));
            float defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            field.setFloat(instance, config.getFloat(name, category, defaultValue, min.floatValue(), max.floatValue(), comment, langKey));
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            boolean boxed = field.getType().equals(Float.class);
            Property prop = config.getCategory(category).get(name);
            prop.set(boxed ? (double)((Float)field.get(instance)).floatValue() : (double)field.getFloat(instance));
        }

        private float fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            boolean boxed = field.getType().equals(Float.class);
            if (defValueString == null) {
                return Optional.ofNullable(field.getAnnotation(Config.DefaultFloat.class)).map(Config.DefaultFloat::value).orElse(Float.valueOf(boxed ? ((Float)field.get(instance)).floatValue() : field.getFloat(instance))).floatValue();
            }
            return Float.parseFloat(defValueString);
        }
    }

    private static class DoubleParser
    implements Parser {
        private DoubleParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            Optional<Config.RangeDouble> range = Optional.ofNullable(field.getAnnotation(Config.RangeDouble.class));
            Double min = range.map(Config.RangeDouble::min).orElse((Double)Double.MIN_VALUE);
            Double max = range.map(Config.RangeDouble::max).orElse((Double)Double.MAX_VALUE);
            double defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            String defaultValueComment = comment + " [range: " + min + " ~ " + max + ", default: " + defaultValue + "]";
            field.setDouble(instance, config.get(category, name, defaultValue, defaultValueComment, min.doubleValue(), max.doubleValue()).setLanguageKey(langKey).getDouble());
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            boolean boxed = field.getType().equals(Double.class);
            Property prop = config.getCategory(category).get(name);
            prop.set(boxed ? ((Double)field.get(instance)).doubleValue() : field.getDouble(instance));
        }

        private double fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            boolean boxed = field.getType().equals(Double.class);
            if (defValueString == null) {
                return Optional.ofNullable(field.getAnnotation(Config.DefaultDouble.class)).map(Config.DefaultDouble::value).orElse(boxed ? ((Double)field.get(instance)).doubleValue() : field.getDouble(instance));
            }
            return Double.parseDouble(defValueString);
        }
    }

    private static class StringParser
    implements Parser {
        private StringParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            String defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            Pattern pattern = Optional.ofNullable(field.getAnnotation(Config.Pattern.class)).map(Config.Pattern::value).map(Pattern::compile).orElse(null);
            field.set(instance, config.getString(name, category, defaultValue, comment, langKey, pattern));
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            Property prop = config.getCategory(category).get(name);
            prop.set((String)field.get(instance));
        }

        private String fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            if (defValueString == null) {
                return Optional.ofNullable(field.getAnnotation(Config.DefaultString.class)).map(Config.DefaultString::value).orElse((String)field.get(instance));
            }
            return defValueString;
        }
    }

    private static class StringArrayParser
    implements Parser {
        private StringArrayParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            String[] defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            String[] value = config.getStringList(name, category, defaultValue, comment, null, langKey);
            field.set(instance, value);
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            Property prop = config.getCategory(category).get(name);
            prop.set((String[])field.get(instance));
        }

        private String[] fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            String[] value = defValueString == null ? Optional.ofNullable(field.getAnnotation(Config.DefaultStringList.class)).map(Config.DefaultStringList::value).orElse((String[])field.get(instance)) : defValueString.split(",");
            return value == null ? new String[]{} : value;
        }
    }

    private static class DoubleArrayParser
    implements Parser {
        private DoubleArrayParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            double[] defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            Object[] stringValues = new String[defaultValue.length];
            for (int i = 0; i < defaultValue.length; ++i) {
                stringValues[i] = Double.toString(defaultValue[i]);
            }
            comment = comment + " [default: " + Arrays.toString(stringValues) + "]";
            double[] value = config.get(category, name, defaultValue, comment).setLanguageKey(langKey).getDoubleList();
            field.set(instance, value);
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            Property prop = config.getCategory(category).get(name);
            prop.set((double[])field.get(instance));
        }

        private double[] fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            double[] value = defValueString == null ? Optional.ofNullable(field.getAnnotation(Config.DefaultDoubleList.class)).map(Config.DefaultDoubleList::value).orElse((double[])field.get(instance)) : Arrays.stream(defValueString.split(",")).mapToDouble(s -> Double.parseDouble(s.trim())).toArray();
            return value == null ? new double[]{} : value;
        }
    }

    private static class IntArrayParser
    implements Parser {
        private IntArrayParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            int[] defaultValue = this.fromStringOrDefault(instance, defValueString, field);
            Object[] stringValues = new String[defaultValue.length];
            for (int i = 0; i < defaultValue.length; ++i) {
                stringValues[i] = Integer.toString(defaultValue[i]);
            }
            comment = comment + " [default: " + Arrays.toString(stringValues) + "]";
            int[] value = config.get(category, name, defaultValue, comment).setLanguageKey(langKey).getIntList();
            field.set(instance, value);
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            Property prop = config.getCategory(category).get(name);
            prop.set((int[])field.get(instance));
        }

        private int[] fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field) {
            int[] value = defValueString == null ? Optional.ofNullable(field.getAnnotation(Config.DefaultIntList.class)).map(Config.DefaultIntList::value).orElse((int[])field.get(instance)) : Arrays.stream(defValueString.split(",")).mapToInt(s -> Integer.parseInt(s.trim())).toArray();
            return value == null ? new int[]{} : value;
        }
    }

    private static class EnumParser
    implements Parser {
        private EnumParser() {
        }

        @Override
        public void load(@Nullable Object instance, @Nullable String defValueString, Field field, Configuration config, String category, String name, String comment, String langKey) {
            Class<?> fieldClass = field.getType();
            List enumValues = Arrays.stream((Object[])fieldClass.getDeclaredMethod("values", new Class[0]).invoke(instance, new Object[0])).map(obj -> (Enum)obj).collect(Collectors.toList());
            Enum<?> defaultValue = this.fromStringOrDefault(instance, defValueString, field, enumValues);
            Object[] possibleValues = (String[])enumValues.stream().map(Enum::name).toArray(String[]::new);
            String value = config.getString(name, category, defaultValue.name(), comment + "\nPossible values: " + Arrays.toString(possibleValues) + "\n", (String[])possibleValues, langKey);
            try {
                if (!Arrays.asList(possibleValues).contains(value)) {
                    throw new NoSuchFieldException();
                }
                Field enumField = fieldClass.getDeclaredField(value);
                if (!enumField.isEnumConstant()) {
                    throw new NoSuchFieldException();
                }
                field.set(instance, enumField.get(instance));
            }
            catch (NoSuchFieldException e) {
                ConfigurationManager.LOGGER.warn("Invalid value {} for enum configuration field {} of type {} in config class {}! Using default value of {}!", new Object[]{value, field.getName(), fieldClass.getName(), field.getDeclaringClass().getName(), defaultValue});
                field.set(instance, defaultValue);
            }
        }

        @Override
        public void save(@Nullable Object instance, Field field, Configuration config, String category, String name) {
            Property prop = config.getCategory(category).get(name);
            prop.set(((Enum)field.get(instance)).name());
        }

        private Enum<?> fromStringOrDefault(@Nullable Object instance, @Nullable String defValueString, Field field, List<? extends Enum<?>> validValues) {
            Enum value;
            if (defValueString == null) {
                value = (Enum)Optional.ofNullable(field.getAnnotation(Config.DefaultEnum.class)).map(Config.DefaultEnum::value).map(defName -> ConfigFieldParser.extractField(field.getType(), defName)).map(x$0 -> ConfigFieldParser.extractValue(x$0)).orElse(field.get(instance));
            } else {
                Field modDefaultField = ConfigFieldParser.extractField(field.getType(), defValueString);
                value = (Enum)ConfigFieldParser.extractValue(modDefaultField);
            }
            if (value == null) {
                throw new ConfigException("Invalid default value for enum field! Valid values are " + validValues);
            }
            return value;
        }
    }
}

